/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.AbstractInitializedBaseBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerRunOnServerUtil;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;
import org.keycloak.testsuite.util.UserBuilder;

public class KcOidcBrokerPromptNoneRedirectTest
extends AbstractInitializedBaseBrokerTest {
    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcOidcBrokerPromptNoneConfiguration();
    }

    @Test
    public void testSuccessfulRedirectToProviderWithPromptNone() throws Exception {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        this.authenticateDirectlyInIDP();
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        String url = this.driver.getCurrentUrl() + "&kc_idp_hint=" + this.bc.getIDPAlias() + "&prompt=none";
        this.driver.navigate().to(url);
        this.waitForAccountManagementTitle();
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/account"));
        this.accountUpdateProfilePage.assertCurrent();
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName(), this.bc.getIDPAlias());
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        url = this.driver.getCurrentUrl() + "&prompt=none";
        this.driver.navigate().to(url);
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains(this.bc.consumerRealmName() + "/account/login-redirect?error=login_required"));
    }

    @Test
    public void testUnauthenticatedUserReturnsLoginRequired() throws Exception {
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        String url = this.driver.getCurrentUrl() + "&prompt=none&kc_idp_hint=" + this.bc.getIDPAlias();
        this.driver.navigate().to(url);
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains(this.bc.consumerRealmName() + "/account/login-redirect?error=login_required"));
    }

    @Test
    public void testUpdateProfileReturnsInteractionRequired() throws Exception {
        this.updateExecutions(AbstractBrokerTest::enableUpdateProfileOnFirstLogin);
        this.checkAuthWithPromptNoneReturnsInteractionRequired();
    }

    @Test
    public void testRequirePasswordUpdateReturnsInteractionRequired() throws Exception {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        this.updateExecutions(AbstractBrokerTest::enableRequirePassword);
        this.checkAuthWithPromptNoneReturnsInteractionRequired();
    }

    @Test
    public void testLinkExistingAccountReturnsInteractionRequired() throws Exception {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        UserRepresentation newUser = UserBuilder.create().username("consumer").email("user@localhost.com").enabled(true).build();
        String userId = ApiUtil.createUserWithAdminClient((RealmResource)this.adminClient.realm(this.bc.consumerRealmName()), (UserRepresentation)newUser);
        ApiUtil.resetUserPassword((UserResource)this.adminClient.realm(this.bc.consumerRealmName()).users().get(userId), (String)"password", (boolean)false);
        this.checkAuthWithPromptNoneReturnsInteractionRequired();
    }

    @Test
    public void testPostBrokerLoginWithOTPReturnsInteractionRequired() throws Exception {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        this.testingClient.server(this.bc.consumerRealmName()).run(BrokerRunOnServerUtil.configurePostBrokerLoginWithOTP(this.bc.getIDPAlias()));
        this.checkAuthWithPromptNoneReturnsInteractionRequired();
    }

    @Test
    public void testRequireConsentReturnsInteractionRequired() throws Exception {
        RealmResource brokeredRealm = this.adminClient.realm(this.bc.providerRealmName());
        List clients = brokeredRealm.clients().findByClientId("brokerapp");
        org.junit.Assert.assertEquals((long)1L, (long)clients.size());
        ClientRepresentation brokerApp = (ClientRepresentation)clients.get(0);
        brokerApp.setConsentRequired(Boolean.valueOf(true));
        brokeredRealm.clients().get(brokerApp.getId()).update(brokerApp);
        this.checkAuthWithPromptNoneReturnsInteractionRequired();
    }

    protected void checkAuthWithPromptNoneReturnsInteractionRequired() {
        this.authenticateDirectlyInIDP();
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        String url = this.driver.getCurrentUrl() + "&kc_idp_hint=" + this.bc.getIDPAlias() + "&prompt=none";
        this.driver.navigate().to(url);
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains(this.bc.consumerRealmName() + "/account/login-redirect?error=interaction_required"));
    }

    protected void authenticateDirectlyInIDP() {
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName()));
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        this.waitForAccountManagementTitle();
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/account"));
        this.accountUpdateProfilePage.assertCurrent();
    }

    private class KcOidcBrokerPromptNoneConfiguration
    extends KcOidcBrokerConfiguration {
        private KcOidcBrokerPromptNoneConfiguration() {
        }

        @Override
        protected void applyDefaultConfiguration(Map<String, String> config, IdentityProviderSyncMode syncMode) {
            super.applyDefaultConfiguration(config, syncMode);
            config.remove("prompt");
            config.put("acceptsPromptNoneForwardFromClient", "true");
        }
    }
}

