/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;
import org.keycloak.testsuite.updaters.Creator;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.testsuite.util.WaitUtils;

public class KcOidcBrokerLoginHintTest
extends AbstractBrokerTest {
    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcOidcBrokerConfigurationWithLoginHint();
    }

    @Override
    protected void loginUser() {
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.driver.navigate().to(this.driver.getCurrentUrl() + "&login_hint=" + "user@localhost.com");
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        Assert.assertTrue((String)"User identifiant should be fullfilled", (boolean)this.loginPage.getUsername().equalsIgnoreCase("user@localhost.com"));
        this.log.debug((Object)"Logging in");
        this.loginPage.login(this.bc.getUserPassword());
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        Assert.assertTrue((String)"We must be on correct realm right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/"));
        this.log.debug((Object)"Updating info on updateAccount page");
        this.updateAccountInformationPage.updateAccountInformation(this.bc.getUserLogin(), this.bc.getUserEmail(), "Firstname", "Lastname");
        UsersResource consumerUsers = this.adminClient.realm(this.bc.consumerRealmName()).users();
        int userCount = consumerUsers.count();
        Assert.assertTrue((String)"There must be at least one user", (userCount > 0 ? 1 : 0) != 0);
        List users = consumerUsers.search("", Integer.valueOf(0), Integer.valueOf(userCount));
        boolean isUserFound = false;
        for (UserRepresentation user : users) {
            if (!user.getUsername().equals(this.bc.getUserLogin()) || !user.getEmail().equals(this.bc.getUserEmail())) continue;
            isUserFound = true;
            break;
        }
        Assert.assertTrue((String)("There must be user " + this.bc.getUserLogin() + " in realm " + this.bc.consumerRealmName()), (boolean)isUserFound);
    }

    @Test
    public void loginHintWithExistingUser() {
        try (Creator c = Creator.create((RealmResource)this.adminClient.realm(this.bc.consumerRealmName()), (UserRepresentation)UserBuilder.create().username(this.bc.getUserLogin()).password(this.bc.getUserPassword()).email(this.bc.getUserEmail()).enabled(true).build());){
            this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
            WaitUtils.waitForPageToLoad();
            this.driver.navigate().to(this.driver.getCurrentUrl() + "&login_hint=" + "user@localhost.com" + "&kc_idp_hint=" + "kc-oidc-idp");
            WaitUtils.waitForPageToLoad();
            this.loginPage.login(this.bc.getUserPassword());
            this.updateAccountInformationPage.assertCurrent();
            this.updateAccountInformationPage.updateAccountInformation(this.bc.getUserLogin(), this.bc.getUserEmail(), "Firstname", "Lastname");
            this.idpConfirmLinkPage.assertCurrent();
            this.idpConfirmLinkPage.clickLinkAccount();
            this.loginPage.login(this.bc.getUserPassword());
            this.accountPage.isCurrent();
        }
    }

    private class KcOidcBrokerConfigurationWithLoginHint
    extends KcOidcBrokerConfiguration {
        private KcOidcBrokerConfigurationWithLoginHint() {
        }

        @Override
        public IdentityProviderRepresentation setUpIdentityProvider(IdentityProviderSyncMode syncMode) {
            IdentityProviderRepresentation idp = BrokerTestTools.createIdentityProvider("kc-oidc-idp", "keycloak-oidc");
            Map config = idp.getConfig();
            this.applyDefaultConfiguration(config, syncMode);
            config.put("loginHint", "true");
            return idp;
        }
    }
}

