/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import org.junit.Test;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.broker.AbstractInitializedBaseBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;

public class KcOidcBrokerIdpHintTest
extends AbstractInitializedBaseBrokerTest {
    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcOidcBrokerConfiguration();
    }

    @Test
    public void testSuccessfulRedirect() {
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        String url = this.driver.getCurrentUrl() + "&kc_idp_hint=" + this.bc.getIDPAlias();
        this.driver.navigate().to(url);
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        this.log.debug((Object)"Logging in");
        this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/"));
    }

    @Test
    public void testSuccessfulRedirectToProviderAfterLoginPageShown() {
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        String urlWithHint = this.driver.getCurrentUrl() + "&kc_idp_hint=" + this.bc.getIDPAlias();
        this.driver.navigate().to(urlWithHint);
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        this.driver.navigate().to(urlWithHint);
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the consumer realm page", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/"));
    }

    @Test
    public void testInvalidIdentityProviderHint() {
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        String url = this.driver.getCurrentUrl() + "&kc_idp_hint=bogus-idp";
        this.driver.navigate().to(url);
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/"));
    }
}

