/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.Map;
import org.junit.Test;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.broker.AbstractInitializedBaseBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;

public class KcOidcBrokerHiddenIdpHintTest
extends AbstractInitializedBaseBrokerTest {
    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcOidcHiddenBrokerConfiguration();
    }

    @Test
    public void testSuccessfulRedirectToProviderHiddenOnLoginPage() {
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        String url = this.driver.getCurrentUrl() + "&kc_idp_hint=" + this.bc.getIDPAlias();
        this.driver.navigate().to(url);
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        this.log.debug((Object)"Logging in");
        this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/"));
    }

    private class KcOidcHiddenBrokerConfiguration
    extends KcOidcBrokerConfiguration {
        private KcOidcHiddenBrokerConfiguration() {
        }

        @Override
        public IdentityProviderRepresentation setUpIdentityProvider(IdentityProviderSyncMode syncMode) {
            IdentityProviderRepresentation idp = BrokerTestTools.createIdentityProvider("kc-oidc-idp", "keycloak-oidc");
            Map config = idp.getConfig();
            this.applyDefaultConfiguration(config, syncMode);
            config.put("hideOnLoginPage", "true");
            return idp;
        }
    }
}

