/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.List;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;

public class KcOidcBrokerAcrParameterTest
extends AbstractBrokerTest {
    private static final String ACR_VALUES = "acr_values";
    private static final String ACR_3 = "3";

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return KcOidcBrokerConfiguration.INSTANCE;
    }

    @Override
    protected void loginUser() {
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.driver.navigate().to(this.driver.getCurrentUrl() + "&" + ACR_VALUES + "=" + ACR_3);
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        Assert.assertTrue((String)"acr_values=3 should be part of the url", (boolean)this.driver.getCurrentUrl().contains("acr_values=3"));
        this.log.debug((Object)"Logging in");
        this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        Assert.assertTrue((String)"We must be on correct realm right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/"));
        this.log.debug((Object)"Updating info on updateAccount page");
        this.updateAccountInformationPage.updateAccountInformation(this.bc.getUserLogin(), this.bc.getUserEmail(), "Firstname", "Lastname");
        UsersResource consumerUsers = this.adminClient.realm(this.bc.consumerRealmName()).users();
        int userCount = consumerUsers.count();
        Assert.assertTrue((String)"There must be at least one user", (userCount > 0 ? 1 : 0) != 0);
        List users = consumerUsers.search("", Integer.valueOf(0), Integer.valueOf(userCount));
        boolean isUserFound = false;
        for (UserRepresentation user : users) {
            if (!user.getUsername().equals(this.bc.getUserLogin()) || !user.getEmail().equals(this.bc.getUserEmail())) continue;
            isUserFound = true;
            break;
        }
        Assert.assertTrue((String)("There must be user " + this.bc.getUserLogin() + " in realm " + this.bc.consumerRealmName()), (boolean)isUserFound);
    }
}

