/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.broker.AbstractIdentityProviderMapperTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;

public class HardcodedUserAttributeMapperTest
extends AbstractIdentityProviderMapperTest {
    private static final String USER_ATTRIBUTE = "user-attribute";
    private static final String USER_ATTRIBUTE_VALUE = "user-attribute";

    @Test
    public void addHardcodedAttributeOnFirstLogin() {
        IdentityProviderRepresentation idp = this.setupIdentityProvider();
        this.createMapperInIdp(idp, IdentityProviderMapperSyncMode.IMPORT);
        this.createUserInProviderRealm();
        this.logInAsUserInIDPForFirstTime();
        UserRepresentation user = this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        this.assertThatAttributeHasBeenAssigned(user);
    }

    @Test
    public void hardcodedAttributeGetsAddedEvenIfMapperIsAddedLaterInSyncModeForce() {
        UserRepresentation user = this.loginAsUserTwiceWithMapper(IdentityProviderMapperSyncMode.FORCE, true);
        this.assertThatAttributeHasBeenAssigned(user);
    }

    @Test
    public void hardcodedAttributeDoesNotGetAddedIfMapperIsAddedLaterInSyncModeImport() {
        UserRepresentation user = this.loginAsUserTwiceWithMapper(IdentityProviderMapperSyncMode.IMPORT, true);
        this.assertThatAttributeHasNotBeenAssigned(user);
    }

    @Test
    public void hardcodedAttributeDoesNotGetAddedAgainInSyncModeImport() {
        UserRepresentation user = this.loginAsUserTwiceWithMapper(IdentityProviderMapperSyncMode.IMPORT, false);
        this.assertThatAttributeHasNotBeenAssigned(user);
    }

    @Test
    public void hardcodedAttributeGetsUpdatedInSyncModeForce() {
        UserRepresentation user = this.loginAsUserTwiceWithMapper(IdentityProviderMapperSyncMode.FORCE, false);
        this.assertThatAttributeHasBeenAssigned(user);
    }

    protected UserRepresentation loginAsUserTwiceWithMapper(IdentityProviderMapperSyncMode syncMode, boolean createAfterFirstLogin) {
        IdentityProviderRepresentation idp = this.setupIdentityProvider();
        if (!createAfterFirstLogin) {
            this.createMapperInIdp(idp, syncMode);
        }
        this.createUserInProviderRealm();
        this.logInAsUserInIDPForFirstTime();
        UserRepresentation user = this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        if (!createAfterFirstLogin) {
            this.assertThatAttributeHasBeenAssigned(user);
        } else {
            this.assertThatAttributeHasNotBeenAssigned(user);
        }
        if (createAfterFirstLogin) {
            this.createMapperInIdp(idp, syncMode);
        }
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        if (user.getAttributes() != null) {
            user.setAttributes(new HashMap());
        }
        this.adminClient.realm(this.bc.consumerRealmName()).users().get(user.getId()).update(user);
        this.logInAsUserInIDP();
        return this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
    }

    protected void createMapperInIdp(IdentityProviderRepresentation idp, IdentityProviderMapperSyncMode syncMode) {
        IdentityProviderMapperRepresentation advancedClaimToRoleMapper = new IdentityProviderMapperRepresentation();
        advancedClaimToRoleMapper.setName("hardcoded-attribute-mapper");
        advancedClaimToRoleMapper.setIdentityProviderMapper("hardcoded-attribute-idp-mapper");
        advancedClaimToRoleMapper.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"attribute", (Object)"user-attribute").put((Object)"attribute.value", (Object)"user-attribute").build());
        IdentityProviderResource idpResource = this.realm.identityProviders().get(idp.getAlias());
        advancedClaimToRoleMapper.setIdentityProviderAlias(this.bc.getIDPAlias());
        idpResource.addMapper(advancedClaimToRoleMapper).close();
    }

    protected void createUserInProviderRealm() {
        this.createUserInProviderRealm(new HashMap<String, List<String>>());
    }

    protected void assertThatAttributeHasBeenAssigned(UserRepresentation user) {
        Assert.assertThat(user.getAttributes().get("user-attribute"), (Matcher)Matchers.contains((Object[])new String[]{"user-attribute"}));
    }

    protected void assertThatAttributeHasNotBeenAssigned(UserRepresentation user) {
        if (user.getAttributes() != null) {
            Assert.assertThat(user.getAttributes().get("user-attribute"), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{"user-attribute"})));
        }
    }

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcOidcBrokerConfiguration();
    }
}

