/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.broker.AbstractRoleMapperTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;

public class HardcodedRoleMapperTest
extends AbstractRoleMapperTest {
    private RealmResource realm;

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcOidcBrokerConfiguration();
    }

    @Before
    public void setupRealm() {
        super.addClients();
        this.realm = this.adminClient.realm(this.bc.consumerRealmName());
    }

    @Test
    public void mapperGrantsRoleOnFirstLogin() {
        UserRepresentation user = this.createMapperThenLoginAsUserTwiceWithHardcodedRoleMapper(IdentityProviderMapperSyncMode.IMPORT);
        this.assertThatRoleHasBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void mapperDoesNotGrantRoleInModeImportIfMapperIsAddedLater() {
        UserRepresentation user = this.loginAsUserThenCreateMapperAndLoginAgainWithHardcodedRoleMapper(IdentityProviderMapperSyncMode.IMPORT);
        this.assertThatRoleHasNotBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void updateBrokeredUserDoesNotGrantRoleInLegacyMode() {
        UserRepresentation user = this.loginAsUserThenCreateMapperAndLoginAgainWithHardcodedRoleMapper(IdentityProviderMapperSyncMode.LEGACY);
        this.assertThatRoleHasNotBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void updateBrokeredUserGrantsRoleInForceMode() {
        UserRepresentation user = this.loginAsUserThenCreateMapperAndLoginAgainWithHardcodedRoleMapper(IdentityProviderMapperSyncMode.FORCE);
        this.assertThatRoleHasBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void updateBrokeredUserMatchDoesntDeleteRole() {
        UserRepresentation user = this.createMapperThenLoginAsUserTwiceWithHardcodedRoleMapper(IdentityProviderMapperSyncMode.FORCE);
        this.assertThatRoleHasBeenAssignedInConsumerRealmTo(user);
    }

    private UserRepresentation createMapperThenLoginAsUserTwiceWithHardcodedRoleMapper(IdentityProviderMapperSyncMode syncMode) {
        return this.loginAsUserTwiceWithMapper(syncMode, false, new HashMap<String, List<String>>());
    }

    private UserRepresentation loginAsUserThenCreateMapperAndLoginAgainWithHardcodedRoleMapper(IdentityProviderMapperSyncMode syncMode) {
        return this.loginAsUserTwiceWithMapper(syncMode, true, new HashMap<String, List<String>>());
    }

    @Override
    protected void createMapperInIdp(IdentityProviderRepresentation idp, IdentityProviderMapperSyncMode syncMode) {
        IdentityProviderMapperRepresentation advancedClaimToRoleMapper = new IdentityProviderMapperRepresentation();
        advancedClaimToRoleMapper.setName("oidc-hardcoded-role-mapper");
        advancedClaimToRoleMapper.setIdentityProviderMapper("oidc-hardcoded-role-idp-mapper");
        advancedClaimToRoleMapper.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"role", (Object)"realm-management.view-realm").build());
        IdentityProviderResource idpResource = this.realm.identityProviders().get(idp.getAlias());
        advancedClaimToRoleMapper.setIdentityProviderAlias(this.bc.getIDPAlias());
        idpResource.addMapper(advancedClaimToRoleMapper).close();
    }
}

