/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.broker.AbstractRoleMapperTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;

public class ExternalKeycloakRoleToRoleMapperTest
extends AbstractRoleMapperTest {
    private RealmResource realm;
    private boolean deleteRoleFromUser = true;

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcOidcBrokerConfiguration();
    }

    @Before
    public void setupRealm() {
        super.addClients();
        this.realm = this.adminClient.realm(this.bc.consumerRealmName());
    }

    @Test
    public void mapperGrantsRoleOnFirstLogin() {
        UserRepresentation user = this.createMapperThenLoginAsUserTwiceWithExternalKeycloakRoleToRoleMapper(IdentityProviderMapperSyncMode.IMPORT);
        this.assertThatRoleHasBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void updateBrokeredUserDoesNotGrantRoleInLegacyMode() {
        UserRepresentation user = this.loginAsUserThenCreateMapperAndLoginAgainWithExternalKeycloakRoleToRoleMapper(IdentityProviderMapperSyncMode.LEGACY);
        this.assertThatRoleHasNotBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void updateBrokeredUserGrantsRoleInForceMode() {
        UserRepresentation user = this.loginAsUserThenCreateMapperAndLoginAgainWithExternalKeycloakRoleToRoleMapper(IdentityProviderMapperSyncMode.FORCE);
        this.assertThatRoleHasBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void updateBrokeredUserMatchDeletesRoleInForceMode() {
        UserRepresentation user = this.createMapperThenLoginAsUserTwiceWithExternalKeycloakRoleToRoleMapper(IdentityProviderMapperSyncMode.FORCE);
        this.assertThatRoleHasNotBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void updateBrokeredUserMatchDoesNotDeleteRoleInLegacyMode() {
        UserRepresentation user = this.createMapperThenLoginAsUserTwiceWithExternalKeycloakRoleToRoleMapper(IdentityProviderMapperSyncMode.LEGACY);
        this.assertThatRoleHasBeenAssignedInConsumerRealmTo(user);
    }

    private UserRepresentation createMapperThenLoginAsUserTwiceWithExternalKeycloakRoleToRoleMapper(IdentityProviderMapperSyncMode syncMode) {
        return this.loginAsUserTwiceWithMapper(syncMode, false, (Map<String, List<String>>)ImmutableMap.builder().build());
    }

    private UserRepresentation loginAsUserThenCreateMapperAndLoginAgainWithExternalKeycloakRoleToRoleMapper(IdentityProviderMapperSyncMode syncMode) {
        this.deleteRoleFromUser = false;
        return this.loginAsUserTwiceWithMapper(syncMode, true, (Map<String, List<String>>)ImmutableMap.builder().build());
    }

    @Override
    protected void createMapperInIdp(IdentityProviderRepresentation idp, IdentityProviderMapperSyncMode syncMode) {
        IdentityProviderMapperRepresentation externalRoleToRoleMapper = new IdentityProviderMapperRepresentation();
        externalRoleToRoleMapper.setName("external-keycloak-role-mapper");
        externalRoleToRoleMapper.setIdentityProviderMapper("keycloak-oidc-role-to-role-idp-mapper");
        externalRoleToRoleMapper.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"external.role", (Object)"user").put((Object)"role", (Object)"realm-management.view-realm").build());
        IdentityProviderResource idpResource = this.realm.identityProviders().get(idp.getAlias());
        externalRoleToRoleMapper.setIdentityProviderAlias(this.bc.getIDPAlias());
        idpResource.addMapper(externalRoleToRoleMapper).close();
    }

    @Override
    public void updateUser() {
        if (this.deleteRoleFromUser) {
            RoleRepresentation role = this.adminClient.realm(this.bc.providerRealmName()).roles().get("user").toRepresentation();
            UserResource userResource = this.adminClient.realm(this.bc.providerRealmName()).users().get(this.userId);
            userResource.roles().realmLevel().remove(Collections.singletonList(role));
        }
    }
}

