/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.io.Serializable;
import org.junit.Assert;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.FlowUtil;

final class BrokerRunOnServerUtil {
    BrokerRunOnServerUtil() {
    }

    static RunOnServer configurePostBrokerLoginWithOTP(String idpAlias) {
        return (RunOnServer & Serializable)session -> {
            RealmModel realm = session.getContext().getRealm();
            AuthenticationFlowModel postBrokerFlow = new AuthenticationFlowModel();
            postBrokerFlow.setAlias("post-broker");
            postBrokerFlow.setDescription("post-broker flow with OTP");
            postBrokerFlow.setProviderId("basic-flow");
            postBrokerFlow.setTopLevel(true);
            postBrokerFlow.setBuiltIn(false);
            postBrokerFlow = realm.addAuthenticationFlow(postBrokerFlow);
            AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
            execution.setParentFlow(postBrokerFlow.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
            execution.setAuthenticator("auth-otp-form");
            execution.setPriority(20);
            execution.setAuthenticatorFlow(false);
            realm.addAuthenticatorExecution(execution);
            IdentityProviderModel idp = realm.getIdentityProviderByAlias(idpAlias);
            idp.setPostBrokerLoginFlowId(postBrokerFlow.getId());
            realm.updateIdentityProvider(idp);
        };
    }

    static RunOnServer disablePostBrokerLoginFlow(String idpAlias) {
        return (RunOnServer & Serializable)session -> {
            RealmModel realm = session.getContext().getRealm();
            IdentityProviderModel idp = realm.getIdentityProviderByAlias(idpAlias);
            idp.setPostBrokerLoginFlowId(null);
            realm.updateIdentityProvider(idp);
        };
    }

    static RunOnServer grantReadTokenRole(String username) {
        return (RunOnServer & Serializable)session -> {
            RealmModel realm = session.getContext().getRealm();
            ClientModel brokerClient = realm.getClientByClientId("broker");
            RoleModel readTokenRole = brokerClient.getRole("read-token");
            UserModel user = session.users().getUserByUsername(realm, username);
            user.grantRole(readTokenRole);
        };
    }

    static RunOnServer revokeReadTokenRole(String username) {
        return (RunOnServer & Serializable)session -> {
            RealmModel realm = session.getContext().getRealm();
            ClientModel brokerClient = realm.getClientByClientId("broker");
            RoleModel readTokenRole = brokerClient.getRole("read-token");
            UserModel user = session.users().getUserByUsername(realm, username);
            user.deleteRoleMapping(readTokenRole);
        };
    }

    static RunOnServer configureAutoLinkFlow(String idpAlias) {
        return (RunOnServer & Serializable)session -> {
            RealmModel appRealm = session.getContext().getRealm();
            AuthenticationFlowModel newFlow = new AuthenticationFlowModel();
            newFlow.setAlias("AutoLink");
            newFlow.setDescription("AutoLink");
            newFlow.setProviderId("basic-flow");
            newFlow.setBuiltIn(false);
            newFlow.setTopLevel(true);
            newFlow = appRealm.addAuthenticationFlow(newFlow);
            AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
            execution.setRequirement(AuthenticationExecutionModel.Requirement.ALTERNATIVE);
            execution.setAuthenticatorFlow(false);
            execution.setAuthenticator("idp-create-user-if-unique");
            execution.setPriority(1);
            execution.setParentFlow(newFlow.getId());
            execution = appRealm.addAuthenticatorExecution(execution);
            AuthenticationExecutionModel execution2 = new AuthenticationExecutionModel();
            execution2.setRequirement(AuthenticationExecutionModel.Requirement.ALTERNATIVE);
            execution2.setAuthenticatorFlow(false);
            execution2.setAuthenticator("idp-auto-link");
            execution2.setPriority(2);
            execution2.setParentFlow(newFlow.getId());
            execution2 = appRealm.addAuthenticatorExecution(execution2);
            IdentityProviderModel idp = appRealm.getIdentityProviderByAlias(idpAlias);
            idp.setFirstBrokerLoginFlowId(newFlow.getId());
            appRealm.updateIdentityProvider(idp);
        };
    }

    static RunOnServer assertHardCodedSessionNote() {
        return (RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("consumer");
            UserModel user = session.users().getUserByUsername(realm, "testuser");
            UserSessionModel sessions = (UserSessionModel)session.sessions().getUserSessionsStream(realm, user).findFirst().get();
            Assert.assertEquals((Object)"sessionvalue", (Object)sessions.getNote("user-session-attr"));
        };
    }

    static RunOnServer removeBrokerExpiredSessions() {
        return (RunOnServer & Serializable)session -> {
            RealmModel realm = session.getContext().getRealm();
            session.sessions().removeExpired(realm);
            session.authenticationSessions().removeExpired(realm);
        };
    }

    static void configureBrokerFlowToReAuthenticationWithPasswordForm(KeycloakTestingClient testingClient, String consumerRealmName, String idpAlias, String newFlowAlias) {
        testingClient.server(consumerRealmName).run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyFirstBrokerLoginFlow(newFlowAlias));
        testingClient.server(consumerRealmName).run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).inVerifyExistingAccountByReAuthentication(subFlow -> subFlow.removeExecution(0).updateExecution(0, exec -> exec.setPriority(30)).addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "idp-auto-link", 10).addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-password-form", 20)).usesInIdentityProvider(idpAlias));
    }

    static void configureBrokerFlowToReAuthenticationWithPasswordOrTotp(KeycloakTestingClient testingClient, String consumerRealmName, String idpAlias, String newFlowAlias) {
        testingClient.server(consumerRealmName).run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyFirstBrokerLoginFlow(newFlowAlias));
        testingClient.server(consumerRealmName).run((RunOnServer & Serializable)session -> {
            AuthenticationFlowModel flowModel = FlowUtil.createFlowModel("password or otp", "basic-flow", "Flow to authenticate user with password or otp", false, true);
            FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).inVerifyExistingAccountByReAuthentication(flowUtil -> flowUtil.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "idp-auto-link").addSubFlowExecution(flowModel, AuthenticationExecutionModel.Requirement.REQUIRED, subFlow -> subFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, "auth-password-form").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, "auth-otp-form"))).usesInIdentityProvider(idpAlias);
        });
    }
}

