/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import org.junit.After;
import org.junit.Before;
import org.keycloak.testsuite.broker.AbstractBaseBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.NestedBrokerConfiguration;

public abstract class AbstractNestedBrokerTest
extends AbstractBaseBrokerTest {
    protected NestedBrokerConfiguration nbc = this.getNestedBrokerConfiguration();

    protected abstract NestedBrokerConfiguration getNestedBrokerConfiguration();

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return this.getNestedBrokerConfiguration();
    }

    @Before
    public void createSubConsumerRealm() {
        this.importRealm(this.nbc.createSubConsumerRealm());
    }

    @After
    public void removeSubConsumerRealm() {
        this.adminClient.realm(this.nbc.subConsumerRealmName()).remove();
    }

    protected void logInAsUserInNestedIDPForFirstTime() {
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.nbc.subConsumerRealmName()));
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        this.log.debug((Object)("Clicking social " + this.nbc.getSubConsumerIDPDisplayName()));
        this.loginPage.clickSocial(this.nbc.getSubConsumerIDPDisplayName());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        this.log.debug((Object)("Clicking social " + this.nbc.getIDPAlias()));
        this.loginPage.clickSocial(this.nbc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        this.log.debug((Object)"Logging in");
        this.loginPage.login(this.nbc.getUserLogin(), this.nbc.getUserPassword());
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.log.debug((Object)"Updating info on updateAccount page");
        this.updateAccountInformationPage.updateAccountInformation(this.bc.getUserLogin(), this.bc.getUserEmail(), "Firstname", "Lastname");
    }
}

