/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.mail.internet.MimeMessage;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.events.EventType;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.AbstractInitializedBaseBrokerTest;
import org.keycloak.testsuite.broker.BrokerRunOnServerUtil;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.forms.VerifyProfileTest;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.util.MailAssert;
import org.keycloak.testsuite.util.MailServer;
import org.keycloak.testsuite.util.SecondBrowser;
import org.keycloak.userprofile.UserProfileContext;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.support.PageFactory;

public abstract class AbstractFirstBrokerLoginTest
extends AbstractInitializedBaseBrokerTest {
    @Drone
    @SecondBrowser
    protected WebDriver driver2;
    @Rule
    public AssertEvents events = new AssertEvents(this);

    protected void enableDynamicUserProfile() {
        RealmResource rr = this.adminClient.realm(this.bc.consumerRealmName());
        RealmRepresentation testRealm = rr.toRepresentation();
        VerifyProfileTest.enableDynamicUserProfile(testRealm);
        rr.update(testRealm);
    }

    @Test
    public void testErrorExistingUserWithUpdateProfile() {
        this.createUser("consumer");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        Assert.assertTrue((boolean)this.updateAccountInformationPage.isCurrent());
        Assert.assertTrue((String)"We must be on correct realm right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/"));
        this.log.debug((Object)"Updating info on updateAccount page");
        this.updateAccountInformationPage.updateAccountInformation("consumer", "consumer-user@redhat.com", "FirstName", "LastName");
        BrokerTestTools.waitForPage(this.driver, "account already exists", false);
        org.junit.Assert.assertTrue((boolean)this.idpConfirmLinkPage.isCurrent());
        org.junit.Assert.assertEquals((Object)"User with username consumer already exists. How do you want to continue?", (Object)this.idpConfirmLinkPage.getMessage());
    }

    @Test
    public void testLinkAccountByReauthenticationWithPassword() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        String existingUser = this.createUser("consumer");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "account already exists", false);
        org.junit.Assert.assertTrue((boolean)this.idpConfirmLinkPage.isCurrent());
        org.junit.Assert.assertEquals((Object)"User with email user@localhost.com already exists. How do you want to continue?", (Object)this.idpConfirmLinkPage.getMessage());
        this.idpConfirmLinkPage.clickLinkAccount();
        org.junit.Assert.assertEquals((Object)("Authenticate to link your account with " + this.bc.getIDPAlias()), (Object)this.loginPage.getInfoMessage());
        try {
            this.loginPage.findSocialButton(this.bc.getIDPAlias());
            Assert.fail((String)("Not expected to see social button with " + this.bc.getIDPAlias()));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            this.loginPage.clickRegister();
            Assert.fail((String)"Not expected to see register link");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.loginPage.login("password");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        this.assertNumFederatedIdentities(existingUser, 1);
    }

    @Test
    public void testLinkAccountByReauthenticationWithUsernameAndPassword() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        String existingUser = this.createUser("consumer");
        String anotherUser = this.createUser("foobar", "foo@bar.baz");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "account already exists", false);
        org.junit.Assert.assertTrue((boolean)this.idpConfirmLinkPage.isCurrent());
        org.junit.Assert.assertEquals((Object)"User with email user@localhost.com already exists. How do you want to continue?", (Object)this.idpConfirmLinkPage.getMessage());
        this.idpConfirmLinkPage.clickLinkAccount();
        org.junit.Assert.assertEquals((Object)("Authenticate to link your account with " + this.bc.getIDPAlias()), (Object)this.loginPage.getInfoMessage());
        try {
            this.loginPage.findSocialButton(this.bc.getIDPAlias());
            Assert.fail((String)("Not expected to see social button with " + this.bc.getIDPAlias()));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            this.loginPage.clickRegister();
            Assert.fail((String)"Not expected to see register link");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.loginPage.login("foobar", "password");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        this.assertNumFederatedIdentities(existingUser, 0);
        this.assertNumFederatedIdentities(anotherUser, 1);
    }

    @Test
    public void testLinkAccountByReauthenticationNoExistingUser() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        this.updateExecutions(AbstractBrokerTest::disableExistingUser);
        String existingUser = this.createUser("consumer");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        org.junit.Assert.assertEquals((Object)("Authenticate to link your account with " + this.bc.getIDPAlias()), (Object)this.loginPage.getInfoMessage());
        try {
            this.loginPage.findSocialButton(this.bc.getIDPAlias());
            Assert.fail((String)("Not expected to see social button with " + this.bc.getIDPAlias()));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            this.loginPage.clickRegister();
            Assert.fail((String)"Not expected to see register link");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.loginPage.login("consumer", "password");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        this.assertNumFederatedIdentities(existingUser, 1);
    }

    @Test
    public void testLinkAccountByReauthenticationResetPassword() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        String existingUser = this.createUser("consumer");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "account already exists", false);
        org.junit.Assert.assertTrue((boolean)this.idpConfirmLinkPage.isCurrent());
        org.junit.Assert.assertEquals((Object)"User with email user@localhost.com already exists. How do you want to continue?", (Object)this.idpConfirmLinkPage.getMessage());
        this.idpConfirmLinkPage.clickLinkAccount();
        org.junit.Assert.assertEquals((Object)("Authenticate to link your account with " + this.bc.getIDPAlias()), (Object)this.loginPage.getInfoMessage());
        try {
            this.loginPage.findSocialButton(this.bc.getIDPAlias());
            Assert.fail((String)("Not expected to see social button with " + this.bc.getIDPAlias()));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            this.loginPage.clickRegister();
            Assert.fail((String)"Not expected to see register link");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.loginPage.resetPassword();
        this.loginPasswordResetPage.assertCurrent();
        org.junit.Assert.assertEquals((Object)"consumer", (Object)this.loginPasswordResetPage.getUsername());
    }

    @Test
    public void testLinkAccountByReauthenticationResetPasswordNoExistingUser() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        this.updateExecutions(AbstractBrokerTest::disableExistingUser);
        String existingUser = this.createUser("consumer");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        org.junit.Assert.assertEquals((Object)("Authenticate to link your account with " + this.bc.getIDPAlias()), (Object)this.loginPage.getInfoMessage());
        try {
            this.loginPage.findSocialButton(this.bc.getIDPAlias());
            Assert.fail((String)("Not expected to see social button with " + this.bc.getIDPAlias()));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            this.loginPage.clickRegister();
            Assert.fail((String)"Not expected to see register link");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.loginPage.resetPassword();
        this.loginPasswordResetPage.assertCurrent();
        org.junit.Assert.assertTrue((boolean)this.loginPasswordResetPage.getUsername().isEmpty());
    }

    @Test
    public void testLinkAccountByLogInAsUserUsingBrowserButtons() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        String userId = this.createUser("consumer");
        UserResource providerUser = this.adminClient.realm(this.bc.providerRealmName()).users().get(this.userId);
        UserRepresentation userResource = providerUser.toRepresentation();
        userResource.setEmail("user@localhost.com");
        userResource.setFirstName("FirstName");
        userResource.setLastName("LastName");
        providerUser.update(userResource);
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        this.log.debug((Object)"Logging in");
        this.loginPage.login("invalid", this.bc.getUserPassword());
        this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        BrokerTestTools.waitForPage(this.driver, "account already exists", false);
        this.driver.navigate().back();
        org.junit.Assert.assertTrue((boolean)this.driver.getPageSource().contains("You are already logged in."));
        this.driver.navigate().forward();
        this.idpConfirmLinkPage.assertCurrent();
        this.idpConfirmLinkPage.clickReviewProfile();
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        this.driver.navigate().back();
        if (!(this.driver instanceof HtmlUnitDriver)) {
            this.loginExpiredPage.assertCurrent();
            this.loginExpiredPage.clickLoginContinueLink();
        }
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        this.updateAccountInformationPage.updateAccountInformation(this.bc.getUserEmail(), "FirstName", "LastName");
        BrokerTestTools.waitForPage(this.driver, "account already exists", false);
        this.idpConfirmLinkPage.assertCurrent();
        this.idpConfirmLinkPage.clickLinkAccount();
        org.junit.Assert.assertEquals((Object)"consumer", (Object)this.loginPage.getUsername());
        org.junit.Assert.assertTrue((boolean)this.loginPage.isUsernameInputEnabled());
        org.junit.Assert.assertEquals((Object)("Authenticate to link your account with " + this.bc.getIDPAlias()), (Object)this.loginPage.getInfoMessage());
        try {
            this.loginPage.findSocialButton(this.bc.getIDPAlias());
            Assert.fail((String)("Not expected to see social button with " + this.bc.getIDPAlias()));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.loginPage.login("password");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        this.assertNumFederatedIdentities(userId, 1);
    }

    @Test
    public void testLinkAccountByLogInAsUserAfterResettingPassword() throws InterruptedException {
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        RealmRepresentation realmRep = realm.toRepresentation();
        realmRep.setResetPasswordAllowed(Boolean.valueOf(true));
        realm.update(realmRep);
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        String existingUser = this.createUser("consumer");
        UserResource providerUser = this.adminClient.realm(this.bc.providerRealmName()).users().get(this.userId);
        UserRepresentation userResource = providerUser.toRepresentation();
        userResource.setEmail("user@localhost.com");
        userResource.setFirstName("FirstName");
        userResource.setLastName("LastName");
        providerUser.update(userResource);
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "account already exists", false);
        this.idpConfirmLinkPage.assertCurrent();
        this.idpConfirmLinkPage.clickLinkAccount();
        this.configureSMTPServer();
        this.loginPage.resetPassword();
        this.loginPasswordResetPage.assertCurrent();
        this.loginPasswordResetPage.changePassword();
        org.junit.Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
        org.junit.Assert.assertEquals((long)1L, (long)MailServer.getReceivedMessages().length);
        MimeMessage message = MailServer.getLastReceivedMessage();
        String linkFromMail = MailAssert.assertEmailAndGetUrl("server@mail.test", "user@localhost.com", "credentials", false);
        this.driver.navigate().to(linkFromMail.trim());
        this.passwordUpdatePage.assertCurrent();
        this.passwordUpdatePage.changePassword("password", "password");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        this.assertNumFederatedIdentities(existingUser, 1);
    }

    @Test
    public void testLinkAccountByLogInAsUserAfterResettingPasswordUsingDifferentBrowsers() throws InterruptedException {
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        RealmRepresentation realmRep = realm.toRepresentation();
        realmRep.setResetPasswordAllowed(Boolean.valueOf(true));
        realm.update(realmRep);
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        String existingUser = this.createUser("consumer");
        UserResource providerUser = this.adminClient.realm(this.bc.providerRealmName()).users().get(this.userId);
        UserRepresentation userResource = providerUser.toRepresentation();
        userResource.setEmail("user@localhost.com");
        userResource.setFirstName("FirstName");
        userResource.setLastName("LastName");
        providerUser.update(userResource);
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "account already exists", false);
        this.idpConfirmLinkPage.assertCurrent();
        this.idpConfirmLinkPage.clickLinkAccount();
        this.configureSMTPServer();
        this.loginPage.resetPassword();
        this.loginPasswordResetPage.assertCurrent();
        this.loginPasswordResetPage.changePassword();
        org.junit.Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
        org.junit.Assert.assertEquals((long)1L, (long)MailServer.getReceivedMessages().length);
        MimeMessage message = MailServer.getLastReceivedMessage();
        String linkFromMail = MailAssert.assertEmailAndGetUrl("server@mail.test", "user@localhost.com", "credentials", false);
        this.driver2.navigate().to(linkFromMail.trim());
        this.removeSMTPConfiguration(realm);
        LoginPasswordUpdatePage passwordUpdatePage = (LoginPasswordUpdatePage)PageFactory.initElements((WebDriver)this.driver2, LoginPasswordUpdatePage.class);
        passwordUpdatePage.changePassword("password", "password");
        this.assertNumFederatedIdentities(existingUser, 0);
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        try {
            BrokerTestTools.waitForPage(this.driver, "account already exists", false);
        }
        catch (Exception e) {
            this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        }
        BrokerTestTools.waitForPage(this.driver, "account already exists", false);
        this.idpConfirmLinkPage.assertCurrent();
        this.idpConfirmLinkPage.clickLinkAccount();
        this.loginPage.login("password");
        this.assertNumFederatedIdentities(existingUser, 1);
    }

    @Test
    public void testUserExistsFirstBrokerLoginFlowUpdateProfileOff() {
        UserResource userResource = this.adminClient.realm(this.bc.consumerRealmName()).users().get(this.createUser("consumer"));
        UserRepresentation consumerUser = userResource.toRepresentation();
        consumerUser.setEmail(this.bc.getUserEmail());
        userResource.update(consumerUser);
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "account already exists", false);
        org.junit.Assert.assertTrue((boolean)this.idpConfirmLinkPage.isCurrent());
    }

    @Test
    public void testUserExistsFirstBrokerLoginFlowUpdateProfileOn() {
        this.createUser("consumer");
        this.updateExecutions(AbstractBrokerTest::enableUpdateProfileOnFirstLogin);
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        Assert.assertTrue((boolean)this.updateAccountInformationPage.isCurrent());
        Assert.assertTrue((String)"We must be on correct realm right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/"));
        this.log.debug((Object)"Updating info on updateAccount page");
        this.updateAccountInformationPage.updateAccountInformation("consumer", "consumer-user@redhat.com", "FirstName", "LastName");
        BrokerTestTools.waitForPage(this.driver, "we are sorry...", false);
        org.junit.Assert.assertEquals((Object)"User with username consumer already exists. Please login to account management to link the account.", (Object)this.errorPage.getError());
    }

    @Test
    public void testRequiredUpdatedPassword() {
        this.updateExecutions(AbstractBrokerTest::enableRequirePassword);
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        Assert.assertTrue((boolean)this.updateAccountInformationPage.isCurrent());
        Assert.assertTrue((String)"We must be on correct realm right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/"));
        this.log.debug((Object)"Updating info on updateAccount page");
        this.updateAccountInformationPage.updateAccountInformation("FirstName", "LastName");
        BrokerTestTools.waitForPage(this.driver, "update password", false);
        this.updatePasswordPage.updatePasswords("password", "password");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
    }

    @Test
    public void testFixDuplicationsByReviewProfile() {
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        UserResource userResource = realm.users().get(this.createUser("consumer"));
        UserRepresentation consumerUser = userResource.toRepresentation();
        consumerUser.setEmail(this.bc.getUserEmail());
        userResource.update(consumerUser);
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        Assert.assertTrue((boolean)this.updateAccountInformationPage.isCurrent());
        this.updateAccountInformationPage.updateAccountInformation("FirstName", "LastName");
        BrokerTestTools.waitForPage(this.driver, "account already exists", false);
        org.junit.Assert.assertTrue((boolean)this.idpConfirmLinkPage.isCurrent());
        org.junit.Assert.assertEquals((Object)"User with email user@localhost.com already exists. How do you want to continue?", (Object)this.idpConfirmLinkPage.getMessage());
        this.idpConfirmLinkPage.clickReviewProfile();
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        Assert.assertTrue((boolean)this.updateAccountInformationPage.isCurrent());
        this.updateAccountInformationPage.updateAccountInformation("consumer", "test@localhost.com", "FirstName", "LastName");
        BrokerTestTools.waitForPage(this.driver, "account already exists", false);
        org.junit.Assert.assertTrue((boolean)this.idpConfirmLinkPage.isCurrent());
        org.junit.Assert.assertEquals((Object)"User with username consumer already exists. How do you want to continue?", (Object)this.idpConfirmLinkPage.getMessage());
        this.idpConfirmLinkPage.clickReviewProfile();
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        Assert.assertTrue((boolean)this.updateAccountInformationPage.isCurrent());
        this.updateAccountInformationPage.updateAccountInformation("test", "test@localhost.com", "FirstName", "LastName");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"FirstName", (Object)this.accountUpdateProfilePage.getFirstName());
        Assert.assertEquals((Object)"LastName", (Object)this.accountUpdateProfilePage.getLastName());
        Assert.assertEquals((Object)"test@localhost.com", (Object)this.accountUpdateProfilePage.getEmail());
        Assert.assertEquals((Object)"test", (Object)this.accountUpdateProfilePage.getUsername());
    }

    @Test
    public void testHardcodedUserSessionNoteIsSetAfterFirstBrokerLogin() {
        this.updateExecutions(AbstractBrokerTest::enableUpdateProfileOnFirstLogin);
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        IdentityProviderResource idpResource = realm.identityProviders().get(this.bc.getIDPAlias());
        IdentityProviderMapperRepresentation hardCodedSessionNoteMapper = new IdentityProviderMapperRepresentation();
        hardCodedSessionNoteMapper.setName("static-session-note");
        hardCodedSessionNoteMapper.setIdentityProviderAlias(this.bc.getIDPAlias());
        hardCodedSessionNoteMapper.setIdentityProviderMapper("hardcoded-user-session-attribute-idp-mapper");
        hardCodedSessionNoteMapper.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)IdentityProviderSyncMode.IMPORT.toString()).put((Object)"attribute.value", (Object)"sessionvalue").put((Object)"attribute", (Object)"user-session-attr").build());
        Response response = idpResource.addMapper(hardCodedSessionNoteMapper);
        response.close();
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        this.updateAccountInformationPage.updateAccountInformation("FirstName", "LastName");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        this.testingClient.server().run(BrokerRunOnServerUtil.assertHardCodedSessionNote());
    }

    @Test
    public void testRequiredRegistrationEmailAsUserName() {
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        RealmRepresentation realmRep = realm.toRepresentation();
        this.updateExecutions(AbstractBrokerTest::enableUpdateProfileOnFirstLogin);
        realmRep.setRegistrationEmailAsUsername(Boolean.valueOf(true));
        realm.update(realmRep);
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        Assert.assertTrue((boolean)this.updateAccountInformationPage.isCurrent());
        Assert.assertTrue((String)"We must be on correct realm right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/"));
        this.log.debug((Object)"Updating info on updateAccount page");
        try {
            this.updateAccountInformationPage.updateAccountInformation("test", "test@redhat.com", "FirstName", "LastName");
            Assert.fail((String)"It is not expected to see username field");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.updateAccountInformationPage.updateAccountInformation("test@redhat.com", "FirstName", "LastName");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        org.junit.Assert.assertEquals((long)1L, (long)realm.users().search("test@redhat.com").size());
    }

    @Test
    public void testLinkAccountWithEmailVerified() {
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        this.configureSMTPServer();
        String linkedUserId = this.createUser("consumer");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        Assert.assertTrue((boolean)this.updateAccountInformationPage.isCurrent());
        Assert.assertTrue((String)"We must be on correct realm right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/"));
        this.log.debug((Object)"Updating info on updateAccount page");
        this.updateAccountInformationPage.updateAccountInformation("Firstname", "Lastname");
        BrokerTestTools.waitForPage(this.driver, "account already exists", false);
        this.idpConfirmLinkPage.clickLinkAccount();
        String url = MailAssert.assertEmailAndGetUrl("server@mail.test", "user@localhost.com", "Someone wants to link your ", false);
        this.log.info((Object)("navigating to url from email: " + url));
        this.driver.navigate().to(url);
        org.junit.Assert.assertEquals((Object)(this.accountPage.buildUri().toASCIIString().replace("master", "consumer") + "/"), (Object)this.driver.getCurrentUrl());
        org.junit.Assert.assertTrue((boolean)realm.users().get(linkedUserId).toRepresentation().isEmailVerified());
    }

    @Test
    public void testLinkAccountWithUntrustedEmailVerified() {
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        RealmRepresentation realmRep = realm.toRepresentation();
        realmRep.setVerifyEmail(Boolean.valueOf(true));
        realm.update(realmRep);
        IdentityProviderRepresentation idpRep = this.identityProviderResource.toRepresentation();
        idpRep.setTrustEmail(false);
        this.identityProviderResource.update(idpRep);
        this.configureSMTPServer();
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        this.updateAccountInformationPage.updateAccountInformation("FirstName", "LastName");
        this.verifyEmailPage.assertCurrent();
        String verificationUrl = MailAssert.assertEmailAndGetUrl("server@mail.test", "user@localhost.com", "verify your email address", false);
        this.driver.navigate().to(verificationUrl.trim());
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
    }

    @Test
    public void testSuccessfulAuthenticationWithoutUpdateProfile_emailNotProvided_emailVerifyEnabled() {
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        RealmRepresentation realmRep = realm.toRepresentation();
        realmRep.setVerifyEmail(Boolean.valueOf(true));
        realm.update(realmRep);
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        this.createUser(this.bc.providerRealmName(), "no-email", "password", "FirstName", "LastName", (String)null);
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        this.log.debug((Object)"Logging in");
        this.loginPage.login("no-email", "password");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        List users = realm.users().search("no-email");
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        List requiredActions = ((UserRepresentation)users.get(0)).getRequiredActions();
        org.junit.Assert.assertEquals((long)1L, (long)requiredActions.size());
        org.junit.Assert.assertEquals((Object)UserModel.RequiredAction.VERIFY_EMAIL.name(), requiredActions.get(0));
    }

    @Test
    public void testVerifyEmailNotRequiredActionWhenEmailIsTrustedByProvider() {
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        RealmRepresentation realmRep = realm.toRepresentation();
        realmRep.setVerifyEmail(Boolean.valueOf(true));
        realm.update(realmRep);
        IdentityProviderRepresentation idpRep = this.identityProviderResource.toRepresentation();
        idpRep.setTrustEmail(true);
        this.identityProviderResource.update(idpRep);
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        this.updateAccountInformationPage.updateAccountInformation("FirstName", "LastName");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        List users = realm.users().search(this.bc.getUserLogin());
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        List requiredActions = ((UserRepresentation)users.get(0)).getRequiredActions();
        org.junit.Assert.assertEquals((long)0L, (long)requiredActions.size());
    }

    @Test
    public void testVerifyEmailRequiredActionWhenChangingEmailDuringFirstLogin() {
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        RealmRepresentation realmRep = realm.toRepresentation();
        realmRep.setVerifyEmail(Boolean.valueOf(true));
        realm.update(realmRep);
        IdentityProviderRepresentation idpRep = this.identityProviderResource.toRepresentation();
        idpRep.setTrustEmail(true);
        this.identityProviderResource.update(idpRep);
        this.configureSMTPServer();
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        this.updateAccountInformationPage.updateAccountInformation("changed@localhost.com", "FirstName", "LastName");
        this.verifyEmailPage.assertCurrent();
        String verificationUrl = MailAssert.assertEmailAndGetUrl("server@mail.test", "changed@localhost.com", "verify your email address", false);
        this.driver.navigate().to(verificationUrl.trim());
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        List users = realm.users().search(this.bc.getUserLogin());
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        List requiredActions = ((UserRepresentation)users.get(0)).getRequiredActions();
        org.junit.Assert.assertEquals((long)0L, (long)requiredActions.size());
    }

    @Test
    public void testLinkAccountByEmailVerificationTwice() {
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        UserResource userResource = realm.users().get(this.createUser("consumer"));
        UserRepresentation consumerUser = userResource.toRepresentation();
        consumerUser.setEmail(this.bc.getUserEmail());
        userResource.update(consumerUser);
        this.configureSMTPServer();
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        Assert.assertTrue((boolean)this.updateAccountInformationPage.isCurrent());
        this.updateAccountInformationPage.updateAccountInformation("FirstName", "LastName");
        BrokerTestTools.waitForPage(this.driver, "account already exists", false);
        org.junit.Assert.assertTrue((boolean)this.idpConfirmLinkPage.isCurrent());
        org.junit.Assert.assertEquals((Object)"User with email user@localhost.com already exists. How do you want to continue?", (Object)this.idpConfirmLinkPage.getMessage());
        this.idpConfirmLinkPage.clickLinkAccount();
        String url = MailAssert.assertEmailAndGetUrl("server@mail.test", "user@localhost.com", "Someone wants to link your ", false);
        this.driver.navigate().to(url);
        org.junit.Assert.assertEquals((Object)(this.accountPage.buildUri().toASCIIString().replace("master", "consumer") + "/"), (Object)this.driver.getCurrentUrl());
        org.junit.Assert.assertTrue((boolean)this.adminClient.realm(this.bc.consumerRealmName()).users().get(consumerUser.getId()).toRepresentation().isEmailVerified());
        this.driver.navigate().to(url);
        BrokerTestTools.waitForPage(this.driver, "you are already logged in.", false);
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.driver.navigate().to(url);
        BrokerTestTools.waitForPage(this.driver, "confirm linking the account testuser of identity provider " + this.bc.getIDPAlias() + " with your account.", false);
        this.proceedPage.clickProceedLink();
        BrokerTestTools.waitForPage(this.driver, "you successfully verified your email. please go back to your original browser and continue there with the login.", false);
    }

    @Test
    public void testLinkAccountByEmailVerificationResendEmail() {
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        UserResource userResource = realm.users().get(this.createUser("consumer"));
        UserRepresentation consumerUser = userResource.toRepresentation();
        consumerUser.setEmail(this.bc.getUserEmail());
        userResource.update(consumerUser);
        this.configureSMTPServer();
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        Assert.assertTrue((boolean)this.updateAccountInformationPage.isCurrent());
        this.updateAccountInformationPage.updateAccountInformation("FirstName", "LastName");
        BrokerTestTools.waitForPage(this.driver, "account already exists", false);
        org.junit.Assert.assertTrue((boolean)this.idpConfirmLinkPage.isCurrent());
        org.junit.Assert.assertEquals((Object)"User with email user@localhost.com already exists. How do you want to continue?", (Object)this.idpConfirmLinkPage.getMessage());
        this.idpConfirmLinkPage.clickLinkAccount();
        BrokerTestTools.waitForPage(this.driver, "link " + this.bc.getIDPAlias(), false);
        org.junit.Assert.assertEquals((Object)("an email with instructions to link " + this.bc.getIDPAlias() + " account testuser with your consumer account has been sent to you."), (Object)this.idpLinkEmailPage.getMessage().toLowerCase());
        this.idpLinkEmailPage.resendEmail();
        org.junit.Assert.assertEquals((long)2L, (long)MailServer.getReceivedMessages().length);
    }

    @Test
    public void testVerifyEmailInNewBrowserWithPreserveClient() {
        RealmResource consumerRealm = this.adminClient.realm(this.bc.consumerRealmName());
        this.configureSMTPServer();
        String linkedUserId = this.createUser("consumer");
        this.driver.navigate().to(this.getLoginUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName(), "broker-app"));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        Assert.assertTrue((boolean)this.updateAccountInformationPage.isCurrent());
        Assert.assertTrue((String)"We must be on correct realm right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/"));
        this.log.debug((Object)"Updating info on updateAccount page");
        this.updateAccountInformationPage.updateAccountInformation("Firstname", "Lastname");
        BrokerTestTools.waitForPage(this.driver, "account already exists", false);
        this.idpConfirmLinkPage.clickLinkAccount();
        String url = MailAssert.assertEmailAndGetUrl("server@mail.test", "user@localhost.com", "Someone wants to link your ", false);
        this.log.info((Object)("navigating to url from email in second browser: " + url));
        this.driver2.navigate().to(url);
        WebElement proceedLink = this.driver2.findElement(By.linkText((String)"\u00bb Click here to proceed"));
        MatcherAssert.assertThat((Object)proceedLink, (Matcher)Matchers.notNullValue());
        String link = proceedLink.getAttribute("href");
        MatcherAssert.assertThat((Object)link, (Matcher)Matchers.containsString((String)"client_id=broker-app"));
        proceedLink.click();
        org.junit.Assert.assertThat((Object)this.driver2.getPageSource(), (Matcher)Matchers.containsString((String)"You successfully verified your email. Please go back to your original browser and continue there with the login."));
        org.junit.Assert.assertTrue((boolean)consumerRealm.users().get(linkedUserId).toRepresentation().isEmailVerified());
    }

    @Test
    public void testEventsOnUpdateProfileNoEmailChange() {
        this.updateExecutions(AbstractBrokerTest::setUpMissingUpdateProfileOnFirstLogin);
        this.createUser(this.bc.providerRealmName(), "no-first-name", "password", (String)null, "LastName", "no-first-name@localhost.com");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        this.log.debug((Object)"Logging in");
        this.loginPage.login("no-first-name", "password");
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        this.updateAccountInformationPage.updateAccountInformation("FirstName", "LastName");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"FirstName", (Object)this.accountUpdateProfilePage.getFirstName());
        Assert.assertEquals((Object)"LastName", (Object)this.accountUpdateProfilePage.getLastName());
        Assert.assertEquals((Object)"no-first-name@localhost.com", (Object)this.accountUpdateProfilePage.getEmail());
        Assert.assertEquals((Object)"no-first-name", (Object)this.accountUpdateProfilePage.getUsername());
        RealmRepresentation consumerRealmRep = this.adminClient.realm(this.bc.consumerRealmName()).toRepresentation();
        this.events.expectAccount(EventType.LOGIN).realm(consumerRealmRep).user((Matcher<String>)Matchers.any(String.class)).session((Matcher<String>)Matchers.any(String.class)).detail("identity_provider_identity", "no-first-name").detail("register_method", "broker").assertEvent(this.getFirstConsumerEvent());
    }

    @Test
    public void testEventsOnUpdateProfileWithEmailChange() {
        this.updateExecutions(AbstractBrokerTest::setUpMissingUpdateProfileOnFirstLogin);
        this.createUser(this.bc.providerRealmName(), "no-first-name", "password", (String)null, "LastName", "no-first-name@localhost.com");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        this.log.debug((Object)"Logging in");
        this.loginPage.login("no-first-name", "password");
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        this.updateAccountInformationPage.updateAccountInformation("new-email@localhost.com", "FirstName", "LastName");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"FirstName", (Object)this.accountUpdateProfilePage.getFirstName());
        Assert.assertEquals((Object)"LastName", (Object)this.accountUpdateProfilePage.getLastName());
        Assert.assertEquals((Object)"new-email@localhost.com", (Object)this.accountUpdateProfilePage.getEmail());
        Assert.assertEquals((Object)"no-first-name", (Object)this.accountUpdateProfilePage.getUsername());
        RealmRepresentation consumerRealmRep = this.adminClient.realm(this.bc.consumerRealmName()).toRepresentation();
        this.events.expectAccount(EventType.UPDATE_EMAIL).realm(consumerRealmRep).user((String)null).session((String)null).detail("context", UserProfileContext.IDP_REVIEW.name()).detail("identity_provider_identity", "no-first-name").detail("previous_email", "no-first-name@localhost.com").detail("updated_email", "new-email@localhost.com").assertEvent(this.getFirstConsumerEvent());
        this.events.expectAccount(EventType.LOGIN).realm(consumerRealmRep).user((Matcher<String>)Matchers.any(String.class)).session((Matcher<String>)Matchers.any(String.class)).detail("identity_provider_identity", "no-first-name").detail("register_method", "broker").assertEvent(this.events.poll());
    }

    protected EventRepresentation getFirstConsumerEvent() {
        String providerRealmId = this.adminClient.realm(this.bc.providerRealmName()).toRepresentation().getId();
        EventRepresentation er = this.events.poll();
        while (er != null && providerRealmId.equals(er.getRealmId())) {
            er = this.events.poll();
        }
        return er;
    }

    @Test
    public void testUpdateProfileIfMissingInformation() {
        this.updateExecutions(AbstractBrokerTest::setUpMissingUpdateProfileOnFirstLogin);
        this.createUser(this.bc.providerRealmName(), "no-first-name", "password", (String)null, "LastName", "no-first-name@localhost.com");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        this.log.debug((Object)"Logging in");
        this.loginPage.login("no-first-name", "password");
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        this.updateAccountInformationPage.updateAccountInformation("FirstName", "LastName");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"FirstName", (Object)this.accountUpdateProfilePage.getFirstName());
        Assert.assertEquals((Object)"LastName", (Object)this.accountUpdateProfilePage.getLastName());
        Assert.assertEquals((Object)"no-first-name@localhost.com", (Object)this.accountUpdateProfilePage.getEmail());
        Assert.assertEquals((Object)"no-first-name", (Object)this.accountUpdateProfilePage.getUsername());
        this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.createUser(this.bc.providerRealmName(), "no-last-name", "password", "FirstName", (String)null, "no-last-name@localhost.com");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        this.log.debug((Object)"Logging in");
        this.loginPage.login("no-last-name", "password");
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        this.updateAccountInformationPage.updateAccountInformation("FirstName", "LastName");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"FirstName", (Object)this.accountUpdateProfilePage.getFirstName());
        Assert.assertEquals((Object)"LastName", (Object)this.accountUpdateProfilePage.getLastName());
        Assert.assertEquals((Object)"no-last-name@localhost.com", (Object)this.accountUpdateProfilePage.getEmail());
        Assert.assertEquals((Object)"no-last-name", (Object)this.accountUpdateProfilePage.getUsername());
        this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.createUser(this.bc.providerRealmName(), "no-email", "password", "FirstName", "LastName", (String)null);
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        this.log.debug((Object)"Logging in");
        this.loginPage.login("no-email", "password");
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        this.updateAccountInformationPage.updateAccountInformation("no-email@localhost.com", "FirstName", "LastName");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"FirstName", (Object)this.accountUpdateProfilePage.getFirstName());
        Assert.assertEquals((Object)"LastName", (Object)this.accountUpdateProfilePage.getLastName());
        Assert.assertEquals((Object)"no-email@localhost.com", (Object)this.accountUpdateProfilePage.getEmail());
        Assert.assertEquals((Object)"no-email", (Object)this.accountUpdateProfilePage.getUsername());
    }

    @Test
    public void testUpdateProfileIfNotMissingInformation() {
        this.updateExecutions(AbstractBrokerTest::setUpMissingUpdateProfileOnFirstLogin);
        this.createUser(this.bc.providerRealmName(), "all-info-set", "password", "FirstName", "LastName", "all-info-set@localhost.com");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        this.log.debug((Object)"Logging in");
        this.loginPage.login("all-info-set", "password");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"FirstName", (Object)this.accountUpdateProfilePage.getFirstName());
        Assert.assertEquals((Object)"LastName", (Object)this.accountUpdateProfilePage.getLastName());
        Assert.assertEquals((Object)"all-info-set@localhost.com", (Object)this.accountUpdateProfilePage.getEmail());
        Assert.assertEquals((Object)"all-info-set", (Object)this.accountUpdateProfilePage.getUsername());
    }

    @Test
    public void testWithoutUpdateProfile() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"", (Object)this.accountUpdateProfilePage.getFirstName());
        Assert.assertEquals((Object)"", (Object)this.accountUpdateProfilePage.getLastName());
        Assert.assertEquals((Object)this.bc.getUserEmail(), (Object)this.accountUpdateProfilePage.getEmail());
        Assert.assertEquals((Object)this.bc.getUserLogin(), (Object)this.accountUpdateProfilePage.getUsername());
    }

    @Test
    public void testAutoLinkAccountWithBroker() {
        this.testingClient.server(this.bc.consumerRealmName()).run(BrokerRunOnServerUtil.configureAutoLinkFlow(this.bc.getIDPAlias()));
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        this.assertNumFederatedIdentities(((UserRepresentation)realm.users().search(this.bc.getUserLogin()).get(0)).getId(), 1);
    }
}

