/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.After;
import org.junit.Before;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Retry;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.pages.AccountApplicationsPage;
import org.keycloak.testsuite.pages.AccountFederatedIdentityPage;
import org.keycloak.testsuite.pages.AccountPasswordPage;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.IdpConfirmLinkPage;
import org.keycloak.testsuite.pages.IdpLinkEmailPage;
import org.keycloak.testsuite.pages.InfoPage;
import org.keycloak.testsuite.pages.LoginConfigTotpPage;
import org.keycloak.testsuite.pages.LoginExpiredPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordResetPage;
import org.keycloak.testsuite.pages.LoginTotpPage;
import org.keycloak.testsuite.pages.OAuthGrantPage;
import org.keycloak.testsuite.pages.ProceedPage;
import org.keycloak.testsuite.pages.UpdateAccountInformationPage;
import org.keycloak.testsuite.pages.VerifyEmailPage;
import org.keycloak.testsuite.util.MailServer;
import org.keycloak.testsuite.util.UserBuilder;
import org.openqa.selenium.TimeoutException;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public abstract class AbstractBaseBrokerTest
extends AbstractKeycloakTest {
    protected static final String ATTRIBUTE_VALUE = "attribute.value";
    @Page
    protected AccountUpdateProfilePage accountUpdateProfilePage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected UpdateAccountInformationPage updateAccountInformationPage;
    @Page
    protected AccountPasswordPage accountPasswordPage;
    @Page
    protected ErrorPage errorPage;
    @Page
    protected IdpConfirmLinkPage idpConfirmLinkPage;
    @Page
    protected ProceedPage proceedPage;
    @Page
    protected InfoPage infoPage;
    @Page
    protected IdpLinkEmailPage idpLinkEmailPage;
    @Page
    protected LoginExpiredPage loginExpiredPage;
    @Page
    protected LoginTotpPage loginTotpPage;
    @Page
    protected LoginConfigTotpPage totpPage;
    @Page
    protected LoginPasswordResetPage loginPasswordResetPage;
    @Page
    protected VerifyEmailPage verifyEmailPage;
    @Page
    protected AccountFederatedIdentityPage accountFederatedIdentityPage;
    @Page
    protected AccountApplicationsPage accountApplicationsPage;
    @Page
    protected OAuthGrantPage grantPage;
    protected TimeBasedOTP totp = new TimeBasedOTP();
    protected BrokerConfiguration bc = this.getBrokerConfiguration();
    protected String userId;

    protected abstract BrokerConfiguration getBrokerConfiguration();

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }

    protected void configureSMTPServer() {
        MailServer.start();
        MailServer.createEmailAccount("user@localhost.com", "password");
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        RealmRepresentation master = realm.toRepresentation();
        master.setSmtpServer(this.suiteContext.getSmtpServer());
        realm.update(master);
    }

    protected void removeSMTPConfiguration(RealmResource consumerRealm) {
        RealmRepresentation master = consumerRealm.toRepresentation();
        master.setSmtpServer(Collections.emptyMap());
        consumerRealm.update(master);
    }

    protected void addClientsToProviderAndConsumer() {
        List<ClientRepresentation> clients = this.bc.createProviderClients();
        RealmResource providerRealm = this.adminClient.realm(this.bc.providerRealmName());
        for (ClientRepresentation client : clients) {
            this.log.debug((Object)("adding client " + client.getClientId() + " to realm " + this.bc.providerRealmName()));
            Response resp = providerRealm.clients().create(client);
            resp.close();
        }
        clients = this.bc.createConsumerClients();
        if (clients != null) {
            RealmResource consumerRealm = this.adminClient.realm(this.bc.consumerRealmName());
            for (ClientRepresentation client : clients) {
                this.log.debug((Object)("adding client " + client.getClientId() + " to realm " + this.bc.consumerRealmName()));
                Response resp = consumerRealm.clients().create(client);
                resp.close();
            }
        }
    }

    @Before
    public void beforeBrokerTest() {
        this.importRealm(this.bc.createConsumerRealm());
        this.importRealm(this.bc.createProviderRealm());
    }

    @After
    public void cleanupUsers() {
        this.adminClient.realm(this.bc.consumerRealmName()).remove();
        this.adminClient.realm(this.bc.providerRealmName()).remove();
        MailServer.stop();
    }

    protected String createUser(String username, String email) {
        UserRepresentation newUser = UserBuilder.create().username(username).email(email).enabled(true).build();
        String userId = ApiUtil.createUserWithAdminClient((RealmResource)this.adminClient.realm(this.bc.consumerRealmName()), (UserRepresentation)newUser);
        ApiUtil.resetUserPassword((UserResource)this.adminClient.realm(this.bc.consumerRealmName()).users().get(userId), (String)"password", (boolean)false);
        return userId;
    }

    protected String createUser(String username) {
        return this.createUser(username, "user@localhost.com");
    }

    protected void assertNumFederatedIdentities(String userId, int expected) {
        org.junit.Assert.assertEquals((long)expected, (long)this.adminClient.realm(this.bc.consumerRealmName()).users().get(userId).getFederatedIdentity().size());
    }

    protected void logInAsUserInIDP() {
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
    }

    protected void logInWithBroker(BrokerConfiguration bc) {
        this.logInWithIdp(bc.getIDPAlias(), bc.getUserLogin(), bc.getUserPassword());
    }

    protected void logInWithIdp(String idpAlias, String username, String password) {
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        this.log.debug((Object)("Clicking social " + idpAlias));
        this.loginPage.clickSocial(idpAlias);
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        this.log.debug((Object)"Logging in");
        this.loginPage.login(username, password);
    }

    protected void logInAsUserInIDPForFirstTime() {
        this.logInAsUserInIDP();
        this.updateAccountInformation();
    }

    protected void updateAccountInformation() {
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        Assert.assertTrue((boolean)this.updateAccountInformationPage.isCurrent());
        Assert.assertTrue((String)"We must be on correct realm right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/"));
        this.log.debug((Object)"Updating info on updateAccount page");
        this.updateAccountInformationPage.updateAccountInformation(this.bc.getUserLogin(), this.bc.getUserEmail(), "Firstname", "Lastname");
    }

    protected String getAccountUrl(String contextRoot, String realmName) {
        return contextRoot + "/auth/realms/" + realmName + "/account";
    }

    protected String getAccountPasswordUrl(String contextRoot, String realmName) {
        return contextRoot + "/auth/realms/" + realmName + "/account/password";
    }

    protected String getLoginUrl(String contextRoot, String realmName, String clientId) {
        List clients = this.adminClient.realm(realmName).clients().findByClientId(clientId);
        org.junit.Assert.assertThat((Object)clients, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        String redirectURI = ((ClientRepresentation)clients.get(0)).getBaseUrl();
        return contextRoot + "/auth/realms/" + realmName + "/protocol/openid-connect/auth?client_id=" + clientId + "&redirect_uri=" + redirectURI + "&response_type=code&scope=openid";
    }

    protected void logoutFromRealm(String contextRoot, String realm) {
        this.logoutFromRealm(contextRoot, realm, null);
    }

    protected void logoutFromRealm(String contextRoot, String realm, String initiatingIdp) {
        this.logoutFromRealm(contextRoot, realm, initiatingIdp, null);
    }

    protected void logoutFromRealm(String contextRoot, String realm, String initiatingIdp, String tokenHint) {
        this.driver.navigate().to(contextRoot + "/auth/realms/" + realm + "/protocol/openid-connect/logout?redirect_uri=" + BrokerTestTools.encodeUrl(this.getAccountUrl(contextRoot, realm)) + (!StringUtils.isBlank((String)initiatingIdp) ? "&initiating_idp=" + initiatingIdp : "") + (!StringUtils.isBlank((String)tokenHint) ? "&id_token_hint=" + tokenHint : ""));
        try {
            Retry.execute(() -> {
                try {
                    BrokerTestTools.waitForPage(this.driver, "sign in to " + realm, true);
                }
                catch (TimeoutException ex) {
                    this.driver.navigate().refresh();
                    this.log.debug((Object)"[Retriable] Timed out waiting for login page");
                    throw ex;
                }
            }, (int)10, (long)100L);
        }
        catch (TimeoutException e) {
            this.log.debug((Object)this.driver.getTitle());
            this.log.debug((Object)this.driver.getPageSource());
            Assert.fail((String)"Timeout while waiting for login page");
        }
    }

    protected void assertLoggedInAccountManagement() {
        this.assertLoggedInAccountManagement(this.bc.getUserLogin(), this.bc.getUserEmail());
    }

    protected void assertLoggedInAccountManagement(String username, String email) {
        this.waitForAccountManagementTitle();
        Assert.assertTrue((boolean)this.accountUpdateProfilePage.isCurrent());
        Assert.assertEquals((Object)this.accountUpdateProfilePage.getUsername(), (Object)username);
        Assert.assertEquals((Object)this.accountUpdateProfilePage.getEmail(), (Object)email);
    }

    protected void waitForAccountManagementTitle() {
        String title = this.getProjectName().toLowerCase() + " account management";
        BrokerTestTools.waitForPage(this.driver, title, true);
    }

    protected void assertErrorPage(String expectedError) {
        this.errorPage.assertCurrent();
        Assert.assertEquals((Object)expectedError, (Object)this.errorPage.getError());
    }

    protected URI getConsumerSamlEndpoint(String realm) throws IllegalArgumentException, UriBuilderException {
        return this.getSamlEndpoint(BrokerTestTools.getConsumerRoot(), realm);
    }

    protected URI getProviderSamlEndpoint(String realm) throws IllegalArgumentException, UriBuilderException {
        return this.getSamlEndpoint(BrokerTestTools.getProviderRoot(), realm);
    }

    protected URI getSamlEndpoint(String fromUri, String realm) {
        return RealmsResource.protocolUrl((UriBuilder)UriBuilder.fromUri((String)fromUri).path("auth")).build(new Object[]{realm, "saml"});
    }
}

