/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.broker.AbstractRoleMapperTest;

public abstract class AbstractAdvancedRoleMapperTest
extends AbstractRoleMapperTest {
    private static final String CLAIMS_OR_ATTRIBUTES = "[\n  {\n    \"key\": \"user-attribute\",\n    \"value\": \"value 1\"\n  },\n  {\n    \"key\": \"user-attribute-2\",\n    \"value\": \"value 2\"\n  }\n]";
    private static final String CLAIMS_OR_ATTRIBUTES_REGEX = "[\n  {\n    \"key\": \"user-attribute\",\n    \"value\": \"va.*\"\n  },\n  {\n    \"key\": \"user-attribute-2\",\n    \"value\": \"value 2\"\n  }\n]";
    private String newValueForAttribute2 = "";

    @Test
    public void allValuesMatch() {
        this.createAdvancedRoleMapper(CLAIMS_OR_ATTRIBUTES, false);
        this.createUserInProviderRealm((Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"value 1").build()).put((Object)"user-attribute-2", (Object)ImmutableList.builder().add((Object)"value 2").build()).build());
        this.logInAsUserInIDPForFirstTime();
        UserRepresentation user = this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        this.assertThatRoleHasBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void valuesMismatch() {
        this.createAdvancedRoleMapper(CLAIMS_OR_ATTRIBUTES, false);
        this.createUserInProviderRealm((Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"value 1").build()).put((Object)"user-attribute-2", (Object)ImmutableList.builder().add((Object)"value mismatch").build()).build());
        this.logInAsUserInIDPForFirstTime();
        UserRepresentation user = this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        this.assertThatRoleHasNotBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void valuesMatchIfNoClaimsSpecified() {
        this.createAdvancedRoleMapper("[]", false);
        this.createUserInProviderRealm((Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"some value").build()).put((Object)"user-attribute-2", (Object)ImmutableList.builder().add((Object)"some value").build()).build());
        this.logInAsUserInIDPForFirstTime();
        UserRepresentation user = this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        this.assertThatRoleHasBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void allValuesMatchRegex() {
        this.createAdvancedRoleMapper(CLAIMS_OR_ATTRIBUTES_REGEX, true);
        this.createUserInProviderRealm((Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"value 1").build()).put((Object)"user-attribute-2", (Object)ImmutableList.builder().add((Object)"value 2").build()).build());
        this.logInAsUserInIDPForFirstTime();
        UserRepresentation user = this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        this.assertThatRoleHasBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void valuesMismatchRegex() {
        this.createAdvancedRoleMapper(CLAIMS_OR_ATTRIBUTES_REGEX, true);
        this.createUserInProviderRealm((Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"mismatch").build()).put((Object)"user-attribute-2", (Object)ImmutableList.builder().add((Object)"value 2").build()).build());
        this.logInAsUserInIDPForFirstTime();
        UserRepresentation user = this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        this.assertThatRoleHasNotBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void updateBrokeredUserMismatchDeletesRole() {
        this.newValueForAttribute2 = "value mismatch";
        UserRepresentation user = this.createMapperAndLoginAsUserTwiceWithMapper(IdentityProviderMapperSyncMode.FORCE, false);
        this.assertThatRoleHasNotBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void updateBrokeredUserMismatchDoesNotDeleteRoleInImportMode() {
        this.newValueForAttribute2 = "value mismatch";
        UserRepresentation user = this.createMapperAndLoginAsUserTwiceWithMapper(IdentityProviderMapperSyncMode.IMPORT, false);
        this.assertThatRoleHasBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void updateBrokeredUserMatchDoesntDeleteRole() {
        this.newValueForAttribute2 = "value 2";
        UserRepresentation user = this.createMapperAndLoginAsUserTwiceWithMapper(IdentityProviderMapperSyncMode.FORCE, false);
        this.assertThatRoleHasBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void updateBrokeredUserAssignsRoleInForceModeWhenCreatingTheMapperAfterFirstLogin() {
        this.newValueForAttribute2 = "value 2";
        UserRepresentation user = this.createMapperAndLoginAsUserTwiceWithMapper(IdentityProviderMapperSyncMode.FORCE, true);
        this.assertThatRoleHasBeenAssignedInConsumerRealmTo(user);
    }

    public UserRepresentation createMapperAndLoginAsUserTwiceWithMapper(IdentityProviderMapperSyncMode syncMode, boolean createAfterFirstLogin) {
        return this.loginAsUserTwiceWithMapper(syncMode, createAfterFirstLogin, (Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"value 1").build()).put((Object)"user-attribute-2", (Object)ImmutableList.builder().add((Object)"value 2").build()).build());
    }

    @Override
    protected void updateUser() {
        UserRepresentation user = this.findUser(this.bc.providerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        ImmutableMap matchingAttributes = ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"value 1").build()).put((Object)"user-attribute-2", (Object)ImmutableList.builder().add((Object)this.newValueForAttribute2).build()).put((Object)"some.other.attribute", (Object)ImmutableList.builder().add((Object)"some value").build()).build();
        user.setAttributes((Map)matchingAttributes);
        this.adminClient.realm(this.bc.providerRealmName()).users().get(user.getId()).update(user);
    }

    @Override
    protected void createMapperInIdp(IdentityProviderRepresentation idp, IdentityProviderMapperSyncMode syncMode) {
        this.createMapperInIdp(idp, CLAIMS_OR_ATTRIBUTES, false, syncMode);
    }

    protected void createAdvancedRoleMapper(String claimsOrAttributeRepresentation, boolean areClaimsOrAttributeValuesRegexes) {
        IdentityProviderRepresentation idp = this.setupIdentityProvider();
        this.createMapperInIdp(idp, claimsOrAttributeRepresentation, areClaimsOrAttributeValuesRegexes, IdentityProviderMapperSyncMode.IMPORT);
    }

    protected abstract void createMapperInIdp(IdentityProviderRepresentation var1, String var2, boolean var3, IdentityProviderMapperSyncMode var4);
}

