/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.util.Time;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.Urls;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.BrokerRunOnServerUtil;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.openqa.selenium.TimeoutException;

public abstract class AbstractAdvancedBrokerTest
extends AbstractBrokerTest {
    protected void createRoleMappersForConsumerRealm() {
        this.createRoleMappersForConsumerRealm(IdentityProviderMapperSyncMode.FORCE);
    }

    protected void createRoleMappersForConsumerRealm(IdentityProviderMapperSyncMode syncMode) {
        this.log.debug((Object)("adding mappers to identity provider in realm " + this.bc.consumerRealmName()));
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        IdentityProviderResource idpResource = realm.identityProviders().get(this.bc.getIDPAlias());
        for (IdentityProviderMapperRepresentation mapper : this.createIdentityProviderMappers(syncMode)) {
            mapper.setIdentityProviderAlias(this.bc.getIDPAlias());
            Response resp = idpResource.addMapper(mapper);
            resp.close();
        }
    }

    protected abstract Iterable<IdentityProviderMapperRepresentation> createIdentityProviderMappers(IdentityProviderMapperSyncMode var1);

    protected abstract void createAdditionalMapperWithCustomSyncMode(IdentityProviderMapperSyncMode var1);

    @Test
    public void testAccountManagementLinkIdentity() {
        this.createUser("consumer");
        this.accountFederatedIdentityPage.realm(this.bc.consumerRealmName());
        this.accountFederatedIdentityPage.open();
        this.loginPage.login("consumer", "password");
        org.junit.Assert.assertTrue((boolean)this.accountFederatedIdentityPage.isCurrent());
        this.accountFederatedIdentityPage.clickAddProvider(this.bc.getIDPAlias());
        this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        org.junit.Assert.assertTrue((boolean)this.accountFederatedIdentityPage.isCurrent());
        org.junit.Assert.assertTrue((boolean)this.accountFederatedIdentityPage.isLinked(this.bc.getIDPAlias()));
        this.accountFederatedIdentityPage.clickRemoveProvider(this.bc.getIDPAlias());
        this.accountFederatedIdentityPage.logout();
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        this.updateAccountInformationPage.updateAccountInformation("FirstName", "LastName");
        BrokerTestTools.waitForPage(this.driver, "account already exists", false);
        this.idpConfirmLinkPage.assertCurrent();
        this.idpConfirmLinkPage.clickLinkAccount();
        this.loginPage.login(this.bc.getUserPassword());
        this.accountFederatedIdentityPage.assertCurrent();
        org.junit.Assert.assertTrue((boolean)this.accountFederatedIdentityPage.isLinked(this.bc.getIDPAlias()));
        this.accountFederatedIdentityPage.clickRemoveProvider(this.bc.getIDPAlias());
        org.junit.Assert.assertFalse((boolean)this.accountFederatedIdentityPage.isLinked(this.bc.getIDPAlias()));
        this.accountFederatedIdentityPage.logout();
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
    }

    @Test
    public void testAccountManagementLinkedIdentityAlreadyExists() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        this.createUser(this.bc.consumerRealmName(), "consumer", "password", "FirstName", "LastName", "consumer@localhost.com");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.accountFederatedIdentityPage.realm(this.bc.consumerRealmName());
        this.accountFederatedIdentityPage.open();
        this.loginPage.login("consumer", "password");
        org.junit.Assert.assertTrue((boolean)this.accountFederatedIdentityPage.isCurrent());
        this.accountFederatedIdentityPage.clickAddProvider(this.bc.getIDPAlias());
        this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        org.junit.Assert.assertTrue((boolean)this.accountFederatedIdentityPage.isCurrent());
        org.junit.Assert.assertEquals((Object)("Federated identity returned by " + this.bc.getIDPAlias() + " is already linked to another user."), (Object)this.accountFederatedIdentityPage.getError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRetrieveToken() throws Exception {
        this.updateExecutions(AbstractBrokerTest::enableRequirePassword);
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        IdentityProviderRepresentation idpRep = this.identityProviderResource.toRepresentation();
        idpRep.setStoreToken(true);
        this.identityProviderResource.update(idpRep);
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        this.updatePasswordPage.updatePasswords("password", "password");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        String username = this.bc.getUserLogin();
        this.testingClient.server(this.bc.consumerRealmName()).run(BrokerRunOnServerUtil.grantReadTokenRole(username));
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.realm(this.bc.consumerRealmName()).clientId("broker-app").doGrantAccessTokenRequest("broker-app-secret", this.bc.getUserLogin(), this.bc.getUserPassword());
        AtomicReference<String> accessToken = new AtomicReference<String>(accessTokenResponse.getAccessToken());
        try (Client client = ((ClientBuilder)ClientBuilder.newBuilder().register(request -> request.getHeaders().add((Object)"Authorization", (Object)("Bearer " + (String)accessToken.get())))).build();){
            WebTarget target = client.target(Urls.identityProviderRetrieveToken((URI)URI.create(BrokerTestTools.getConsumerRoot() + "/auth"), (String)this.bc.getIDPAlias(), (String)this.bc.consumerRealmName()));
            try (Response response = target.request().get();){
                org.junit.Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
                org.junit.Assert.assertNotNull((Object)response.readEntity(String.class));
            }
            this.testingClient.server(this.bc.consumerRealmName()).run(BrokerRunOnServerUtil.revokeReadTokenRole(username));
            accessTokenResponse = this.oauth.realm(this.bc.consumerRealmName()).clientId("broker-app").doGrantAccessTokenRequest("broker-app-secret", this.bc.getUserLogin(), this.bc.getUserPassword());
            accessToken.set(accessTokenResponse.getAccessToken());
            response = target.request().get();
            var8_8 = null;
            try {
                org.junit.Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.getStatus());
            }
            catch (Throwable throwable) {
                var8_8 = throwable;
                throw throwable;
            }
            finally {
                if (response != null) {
                    if (var8_8 != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            var8_8.addSuppressed(throwable);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
    }

    @Test
    public void loginWithExistingUserWithBruteForceEnabled() {
        this.adminClient.realm(this.bc.consumerRealmName()).update(RealmBuilder.create().bruteForceProtected(true).failureFactor(2).build());
        this.loginWithExistingUser();
        this.driver.navigate().to(this.getAccountPasswordUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.accountPasswordPage.changePassword("password", "password");
        this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        try {
            BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        }
        catch (TimeoutException e) {
            this.log.debug((Object)this.driver.getTitle());
            this.log.debug((Object)this.driver.getPageSource());
            Assert.fail((String)"Timeout while waiting for login page");
        }
        for (int i = 0; i < 3; ++i) {
            try {
                BrokerTestTools.waitForElementEnabled(this.driver, "login");
            }
            catch (TimeoutException e) {
                Assert.fail((String)"Timeout while waiting for login element enabled");
            }
            this.loginPage.login(this.bc.getUserLogin(), "invalid");
        }
        org.junit.Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        try {
            BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        }
        catch (TimeoutException e) {
            this.log.debug((Object)this.driver.getTitle());
            this.log.debug((Object)this.driver.getPageSource());
            Assert.fail((String)"Timeout while waiting for login page");
        }
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        org.junit.Assert.assertEquals((Object)"Account is disabled, contact your administrator.", (Object)this.errorPage.getError());
    }

    @Test
    public void loginWithExistingUserWithErrorFromProviderIdP() {
        ClientRepresentation client = (ClientRepresentation)this.adminClient.realm(this.bc.providerRealmName()).clients().findByClientId(this.bc.getIDPClientIdInProviderRealm()).get(0);
        this.adminClient.realm(this.bc.providerRealmName()).clients().get(client.getId()).update(org.keycloak.testsuite.util.ClientBuilder.edit(client).consentRequired(true).build());
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        this.driver.manage().timeouts().pageLoadTimeout(30L, TimeUnit.MINUTES);
        BrokerTestTools.waitForPage(this.driver, "grant access", false);
        this.consentPage.cancel();
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        this.adminClient.realm(this.bc.providerRealmName()).clients().get(client.getId()).update(org.keycloak.testsuite.util.ClientBuilder.edit(client).consentRequired(false).build());
    }

    @Test
    public void testDisabledUser() {
        this.loginUser();
        this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        UserRepresentation userRep = (UserRepresentation)realm.users().search(this.bc.getUserLogin()).get(0);
        UserResource user = realm.users().get(userRep.getId());
        userRep.setEnabled(Boolean.valueOf(false));
        user.update(userRep);
        this.logInWithBroker(this.bc);
        this.errorPage.assertCurrent();
        org.junit.Assert.assertEquals((Object)"Account is disabled, contact your administrator.", (Object)this.errorPage.getError());
    }

    @Test
    public void mapperDoesNotGrantNewRoleFromTokenWithSyncModeImport() {
        this.testMapperAssigningRoles(IdentityProviderMapperSyncMode.IMPORT, false);
    }

    @Test
    public void mapperGrantsNewRoleFromTokenWithInheritedSyncModeForce() {
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        realm.identityProviders().get(this.bc.getIDPAlias()).update(this.bc.setUpIdentityProvider(IdentityProviderSyncMode.FORCE));
        this.testMapperAssigningRoles(IdentityProviderMapperSyncMode.INHERIT, true);
    }

    @Test
    public void mapperDoesNotGrantNewRoleFromTokenWithInheritedSyncModeImport() {
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        realm.identityProviders().get(this.bc.getIDPAlias()).update(this.bc.setUpIdentityProvider(IdentityProviderSyncMode.IMPORT));
        this.testMapperAssigningRoles(IdentityProviderMapperSyncMode.INHERIT, false);
    }

    private void testMapperAssigningRoles(IdentityProviderMapperSyncMode anImport, boolean isAssigned) {
        this.createRolesForRealm(this.bc.providerRealmName());
        this.createRolesForRealm(this.bc.consumerRealmName());
        this.createRoleMappersForConsumerRealm(anImport);
        RoleRepresentation managerRole = this.adminClient.realm(this.bc.providerRealmName()).roles().get("manager").toRepresentation();
        RoleRepresentation userRole = this.adminClient.realm(this.bc.providerRealmName()).roles().get("user").toRepresentation();
        UserResource userResource = this.adminClient.realm(this.bc.providerRealmName()).users().get(this.userId);
        userResource.roles().realmLevel().add(Collections.singletonList(managerRole));
        this.logInAsUserInIDPForFirstTime();
        UserResource consumerUserResource = this.adminClient.realm(this.bc.consumerRealmName()).users().get(((UserRepresentation)this.adminClient.realm(this.bc.consumerRealmName()).users().search(this.bc.getUserLogin()).get(0)).getId());
        Set currentRoles = consumerUserResource.roles().realmLevel().listAll().stream().map(RoleRepresentation::getName).collect(Collectors.toSet());
        org.junit.Assert.assertThat(currentRoles, (Matcher)Matchers.hasItems((Object[])new String[]{"manager"}));
        org.junit.Assert.assertThat(currentRoles, (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new String[]{"user"})));
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        userResource.roles().realmLevel().add(Collections.singletonList(userRole));
        this.logInAsUserInIDP();
        currentRoles = consumerUserResource.roles().realmLevel().listAll().stream().map(RoleRepresentation::getName).collect(Collectors.toSet());
        if (isAssigned) {
            org.junit.Assert.assertThat(currentRoles, (Matcher)Matchers.hasItems((Object[])new String[]{"manager", "user"}));
        } else {
            org.junit.Assert.assertThat(currentRoles, (Matcher)Matchers.hasItems((Object[])new String[]{"manager"}));
            org.junit.Assert.assertThat(currentRoles, (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new String[]{"user"})));
        }
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
    }

    @Test
    public void differentMappersCanHaveDifferentSyncModes() {
        this.createRolesForRealm(this.bc.providerRealmName());
        this.createRolesForRealm(this.bc.consumerRealmName());
        this.createRoleMappersForConsumerRealm(IdentityProviderMapperSyncMode.INHERIT);
        this.createAdditionalMapperWithCustomSyncMode(IdentityProviderMapperSyncMode.FORCE);
        RoleRepresentation managerRole = this.adminClient.realm(this.bc.providerRealmName()).roles().get("manager").toRepresentation();
        RoleRepresentation userRole = this.adminClient.realm(this.bc.providerRealmName()).roles().get("user").toRepresentation();
        RoleRepresentation friendlyManagerRole = this.adminClient.realm(this.bc.providerRealmName()).roles().get("friendly-manager").toRepresentation();
        UserResource userResource = this.adminClient.realm(this.bc.providerRealmName()).users().get(this.userId);
        userResource.roles().realmLevel().add(Collections.singletonList(managerRole));
        this.logInAsUserInIDPForFirstTime();
        UserResource consumerUserResource = this.adminClient.realm(this.bc.consumerRealmName()).users().get(((UserRepresentation)this.adminClient.realm(this.bc.consumerRealmName()).users().search(this.bc.getUserLogin()).get(0)).getId());
        Set currentRoles = consumerUserResource.roles().realmLevel().listAll().stream().map(RoleRepresentation::getName).collect(Collectors.toSet());
        org.junit.Assert.assertThat(currentRoles, (Matcher)Matchers.hasItems((Object[])new String[]{"manager"}));
        org.junit.Assert.assertThat(currentRoles, (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new String[]{"user", "friendly-manager"})));
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        userResource.roles().realmLevel().add(Arrays.asList(userRole, friendlyManagerRole));
        this.logInAsUserInIDP();
        currentRoles = consumerUserResource.roles().realmLevel().listAll().stream().map(RoleRepresentation::getName).collect(Collectors.toSet());
        org.junit.Assert.assertThat(currentRoles, (Matcher)Matchers.hasItems((Object[])new String[]{"manager", "friendly-manager"}));
        org.junit.Assert.assertThat(currentRoles, (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new String[]{"user"})));
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
    }

    @Test
    public void testExpiredCode() {
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.log.debug((Object)"Expire all browser cookies");
        this.driver.manage().deleteAllCookies();
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sorry", false);
        this.errorPage.assertCurrent();
        String link = this.errorPage.getBackToApplicationLink();
        Assert.assertTrue((boolean)link.endsWith("/auth/realms/consumer/account/"));
    }

    @Test
    public void testPostBrokerLoginFlowWithOTP() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        this.testingClient.server(this.bc.consumerRealmName()).run(BrokerRunOnServerUtil.configurePostBrokerLoginWithOTP(this.bc.getIDPAlias()));
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        this.totpPage.assertCurrent();
        String totpSecret = this.totpPage.getTotpSecret();
        this.totpPage.configure(this.totp.generateTOTP(totpSecret));
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        this.assertNumFederatedIdentities(((UserRepresentation)realm.users().search(this.bc.getUserLogin()).get(0)).getId(), 1);
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.logInWithBroker(this.bc);
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.login(this.totp.generateTOTP(totpSecret));
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.testingClient.server(this.bc.consumerRealmName()).run(BrokerRunOnServerUtil.disablePostBrokerLoginFlow(this.bc.getIDPAlias()));
        this.logInWithBroker(this.bc);
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostBrokerLoginFlowWithOTP_bruteForceEnabled() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        this.testingClient.server(this.bc.consumerRealmName()).run(BrokerRunOnServerUtil.configurePostBrokerLoginWithOTP(this.bc.getIDPAlias()));
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        RealmRepresentation consumerRealmRep = realm.toRepresentation();
        consumerRealmRep.setBruteForceProtected(Boolean.valueOf(true));
        consumerRealmRep.setFailureFactor(Integer.valueOf(2));
        consumerRealmRep.setMaxDeltaTimeSeconds(Integer.valueOf(20));
        consumerRealmRep.setMaxFailureWaitSeconds(Integer.valueOf(100));
        consumerRealmRep.setWaitIncrementSeconds(Integer.valueOf(5));
        realm.update(consumerRealmRep);
        try {
            this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
            this.logInWithBroker(this.bc);
            this.totpPage.assertCurrent();
            String totpSecret = this.totpPage.getTotpSecret();
            this.totpPage.configure(this.totp.generateTOTP(totpSecret));
            this.assertNumFederatedIdentities(((UserRepresentation)realm.users().search(this.bc.getUserLogin()).get(0)).getId(), 1);
            this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
            this.logInWithBroker(this.bc);
            this.loginTotpPage.assertCurrent();
            this.loginTotpPage.login("bad-totp");
            Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.loginTotpPage.getInputError());
            this.loginTotpPage.login("bad-totp");
            Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.loginTotpPage.getInputError());
            this.loginTotpPage.login(this.totp.generateTOTP(totpSecret));
            Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.loginTotpPage.getInputError());
            String userId = ApiUtil.findUserByUsername((RealmResource)realm, (String)this.bc.getUserLogin()).getId();
            realm.attackDetection().clearBruteForceForUser(userId);
            this.loginTotpPage.login(this.totp.generateTOTP(totpSecret));
            this.waitForAccountManagementTitle();
            this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        }
        finally {
            this.testingClient.server(this.bc.consumerRealmName()).run(BrokerRunOnServerUtil.disablePostBrokerLoginFlow(this.bc.getIDPAlias()));
            consumerRealmRep = realm.toRepresentation();
            consumerRealmRep.setBruteForceProtected(Boolean.valueOf(false));
            realm.update(consumerRealmRep);
        }
    }

    @Test
    public void testLogoutWorksWithTokenTimeout() {
        try {
            this.updateExecutions(AbstractBrokerTest::enableUpdateProfileOnFirstLogin);
            RealmRepresentation realm = this.adminClient.realm(this.bc.providerRealmName()).toRepresentation();
            org.junit.Assert.assertNotNull((Object)realm);
            realm.setAccessTokenLifespan(Integer.valueOf(1));
            this.adminClient.realm(this.bc.providerRealmName()).update(realm);
            IdentityProviderRepresentation idp = this.adminClient.realm(this.bc.consumerRealmName()).identityProviders().get(this.bc.getIDPAlias()).toRepresentation();
            idp.getConfig().put("backchannelSupported", "false");
            this.adminClient.realm(this.bc.consumerRealmName()).identityProviders().get(this.bc.getIDPAlias()).update(idp);
            Time.setOffset((int)2);
            this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
            this.logInWithBroker(this.bc);
            BrokerTestTools.waitForPage(this.driver, "update account information", false);
            this.updateAccountInformationPage.assertCurrent();
            this.updateAccountInformationPage.updateAccountInformation("FirstName", "LastName");
            this.accountPage.logOut();
            BrokerTestTools.waitForPage(this.driver, "sign in to", true);
            this.log.debug((Object)"Logging in");
            org.junit.Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/protocol/openid-connect/auth"));
        }
        finally {
            Time.setOffset((int)0);
        }
    }

    @Test
    public void testWithLinkedFederationProvider() {
        try {
            this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
            ComponentRepresentation component = new ComponentRepresentation();
            component.setId("dummy");
            component.setName("dummy");
            component.setProviderId("dummy");
            component.setProviderType(UserStorageProvider.class.getName());
            this.adminClient.realm(this.bc.consumerRealmName()).components().add(component);
            this.createUser(this.bc.providerRealmName(), "test-user", "password", "FirstName", "LastName", "test-user@localhost.com");
            this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
            this.loginPage.clickSocial(this.bc.getIDPAlias());
            this.loginPage.login("test-user", "password");
            this.waitForAccountManagementTitle();
            this.accountUpdateProfilePage.assertCurrent();
            this.accountPage.password();
            this.accountPasswordPage.changePassword("bad", "new-password", "new-password");
            org.junit.Assert.assertEquals((Object)"Invalid existing password.", (Object)this.accountPasswordPage.getError());
            this.accountPasswordPage.changePassword("secret", "new-password", "new-password");
            org.junit.Assert.assertEquals((Object)"Your password has been updated.", (Object)this.accountUpdateProfilePage.getSuccess());
            this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
            this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
            this.createUser(this.bc.providerRealmName(), "test-user-noemail", "password", "FirstName", "LastName", "test-user-noemail@localhost.com");
            this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
            this.loginPage.clickSocial(this.bc.getIDPAlias());
            this.loginPage.login("test-user-noemail", "password");
            this.waitForAccountManagementTitle();
            this.accountUpdateProfilePage.assertCurrent();
            this.accountPage.password();
            this.accountPasswordPage.changePassword("new-password", "new-password");
            org.junit.Assert.assertEquals((Object)"Your password has been updated.", (Object)this.accountUpdateProfilePage.getSuccess());
        }
        finally {
            ApiUtil.removeUserByUsername((RealmResource)this.adminClient.realm(this.bc.consumerRealmName()), (String)"test-user");
            ApiUtil.removeUserByUsername((RealmResource)this.adminClient.realm(this.bc.consumerRealmName()), (String)"test-user-noemail");
        }
    }
}

