/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.util.List;
import javax.ws.rs.core.UriInfo;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.client.resource.PermissionResource;
import org.keycloak.forms.account.freemarker.model.AuthorizationBean;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.DecisionEffect;
import org.keycloak.representations.idm.authorization.PermissionTicketRepresentation;
import org.keycloak.representations.idm.authorization.PolicyEvaluationRequest;
import org.keycloak.representations.idm.authorization.PolicyEvaluationResponse;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.authz.AbstractResourceServerTest;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class UmaRepresentationTest
extends AbstractResourceServerTest {
    private ResourceRepresentation resource;
    private PermissionResource permission;

    private void createPermissionTicket() {
        PermissionTicketRepresentation ticket = new PermissionTicketRepresentation();
        ticket.setOwner(this.resource.getOwner().getId());
        ticket.setResource(this.resource.getId());
        ticket.setRequesterName("kolo");
        ticket.setScopeName("ScopeA");
        ticket.setGranted(true);
        this.permission.create(ticket);
    }

    @Test
    public void testCanRepresentPermissionTicketWithNamesOfResourceOwnedByUser() throws Exception {
        this.resource = this.addResource("Resource A", "marta", true, "ScopeA");
        this.permission = this.getAuthzClient().protection("marta", "password").permission();
        this.createPermissionTicket();
        List permissionTickets = this.permission.find(this.resource.getId(), null, null, null, null, Boolean.valueOf(true), null, null);
        Assert.assertFalse((boolean)permissionTickets.isEmpty());
        Assert.assertEquals((long)1L, (long)permissionTickets.size());
        PermissionTicketRepresentation ticket = (PermissionTicketRepresentation)permissionTickets.get(0);
        Assert.assertEquals((Object)ticket.getOwnerName(), (Object)"marta");
        Assert.assertEquals((Object)ticket.getRequesterName(), (Object)"kolo");
        Assert.assertEquals((Object)ticket.getResourceName(), (Object)"Resource A");
        Assert.assertEquals((Object)ticket.getScopeName(), (Object)"ScopeA");
        Assert.assertTrue((boolean)ticket.isGranted());
    }

    @Test
    public void testCanRepresentPermissionTicketWithNamesOfResourceOwnedByClient() throws Exception {
        this.resource = this.addResource("Resource A", this.getClient(this.getRealm()).toRepresentation().getId(), true, "ScopeA");
        this.permission = this.getAuthzClient().protection().permission();
        this.createPermissionTicket();
        List permissionTickets = this.permission.find(this.resource.getId(), null, null, null, null, Boolean.valueOf(true), null, null);
        Assert.assertFalse((boolean)permissionTickets.isEmpty());
        Assert.assertEquals((long)1L, (long)permissionTickets.size());
        PermissionTicketRepresentation ticket = (PermissionTicketRepresentation)permissionTickets.get(0);
        Assert.assertEquals((Object)ticket.getOwnerName(), (Object)"resource-server-test");
        Assert.assertEquals((Object)ticket.getRequesterName(), (Object)"kolo");
        Assert.assertEquals((Object)ticket.getResourceName(), (Object)"Resource A");
        Assert.assertEquals((Object)ticket.getScopeName(), (Object)"ScopeA");
        Assert.assertTrue((boolean)ticket.isGranted());
    }

    @Test
    public void testCanRepresentPolicyResultGrantOfResourceOwnedByUser() throws Exception {
        this.resource = this.addResource("Resource A", "marta", true, "ScopeA");
        this.permission = this.getAuthzClient().protection("marta", "password").permission();
        this.createPermissionTicket();
        RealmResource realm = this.getRealm();
        String resourceServerId = this.getClient(realm).toRepresentation().getId();
        UserRepresentation user = (UserRepresentation)realm.users().search("kolo").get(0);
        PolicyEvaluationRequest request = new PolicyEvaluationRequest();
        request.setUserId(user.getId());
        request.setClientId(resourceServerId);
        request.addResource("Resource A", new String[]{"ScopeA"});
        PolicyEvaluationResponse result = this.getClient(realm).authorization().policies().evaluate(request);
        Assert.assertEquals((Object)result.getStatus(), (Object)DecisionEffect.PERMIT);
        List evaluations = result.getResults();
        Assert.assertFalse((boolean)evaluations.isEmpty());
        Assert.assertEquals((long)1L, (long)evaluations.size());
        List policies = ((PolicyEvaluationResponse.EvaluationResultRepresentation)evaluations.get(0)).getPolicies();
        Assert.assertFalse((boolean)evaluations.isEmpty());
        Assert.assertEquals((long)1L, (long)evaluations.size());
        String description = ((PolicyEvaluationResponse.PolicyResultRepresentation)policies.get(0)).getPolicy().getDescription();
        Assert.assertTrue((boolean)description.startsWith("Resource owner (marta) grants access"));
    }

    @Test
    public void testCanRepresentPolicyResultGrantOfResourceOwnedByClient() throws Exception {
        this.resource = this.addResource("Resource A", this.getClient(this.getRealm()).toRepresentation().getId(), true, "ScopeA");
        this.permission = this.getAuthzClient().protection().permission();
        this.createPermissionTicket();
        RealmResource realm = this.getRealm();
        String resourceServerId = this.getClient(realm).toRepresentation().getId();
        UserRepresentation user = (UserRepresentation)realm.users().search("kolo").get(0);
        PolicyEvaluationRequest request = new PolicyEvaluationRequest();
        request.setUserId(user.getId());
        request.setClientId(resourceServerId);
        request.addResource("Resource A", new String[]{"ScopeA"});
        PolicyEvaluationResponse result = this.getClient(realm).authorization().policies().evaluate(request);
        Assert.assertEquals((Object)result.getStatus(), (Object)DecisionEffect.PERMIT);
        List evaluations = result.getResults();
        Assert.assertFalse((boolean)evaluations.isEmpty());
        Assert.assertEquals((long)1L, (long)evaluations.size());
        List policies = ((PolicyEvaluationResponse.EvaluationResultRepresentation)evaluations.get(0)).getPolicies();
        Assert.assertFalse((boolean)evaluations.isEmpty());
        Assert.assertEquals((long)1L, (long)evaluations.size());
        String description = ((PolicyEvaluationResponse.PolicyResultRepresentation)policies.get(0)).getPolicy().getDescription();
        Assert.assertTrue((boolean)description.startsWith("Resource owner (resource-server-test) grants access"));
    }

    @Test
    public void testCanRepresentResourceBeanOfResourceOwnedByUser() throws Exception {
        this.resource = this.addResource("Resource A", "marta", true, "ScopeA");
        this.testingClient.server().run(UmaRepresentationTest::testCanRepresentResourceBeanOfResourceOwnedByUser);
    }

    public static void testCanRepresentResourceBeanOfResourceOwnedByUser(KeycloakSession session) {
        session.getContext().setRealm(session.realms().getRealmByName("authz-test"));
        AuthorizationProvider authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        AuthorizationBean authorizationBean = new AuthorizationBean(session, null, (UriInfo)session.getContext().getUri());
        ClientModel client = session.getContext().getRealm().getClientByClientId("resource-server-test");
        UserModel user = session.userStorageManager().getUserByUsername(session.getContext().getRealm(), "marta");
        AuthorizationBean authorizationBean2 = authorizationBean;
        authorizationBean2.getClass();
        AuthorizationBean.ResourceBean resourceBean = new AuthorizationBean.ResourceBean(authorizationBean2, authorization.getStoreFactory().getResourceStore().findByName("Resource A", user.getId(), client.getId()));
        Assert.assertEquals((Object)"Resource A", (Object)resourceBean.getName());
        Assert.assertEquals((Object)"marta", (Object)resourceBean.getOwnerName());
        Assert.assertNotNull((Object)resourceBean.getUserOwner());
        Assert.assertEquals((Object)"marta", (Object)resourceBean.getUserOwner().getUsername());
        Assert.assertNull((Object)resourceBean.getClientOwner());
    }

    @Test
    public void testCanRepresentResourceBeanOfResourceOwnedByClient() throws Exception {
        this.resource = this.addResource("Resource A", this.getClient(this.getRealm()).toRepresentation().getId(), true, "ScopeA");
        this.testingClient.server().run(UmaRepresentationTest::testCanRepresentResourceBeanOfResourceOwnedByClient);
    }

    public static void testCanRepresentResourceBeanOfResourceOwnedByClient(KeycloakSession session) {
        session.getContext().setRealm(session.realms().getRealmByName("authz-test"));
        AuthorizationProvider authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        AuthorizationBean authorizationBean = new AuthorizationBean(session, null, (UriInfo)session.getContext().getUri());
        ClientModel client = session.getContext().getRealm().getClientByClientId("resource-server-test");
        AuthorizationBean authorizationBean2 = authorizationBean;
        authorizationBean2.getClass();
        AuthorizationBean.ResourceBean resourceBean = new AuthorizationBean.ResourceBean(authorizationBean2, authorization.getStoreFactory().getResourceStore().findByName("Resource A", client.getId(), client.getId()));
        Assert.assertEquals((Object)"Resource A", (Object)resourceBean.getName());
        Assert.assertEquals((Object)"resource-server-test", (Object)resourceBean.getOwnerName());
        Assert.assertNotNull((Object)resourceBean.getClientOwner());
        Assert.assertEquals((Object)"resource-server-test", (Object)resourceBean.getClientOwner().getClientId());
        Assert.assertNull((Object)resourceBean.getUserOwner());
    }
}

