/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import com.google.common.base.Charsets;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.authorization.client.AuthorizationDeniedException;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.representation.TokenIntrospectionResponse;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.JSPolicyRepresentation;
import org.keycloak.representations.idm.authorization.PermissionRequest;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.authz.AbstractResourceServerTest;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.util.BasicAuthHelper;
import org.keycloak.util.JsonSerialization;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class UmaGrantTypeTest
extends AbstractResourceServerTest {
    private ResourceRepresentation resourceA;

    @Before
    public void configureAuthorization() throws Exception {
        ClientResource client = this.getClient(this.getRealm());
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName("Default Policy");
        policy.setCode("$evaluation.grant();");
        authorization.policies().js().create(policy).close();
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        this.resourceA = this.addResource("Resource A", "ScopeA", "ScopeB", "ScopeC");
        permission.setName(this.resourceA.getName() + " Permission");
        permission.addResource(this.resourceA.getName());
        permission.addPolicy(new String[]{policy.getName()});
        authorization.permissions().resource().create(permission).close();
        policy = new JSPolicyRepresentation();
        policy.setName("Deny Policy");
        policy.setCode("$evaluation.deny();");
        authorization.policies().js().create(policy).close();
    }

    @Test
    public void testObtainRptWithClientAdditionalScopes() throws Exception {
        AuthorizationResponse response = this.authorize("marta", "password", "Resource A", new String[]{"ScopeA", "ScopeB"}, new String[]{"ScopeC"});
        AccessToken accessToken = this.toAccessToken(response.getToken());
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        Collection permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, "Resource A", "ScopeA", "ScopeB", "ScopeC");
        Assert.assertTrue((boolean)permissions.isEmpty());
    }

    @Test
    public void testObtainRptWithUpgrade() throws Exception {
        AuthorizationResponse response = this.authorize("marta", "password", "Resource A", new String[]{"ScopeA", "ScopeB"});
        String rpt = response.getToken();
        AccessToken.Authorization authorization = this.toAccessToken(rpt).getAuthorization();
        Collection permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, "Resource A", "ScopeA", "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
        response = this.authorize("marta", "password", "Resource A", new String[]{"ScopeC"}, rpt);
        Assert.assertTrue((boolean)response.isUpgraded());
        authorization = this.toAccessToken(response.getToken()).getAuthorization();
        permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, "Resource A", "ScopeA", "ScopeB", "ScopeC");
        Assert.assertTrue((boolean)permissions.isEmpty());
    }

    @Test
    public void testObtainRptWithUpgradeOnlyScopes() throws Exception {
        AuthorizationResponse response = this.authorize("marta", "password", null, new String[]{"ScopeA", "ScopeB"});
        String rpt = response.getToken();
        AccessToken.Authorization authorization = this.toAccessToken(rpt).getAuthorization();
        Collection permissions = authorization.getPermissions();
        Assert.assertFalse((boolean)response.isUpgraded());
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, "Resource A", "ScopeA", "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
        response = this.authorize("marta", "password", "Resource A", new String[]{"ScopeC"}, rpt);
        authorization = this.toAccessToken(response.getToken()).getAuthorization();
        permissions = authorization.getPermissions();
        Assert.assertTrue((boolean)response.isUpgraded());
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, "Resource A", "ScopeA", "ScopeB", "ScopeC");
        Assert.assertTrue((boolean)permissions.isEmpty());
    }

    @Test
    public void testObtainRptWithUpgradeWithUnauthorizedResource() throws Exception {
        AuthorizationResponse response = this.authorize("marta", "password", "Resource A", new String[]{"ScopeA", "ScopeB"});
        String rpt = response.getToken();
        AccessToken.Authorization authorization = this.toAccessToken(rpt).getAuthorization();
        Collection permissions = authorization.getPermissions();
        Assert.assertFalse((boolean)response.isUpgraded());
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, "Resource A", "ScopeA", "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        ResourceRepresentation resourceB = this.addResource("Resource B", "ScopeA", "ScopeB", "ScopeC");
        permission.setName(resourceB.getName() + " Permission");
        permission.addResource(resourceB.getName());
        permission.addPolicy(new String[]{"Deny Policy"});
        this.getClient(this.getRealm()).authorization().permissions().resource().create(permission).close();
        try {
            this.authorize("marta", "password", "Resource B", new String[]{"ScopeC"}, rpt);
            Assert.fail((String)"Should be denied, resource b not granted");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
    }

    @Test
    public void testObtainRptWithUpgradeWithUnauthorizedResourceFromRpt() throws Exception {
        ResourcePermissionRepresentation permissionA = new ResourcePermissionRepresentation();
        ResourceRepresentation resourceA = this.addResource(KeycloakModelUtils.generateId(), "ScopeA", "ScopeB", "ScopeC");
        permissionA.setName(resourceA.getName() + " Permission");
        permissionA.addResource(resourceA.getName());
        permissionA.addPolicy(new String[]{"Default Policy"});
        AuthorizationResource authzResource = this.getClient(this.getRealm()).authorization();
        authzResource.permissions().resource().create(permissionA).close();
        AuthorizationResponse response = this.authorize("marta", "password", resourceA.getId(), new String[]{"ScopeA", "ScopeB"});
        String rpt = response.getToken();
        AccessToken.Authorization authorization = this.toAccessToken(rpt).getAuthorization();
        Collection permissions = authorization.getPermissions();
        Assert.assertFalse((boolean)response.isUpgraded());
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, resourceA.getName(), "ScopeA", "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
        ResourceRepresentation resourceB = this.addResource(KeycloakModelUtils.generateId(), "ScopeA", "ScopeB", "ScopeC");
        ResourcePermissionRepresentation permissionB = new ResourcePermissionRepresentation();
        permissionB.setName(resourceB.getName() + " Permission");
        permissionB.addResource(resourceB.getName());
        permissionB.addPolicy(new String[]{"Default Policy"});
        authzResource.permissions().resource().create(permissionB).close();
        response = this.authorize("marta", "password", resourceB.getId(), new String[]{"ScopeC"}, rpt);
        rpt = response.getToken();
        authorization = this.toAccessToken(rpt).getAuthorization();
        permissions = authorization.getPermissions();
        Assert.assertTrue((boolean)response.isUpgraded());
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, resourceA.getName(), "ScopeA", "ScopeB");
        this.assertPermissions(permissions, resourceB.getName(), "ScopeC");
        Assert.assertTrue((boolean)permissions.isEmpty());
        permissionB = authzResource.permissions().resource().findByName(permissionB.getName());
        permissionB.removePolicy("Default Policy");
        permissionB.addPolicy(new String[]{"Deny Policy"});
        authzResource.permissions().resource().findById(permissionB.getId()).update(permissionB);
        response = this.authorize("marta", "password", resourceA.getId(), new String[]{"ScopeC"}, rpt);
        rpt = response.getToken();
        authorization = this.toAccessToken(rpt).getAuthorization();
        permissions = authorization.getPermissions();
        Assert.assertFalse((boolean)response.isUpgraded());
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, resourceA.getName(), "ScopeA", "ScopeB", "ScopeC");
        Assert.assertTrue((boolean)permissions.isEmpty());
    }

    @Test
    public void testObtainRptOnlyAuthorizedScopes() throws Exception {
        ResourceRepresentation resourceA = this.addResource(KeycloakModelUtils.generateId(), "READ", "WRITE");
        ScopePermissionRepresentation permissionA = new ScopePermissionRepresentation();
        permissionA.setName(KeycloakModelUtils.generateId());
        permissionA.addScope(new String[]{"READ"});
        permissionA.addPolicy(new String[]{"Default Policy"});
        AuthorizationResource authzResource = this.getClient(this.getRealm()).authorization();
        authzResource.permissions().scope().create(permissionA).close();
        ScopePermissionRepresentation permissionB = new ScopePermissionRepresentation();
        permissionB.setName(KeycloakModelUtils.generateId());
        permissionB.addScope(new String[]{"WRITE"});
        permissionB.addPolicy(new String[]{"Deny Policy"});
        authzResource.permissions().scope().create(permissionB).close();
        AuthorizationResponse response = this.authorize("marta", "password", resourceA.getName(), new String[]{"READ"});
        String rpt = response.getToken();
        AccessToken.Authorization authorization = this.toAccessToken(rpt).getAuthorization();
        Collection permissions = authorization.getPermissions();
        Assert.assertFalse((boolean)response.isUpgraded());
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, resourceA.getName(), "READ");
        Assert.assertTrue((boolean)permissions.isEmpty());
        response = this.authorize("marta", "password", resourceA.getName(), new String[]{"READ", "WRITE"});
        rpt = response.getToken();
        authorization = this.toAccessToken(rpt).getAuthorization();
        permissions = authorization.getPermissions();
        Assert.assertFalse((boolean)response.isUpgraded());
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, resourceA.getName(), "READ");
        Assert.assertTrue((boolean)permissions.isEmpty());
    }

    @Test
    public void testObtainRptWithOwnerManagedResource() throws Exception {
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        ResourceRepresentation resourceA = this.addResource("Resource Marta", "marta", true, "ScopeA", "ScopeB", "ScopeC");
        permission.setName(resourceA.getName() + " Permission");
        permission.addResource(resourceA.getId());
        permission.addPolicy(new String[]{"Default Policy"});
        this.getClient(this.getRealm()).authorization().permissions().resource().create(permission).close();
        ResourceRepresentation resourceB = this.addResource("Resource B", "marta", "ScopeA", "ScopeB", "ScopeC");
        permission.setName(resourceB.getName() + " Permission");
        permission.addResource(resourceB.getId());
        permission.addPolicy(new String[]{"Default Policy"});
        this.getClient(this.getRealm()).authorization().permissions().resource().create(permission).close();
        AuthorizationResponse response = this.authorize("marta", "password", new PermissionRequest(resourceA.getName(), new String[]{"ScopeA", "ScopeB"}), new PermissionRequest(resourceB.getName(), new String[]{"ScopeC"}));
        String rpt = response.getToken();
        AccessToken.Authorization authorization = this.toAccessToken(rpt).getAuthorization();
        Collection permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, resourceA.getName(), "ScopeA", "ScopeB");
        this.assertPermissions(permissions, resourceB.getName(), "ScopeC");
        Assert.assertTrue((boolean)permissions.isEmpty());
    }

    @Test
    public void testObtainRptWithClientCredentials() throws Exception {
        AuthorizationResponse response = this.authorize("Resource A", new String[]{"ScopeA", "ScopeB"});
        String rpt = response.getToken();
        Assert.assertNotNull((Object)rpt);
        Assert.assertFalse((boolean)response.isUpgraded());
        AccessToken accessToken = this.toAccessToken(rpt);
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        Assert.assertNotNull((Object)authorization);
        Collection permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, "Resource A", "ScopeA", "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
    }

    @Test
    public void testObtainRptUsingAccessToken() throws Exception {
        AccessTokenResponse accessTokenResponse = this.getAuthzClient().obtainAccessToken("marta", "password");
        AuthorizationResponse response = this.authorize(null, null, null, null, accessTokenResponse.getToken(), null, null, new PermissionRequest("Resource A", new String[]{"ScopeA", "ScopeB"}));
        String rpt = response.getToken();
        Assert.assertNotNull((Object)rpt);
        Assert.assertFalse((boolean)response.isUpgraded());
        AccessToken accessToken = this.toAccessToken(rpt);
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        Assert.assertNotNull((Object)authorization);
        Collection permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, "Resource A", "ScopeA", "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
    }

    @Test
    public void testCORSHeadersInFailedRptRequest() throws Exception {
        AccessTokenResponse accessTokenResponse = this.getAuthzClient().obtainAccessToken("marta", "password");
        UserRepresentation userRepresentation = (UserRepresentation)this.getRealm().users().search("marta").get(0);
        UserRepresentation updatedUser = UserBuilder.edit(userRepresentation).enabled(false).build();
        this.getRealm().users().get(userRepresentation.getId()).update(updatedUser);
        PermissionRequest permissions = new PermissionRequest("Resource A", new String[]{"ScopeA", "ScopeB"});
        String ticket = this.getAuthzClient().protection().permission().create(Arrays.asList(permissions)).getTicket();
        String tokenEndpoint = this.getAuthzClient().getServerConfiguration().getTokenEndpoint();
        HttpPost post = new HttpPost(tokenEndpoint);
        post.addHeader("Origin", "http://localhost");
        post.addHeader("Authorization", "Bearer " + accessTokenResponse.getToken());
        LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("grant_type", "urn:ietf:params:oauth:grant-type:uma-ticket"));
        parameters.add(new BasicNameValuePair("ticket", ticket));
        UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(parameters, Charsets.UTF_8);
        post.setEntity((HttpEntity)formEntity);
        CloseableHttpResponse response = ((CloseableHttpClient)this.oauth.getHttpClient().get()).execute((HttpUriRequest)post);
        Assert.assertEquals((long)401L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"http://localhost", (Object)response.getFirstHeader("Access-Control-Allow-Origin").getValue());
    }

    @Test
    public void testRefreshRpt() {
        AccessTokenResponse accessTokenResponse = this.getAuthzClient().obtainAccessToken("marta", "password");
        AuthorizationResponse response = this.authorize(null, null, null, null, accessTokenResponse.getToken(), null, null, new PermissionRequest("Resource A", new String[]{"ScopeA", "ScopeB"}));
        String rpt = response.getToken();
        Assert.assertNotNull((Object)rpt);
        AccessToken accessToken = this.toAccessToken(rpt);
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        Assert.assertNotNull((Object)authorization);
        Collection permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, "Resource A", "ScopeA", "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
        String refreshToken = response.getRefreshToken();
        Assert.assertNotNull((Object)refreshToken);
        AccessToken refreshTokenToken = this.toAccessToken(refreshToken);
        Assert.assertNotNull((Object)refreshTokenToken.getAuthorization());
        ResteasyClient client = AdminClientUtil.createResteasyClient();
        UriBuilder builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI uri = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder).build(new Object[]{"authz-test"});
        WebTarget target = client.target(uri);
        Form parameters = new Form();
        parameters.param("grant_type", "refresh_token");
        parameters.param("refresh_token", refreshToken);
        AccessTokenResponse refreshTokenResponse = (AccessTokenResponse)target.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"resource-server-test", (String)"secret")).post(Entity.form((Form)parameters)).readEntity(AccessTokenResponse.class);
        Assert.assertNotNull((Object)refreshTokenResponse.getToken());
        refreshToken = refreshTokenResponse.getRefreshToken();
        refreshTokenToken = this.toAccessToken(refreshToken);
        Assert.assertNotNull((Object)refreshTokenToken.getAuthorization());
        AccessToken refreshedToken = this.toAccessToken(rpt);
        authorization = refreshedToken.getAuthorization();
        Assert.assertNotNull((Object)authorization);
        permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, "Resource A", "ScopeA", "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
        refreshTokenResponse = (AccessTokenResponse)target.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"resource-server-test", (String)"secret")).post(Entity.form((Form)parameters)).readEntity(AccessTokenResponse.class);
        Assert.assertNotNull((Object)refreshTokenResponse.getToken());
        refreshToken = refreshTokenResponse.getRefreshToken();
        refreshTokenToken = this.toAccessToken(refreshToken);
        Assert.assertNotNull((Object)refreshTokenToken.getAuthorization());
        refreshedToken = this.toAccessToken(rpt);
        authorization = refreshedToken.getAuthorization();
        Assert.assertNotNull((Object)authorization);
        permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, "Resource A", "ScopeA", "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
    }

    @Test
    public void testObtainRptWithIDToken() throws Exception {
        String idToken = this.getIdToken("marta", "password");
        AuthorizationResponse response = this.authorize("Resource A", new String[]{"ScopeA", "ScopeB"}, idToken, "http://openid.net/specs/openid-connect-core-1_0.html#IDToken");
        String rpt = response.getToken();
        Assert.assertNotNull((Object)rpt);
        Assert.assertFalse((boolean)response.isUpgraded());
        AccessToken accessToken = this.toAccessToken(rpt);
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        Assert.assertNotNull((Object)authorization);
        Collection permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, "Resource A", "ScopeA", "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
    }

    @Test
    public void testTokenIntrospect() throws Exception {
        AuthzClient authzClient = this.getAuthzClient();
        AccessTokenResponse accessTokenResponse = authzClient.obtainAccessToken("marta", "password");
        AuthorizationResponse response = this.authorize(null, null, null, null, accessTokenResponse.getToken(), null, null, new PermissionRequest("Resource A", new String[]{"ScopeA", "ScopeB"}));
        String rpt = response.getToken();
        Assert.assertNotNull((Object)rpt);
        Assert.assertFalse((boolean)response.isUpgraded());
        AccessToken accessToken = this.toAccessToken(rpt);
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        Assert.assertNotNull((Object)authorization);
        Collection permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, "Resource A", "ScopeA", "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
        TokenIntrospectionResponse introspectionResponse = authzClient.protection().introspectRequestingPartyToken(rpt);
        Assert.assertNotNull((Object)introspectionResponse);
        Assert.assertNotNull((Object)introspectionResponse.getPermissions());
        this.oauth.realm("authz-test");
        String introspectHttpResponse = this.oauth.introspectTokenWithClientCredential("resource-server-test", "secret", "requesting_party_token", rpt);
        Map jsonNode = (Map)JsonSerialization.readValue((String)introspectHttpResponse, Map.class);
        Assert.assertEquals((Object)true, jsonNode.get("active"));
        Collection permissionClaims = (Collection)jsonNode.get("permissions");
        Assert.assertNotNull((Object)permissionClaims);
        Assert.assertEquals((long)1L, (long)permissionClaims.size());
        Map claim = (Map)permissionClaims.iterator().next();
        Assert.assertThat(claim.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"resource_id", "rsname", "resource_scopes", "scopes", "rsid"}));
        Assert.assertThat(claim.get("rsname"), (Matcher)Matchers.equalTo((Object)"Resource A"));
        ResourceRepresentation resourceRep = authzClient.protection().resource().findByName("Resource A");
        Assert.assertThat(claim.get("rsid"), (Matcher)Matchers.equalTo((Object)resourceRep.getId()));
        Assert.assertThat(claim.get("resource_id"), (Matcher)Matchers.equalTo((Object)resourceRep.getId()));
        Assert.assertThat((Object)((Collection)claim.get("resource_scopes")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"ScopeA", "ScopeB"}));
        Assert.assertThat((Object)((Collection)claim.get("scopes")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"ScopeA", "ScopeB"}));
    }

    @Test
    public void testNoRefreshToken() {
        ClientResource client = this.getClient(this.getRealm());
        ClientRepresentation clientRepresentation = client.toRepresentation();
        clientRepresentation.getAttributes().put("use.refresh.tokens", "false");
        client.update(clientRepresentation);
        AccessTokenResponse accessTokenResponse = this.getAuthzClient().obtainAccessToken("marta", "password");
        AuthorizationResponse response = this.authorize(null, null, null, null, accessTokenResponse.getToken(), null, null, new PermissionRequest("Resource A", new String[]{"ScopeA", "ScopeB"}));
        String rpt = response.getToken();
        String refreshToken = response.getRefreshToken();
        Assert.assertNotNull((Object)rpt);
        Assert.assertNull((Object)refreshToken);
        clientRepresentation.getAttributes().put("use.refresh.tokens", "true");
        client.update(clientRepresentation);
    }

    private String getIdToken(String username, String password) {
        this.oauth.realm("authz-test");
        this.oauth.clientId("test-app");
        this.oauth.openLoginForm();
        OAuthClient.AuthorizationEndpointResponse resp = this.oauth.doLogin(username, password);
        String code = resp.getCode();
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, password);
        return response.getIdToken();
    }
}

