/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.net.URI;
import java.util.List;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.authorization.config.UmaConfiguration;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.OAuthClient;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class UmaDiscoveryDocumentTest
extends AbstractKeycloakTest {
    @ArquillianResource
    protected OAuthClient oauth;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    @Test
    public void testFetchDiscoveryDocument() {
        ResteasyClient client = AdminClientUtil.createResteasyClient();
        UriBuilder builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI oidcDiscoveryUri = RealmsResource.wellKnownProviderUrl((UriBuilder)builder).build(new Object[]{"test", "uma2-configuration"});
        WebTarget oidcDiscoveryTarget = client.target(oidcDiscoveryUri);
        try (Response response = oidcDiscoveryTarget.request().get();){
            Assert.assertEquals((Object)"no-cache, must-revalidate, no-transform, no-store", (Object)response.getHeaders().getFirst((Object)"Cache-Control"));
            UmaConfiguration configuration = (UmaConfiguration)response.readEntity(UmaConfiguration.class);
            Assert.assertEquals((Object)configuration.getAuthorizationEndpoint(), (Object)OIDCLoginProtocolService.authUrl((UriBuilder)UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT)).build(new Object[]{"test"}).toString());
            Assert.assertEquals((Object)configuration.getTokenEndpoint(), (Object)this.oauth.getAccessTokenUrl());
            Assert.assertEquals((Object)configuration.getJwksUri(), (Object)this.oauth.getCertsUrl("test"));
            Assert.assertEquals((Object)configuration.getIntrospectionEndpoint(), (Object)this.oauth.getTokenIntrospectionUrl());
            String registrationUri = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT).path(RealmsResource.class).path(RealmsResource.class, "getRealmResource").build(new Object[]{this.realmsResouce().realm("test").toRepresentation().getRealm()}).toString();
            Assert.assertEquals((Object)(registrationUri + "/authz/protection/permission"), (Object)configuration.getPermissionEndpoint().toString());
            Assert.assertEquals((Object)(registrationUri + "/authz/protection/resource_set"), (Object)configuration.getResourceRegistrationEndpoint().toString());
        }
    }
}

