/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.authorization.client.AuthorizationDeniedException;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.PermissionRequest;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.RolePolicyRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.authz.AbstractAuthzTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.GroupBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.RolesBuilder;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class RolePolicyTest
extends AbstractAuthzTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(RealmBuilder.create().name("authz-test").roles(RolesBuilder.create().realmRole(RoleBuilder.create().name("uma_authorization").build()).realmRole(RoleBuilder.create().name("Role A").build()).realmRole(RoleBuilder.create().name("Role B").build()).realmRole(RoleBuilder.create().name("Role C").build())).group(GroupBuilder.create().name("Group A").realmRoles(Arrays.asList("Role A")).build()).group(GroupBuilder.create().name("Group B").realmRoles(Arrays.asList("Role C")).build()).user(UserBuilder.create().username("marta").password("password").addRoles("uma_authorization", "Role A")).user(UserBuilder.create().username("kolo").password("password").addRoles("uma_authorization", "Role B")).user(UserBuilder.create().username("alice").password("password").addRoles("uma_authorization").addGroups("Group B")).client(ClientBuilder.create().clientId("resource-server-test").secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-test").defaultRoles("uma_protection").directAccessGrants()).build());
    }

    @Before
    public void configureAuthorization() throws Exception {
        this.createResource("Resource A");
        this.createResource("Resource B");
        this.createResource("Resource C");
        this.createRealmRolePolicy("Role A Policy", "Role A");
        this.createRealmRolePolicy("Role B Policy", "Role B");
        this.createRealmRolePolicy("Role C Policy", "Role C");
        this.createResourcePermission("Resource A Permission", "Resource A", "Role A Policy");
        this.createResourcePermission("Resource B Permission", "Resource B", "Role B Policy");
        this.createResourcePermission("Resource C Permission", "Resource C", "Role C Policy");
    }

    @Test
    public void testUserWithExpectedRole() {
        AuthzClient authzClient = this.getAuthzClient();
        PermissionRequest request = new PermissionRequest("Resource A", new String[0]);
        String ticket = authzClient.protection().permission().create(request).getTicket();
        AuthorizationResponse response = authzClient.authorization("marta", "password").authorize(new AuthorizationRequest(ticket));
        Assert.assertNotNull((Object)response.getToken());
    }

    @Test
    public void testUserWithoutExpectedRole() {
        AuthzClient authzClient = this.getAuthzClient();
        PermissionRequest request = new PermissionRequest("Resource A", new String[0]);
        String ticket = authzClient.protection().permission().create(request).getTicket();
        try {
            authzClient.authorization("kolo", "password").authorize(new AuthorizationRequest(ticket));
            Assert.fail((String)"Should fail because user is not granted with expected role");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
        request.setResourceId("Resource B");
        ticket = authzClient.protection().permission().create(request).getTicket();
        Assert.assertNotNull((Object)authzClient.authorization("kolo", "password").authorize(new AuthorizationRequest(ticket)));
        UserRepresentation user = (UserRepresentation)this.getRealm().users().search("kolo").get(0);
        RoleRepresentation roleA = this.getRealm().roles().get("Role A").toRepresentation();
        this.getRealm().users().get(user.getId()).roles().realmLevel().add(Arrays.asList(roleA));
        request.setResourceId("Resource A");
        ticket = authzClient.protection().permission().create(request).getTicket();
        Assert.assertNotNull((Object)authzClient.authorization("kolo", "password").authorize(new AuthorizationRequest(ticket)));
    }

    @Test
    public void testUserWithGroupRole() throws InterruptedException {
        AuthzClient authzClient = this.getAuthzClient();
        PermissionRequest request = new PermissionRequest();
        request.setResourceId("Resource C");
        String ticket = authzClient.protection().permission().create(request).getTicket();
        Assert.assertNotNull((Object)authzClient.authorization("alice", "password").authorize(new AuthorizationRequest(ticket)));
        UserRepresentation user = (UserRepresentation)this.getRealm().users().search("alice").get(0);
        GroupRepresentation groupB = this.getRealm().groups().groups().stream().filter(representation -> "Group B".equals(representation.getName())).findFirst().get();
        this.getRealm().users().get(user.getId()).leaveGroup(groupB.getId());
        try {
            authzClient.authorization("alice", "password").authorize(new AuthorizationRequest(ticket));
            Assert.fail((String)"Should fail because user is not granted with expected role");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
        request.setResourceId("Resource A");
        ticket = authzClient.protection().permission().create(request).getTicket();
        try {
            authzClient.authorization("alice", "password").authorize(new AuthorizationRequest(ticket));
            Assert.fail((String)"Should fail because user is not granted with expected role");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
        GroupRepresentation groupA = this.getRealm().groups().groups().stream().filter(representation -> "Group A".equals(representation.getName())).findFirst().get();
        this.getRealm().users().get(user.getId()).joinGroup(groupA.getId());
        Assert.assertNotNull((Object)authzClient.authorization("alice", "password").authorize(new AuthorizationRequest(ticket)));
    }

    private void createRealmRolePolicy(String name, String ... roles) {
        RolePolicyRepresentation policy = new RolePolicyRepresentation();
        policy.setName(name);
        for (String role : roles) {
            policy.addRole(role);
        }
        this.getClient().authorization().policies().role().create(policy).close();
    }

    private void createResourcePermission(String name, String resource, String ... policies) {
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName(name);
        permission.addResource(resource);
        permission.addPolicy(policies);
        this.getClient().authorization().permissions().resource().create(permission).close();
    }

    private void createResource(String name) {
        AuthorizationResource authorization = this.getClient().authorization();
        ResourceRepresentation resource = new ResourceRepresentation(name, new String[0]);
        authorization.resources().create(resource).close();
    }

    private RealmResource getRealm() {
        try {
            return this.getAdminClient().realm("authz-test");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create admin client");
        }
    }

    private ClientResource getClient(RealmResource realm) {
        ClientsResource clients = realm.clients();
        return clients.findByClientId("resource-server-test").stream().map(representation -> clients.get(representation.getId())).findFirst().orElseThrow(() -> new RuntimeException("Expected client [resource-server-test]"));
    }

    private AuthzClient getAuthzClient() {
        return AuthzClient.create((InputStream)this.getClass().getResourceAsStream("/authorization-test/default-keycloak.json"));
    }

    private ClientResource getClient() {
        return this.getClient(this.getRealm());
    }
}

