/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.common.DefaultEvaluationContext;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.permission.evaluator.PermissionEvaluator;
import org.keycloak.authorization.policy.evaluation.DefaultEvaluation;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.JSPolicyRepresentation;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.representations.idm.authorization.TimePolicyRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.authz.AbstractAuthzTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.GroupBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.RolesBuilder;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class PolicyEvaluationTest
extends AbstractAuthzTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        ProtocolMapperRepresentation groupProtocolMapper = new ProtocolMapperRepresentation();
        groupProtocolMapper.setName("groups");
        groupProtocolMapper.setProtocolMapper("oidc-group-membership-mapper");
        groupProtocolMapper.setProtocol("openid-connect");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("claim.name", "groups");
        config.put("access.token.claim", "true");
        config.put("id.token.claim", "true");
        config.put("full.path", "true");
        groupProtocolMapper.setConfig(config);
        testRealms.add(RealmBuilder.create().name("authz-test").roles(RolesBuilder.create().realmRole(RoleBuilder.create().name("uma_authorization").build()).realmRole(RoleBuilder.create().name("role-a").build()).realmRole(RoleBuilder.create().name("role-b").build())).group(GroupBuilder.create().name("Group A").subGroups(Arrays.asList("Group B", "Group D").stream().map(name -> {
            if ("Group B".equals(name)) {
                return GroupBuilder.create().name((String)name).subGroups(Arrays.asList("Group C", "Group E").stream().map(new Function<String, GroupRepresentation>(){

                    @Override
                    public GroupRepresentation apply(String name) {
                        return GroupBuilder.create().name(name).build();
                    }
                }).collect(Collectors.toList())).build();
            }
            return GroupBuilder.create().name((String)name).realmRoles(Arrays.asList("role-a")).build();
        }).collect(Collectors.toList())).build()).group(GroupBuilder.create().name("Group E").build()).user(UserBuilder.create().username("marta").password("password").addRoles("uma_authorization", "role-a").addGroups("Group A")).user(UserBuilder.create().username("alice").password("password").addRoles("uma_authorization").addGroups("/Group A/Group B/Group E")).user(UserBuilder.create().username("kolo").password("password").addRoles("uma_authorization").addGroups("/Group A/Group D")).user(UserBuilder.create().username("trinity").password("password").addRoles("uma_authorization").role("role-mapping-client", "client-role-a")).user(UserBuilder.create().username("jdoe").password("password").addGroups("/Group A/Group B", "/Group A/Group D")).client(ClientBuilder.create().clientId("resource-server-test").secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-test").defaultRoles("uma_protection").directAccessGrants().protocolMapper(groupProtocolMapper)).client(ClientBuilder.create().clientId("role-mapping-client").defaultRoles("client-role-a", "client-role-b")).build());
    }

    @Test
    public void testCheckDateAndTime() {
        this.testingClient.server().run(PolicyEvaluationTest::testCheckDateAndTime);
    }

    public static void testCheckDateAndTime(KeycloakSession session) {
        session.getContext().setRealm(session.realms().getRealmByName("authz-test"));
        AuthorizationProvider authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        ClientModel clientModel = session.clients().getClientByClientId(session.getContext().getRealm(), "resource-server-test");
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceServer resourceServer = storeFactory.getResourceServerStore().findById(clientModel.getId());
        TimePolicyRepresentation policyRepresentation = new TimePolicyRepresentation();
        policyRepresentation.setName("testCheckDateAndTime");
        long notOnOrAfter = System.currentTimeMillis() + 3600000L;
        Date notOnOrAfterDate = new Date(notOnOrAfter);
        policyRepresentation.setNotOnOrAfter(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(notOnOrAfterDate));
        Policy policy = storeFactory.getPolicyStore().create((AbstractPolicyRepresentation)policyRepresentation, resourceServer);
        PolicyProvider provider = authorization.getProvider(policy.getType());
        DefaultEvaluation evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertEquals((Object)Decision.Effect.PERMIT, (Object)evaluation.getEffect());
        long contextTime = System.currentTimeMillis() + 5400000L;
        HashMap<String, Collection<String>> attributes = new HashMap<String, Collection<String>>();
        attributes.put("kc.time.date_time", Arrays.asList(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(contextTime))));
        evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, null, resourceServer, policy, attributes);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertEquals((Object)Decision.Effect.DENY, (Object)evaluation.getEffect());
    }

    @Test
    public void testCheckUserInGroup() {
        this.testingClient.server().run(PolicyEvaluationTest::testCheckUserInGroup);
    }

    public static void testCheckUserInGroup(KeycloakSession session) {
        session.getContext().setRealm(session.realms().getRealmByName("authz-test"));
        AuthorizationProvider authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        ClientModel clientModel = session.clients().getClientByClientId(session.getContext().getRealm(), "resource-server-test");
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceServer resourceServer = storeFactory.getResourceServerStore().findById(clientModel.getId());
        JSPolicyRepresentation policyRepresentation = new JSPolicyRepresentation();
        policyRepresentation.setName("testCheckUserInGroup");
        StringBuilder builder = new StringBuilder();
        builder.append("var realm = $evaluation.getRealm();");
        builder.append("if (realm.isUserInGroup('marta', 'Group C')) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        Policy policy = storeFactory.getPolicyStore().create((AbstractPolicyRepresentation)policyRepresentation, resourceServer);
        PolicyProvider provider = authorization.getProvider(policy.getType());
        DefaultEvaluation evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertNull((Object)evaluation.getEffect());
        builder = new StringBuilder();
        builder.append("var realm = $evaluation.getRealm();");
        builder.append("if (realm.isUserInGroup('marta', 'Group A')) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        policyRepresentation.setId(policy.getId());
        policy = RepresentationToModel.toModel((AbstractPolicyRepresentation)policyRepresentation, (AuthorizationProvider)authorization, (Policy)policy);
        evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertEquals((Object)Decision.Effect.PERMIT, (Object)evaluation.getEffect());
        builder = new StringBuilder();
        builder.append("var realm = $evaluation.getRealm();");
        builder.append("if (realm.isUserInGroup('marta', '/Group A')) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        policyRepresentation.setId(policy.getId());
        policy = RepresentationToModel.toModel((AbstractPolicyRepresentation)policyRepresentation, (AuthorizationProvider)authorization, (Policy)policy);
        evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertEquals((Object)Decision.Effect.PERMIT, (Object)evaluation.getEffect());
        builder = new StringBuilder();
        builder.append("var realm = $evaluation.getRealm();");
        builder.append("if (realm.isUserInGroup('marta', '/Group A/Group B')) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        policyRepresentation.setId(policy.getId());
        policy = RepresentationToModel.toModel((AbstractPolicyRepresentation)policyRepresentation, (AuthorizationProvider)authorization, (Policy)policy);
        evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertNull((Object)evaluation.getEffect());
        builder = new StringBuilder();
        builder.append("var realm = $evaluation.getRealm();");
        builder.append("if (realm.isUserInGroup('alice', '/Group A/Group B/Group E')) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        policyRepresentation.setId(policy.getId());
        policy = RepresentationToModel.toModel((AbstractPolicyRepresentation)policyRepresentation, (AuthorizationProvider)authorization, (Policy)policy);
        evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertEquals((Object)Decision.Effect.PERMIT, (Object)evaluation.getEffect());
        builder = new StringBuilder();
        builder.append("var realm = $evaluation.getRealm();");
        builder.append("if (realm.isUserInGroup('alice', '/Group A')) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        policyRepresentation.setId(policy.getId());
        policy = RepresentationToModel.toModel((AbstractPolicyRepresentation)policyRepresentation, (AuthorizationProvider)authorization, (Policy)policy);
        evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertEquals((Object)Decision.Effect.PERMIT, (Object)evaluation.getEffect());
        builder = new StringBuilder();
        builder.append("var realm = $evaluation.getRealm();");
        builder.append("if (!realm.isUserInGroup('alice', '/Group A', false)) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        policyRepresentation.setId(policy.getId());
        policy = RepresentationToModel.toModel((AbstractPolicyRepresentation)policyRepresentation, (AuthorizationProvider)authorization, (Policy)policy);
        evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertNull((Object)evaluation.getEffect());
        builder = new StringBuilder();
        builder.append("var realm = $evaluation.getRealm();");
        builder.append("if (realm.isUserInGroup('alice', '/Group E')) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        policyRepresentation.setId(policy.getId());
        policy = RepresentationToModel.toModel((AbstractPolicyRepresentation)policyRepresentation, (AuthorizationProvider)authorization, (Policy)policy);
        evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertNull((Object)evaluation.getEffect());
        builder = new StringBuilder();
        builder.append("var realm = $evaluation.getRealm();");
        builder.append("if (realm.isUserInGroup('alice', 'Group E')) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        policyRepresentation.setId(policy.getId());
        policy = RepresentationToModel.toModel((AbstractPolicyRepresentation)policyRepresentation, (AuthorizationProvider)authorization, (Policy)policy);
        evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertNull((Object)evaluation.getEffect());
    }

    @Test
    public void testCheckUserInRole() {
        this.testingClient.server().run(PolicyEvaluationTest::testCheckUserInRole);
    }

    public static void testCheckUserInRole(KeycloakSession session) {
        session.getContext().setRealm(session.realms().getRealmByName("authz-test"));
        AuthorizationProvider authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        ClientModel clientModel = session.clients().getClientByClientId(session.getContext().getRealm(), "resource-server-test");
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceServer resourceServer = storeFactory.getResourceServerStore().findById(clientModel.getId());
        JSPolicyRepresentation policyRepresentation = new JSPolicyRepresentation();
        policyRepresentation.setName("testCheckUserInRole");
        StringBuilder builder = new StringBuilder();
        builder.append("var realm = $evaluation.getRealm();");
        builder.append("if (realm.isUserInRealmRole('marta', 'role-a')) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        Policy policy = storeFactory.getPolicyStore().create((AbstractPolicyRepresentation)policyRepresentation, resourceServer);
        PolicyProvider provider = authorization.getProvider(policy.getType());
        DefaultEvaluation evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertEquals((Object)Decision.Effect.PERMIT, (Object)evaluation.getEffect());
        builder = new StringBuilder();
        builder.append("var realm = $evaluation.getRealm();");
        builder.append("if (realm.isUserInRealmRole('marta', 'role-b')) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        policyRepresentation.setId(policy.getId());
        policy = RepresentationToModel.toModel((AbstractPolicyRepresentation)policyRepresentation, (AuthorizationProvider)authorization, (Policy)policy);
        evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertNull((Object)evaluation.getEffect());
    }

    @Test
    public void testCheckUserInClientRole() {
        this.testingClient.server().run(PolicyEvaluationTest::testCheckUserInClientRole);
    }

    public static void testCheckUserInClientRole(KeycloakSession session) {
        session.getContext().setRealm(session.realms().getRealmByName("authz-test"));
        AuthorizationProvider authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        ClientModel clientModel = session.clients().getClientByClientId(session.getContext().getRealm(), "resource-server-test");
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceServer resourceServer = storeFactory.getResourceServerStore().findById(clientModel.getId());
        JSPolicyRepresentation policyRepresentation = new JSPolicyRepresentation();
        policyRepresentation.setName("testCheckUserInClientRole");
        StringBuilder builder = new StringBuilder();
        builder.append("var realm = $evaluation.getRealm();");
        builder.append("if (realm.isUserInClientRole('trinity', 'role-mapping-client', 'client-role-a')) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        Policy policy = storeFactory.getPolicyStore().create((AbstractPolicyRepresentation)policyRepresentation, resourceServer);
        PolicyProvider provider = authorization.getProvider(policy.getType());
        DefaultEvaluation evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertEquals((Object)Decision.Effect.PERMIT, (Object)evaluation.getEffect());
        builder = new StringBuilder();
        builder.append("var realm = $evaluation.getRealm();");
        builder.append("if (realm.isUserInRealmRole('trinity', 'client-role-b')) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        policyRepresentation.setId(policy.getId());
        policy = RepresentationToModel.toModel((AbstractPolicyRepresentation)policyRepresentation, (AuthorizationProvider)authorization, (Policy)policy);
        evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertNull((Object)evaluation.getEffect());
    }

    @Test
    public void testCheckGroupInRole() {
        this.testingClient.server().run(PolicyEvaluationTest::testCheckGroupInRole);
    }

    public static void testCheckGroupInRole(KeycloakSession session) {
        session.getContext().setRealm(session.realms().getRealmByName("authz-test"));
        AuthorizationProvider authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        ClientModel clientModel = session.clients().getClientByClientId(session.getContext().getRealm(), "resource-server-test");
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceServer resourceServer = storeFactory.getResourceServerStore().findById(clientModel.getId());
        JSPolicyRepresentation policyRepresentation = new JSPolicyRepresentation();
        policyRepresentation.setName("testCheckGroupInRole");
        StringBuilder builder = new StringBuilder();
        builder.append("var realm = $evaluation.getRealm();");
        builder.append("if (realm.isGroupInRole('/Group A/Group D', 'role-a')) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        Policy policy = storeFactory.getPolicyStore().create((AbstractPolicyRepresentation)policyRepresentation, resourceServer);
        PolicyProvider provider = authorization.getProvider(policy.getType());
        DefaultEvaluation evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertEquals((Object)Decision.Effect.PERMIT, (Object)evaluation.getEffect());
        builder = new StringBuilder();
        builder.append("var realm = $evaluation.getRealm();");
        builder.append("if (realm.isGroupInRole('/Group A/Group D', 'role-b')) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        policyRepresentation.setId(policy.getId());
        policy = RepresentationToModel.toModel((AbstractPolicyRepresentation)policyRepresentation, (AuthorizationProvider)authorization, (Policy)policy);
        evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertNull((Object)evaluation.getEffect());
    }

    @Test
    public void testCheckUserRealmRoles() {
        this.testingClient.server().run(PolicyEvaluationTest::testCheckUserRealmRoles);
    }

    public static void testCheckUserRealmRoles(KeycloakSession session) {
        session.getContext().setRealm(session.realms().getRealmByName("authz-test"));
        AuthorizationProvider authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        ClientModel clientModel = session.clients().getClientByClientId(session.getContext().getRealm(), "resource-server-test");
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceServer resourceServer = storeFactory.getResourceServerStore().findById(clientModel.getId());
        JSPolicyRepresentation policyRepresentation = new JSPolicyRepresentation();
        policyRepresentation.setName("testCheckUserRealmRoles");
        StringBuilder builder = new StringBuilder();
        builder.append("var realm = $evaluation.getRealm();");
        builder.append("var roles = realm.getUserRealmRoles('marta');");
        builder.append("if (roles.size() == 2 && roles.contains('uma_authorization') && roles.contains('role-a')) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        Policy policy = storeFactory.getPolicyStore().create((AbstractPolicyRepresentation)policyRepresentation, resourceServer);
        PolicyProvider provider = authorization.getProvider(policy.getType());
        DefaultEvaluation evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertEquals((Object)Decision.Effect.PERMIT, (Object)evaluation.getEffect());
    }

    @Test
    public void testCheckUserClientRoles() {
        this.testingClient.server().run(PolicyEvaluationTest::testCheckUserClientRoles);
    }

    public static void testCheckUserClientRoles(KeycloakSession session) {
        session.getContext().setRealm(session.realms().getRealmByName("authz-test"));
        AuthorizationProvider authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        ClientModel clientModel = session.clients().getClientByClientId(session.getContext().getRealm(), "resource-server-test");
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceServer resourceServer = storeFactory.getResourceServerStore().findById(clientModel.getId());
        JSPolicyRepresentation policyRepresentation = new JSPolicyRepresentation();
        policyRepresentation.setName("testCheckUserClientRoles");
        StringBuilder builder = new StringBuilder();
        builder.append("var realm = $evaluation.getRealm();");
        builder.append("var roles = realm.getUserClientRoles('trinity', 'role-mapping-client');");
        builder.append("if (roles.size() == 1 && roles.contains('client-role-a')) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        Policy policy = storeFactory.getPolicyStore().create((AbstractPolicyRepresentation)policyRepresentation, resourceServer);
        PolicyProvider provider = authorization.getProvider(policy.getType());
        DefaultEvaluation evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertEquals((Object)Decision.Effect.PERMIT, (Object)evaluation.getEffect());
    }

    @Test
    public void testCheckUserGroups() {
        this.testingClient.server().run(PolicyEvaluationTest::testCheckUserGroups);
    }

    public static void testCheckUserGroups(KeycloakSession session) {
        session.getContext().setRealm(session.realms().getRealmByName("authz-test"));
        AuthorizationProvider authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        ClientModel clientModel = session.clients().getClientByClientId(session.getContext().getRealm(), "resource-server-test");
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceServer resourceServer = storeFactory.getResourceServerStore().findById(clientModel.getId());
        JSPolicyRepresentation policyRepresentation = new JSPolicyRepresentation();
        policyRepresentation.setName("testCheckUserGroups");
        StringBuilder builder = new StringBuilder();
        builder.append("var realm = $evaluation.getRealm();");
        builder.append("var groups = realm.getUserGroups('jdoe');");
        builder.append("if (groups.size() == 2 && groups.contains('/Group A/Group B') && groups.contains('/Group A/Group D')) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        Policy policy = storeFactory.getPolicyStore().create((AbstractPolicyRepresentation)policyRepresentation, resourceServer);
        PolicyProvider provider = authorization.getProvider(policy.getType());
        DefaultEvaluation evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertEquals((Object)Decision.Effect.PERMIT, (Object)evaluation.getEffect());
    }

    @Test
    public void testCheckUserAttributes() {
        this.testingClient.server().run(PolicyEvaluationTest::testCheckUserAttributes);
    }

    public static void testCheckUserAttributes(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("authz-test");
        UserModel jdoe = session.users().getUserByUsername(realm, "jdoe");
        jdoe.setAttribute("a1", Arrays.asList("1", "2"));
        jdoe.setSingleAttribute("a2", "3");
        session.getContext().setRealm(realm);
        AuthorizationProvider authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        ClientModel clientModel = session.clients().getClientByClientId(session.getContext().getRealm(), "resource-server-test");
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceServer resourceServer = storeFactory.getResourceServerStore().findById(clientModel.getId());
        JSPolicyRepresentation policyRepresentation = new JSPolicyRepresentation();
        policyRepresentation.setName("testCheckUserAttributes");
        StringBuilder builder = new StringBuilder();
        builder.append("var realm = $evaluation.getRealm();");
        builder.append("var attributes = realm.getUserAttributes('jdoe');");
        builder.append("if (attributes.size() == 6 && attributes.containsKey('a1') && attributes.containsKey('a2') && attributes.get('a1').size() == 2 && attributes.get('a2').get(0).equals('3')) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        Policy policy = storeFactory.getPolicyStore().create((AbstractPolicyRepresentation)policyRepresentation, resourceServer);
        PolicyProvider provider = authorization.getProvider(policy.getType());
        DefaultEvaluation evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertEquals((Object)Decision.Effect.PERMIT, (Object)evaluation.getEffect());
    }

    @Test
    public void testCheckResourceAttributes() {
        this.testingClient.server().run(PolicyEvaluationTest::testCheckResourceAttributes);
    }

    public static void testCheckResourceAttributes(KeycloakSession session) {
        session.getContext().setRealm(session.realms().getRealmByName("authz-test"));
        AuthorizationProvider authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        ClientModel clientModel = session.clients().getClientByClientId(session.getContext().getRealm(), "resource-server-test");
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceServer resourceServer = storeFactory.getResourceServerStore().findById(clientModel.getId());
        JSPolicyRepresentation policyRepresentation = new JSPolicyRepresentation();
        policyRepresentation.setName("testCheckResourceAttributes");
        StringBuilder builder = new StringBuilder();
        builder.append("var permission = $evaluation.getPermission();");
        builder.append("var resource = permission.getResource();");
        builder.append("var attributes = resource.getAttributes();");
        builder.append("if (attributes.size() == 2 && attributes.containsKey('a1') && attributes.containsKey('a2') && attributes.get('a1').size() == 2 && attributes.get('a2').get(0).equals('3') && resource.getAttribute('a1').size() == 2 && resource.getSingleAttribute('a2').equals('3')) { $evaluation.grant(); }");
        policyRepresentation.setCode(builder.toString());
        Policy policy = storeFactory.getPolicyStore().create((AbstractPolicyRepresentation)policyRepresentation, resourceServer);
        PolicyProvider provider = authorization.getProvider(policy.getType());
        Resource resource = storeFactory.getResourceStore().create("testCheckResourceAttributesResource", resourceServer, resourceServer.getId());
        resource.setAttribute("a1", Arrays.asList("1", "2"));
        resource.setAttribute("a2", Arrays.asList("3"));
        DefaultEvaluation evaluation = PolicyEvaluationTest.createEvaluation(session, authorization, resource, resourceServer, policy);
        provider.evaluate((Evaluation)evaluation);
        Assert.assertEquals((Object)Decision.Effect.PERMIT, (Object)evaluation.getEffect());
    }

    @Test
    public void testCheckReadOnlyInstances() {
        this.testingClient.server().run(PolicyEvaluationTest::testCheckReadOnlyInstances);
    }

    public static void testCheckReadOnlyInstances(KeycloakSession session) {
        session.getContext().setRealm(session.realms().getRealmByName("authz-test"));
        AuthorizationProvider authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        ClientModel clientModel = session.clients().getClientByClientId(session.getContext().getRealm(), "resource-server-test");
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceServer resourceServer = storeFactory.getResourceServerStore().findById(clientModel.getId());
        JSPolicyRepresentation policyRepresentation = new JSPolicyRepresentation();
        policyRepresentation.setName("testCheckReadOnlyInstances");
        StringBuilder builder = new StringBuilder();
        builder.append("$evaluation.getPermission().getResource().setName('test')");
        policyRepresentation.setCode(builder.toString());
        Policy policy = storeFactory.getPolicyStore().create((AbstractPolicyRepresentation)policyRepresentation, resourceServer);
        Resource resource = storeFactory.getResourceStore().create("Resource A", resourceServer, resourceServer.getId());
        Scope scope = storeFactory.getScopeStore().create("Scope A", resourceServer);
        resource.updateScopes(new HashSet<Scope>(Arrays.asList(scope)));
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName("testCheckReadOnlyInstances permission");
        permission.addPolicy(new String[]{policy.getId()});
        permission.addResource(resource.getId());
        storeFactory.getPolicyStore().create((AbstractPolicyRepresentation)permission, resourceServer);
        session.getTransactionManager().commit();
        PermissionEvaluator evaluator = authorization.evaluators().from(Arrays.asList(new ResourcePermission(resource, Arrays.asList(scope), resourceServer)), (EvaluationContext)PolicyEvaluationTest.createEvaluationContext(session, Collections.emptyMap()));
        try {
            evaluator.evaluate(resourceServer, null);
            Assert.fail((String)"Instances should be marked as read-only");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCachedDecisionsWithNegativePolicies() {
        this.testingClient.server().run(PolicyEvaluationTest::testCachedDecisionsWithNegativePolicies);
    }

    public static void testCachedDecisionsWithNegativePolicies(KeycloakSession session) {
        session.getContext().setRealm(session.realms().getRealmByName("authz-test"));
        AuthorizationProvider authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        ClientModel clientModel = session.clients().getClientByClientId(session.getContext().getRealm(), "resource-server-test");
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceServer resourceServer = storeFactory.getResourceServerStore().findById(clientModel.getId());
        Scope readScope = storeFactory.getScopeStore().create("read", resourceServer);
        Scope writeScope = storeFactory.getScopeStore().create("write", resourceServer);
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName(KeycloakModelUtils.generateId());
        policy.setCode("$evaluation.grant()");
        policy.setLogic(Logic.NEGATIVE);
        storeFactory.getPolicyStore().create((AbstractPolicyRepresentation)policy, resourceServer);
        ScopePermissionRepresentation readPermission = new ScopePermissionRepresentation();
        readPermission.setName(KeycloakModelUtils.generateId());
        readPermission.addScope(new String[]{readScope.getId()});
        readPermission.addPolicy(new String[]{policy.getName()});
        storeFactory.getPolicyStore().create((AbstractPolicyRepresentation)readPermission, resourceServer);
        ScopePermissionRepresentation writePermission = new ScopePermissionRepresentation();
        writePermission.setName(KeycloakModelUtils.generateId());
        writePermission.addScope(new String[]{writeScope.getId()});
        writePermission.addPolicy(new String[]{policy.getName()});
        storeFactory.getPolicyStore().create((AbstractPolicyRepresentation)writePermission, resourceServer);
        Resource resource = storeFactory.getResourceStore().create(KeycloakModelUtils.generateId(), resourceServer, resourceServer.getId());
        PermissionEvaluator evaluator = authorization.evaluators().from(Arrays.asList(new ResourcePermission(resource, Arrays.asList(readScope, writeScope), resourceServer)), (EvaluationContext)PolicyEvaluationTest.createEvaluationContext(session, Collections.emptyMap()));
        Collection permissions = evaluator.evaluate(resourceServer, null);
        Assert.assertEquals((long)0L, (long)permissions.size());
    }

    private static DefaultEvaluation createEvaluation(KeycloakSession session, AuthorizationProvider authorization, ResourceServer resourceServer, Policy policy) {
        return PolicyEvaluationTest.createEvaluation(session, authorization, null, resourceServer, policy);
    }

    private static DefaultEvaluation createEvaluation(KeycloakSession session, AuthorizationProvider authorization, Resource resource, ResourceServer resourceServer, Policy policy) {
        return PolicyEvaluationTest.createEvaluation(session, authorization, resource, resourceServer, policy, null);
    }

    private static DefaultEvaluation createEvaluation(KeycloakSession session, AuthorizationProvider authorization, Resource resource, ResourceServer resourceServer, Policy policy, Map<String, Collection<String>> contextAttributes) {
        return new DefaultEvaluation(new ResourcePermission(resource, null, resourceServer), (EvaluationContext)PolicyEvaluationTest.createEvaluationContext(session, contextAttributes), policy, evaluation -> {}, authorization, null);
    }

    private static DefaultEvaluationContext createEvaluationContext(KeycloakSession session, final Map<String, Collection<String>> contextAttributes) {
        return new DefaultEvaluationContext(new Identity(){

            public String getId() {
                return null;
            }

            public Attributes getAttributes() {
                return null;
            }
        }, session){

            public Map<String, Collection<String>> getBaseAttributes() {
                Map baseAttributes = super.getBaseAttributes();
                if (contextAttributes != null) {
                    baseAttributes.putAll(contextAttributes);
                }
                return baseAttributes;
            }
        };
    }
}

