/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.AuthorizationProviderFactory;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionEffect;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.PolicyEvaluationRequest;
import org.keycloak.representations.idm.authorization.PolicyEvaluationResponse;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.authz.AbstractAuthzTest;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class PolicyEvaluationCompositeRoleTest
extends AbstractAuthzTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation testRealmRep = new RealmRepresentation();
        testRealmRep.setId("test");
        testRealmRep.setRealm("test");
        testRealmRep.setEnabled(Boolean.valueOf(true));
        testRealms.add(testRealmRep);
    }

    public static void setup(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        session.getContext().setRealm(realm);
        ClientModel client = session.clients().addClient(realm, "myclient");
        RoleModel role1 = client.addRole("client-role1");
        AuthorizationProviderFactory factory = (AuthorizationProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(AuthorizationProvider.class);
        AuthorizationProvider authz = factory.create(session, realm);
        ResourceServer resourceServer = authz.getStoreFactory().getResourceServerStore().create(client.getId());
        Policy policy = PolicyEvaluationCompositeRoleTest.createRolePolicy(authz, resourceServer, role1);
        Scope scope = authz.getStoreFactory().getScopeStore().create("myscope", resourceServer);
        Resource resource = authz.getStoreFactory().getResourceStore().create("myresource", resourceServer, resourceServer.getId());
        PolicyEvaluationCompositeRoleTest.addScopePermission(authz, resourceServer, "mypermission", resource, scope, policy);
        RoleModel composite = realm.addRole("composite");
        composite.addCompositeRole(role1);
        UserModel user = session.users().addUser(realm, "user");
        user.grantRole(composite);
    }

    private static Policy addScopePermission(AuthorizationProvider authz, ResourceServer resourceServer, String name, Resource resource, Scope scope, Policy policy) {
        ScopePermissionRepresentation representation = new ScopePermissionRepresentation();
        representation.setName(name);
        representation.setType("scope");
        representation.addResource(resource.getName());
        representation.addScope(new String[]{scope.getName()});
        representation.addPolicy(new String[]{policy.getName()});
        representation.setDecisionStrategy(DecisionStrategy.UNANIMOUS);
        representation.setLogic(Logic.POSITIVE);
        return authz.getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)representation, resourceServer);
    }

    private static Policy createRolePolicy(AuthorizationProvider authz, ResourceServer resourceServer, RoleModel role) {
        PolicyRepresentation representation = new PolicyRepresentation();
        representation.setName(role.getName());
        representation.setType("role");
        representation.setDecisionStrategy(DecisionStrategy.UNANIMOUS);
        representation.setLogic(Logic.POSITIVE);
        String roleValues = "[{\"id\":\"" + role.getId() + "\",\"required\": true}]";
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("roles", roleValues);
        representation.setConfig(config);
        return authz.getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)representation, resourceServer);
    }

    @Test
    public void testCreate() throws Exception {
        this.testingClient.server().run(PolicyEvaluationCompositeRoleTest::setup);
        RealmResource realm = this.adminClient.realm("test");
        String resourceServerId = ((ClientRepresentation)realm.clients().findByClientId("myclient").get(0)).getId();
        UserRepresentation user = (UserRepresentation)realm.users().search("user").get(0);
        PolicyEvaluationRequest request = new PolicyEvaluationRequest();
        request.setUserId(user.getId());
        request.setClientId(resourceServerId);
        request.addResource("myresource", new String[]{"myscope"});
        PolicyEvaluationResponse result = realm.clients().get(resourceServerId).authorization().policies().evaluate(request);
        Assert.assertEquals((Object)result.getStatus(), (Object)DecisionEffect.PERMIT);
    }
}

