/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ResourceScopesResource;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.util.HttpResponseException;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.PermissionRequest;
import org.keycloak.representations.idm.authorization.PermissionResponse;
import org.keycloak.representations.idm.authorization.PermissionTicketRepresentation;
import org.keycloak.representations.idm.authorization.PermissionTicketToken;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.authz.AbstractResourceServerTest;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class PermissionManagementTest
extends AbstractResourceServerTest {
    @Test
    public void testCreatePermissionTicketWithResourceName() throws Exception {
        ResourceRepresentation resource = this.addResource("Resource A", "kolo", true, new String[0]);
        AuthzClient authzClient = this.getAuthzClient();
        PermissionResponse response = authzClient.protection("marta", "password").permission().create(new PermissionRequest(resource.getId(), new String[0]));
        AuthorizationRequest request = new AuthorizationRequest();
        request.setTicket(response.getTicket());
        request.setClaimToken(authzClient.obtainAccessToken("marta", "password").getToken());
        try {
            authzClient.authorization().authorize(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertPersistence(response, resource, new String[0]);
    }

    @Test
    public void removeUserWithPermissionTicketTest() throws Exception {
        String userToRemoveID = this.createUser("authz-test", "user-to-remove", "password", new String[0]);
        ResourceRepresentation resource = this.addResource("Resource A", "kolo", true, new String[0]);
        AuthzClient authzClient = this.getAuthzClient();
        PermissionResponse response = authzClient.protection("user-to-remove", "password").permission().create(new PermissionRequest(resource.getId(), new String[0]));
        AuthorizationRequest request = new AuthorizationRequest();
        request.setTicket(response.getTicket());
        request.setClaimToken(authzClient.obtainAccessToken("user-to-remove", "password").getToken());
        try {
            authzClient.authorization().authorize(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertPersistence(response, resource, new String[0]);
        this.adminClient.realm("authz-test").users().delete(userToRemoveID);
        Assert.assertThat(this.adminClient.realm("authz-test").users().list().stream().map(UserRepresentation::getId).collect(Collectors.toList()), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)userToRemoveID)));
        Assert.assertThat((Object)this.getAuthzClient().protection().permission().findByResource(resource.getId()), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testCreatePermissionTicketWithResourceId() throws Exception {
        ResourceRepresentation resource = this.addResource("Resource A", "kolo", true, new String[0]);
        AuthzClient authzClient = this.getAuthzClient();
        PermissionResponse response = authzClient.protection("marta", "password").permission().create(new PermissionRequest(resource.getId(), new String[0]));
        AuthorizationRequest request = new AuthorizationRequest();
        request.setTicket(response.getTicket());
        request.setClaimToken(authzClient.obtainAccessToken("marta", "password").getToken());
        try {
            authzClient.authorization().authorize(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNotNull((Object)response.getTicket());
        Assert.assertFalse((boolean)authzClient.protection().permission().findByResource(resource.getId()).isEmpty());
    }

    @Test
    public void testCreatePermissionTicketWithScopes() throws Exception {
        ResourceRepresentation resource = this.addResource("Resource A", "kolo", true, "ScopeA", "ScopeB", "ScopeC");
        AuthzClient authzClient = this.getAuthzClient();
        PermissionResponse response = authzClient.protection("marta", "password").permission().create(new PermissionRequest(resource.getId(), new String[]{"ScopeA", "ScopeB", "ScopeC"}));
        AuthorizationRequest request = new AuthorizationRequest();
        request.setTicket(response.getTicket());
        request.setClaimToken(authzClient.obtainAccessToken("marta", "password").getToken());
        try {
            authzClient.authorization().authorize(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertPersistence(response, resource, "ScopeA", "ScopeB", "ScopeC");
    }

    @Test
    public void testDeleteResourceAndPermissionTicket() throws Exception {
        ResourceRepresentation resource = this.addResource("Resource A", "kolo", true, "ScopeA", "ScopeB", "ScopeC");
        AuthzClient authzClient = this.getAuthzClient();
        PermissionResponse response = authzClient.protection("marta", "password").permission().create(new PermissionRequest(resource.getId(), new String[]{"ScopeA", "ScopeB", "ScopeC"}));
        AuthorizationRequest request = new AuthorizationRequest();
        request.setTicket(response.getTicket());
        request.setClaimToken(authzClient.obtainAccessToken("marta", "password").getToken());
        try {
            authzClient.authorization().authorize(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertPersistence(response, resource, "ScopeA", "ScopeB", "ScopeC");
        this.getAuthzClient().protection().resource().delete(resource.getId());
        Assert.assertTrue((boolean)this.getAuthzClient().protection().permission().findByResource(resource.getId()).isEmpty());
    }

    @Test
    public void testMultiplePermissionRequest() throws Exception {
        ArrayList<PermissionRequest> permissions = new ArrayList<PermissionRequest>();
        permissions.add(new PermissionRequest(this.addResource("Resource A", true, new String[0]).getName(), new String[0]));
        permissions.add(new PermissionRequest(this.addResource("Resource B", true, new String[0]).getName(), new String[0]));
        permissions.add(new PermissionRequest(this.addResource("Resource C", true, new String[0]).getName(), new String[0]));
        permissions.add(new PermissionRequest(this.addResource("Resource D", true, new String[0]).getName(), new String[0]));
        PermissionResponse response = this.getAuthzClient().protection().permission().create(permissions);
        Assert.assertNotNull((Object)response.getTicket());
    }

    @Test
    public void testDeleteScopeAndPermissionTicket() throws Exception {
        ResourceRepresentation resource = this.addResource("Resource A", "kolo", true, "ScopeA", "ScopeB", "ScopeC");
        PermissionRequest permissionRequest = new PermissionRequest(resource.getId(), new String[0]);
        permissionRequest.setScopes(new HashSet<String>(Arrays.asList("ScopeA", "ScopeB", "ScopeC")));
        AuthzClient authzClient = this.getAuthzClient();
        PermissionResponse response = authzClient.protection("marta", "password").permission().create(permissionRequest);
        Assert.assertNotNull((Object)response.getTicket());
        AuthorizationRequest request = new AuthorizationRequest();
        request.setTicket(response.getTicket());
        request.setClaimToken(authzClient.obtainAccessToken("marta", "password").getToken());
        try {
            authzClient.authorization().authorize(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)3L, (long)authzClient.protection().permission().findByResource(resource.getId()).size());
        AuthorizationResource authorization = this.getClient(this.getRealm()).authorization();
        ResourceScopesResource scopes = authorization.scopes();
        ScopeRepresentation scope = scopes.findByName("ScopeA");
        List permissions = authzClient.protection().permission().findByScope(scope.getId());
        Assert.assertFalse((boolean)permissions.isEmpty());
        Assert.assertEquals((long)1L, (long)permissions.size());
        resource.setScopes(Collections.emptySet());
        authorization.resources().resource(resource.getId()).update(resource);
        scopes.scope(scope.getId()).remove();
        Assert.assertTrue((boolean)authzClient.protection().permission().findByScope(scope.getId()).isEmpty());
        Assert.assertEquals((long)0L, (long)authzClient.protection().permission().findByResource(resource.getId()).size());
    }

    @Test
    public void testRemoveScopeFromResource() throws Exception {
        ResourceRepresentation resource = this.addResource("Resource A", "kolo", true, "ScopeA", "ScopeB");
        PermissionRequest permissionRequest = new PermissionRequest(resource.getId(), new String[]{"ScopeA", "ScopeB"});
        AuthzClient authzClient = this.getAuthzClient();
        PermissionResponse response = authzClient.protection("marta", "password").permission().create(permissionRequest);
        Assert.assertNotNull((Object)response.getTicket());
        AuthorizationRequest request = new AuthorizationRequest();
        request.setTicket(response.getTicket());
        request.setClaimToken(authzClient.obtainAccessToken("marta", "password").getToken());
        try {
            authzClient.authorization().authorize(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        AuthorizationResource authorization = this.getClient(this.getRealm()).authorization();
        ResourceScopesResource scopes = authorization.scopes();
        ScopeRepresentation removedScope = scopes.findByName("ScopeA");
        List permissions = authzClient.protection().permission().findByScope(removedScope.getId());
        Assert.assertFalse((boolean)permissions.isEmpty());
        resource.setScopes(new HashSet());
        resource.addScope(new String[]{"ScopeB"});
        authorization.resources().resource(resource.getId()).update(resource);
        permissions = authzClient.protection().permission().findByScope(removedScope.getId());
        Assert.assertTrue((boolean)permissions.isEmpty());
        ScopeRepresentation scopeB = scopes.findByName("ScopeB");
        permissions = authzClient.protection().permission().findByScope(scopeB.getId());
        Assert.assertFalse((boolean)permissions.isEmpty());
    }

    @Test
    public void testCreatePermissionTicketWithResourceWithoutManagedAccess() throws Exception {
        ResourceRepresentation resource = this.addResource("Resource A", new String[0]);
        PermissionResponse response = this.getAuthzClient().protection().permission().create(new PermissionRequest(resource.getName(), new String[0]));
        Assert.assertNotNull((Object)response.getTicket());
        Assert.assertTrue((boolean)this.getAuthzClient().protection().permission().findByResource(resource.getId()).isEmpty());
    }

    @Test
    public void testTicketNotCreatedWhenResourceOwner() throws Exception {
        ResourceRepresentation resource = this.addResource("Resource A", "marta", true, new String[0]);
        AuthzClient authzClient = this.getAuthzClient();
        PermissionResponse response = authzClient.protection("marta", "password").permission().create(new PermissionRequest(resource.getId(), new String[0]));
        Assert.assertNotNull((Object)response.getTicket());
        AuthorizationRequest request = new AuthorizationRequest();
        request.setTicket(response.getTicket());
        request.setClaimToken(authzClient.obtainAccessToken("marta", "password").getToken());
        try {
            authzClient.authorization().authorize(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List permissions = authzClient.protection().permission().findByResource(resource.getId());
        Assert.assertTrue((boolean)permissions.isEmpty());
        response = authzClient.protection("kolo", "password").permission().create(new PermissionRequest(resource.getId(), new String[0]));
        Assert.assertNotNull((Object)response.getTicket());
        request = new AuthorizationRequest();
        request.setTicket(response.getTicket());
        request.setClaimToken(authzClient.obtainAccessToken("kolo", "password").getToken());
        try {
            authzClient.authorization().authorize(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        permissions = authzClient.protection().permission().findByResource(resource.getId());
        Assert.assertFalse((boolean)permissions.isEmpty());
        Assert.assertEquals((long)1L, (long)permissions.size());
    }

    @Test
    public void testPermissionForTypedScope() throws Exception {
        ResourceRepresentation typedResource = this.addResource("Typed Resource", "ScopeC");
        typedResource.setType("typed-resource");
        this.getClient(this.getRealm()).authorization().resources().resource(typedResource.getId()).update(typedResource);
        ResourceRepresentation resourceA = this.addResource("Resource A", "marta", true, "ScopeA", "ScopeB");
        resourceA.setType(typedResource.getType());
        this.getClient(this.getRealm()).authorization().resources().resource(resourceA.getId()).update(resourceA);
        PermissionRequest permissionRequest = new PermissionRequest(resourceA.getId(), new String[0]);
        permissionRequest.setScopes(new HashSet<String>(Arrays.asList("ScopeA", "ScopeC")));
        AuthzClient authzClient = this.getAuthzClient();
        PermissionResponse response = authzClient.protection("kolo", "password").permission().create(permissionRequest);
        AuthorizationRequest request = new AuthorizationRequest();
        request.setTicket(response.getTicket());
        request.setClaimToken(authzClient.obtainAccessToken("kolo", "password").getToken());
        try {
            authzClient.authorization().authorize(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertPersistence(response, resourceA, "ScopeA", "ScopeC");
    }

    @Test
    public void testSameTicketForSamePermissionRequest() throws Exception {
        ResourceRepresentation resource = this.addResource("Resource A", true, new String[0]);
        PermissionResponse response = this.getAuthzClient().protection("marta", "password").permission().create(new PermissionRequest(resource.getName(), new String[0]));
        Assert.assertNotNull((Object)response.getTicket());
    }

    private void assertPersistence(PermissionResponse response, ResourceRepresentation resource, String ... scopeNames) throws Exception {
        String ticket = response.getTicket();
        Assert.assertNotNull((Object)ticket);
        int expectedPermissions = scopeNames.length > 0 ? scopeNames.length : 1;
        List tickets = this.getAuthzClient().protection().permission().findByResource(resource.getId());
        Assert.assertEquals((long)expectedPermissions, (long)tickets.size());
        PermissionTicketToken token = (PermissionTicketToken)new JWSInput(ticket).readJsonContent(PermissionTicketToken.class);
        List tokenPermissions = token.getPermissions();
        Assert.assertNotNull((Object)tokenPermissions);
        Assert.assertEquals((long)expectedPermissions, (long)(scopeNames.length > 0 ? (long)scopeNames.length : (long)tokenPermissions.size()));
        Iterator permissionIterator = tokenPermissions.iterator();
        while (permissionIterator.hasNext()) {
            Permission resourcePermission = (Permission)permissionIterator.next();
            long count = tickets.stream().filter(representation -> representation.getResource().equals(resourcePermission.getResourceId())).count();
            if (count != (long)(scopeNames.length > 0 ? scopeNames.length : 1)) continue;
            permissionIterator.remove();
        }
        Assert.assertTrue((boolean)tokenPermissions.isEmpty());
        ArrayList expectedTickets = new ArrayList(tickets);
        Iterator ticketIterator = expectedTickets.iterator();
        while (ticketIterator.hasNext()) {
            PermissionTicketRepresentation ticketRep = (PermissionTicketRepresentation)ticketIterator.next();
            Assert.assertFalse((boolean)ticketRep.isGranted());
            if (ticketRep.getScope() != null) {
                ScopeRepresentation scope = this.getClient(this.getRealm()).authorization().scopes().scope(ticketRep.getScope()).toRepresentation();
                if (!Arrays.asList(scopeNames).contains(scope.getName())) continue;
                ticketIterator.remove();
                continue;
            }
            if (!ticketRep.getResource().equals(resource.getId())) continue;
            ticketIterator.remove();
        }
        Assert.assertTrue((boolean)expectedTickets.isEmpty());
    }

    @Test
    public void failInvalidResource() {
        try {
            this.getAuthzClient().protection().permission().create(new PermissionRequest("Invalid Resource", new String[0]));
            Assert.fail((String)"Should fail, resource does not exist");
        }
        catch (RuntimeException cause) {
            Assert.assertTrue((boolean)HttpResponseException.class.isInstance(cause.getCause()));
            Assert.assertEquals((long)400L, (long)((HttpResponseException)HttpResponseException.class.cast(cause.getCause())).getStatusCode());
            Assert.assertTrue((boolean)new String(((HttpResponseException)HttpResponseException.class.cast(cause.getCause())).getBytes()).contains("invalid_resource_id"));
        }
        try {
            this.getAuthzClient().protection().permission().create(new PermissionRequest());
            Assert.fail((String)"Should fail, resource is empty");
        }
        catch (RuntimeException cause) {
            cause.printStackTrace();
            Assert.assertTrue((boolean)HttpResponseException.class.isInstance(cause.getCause()));
            Assert.assertEquals((long)400L, (long)((HttpResponseException)HttpResponseException.class.cast(cause.getCause())).getStatusCode());
            Assert.assertTrue((boolean)new String(((HttpResponseException)HttpResponseException.class.cast(cause.getCause())).getBytes()).contains("invalid_resource_id"));
        }
    }

    @Test
    public void failInvalidScope() throws Exception {
        this.addResource("Resource A", "ScopeA", "ScopeB");
        try {
            PermissionRequest permissionRequest = new PermissionRequest("Resource A", new String[0]);
            permissionRequest.setScopes(new HashSet<String>(Arrays.asList("ScopeA", "ScopeC")));
            this.getAuthzClient().protection().permission().create(permissionRequest);
            Assert.fail((String)"Should fail, resource does not exist");
        }
        catch (RuntimeException cause) {
            Assert.assertTrue((boolean)HttpResponseException.class.isInstance(cause.getCause()));
            Assert.assertEquals((long)400L, (long)((HttpResponseException)HttpResponseException.class.cast(cause.getCause())).getStatusCode());
            Assert.assertTrue((boolean)new String(((HttpResponseException)HttpResponseException.class.cast(cause.getCause())).getBytes()).contains("invalid_scope"));
        }
    }

    @Test
    public void testGetPermissionTicketWithPagination() throws Exception {
        String[] scopes = new String[]{"ScopeA", "ScopeB", "ScopeC", "ScopeD"};
        ResourceRepresentation resource = this.addResource("Resource A", "kolo", true, scopes);
        AuthzClient authzClient = this.getAuthzClient();
        PermissionResponse response = authzClient.protection("marta", "password").permission().create(new PermissionRequest(resource.getId(), scopes));
        AuthorizationRequest request = new AuthorizationRequest();
        request.setTicket(response.getTicket());
        request.setClaimToken(authzClient.obtainAccessToken("marta", "password").getToken());
        try {
            authzClient.authorization().authorize(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<String> expectedScopes = new ArrayList<String>(Arrays.asList(scopes));
        List tickets = this.getAuthzClient().protection().permission().find(resource.getId(), null, null, null, null, Boolean.valueOf(true), Integer.valueOf(2), Integer.valueOf(2));
        Assert.assertEquals((String)"Returned number of permissions tickets must match the specified page size (i.e., 'maxResult').", (long)2L, (long)tickets.size());
        boolean foundScope = expectedScopes.remove(((PermissionTicketRepresentation)tickets.get(0)).getScopeName());
        Assert.assertTrue((String)"Returned set of permission tickets must be only a sub-set as per pagination offset and specified page size.", (boolean)foundScope);
        foundScope = expectedScopes.remove(((PermissionTicketRepresentation)tickets.get(1)).getScopeName());
        Assert.assertTrue((String)"Returned set of permission tickets must be only a sub-set as per pagination offset and specified page size.", (boolean)foundScope);
        tickets = this.getAuthzClient().protection().permission().find(resource.getId(), null, null, null, null, Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(2));
        Assert.assertEquals((String)"Returned number of permissions tickets must match the specified page size (i.e., 'maxResult').", (long)2L, (long)tickets.size());
        foundScope = expectedScopes.remove(((PermissionTicketRepresentation)tickets.get(0)).getScopeName());
        Assert.assertTrue((String)"Returned set of permission tickets must be only a sub-set as per pagination offset and specified page size.", (boolean)foundScope);
        foundScope = expectedScopes.remove(((PermissionTicketRepresentation)tickets.get(1)).getScopeName());
        Assert.assertTrue((String)"Returned set of permission tickets must be only a sub-set as per pagination offset and specified page size.", (boolean)foundScope);
    }

    @Test
    public void testPermissionCount() throws Exception {
        String[] scopes = new String[]{"ScopeA", "ScopeB", "ScopeC", "ScopeD"};
        ResourceRepresentation resource = this.addResource("Resource A", "kolo", true, scopes);
        AuthzClient authzClient = this.getAuthzClient();
        PermissionResponse response = authzClient.protection("marta", "password").permission().create(new PermissionRequest(resource.getId(), scopes));
        AuthorizationRequest request = new AuthorizationRequest();
        request.setTicket(response.getTicket());
        request.setClaimToken(authzClient.obtainAccessToken("marta", "password").getToken());
        try {
            authzClient.authorization().authorize(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Long ticketCount = this.getAuthzClient().protection().permission().count(resource.getId(), null, null, null, null, Boolean.valueOf(true));
        Assert.assertEquals((String)"Returned number of permissions tickets must match the amount of permission tickets.", (Object)4L, (Object)ticketCount);
    }
}

