/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.ResourcesResource;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.util.HttpResponseException;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.JSPolicyRepresentation;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.PermissionRequest;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.authz.AbstractAuthzTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.RolesBuilder;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class PermissionClaimTest
extends AbstractAuthzTest {
    private JSPolicyRepresentation claimAPolicy;
    private JSPolicyRepresentation claimBPolicy;
    private JSPolicyRepresentation claimCPolicy;
    private JSPolicyRepresentation denyPolicy;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(RealmBuilder.create().name("authz-test").roles(RolesBuilder.create().realmRole(RoleBuilder.create().name("uma_authorization").build())).user(UserBuilder.create().username("marta").password("password").addRoles("uma_authorization")).user(UserBuilder.create().username("kolo").password("password")).client(ClientBuilder.create().clientId("resource-server-test").secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-test").defaultRoles("uma_protection").directAccessGrants()).client(ClientBuilder.create().clientId("test-client").secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/test-client").directAccessGrants()).build());
    }

    @Before
    public void configureAuthorization() throws Exception {
        ClientResource client = this.getClient(this.getRealm());
        AuthorizationResource authorization = client.authorization();
        this.claimAPolicy = new JSPolicyRepresentation();
        this.claimAPolicy.setName("Claim A Policy");
        this.claimAPolicy.setCode("$evaluation.getPermission().addClaim('claim-a', 'claim-a');$evaluation.getPermission().addClaim('claim-a', 'claim-a1');$evaluation.grant();");
        authorization.policies().js().create(this.claimAPolicy).close();
        this.claimBPolicy = new JSPolicyRepresentation();
        this.claimBPolicy.setName("Policy Claim B");
        this.claimBPolicy.setCode("$evaluation.getPermission().addClaim('claim-b', 'claim-b');$evaluation.grant();");
        authorization.policies().js().create(this.claimBPolicy).close();
        this.claimCPolicy = new JSPolicyRepresentation();
        this.claimCPolicy.setName("Policy Claim C");
        this.claimCPolicy.setCode("$evaluation.getPermission().addClaim('claim-c', 'claim-c');$evaluation.grant();");
        authorization.policies().js().create(this.claimCPolicy).close();
        this.denyPolicy = new JSPolicyRepresentation();
        this.denyPolicy.setName("Deny Policy");
        this.denyPolicy.setCode("$evaluation.getPermission().addClaim('deny-policy', 'deny-policy');$evaluation.deny();");
        authorization.policies().js().create(this.denyPolicy).close();
    }

    @After
    public void removeAuthorization() throws Exception {
        ClientResource client = this.getClient(this.getRealm());
        ClientRepresentation representation = client.toRepresentation();
        representation.setAuthorizationServicesEnabled(Boolean.valueOf(false));
        client.update(representation);
        representation.setAuthorizationServicesEnabled(Boolean.valueOf(true));
        client.update(representation);
        ResourcesResource resources = client.authorization().resources();
        List defaultResource = resources.findByName("Default Resource");
        resources.resource(((ResourceRepresentation)defaultResource.get(0)).getId()).remove();
    }

    @Test
    public void testPermissionWithClaims() throws Exception {
        ClientResource client = this.getClient(this.getRealm());
        AuthorizationResource authorization = client.authorization();
        ResourceRepresentation resource = new ResourceRepresentation("Resource A", new String[0]);
        authorization.resources().create(resource).close();
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName(resource.getName() + " Permission");
        permission.addResource(resource.getName());
        permission.addPolicy(new String[]{this.claimAPolicy.getName()});
        authorization.permissions().resource().create(permission).close();
        PermissionRequest request = new PermissionRequest();
        request.setResourceId(resource.getName());
        String accessToken = new OAuthClient().realm("authz-test").clientId("test-client").doGrantAccessTokenRequest("secret", "marta", "password").getAccessToken();
        AuthzClient authzClient = this.getAuthzClient();
        String ticket = authzClient.protection().permission().create(request).getTicket();
        AuthorizationResponse response = authzClient.authorization(accessToken).authorize(new AuthorizationRequest(ticket));
        Assert.assertNotNull((Object)response.getToken());
        AccessToken rpt = this.toAccessToken(response.getToken());
        AccessToken.Authorization authorizationClaim = rpt.getAuthorization();
        ArrayList permissions = new ArrayList(authorizationClaim.getPermissions());
        Assert.assertEquals((long)1L, (long)permissions.size());
        Assert.assertTrue((boolean)((Set)((Permission)permissions.get(0)).getClaims().get("claim-a")).containsAll(Arrays.asList("claim-a", "claim-a1")));
    }

    @Test
    public void testPermissionWithClaimsDifferentPolicies() throws Exception {
        ClientResource client = this.getClient(this.getRealm());
        AuthorizationResource authorization = client.authorization();
        ResourceRepresentation resource = new ResourceRepresentation("Resource B", new String[0]);
        authorization.resources().create(resource).close();
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName(resource.getName() + " Permission");
        permission.addResource(resource.getName());
        permission.addPolicy(new String[]{this.claimAPolicy.getName(), this.claimBPolicy.getName()});
        authorization.permissions().resource().create(permission).close();
        PermissionRequest request = new PermissionRequest();
        request.setResourceId(resource.getName());
        String accessToken = new OAuthClient().realm("authz-test").clientId("test-client").doGrantAccessTokenRequest("secret", "marta", "password").getAccessToken();
        AuthzClient authzClient = this.getAuthzClient();
        String ticket = authzClient.protection().permission().forResource(request).getTicket();
        AuthorizationResponse response = authzClient.authorization(accessToken).authorize(new AuthorizationRequest(ticket));
        Assert.assertNotNull((Object)response.getToken());
        AccessToken rpt = this.toAccessToken(response.getToken());
        AccessToken.Authorization authorizationClaim = rpt.getAuthorization();
        ArrayList permissions = new ArrayList(authorizationClaim.getPermissions());
        Assert.assertEquals((long)1L, (long)permissions.size());
        Map claims = ((Permission)permissions.get(0)).getClaims();
        Assert.assertTrue((boolean)claims.containsKey("claim-a"));
        Assert.assertTrue((boolean)claims.containsKey("claim-b"));
    }

    @Test
    public void testClaimsFromDifferentScopePermissions() throws Exception {
        Map claims;
        ClientResource client = this.getClient(this.getRealm());
        AuthorizationResource authorization = client.authorization();
        ResourceRepresentation resourceA = new ResourceRepresentation(KeycloakModelUtils.generateId(), new String[]{"create", "update"});
        authorization.resources().create(resourceA).close();
        ResourceRepresentation resourceB = new ResourceRepresentation(KeycloakModelUtils.generateId(), new String[]{"create", "update"});
        authorization.resources().create(resourceB).close();
        ScopePermissionRepresentation allScopesPermission = new ScopePermissionRepresentation();
        allScopesPermission.setName(KeycloakModelUtils.generateId());
        allScopesPermission.addScope(new String[]{"create", "update"});
        allScopesPermission.addPolicy(new String[]{this.claimAPolicy.getName(), this.claimBPolicy.getName()});
        authorization.permissions().scope().create(allScopesPermission).close();
        ScopePermissionRepresentation updatePermission = new ScopePermissionRepresentation();
        updatePermission.setName(KeycloakModelUtils.generateId());
        updatePermission.addScope(new String[]{"update"});
        updatePermission.addPolicy(new String[]{this.claimCPolicy.getName()});
        try (Response response = authorization.permissions().scope().create(updatePermission);){
            updatePermission = (ScopePermissionRepresentation)response.readEntity(ScopePermissionRepresentation.class);
        }
        AuthzClient authzClient = this.getAuthzClient();
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission(null, new String[]{"create", "update"});
        AuthorizationResponse response = authzClient.authorization("marta", "password").authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        AccessToken rpt = this.toAccessToken(response.getToken());
        AccessToken.Authorization authorizationClaim = rpt.getAuthorization();
        ArrayList permissions = new ArrayList(authorizationClaim.getPermissions());
        Assert.assertEquals((long)2L, (long)permissions.size());
        for (Permission permission : permissions) {
            claims = permission.getClaims();
            Assert.assertNotNull((Object)claims);
            Assert.assertThat(claims.get("claim-a"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"claim-a", "claim-a1"}));
            Assert.assertThat(claims.get("claim-b"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"claim-b"}));
            Assert.assertThat(claims.get("claim-c"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"claim-c"}));
        }
        updatePermission.addPolicy(new String[]{this.denyPolicy.getName()});
        authorization.permissions().scope().findById(updatePermission.getId()).update(updatePermission);
        response = authzClient.authorization("marta", "password").authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        rpt = this.toAccessToken(response.getToken());
        authorizationClaim = rpt.getAuthorization();
        permissions = new ArrayList(authorizationClaim.getPermissions());
        Assert.assertEquals((long)2L, (long)permissions.size());
        for (Permission permission : permissions) {
            claims = permission.getClaims();
            Assert.assertNotNull((Object)claims);
            Assert.assertThat(claims.get("claim-a"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"claim-a", "claim-a1"}));
            Assert.assertThat(claims.get("claim-b"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"claim-b"}));
            Assert.assertThat(claims.get("claim-c"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"claim-c"}));
            Assert.assertThat(claims.get("deny-policy"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"deny-policy"}));
        }
    }

    @Test
    public void testClaimsFromDifferentResourcePermissions() throws Exception {
        Map claims;
        Object claims2;
        ClientResource client = this.getClient(this.getRealm());
        AuthorizationResource authorization = client.authorization();
        ResourceRepresentation resourceA = new ResourceRepresentation(KeycloakModelUtils.generateId(), new String[0]);
        resourceA.setType("typed-resource");
        authorization.resources().create(resourceA).close();
        ResourcePermissionRepresentation allScopesPermission = new ResourcePermissionRepresentation();
        allScopesPermission.setName(KeycloakModelUtils.generateId());
        allScopesPermission.addResource(resourceA.getName());
        allScopesPermission.addPolicy(new String[]{this.claimAPolicy.getName(), this.claimBPolicy.getName()});
        authorization.permissions().resource().create(allScopesPermission).close();
        ResourcePermissionRepresentation updatePermission = new ResourcePermissionRepresentation();
        updatePermission.setName(KeycloakModelUtils.generateId());
        updatePermission.addResource(resourceA.getName());
        updatePermission.addPolicy(new String[]{this.claimCPolicy.getName()});
        try (Response response = authorization.permissions().resource().create(updatePermission);){
            updatePermission = (ResourcePermissionRepresentation)response.readEntity(ResourcePermissionRepresentation.class);
        }
        AuthzClient authzClient = this.getAuthzClient();
        AuthorizationResponse response = authzClient.authorization("marta", "password").authorize();
        Assert.assertNotNull((Object)response.getToken());
        AccessToken rpt = this.toAccessToken(response.getToken());
        AccessToken.Authorization authorizationClaim = rpt.getAuthorization();
        ArrayList permissions = new ArrayList(authorizationClaim.getPermissions());
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission permission : permissions) {
            claims2 = permission.getClaims();
            Assert.assertNotNull((Object)claims2);
            Assert.assertThat(claims2.get("claim-a"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"claim-a", "claim-a1"}));
            Assert.assertThat(claims2.get("claim-b"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"claim-b"}));
            Assert.assertThat(claims2.get("claim-c"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"claim-c"}));
        }
        updatePermission.addPolicy(new String[]{this.denyPolicy.getName()});
        authorization.permissions().resource().findById(updatePermission.getId()).update(updatePermission);
        try {
            authzClient.authorization("marta", "password").authorize();
            Assert.fail((String)"can not access resource");
        }
        catch (RuntimeException expected) {
            Assert.assertEquals((long)403L, (long)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).getStatusCode());
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).toString().contains("access_denied"));
        }
        ResourceRepresentation resourceInstance = new ResourceRepresentation(KeycloakModelUtils.generateId(), new String[]{"create", "update"});
        resourceInstance.setType(resourceA.getType());
        resourceInstance.setOwner("marta");
        Response response1 = authorization.resources().create(resourceInstance);
        claims2 = null;
        try {
            resourceInstance = (ResourceRepresentation)response1.readEntity(ResourceRepresentation.class);
        }
        catch (Throwable throwable) {
            claims2 = throwable;
            throw throwable;
        }
        finally {
            if (response1 != null) {
                if (claims2 != null) {
                    try {
                        response1.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)claims2).addSuppressed(throwable);
                    }
                } else {
                    response1.close();
                }
            }
        }
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission(null, new String[]{"create", "update"});
        try {
            authzClient.authorization("marta", "password").authorize(request);
            Assert.fail((String)"can not access resource");
        }
        catch (RuntimeException expected) {
            Assert.assertEquals((long)403L, (long)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).getStatusCode());
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).toString().contains("access_denied"));
        }
        ResourcePermissionRepresentation resourceInstancePermission = new ResourcePermissionRepresentation();
        resourceInstancePermission.setName(KeycloakModelUtils.generateId());
        resourceInstancePermission.addResource(resourceInstance.getId());
        resourceInstancePermission.addPolicy(new String[]{this.claimCPolicy.getName()});
        try (Response response12 = authorization.permissions().resource().create(resourceInstancePermission);){
            resourceInstancePermission = (ResourcePermissionRepresentation)response12.readEntity(ResourcePermissionRepresentation.class);
        }
        response = authzClient.authorization("marta", "password").authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        rpt = this.toAccessToken(response.getToken());
        authorizationClaim = rpt.getAuthorization();
        permissions = new ArrayList(authorizationClaim.getPermissions());
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission permission : permissions) {
            claims = permission.getClaims();
            Assert.assertNotNull((Object)claims);
            Assert.assertThat(claims.get("claim-a"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"claim-a", "claim-a1"}));
            Assert.assertThat(claims.get("claim-b"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"claim-b"}));
            Assert.assertThat(claims.get("claim-c"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"claim-c"}));
            Assert.assertThat(claims.get("deny-policy"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"deny-policy"}));
        }
        response = authzClient.authorization("marta", "password").authorize();
        Assert.assertNotNull((Object)response.getToken());
        rpt = this.toAccessToken(response.getToken());
        authorizationClaim = rpt.getAuthorization();
        permissions = new ArrayList(authorizationClaim.getPermissions());
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission permission : permissions) {
            claims = permission.getClaims();
            Assert.assertNotNull((Object)claims);
            Assert.assertThat(claims.get("claim-a"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"claim-a", "claim-a1"}));
            Assert.assertThat(claims.get("claim-b"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"claim-b"}));
            Assert.assertThat(claims.get("claim-c"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"claim-c"}));
            Assert.assertThat(claims.get("deny-policy"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"deny-policy"}));
            Assert.assertThat((Object)permission.getScopes(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"create", "update"}));
        }
        updatePermission.setPolicies(new HashSet());
        updatePermission.addPolicy(new String[]{this.claimCPolicy.getName()});
        authorization.permissions().resource().findById(updatePermission.getId()).update(updatePermission);
        response = authzClient.authorization("marta", "password").authorize();
        Assert.assertNotNull((Object)response.getToken());
        rpt = this.toAccessToken(response.getToken());
        authorizationClaim = rpt.getAuthorization();
        permissions = new ArrayList(authorizationClaim.getPermissions());
        Assert.assertEquals((long)2L, (long)permissions.size());
        for (Permission permission : permissions) {
            claims = permission.getClaims();
            Assert.assertNotNull((Object)claims);
            Assert.assertThat(claims.get("claim-a"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"claim-a", "claim-a1"}));
            Assert.assertThat(claims.get("claim-b"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"claim-b"}));
            Assert.assertThat(claims.get("claim-c"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"claim-c"}));
        }
    }

    private RealmResource getRealm() throws Exception {
        return this.adminClient.realm("authz-test");
    }

    private ClientResource getClient(RealmResource realm) {
        ClientsResource clients = realm.clients();
        return clients.findByClientId("resource-server-test").stream().map(representation -> clients.get(representation.getId())).findFirst().orElseThrow(() -> new RuntimeException("Expected client [resource-server-test]"));
    }

    private AuthzClient getAuthzClient() {
        try {
            return AuthzClient.create((InputStream)PermissionClaimTest.httpsAwareConfigurationStream(this.getClass().getResourceAsStream("/authorization-test/default-keycloak.json")));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to create authz client", cause);
        }
    }
}

