/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.authz.GroupPathPolicyTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.GroupBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.RolesBuilder;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class GroupPathWithoutGroupClaimPolicyTest
extends GroupPathPolicyTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        ProtocolMapperRepresentation groupProtocolMapper = new ProtocolMapperRepresentation();
        groupProtocolMapper.setName("groups");
        groupProtocolMapper.setProtocolMapper("oidc-group-membership-mapper");
        groupProtocolMapper.setProtocol("openid-connect");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("claim.name", "groups");
        config.put("access.token.claim", "true");
        config.put("id.token.claim", "true");
        groupProtocolMapper.setConfig(config);
        testRealms.add(RealmBuilder.create().name("authz-test").roles(RolesBuilder.create().realmRole(RoleBuilder.create().name("uma_authorization").build())).group(GroupBuilder.create().name("Group A").subGroups(Arrays.asList("Group B", "Group D").stream().map(name -> {
            if ("Group B".equals(name)) {
                return GroupBuilder.create().name((String)name).subGroups(Arrays.asList("Group C", "Group E").stream().map(new Function<String, GroupRepresentation>(){

                    @Override
                    public GroupRepresentation apply(String name) {
                        return GroupBuilder.create().name(name).build();
                    }
                }).collect(Collectors.toList())).build();
            }
            return GroupBuilder.create().name((String)name).build();
        }).collect(Collectors.toList())).build()).group(GroupBuilder.create().name("Group E").build()).user(UserBuilder.create().username("marta").password("password").addRoles("uma_authorization").addGroups("Group A")).user(UserBuilder.create().username("alice").password("password").addRoles("uma_authorization")).user(UserBuilder.create().username("kolo").password("password").addRoles("uma_authorization")).client(ClientBuilder.create().clientId("resource-server-test").secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-test").defaultRoles("uma_protection").directAccessGrants()).build());
    }
}

