/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.authorization.client.AuthorizationDeniedException;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.GroupPolicyRepresentation;
import org.keycloak.representations.idm.authorization.PermissionRequest;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.authz.AbstractAuthzTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.GroupBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.RolesBuilder;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class GroupNamePolicyTest
extends AbstractAuthzTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        ProtocolMapperRepresentation groupProtocolMapper = new ProtocolMapperRepresentation();
        groupProtocolMapper.setName("groups");
        groupProtocolMapper.setProtocolMapper("oidc-group-membership-mapper");
        groupProtocolMapper.setProtocol("openid-connect");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("claim.name", "groups");
        config.put("access.token.claim", "true");
        config.put("id.token.claim", "true");
        groupProtocolMapper.setConfig(config);
        testRealms.add(RealmBuilder.create().name("authz-test").roles(RolesBuilder.create().realmRole(RoleBuilder.create().name("uma_authorization").build())).group(GroupBuilder.create().name("Group A").subGroups(Arrays.asList("Group B", "Group D").stream().map(name -> {
            if ("Group B".equals(name)) {
                return GroupBuilder.create().name((String)name).subGroups(Arrays.asList("Group C", "Group E").stream().map(new Function<String, GroupRepresentation>(){

                    @Override
                    public GroupRepresentation apply(String name) {
                        return GroupBuilder.create().name(name).build();
                    }
                }).collect(Collectors.toList())).build();
            }
            return GroupBuilder.create().name((String)name).build();
        }).collect(Collectors.toList())).build()).group(GroupBuilder.create().name("Group E").build()).user(UserBuilder.create().username("marta").password("password").addRoles("uma_authorization").addGroups("Group A")).user(UserBuilder.create().username("alice").password("password").addRoles("uma_authorization")).user(UserBuilder.create().username("kolo").password("password").addRoles("uma_authorization")).client(ClientBuilder.create().clientId("resource-server-test").secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-test").defaultRoles("uma_protection").directAccessGrants().protocolMapper(groupProtocolMapper).serviceAccountsEnabled(true)).build());
    }

    @Before
    public void configureAuthorization() throws Exception {
        this.createResource("Resource A");
        this.createResource("Resource B");
        this.createResource("Resource C");
        this.createGroupPolicy("Only Group A Policy", "/Group A", true);
        this.createGroupPolicy("Only Group B Policy", "/Group A/Group B", false);
        this.createGroupPolicy("Only Group C Policy", "/Group A/Group B/Group C", false);
        this.createResourcePermission("Resource A Permission", "Resource A", "Only Group A Policy");
        this.createResourcePermission("Resource B Permission", "Resource B", "Only Group B Policy");
        this.createResourcePermission("Resource C Permission", "Resource C", "Only Group C Policy");
        RealmResource realm = this.getRealm();
        GroupRepresentation group = this.getGroup("/Group A/Group B/Group C");
        UserRepresentation user = (UserRepresentation)realm.users().search("kolo").get(0);
        realm.users().get(user.getId()).joinGroup(group.getId());
        group = this.getGroup("/Group A/Group B");
        user = (UserRepresentation)realm.users().search("alice").get(0);
        realm.users().get(user.getId()).joinGroup(group.getId());
    }

    @Test
    public void testExactNameMatch() {
        AuthzClient authzClient = this.getAuthzClient();
        PermissionRequest request = new PermissionRequest("Resource A", new String[0]);
        String ticket = authzClient.protection().permission().create(request).getTicket();
        AuthorizationResponse response = authzClient.authorization("marta", "password").authorize(new AuthorizationRequest(ticket));
        Assert.assertNotNull((Object)response.getToken());
        try {
            authzClient.authorization("kolo", "password").authorize(new AuthorizationRequest(ticket));
            Assert.fail((String)"Should fail because user is not granted with expected group");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
        try {
            authzClient.authorization("alice", "password").authorize(new AuthorizationRequest(ticket));
            Assert.fail((String)"Should fail because user is not granted with expected group");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
        try {
            authzClient.authorization(authzClient.obtainAccessToken().getToken()).authorize(new AuthorizationRequest(ticket));
            Assert.fail((String)"Should fail because service account is not granted with expected group");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
    }

    @Test
    public void testOnlyChildrenPolicy() throws Exception {
        RealmResource realm = this.getRealm();
        AuthzClient authzClient = this.getAuthzClient();
        PermissionRequest request = new PermissionRequest("Resource B", new String[0]);
        String ticket = authzClient.protection().permission().create(request).getTicket();
        try {
            authzClient.authorization("kolo", "password").authorize(new AuthorizationRequest(ticket));
            Assert.fail((String)"Should fail because user is not granted with expected group");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
        AuthorizationResponse response = authzClient.authorization("alice", "password").authorize(new AuthorizationRequest(ticket));
        Assert.assertNotNull((Object)response.getToken());
        try {
            authzClient.authorization("marta", "password").authorize(new AuthorizationRequest(ticket));
            Assert.fail((String)"Should fail because user is not granted with expected role");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
        request = new PermissionRequest("Resource C", new String[0]);
        ticket = authzClient.protection().permission().create(request).getTicket();
        response = authzClient.authorization("kolo", "password").authorize(new AuthorizationRequest(ticket));
        Assert.assertNotNull((Object)response.getToken());
    }

    private void createGroupPolicy(String name, String groupPath, boolean extendChildren) {
        GroupPolicyRepresentation policy = new GroupPolicyRepresentation();
        policy.setName(name);
        policy.setGroupsClaim("groups");
        policy.addGroupPath(groupPath, extendChildren);
        this.getClient().authorization().policies().group().create(policy).close();
    }

    private void createResourcePermission(String name, String resource, String ... policies) {
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName(name);
        permission.addResource(resource);
        permission.addPolicy(policies);
        this.getClient().authorization().permissions().resource().create(permission).close();
    }

    private void createResource(String name) {
        AuthorizationResource authorization = this.getClient().authorization();
        ResourceRepresentation resource = new ResourceRepresentation(name, new String[0]);
        authorization.resources().create(resource).close();
    }

    private RealmResource getRealm() {
        try {
            return this.getAdminClient().realm("authz-test");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create admin client");
        }
    }

    private ClientResource getClient(RealmResource realm) {
        ClientsResource clients = realm.clients();
        return clients.findByClientId("resource-server-test").stream().map(representation -> clients.get(representation.getId())).findFirst().orElseThrow(() -> new RuntimeException("Expected client [resource-server-test]"));
    }

    private AuthzClient getAuthzClient() {
        return AuthzClient.create((InputStream)this.getClass().getResourceAsStream("/authorization-test/default-keycloak.json"));
    }

    private ClientResource getClient() {
        return this.getClient(this.getRealm());
    }

    private GroupRepresentation getGroup(String path) {
        String[] parts = path.split("/");
        RealmResource realm = this.getRealm();
        GroupRepresentation parent = null;
        for (final String part : parts) {
            if ("".equals(part)) continue;
            if (parent == null) {
                parent = realm.groups().groups().stream().filter(new Predicate<GroupRepresentation>(){

                    @Override
                    public boolean test(GroupRepresentation groupRepresentation) {
                        return part.equals(groupRepresentation.getName());
                    }
                }).findFirst().get();
                continue;
            }
            GroupRepresentation group = this.getGroup(part, parent.getSubGroups());
            if (path.endsWith(group.getName())) {
                return group;
            }
            parent = group;
        }
        return null;
    }

    private GroupRepresentation getGroup(String name, List<GroupRepresentation> groups) {
        for (GroupRepresentation group : groups) {
            if (name.equals(group.getName())) {
                return group;
            }
            GroupRepresentation child = this.getGroup(name, group.getSubGroups());
            if (child == null || !name.equals(child.getName())) continue;
            return child;
        }
        return null;
    }
}

