/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.ws.rs.core.Response;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.ResourceResource;
import org.keycloak.admin.client.resource.ScopePermissionsResource;
import org.keycloak.authorization.client.AuthorizationDeniedException;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.representation.TokenIntrospectionResponse;
import org.keycloak.authorization.client.util.HttpResponseException;
import org.keycloak.common.util.Base64Url;
import org.keycloak.events.EventType;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.JSPolicyRepresentation;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.PermissionRequest;
import org.keycloak.representations.idm.authorization.PermissionResponse;
import org.keycloak.representations.idm.authorization.PermissionTicketRepresentation;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.authz.AbstractAuthzTest;
import org.keycloak.testsuite.client.resources.TestApplicationResourceUrls;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.RolesBuilder;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.util.JsonSerialization;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class EntitlementAPITest
extends AbstractAuthzTest {
    private static final String RESOURCE_SERVER_TEST = "resource-server-test";
    private static final String TEST_CLIENT = "test-client";
    private static final String AUTHZ_CLIENT_CONFIG = "default-keycloak.json";
    private static final String PAIRWISE_RESOURCE_SERVER_TEST = "pairwise-resource-server-test";
    private static final String PAIRWISE_TEST_CLIENT = "test-client-pairwise";
    private static final String PAIRWISE_AUTHZ_CLIENT_CONFIG = "default-keycloak-pairwise.json";
    private static final String PUBLIC_TEST_CLIENT = "test-public-client";
    private static final String PUBLIC_TEST_CLIENT_CONFIG = "default-keycloak-public-client.json";
    private AuthzClient authzClient;
    @ArquillianResource
    protected ContainerController controller;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(RealmBuilder.create().name("authz-test").roles(RolesBuilder.create().realmRole(RoleBuilder.create().name("uma_authorization").build())).user(UserBuilder.create().username("marta").password("password").addRoles("uma_authorization")).user(UserBuilder.create().username("kolo").password("password")).user(UserBuilder.create().username("offlineuser").password("password").addRoles("offline_access")).client(ClientBuilder.create().clientId(RESOURCE_SERVER_TEST).secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-test").defaultRoles("uma_protection").directAccessGrants()).client(ClientBuilder.create().clientId(PAIRWISE_RESOURCE_SERVER_TEST).secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-test").defaultRoles("uma_protection").pairwise(TestApplicationResourceUrls.pairwiseSectorIdentifierUri()).directAccessGrants()).client(ClientBuilder.create().clientId(TEST_CLIENT).secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/test-client").directAccessGrants()).client(ClientBuilder.create().clientId(PAIRWISE_TEST_CLIENT).secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/test-client").pairwise(TestApplicationResourceUrls.pairwiseSectorIdentifierUri()).directAccessGrants()).client(ClientBuilder.create().clientId(PUBLIC_TEST_CLIENT).secret("secret").redirectUris("http://localhost:8180/auth/realms/master/app/auth/*", "https://localhost:8543/auth/realms/master/app/auth/*").publicClient()).testEventListener().build());
        this.configureSectorIdentifierRedirectUris();
    }

    private void configureSectorIdentifierRedirectUris() {
        this.testingClient.testApp().oidcClientEndpoints().setSectorIdentifierRedirectUris(Arrays.asList("http://localhost/resource-server-test", "http://localhost/test-client"));
    }

    @Before
    public void configureAuthorization() throws Exception {
        this.configureAuthorization(RESOURCE_SERVER_TEST);
        this.configureAuthorization(PAIRWISE_RESOURCE_SERVER_TEST);
    }

    @After
    public void removeAuthorization() throws Exception {
        this.removeAuthorization(RESOURCE_SERVER_TEST);
        this.removeAuthorization(PAIRWISE_RESOURCE_SERVER_TEST);
    }

    @Test
    public void testRptRequestWithoutResourceName() {
        this.testRptRequestWithoutResourceName(AUTHZ_CLIENT_CONFIG);
    }

    @Test
    public void testRptRequestWithoutResourceNamePairwise() {
        this.testRptRequestWithoutResourceName(PAIRWISE_AUTHZ_CLIENT_CONFIG);
    }

    public void testRptRequestWithoutResourceName(String configFile) {
        AuthorizationRequest.Metadata metadata = new AuthorizationRequest.Metadata();
        metadata.setIncludeResourceName(Boolean.valueOf(false));
        this.assertResponse(metadata, () -> {
            AuthorizationRequest request = new AuthorizationRequest();
            request.setMetadata(metadata);
            request.addPermission("Resource 1", new String[0]);
            return this.getAuthzClient(configFile).authorization("marta", "password").authorize(request);
        });
    }

    @Test
    public void testRptRequestWithResourceName() {
        this.testRptRequestWithResourceName(AUTHZ_CLIENT_CONFIG);
    }

    @Test
    public void testRptRequestWithResourceNamePairwise() {
        this.testRptRequestWithResourceName(PAIRWISE_AUTHZ_CLIENT_CONFIG);
    }

    @Test
    public void testInvalidRequestWithClaimsFromConfidentialClient() throws IOException {
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission("Resource 13", new String[0]);
        HashMap<String, String> obj = new HashMap<String, String>();
        obj.put("claim-a", "claim-a");
        request.setClaimToken(Base64Url.encode((byte[])JsonSerialization.writeValueAsBytes(obj)));
        this.assertResponse(new AuthorizationRequest.Metadata(), () -> this.getAuthzClient(AUTHZ_CLIENT_CONFIG).authorization("marta", "password").authorize(request));
    }

    @Test
    public void testInvalidRequestWithClaimsFromPublicClient() throws IOException {
        this.oauth.realm("authz-test");
        this.oauth.clientId(PUBLIC_TEST_CLIENT);
        this.oauth.doLogin("marta", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, null);
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission("Resource 13", new String[0]);
        HashMap<String, String> obj = new HashMap<String, String>();
        obj.put("claim-a", "claim-a");
        request.setClaimToken(Base64Url.encode((byte[])JsonSerialization.writeValueAsBytes(obj)));
        this.expectedException.expect(AuthorizationDeniedException.class);
        this.expectedException.expectCause(Matchers.allOf((Matcher)Matchers.instanceOf(HttpResponseException.class), (Matcher)Matchers.hasProperty((String)"statusCode", (Matcher)Matchers.is((Object)403))));
        this.expectedException.expectMessage("Public clients are not allowed to send claims");
        this.expectedException.reportMissingExceptionWithMessage("Should fail, public clients not allowed");
        this.getAuthzClient(AUTHZ_CLIENT_CONFIG).authorization(response.getAccessToken()).authorize(request);
    }

    @Test
    public void testRequestWithoutClaimsFromPublicClient() {
        this.oauth.realm("authz-test");
        this.oauth.clientId(PUBLIC_TEST_CLIENT);
        this.oauth.doLogin("marta", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, null);
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission("Resource 13", new String[0]);
        this.assertResponse(new AuthorizationRequest.Metadata(), () -> this.getAuthzClient(AUTHZ_CLIENT_CONFIG).authorization(response.getAccessToken()).authorize(request));
    }

    @Test
    public void testPermissionLimit() {
        this.testPermissionLimit(AUTHZ_CLIENT_CONFIG);
    }

    @Test
    public void testPermissionLimitPairwise() {
        this.testPermissionLimit(PAIRWISE_AUTHZ_CLIENT_CONFIG);
    }

    public void testPermissionLimit(String configFile) {
        int i;
        AuthorizationRequest request = new AuthorizationRequest();
        for (int i2 = 1; i2 <= 10; ++i2) {
            request.addPermission("Resource " + i2, new String[0]);
        }
        AuthorizationRequest.Metadata metadata = new AuthorizationRequest.Metadata();
        metadata.setLimit(Integer.valueOf(10));
        request.setMetadata(metadata);
        AuthorizationResponse response = this.getAuthzClient(configFile).authorization("marta", "password").authorize(request);
        AccessToken rpt = this.toAccessToken(response.getToken());
        ArrayList permissions = new ArrayList(rpt.getAuthorization().getPermissions());
        Assert.assertEquals((long)10L, (long)permissions.size());
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)("Resource " + (i + 1)), (Object)((Permission)permissions.get(i)).getResourceName());
        }
        request = new AuthorizationRequest();
        for (i = 11; i <= 15; ++i) {
            request.addPermission("Resource " + i, new String[0]);
        }
        request.setMetadata(metadata);
        request.setRpt(response.getToken());
        response = this.getAuthzClient(configFile).authorization("marta", "password").authorize(request);
        rpt = this.toAccessToken(response.getToken());
        permissions = new ArrayList(rpt.getAuthorization().getPermissions());
        Assert.assertEquals((long)10L, (long)permissions.size());
        for (i = 0; i < 10; ++i) {
            if (i < 5) {
                Assert.assertEquals((Object)("Resource " + (i + 11)), (Object)((Permission)permissions.get(i)).getResourceName());
                continue;
            }
            Assert.assertEquals((Object)("Resource " + (i - 4)), (Object)((Permission)permissions.get(i)).getResourceName());
        }
        request = new AuthorizationRequest();
        for (i = 16; i <= 18; ++i) {
            request.addPermission("Resource " + i, new String[0]);
        }
        request.setMetadata(metadata);
        request.setRpt(response.getToken());
        response = this.getAuthzClient(configFile).authorization("marta", "password").authorize(request);
        rpt = this.toAccessToken(response.getToken());
        permissions = new ArrayList(rpt.getAuthorization().getPermissions());
        Assert.assertEquals((long)10L, (long)permissions.size());
        Assert.assertEquals((Object)"Resource 16", (Object)((Permission)permissions.get(0)).getResourceName());
        Assert.assertEquals((Object)"Resource 17", (Object)((Permission)permissions.get(1)).getResourceName());
        Assert.assertEquals((Object)"Resource 18", (Object)((Permission)permissions.get(2)).getResourceName());
        Assert.assertEquals((Object)"Resource 11", (Object)((Permission)permissions.get(3)).getResourceName());
        Assert.assertEquals((Object)"Resource 12", (Object)((Permission)permissions.get(4)).getResourceName());
        Assert.assertEquals((Object)"Resource 13", (Object)((Permission)permissions.get(5)).getResourceName());
        Assert.assertEquals((Object)"Resource 14", (Object)((Permission)permissions.get(6)).getResourceName());
        Assert.assertEquals((Object)"Resource 15", (Object)((Permission)permissions.get(7)).getResourceName());
        Assert.assertEquals((Object)"Resource 1", (Object)((Permission)permissions.get(8)).getResourceName());
        Assert.assertEquals((Object)"Resource 2", (Object)((Permission)permissions.get(9)).getResourceName());
        request = new AuthorizationRequest();
        metadata.setLimit(Integer.valueOf(5));
        request.setMetadata(metadata);
        request.setRpt(response.getToken());
        response = this.getAuthzClient(configFile).authorization("marta", "password").authorize(request);
        rpt = this.toAccessToken(response.getToken());
        permissions = new ArrayList(rpt.getAuthorization().getPermissions());
        Assert.assertEquals((long)5L, (long)permissions.size());
        Assert.assertEquals((Object)"Resource 16", (Object)((Permission)permissions.get(0)).getResourceName());
        Assert.assertEquals((Object)"Resource 17", (Object)((Permission)permissions.get(1)).getResourceName());
        Assert.assertEquals((Object)"Resource 18", (Object)((Permission)permissions.get(2)).getResourceName());
        Assert.assertEquals((Object)"Resource 11", (Object)((Permission)permissions.get(3)).getResourceName());
        Assert.assertEquals((Object)"Resource 12", (Object)((Permission)permissions.get(4)).getResourceName());
    }

    @Test
    public void testResourceServerAsAudience() throws Exception {
        this.testResourceServerAsAudience(TEST_CLIENT, RESOURCE_SERVER_TEST, AUTHZ_CLIENT_CONFIG);
    }

    @Test
    public void testResourceServerAsAudienceWithPairwiseClient() throws Exception {
        this.testResourceServerAsAudience(PAIRWISE_TEST_CLIENT, RESOURCE_SERVER_TEST, AUTHZ_CLIENT_CONFIG);
    }

    @Test
    public void testPairwiseResourceServerAsAudience() throws Exception {
        this.testResourceServerAsAudience(TEST_CLIENT, PAIRWISE_RESOURCE_SERVER_TEST, PAIRWISE_AUTHZ_CLIENT_CONFIG);
    }

    @Test
    public void testPairwiseResourceServerAsAudienceWithPairwiseClient() throws Exception {
        this.testResourceServerAsAudience(PAIRWISE_TEST_CLIENT, PAIRWISE_RESOURCE_SERVER_TEST, PAIRWISE_AUTHZ_CLIENT_CONFIG);
    }

    @Test
    public void testObtainAllEntitlements() throws Exception {
        ClientResource client = this.getClient(this.getRealm(), RESOURCE_SERVER_TEST);
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName("Only Owner Policy");
        policy.setCode("if ($evaluation.getContext().getIdentity().getId() == $evaluation.getPermission().getResource().getOwner()) {$evaluation.grant();}");
        authorization.policies().js().create(policy).close();
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName("Marta Resource");
        resource.setOwner("marta");
        resource.setOwnerManagedAccess(Boolean.valueOf(true));
        try (Response response = authorization.resources().create(resource);){
            resource = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        }
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName("Marta Resource Permission");
        permission.addResource(resource.getId());
        permission.addPolicy(new String[]{policy.getName()});
        authorization.permissions().resource().create(permission).close();
        Assert.assertTrue((boolean)this.hasPermission("marta", "password", resource.getId()));
        Assert.assertFalse((boolean)this.hasPermission("kolo", "password", resource.getId()));
        String accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "kolo", "password").getAccessToken();
        AuthzClient authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        PermissionResponse permissionResponse = authzClient.protection().permission().create(new PermissionRequest(resource.getId(), new String[0]));
        AuthorizationRequest request = new AuthorizationRequest();
        request.setTicket(permissionResponse.getTicket());
        try {
            authzClient.authorization(accessToken).authorize(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List tickets = authzClient.protection().permission().findByResource(resource.getId());
        Assert.assertEquals((long)1L, (long)tickets.size());
        PermissionTicketRepresentation ticket = (PermissionTicketRepresentation)tickets.get(0);
        ticket.setGranted(true);
        authzClient.protection().permission().update(ticket);
        Assert.assertTrue((boolean)this.hasPermission("kolo", "password", resource.getId()));
        resource.addScope(new String[]{"Scope A"});
        authorization.resources().resource(resource.getId()).update(resource);
        Assert.assertFalse((boolean)this.hasPermission("kolo", "password", resource.getId()));
        accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "kolo", "password").getAccessToken();
        permissionResponse = authzClient.protection().permission().create(new PermissionRequest(resource.getId(), new String[]{"Scope A"}));
        request = new AuthorizationRequest();
        request.setTicket(permissionResponse.getTicket());
        try {
            authzClient.authorization(accessToken).authorize(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        tickets = authzClient.protection().permission().find(resource.getId(), "Scope A", null, null, Boolean.valueOf(false), Boolean.valueOf(false), null, null);
        Assert.assertEquals((long)1L, (long)tickets.size());
        ticket = (PermissionTicketRepresentation)tickets.get(0);
        ticket.setGranted(true);
        authzClient.protection().permission().update(ticket);
        Assert.assertTrue((boolean)this.hasPermission("kolo", "password", resource.getId(), "Scope A"));
        resource.addScope(new String[]{"Scope B"});
        authorization.resources().resource(resource.getId()).update(resource);
        Assert.assertTrue((boolean)this.hasPermission("kolo", "password", resource.getId()));
        Assert.assertTrue((boolean)this.hasPermission("kolo", "password", resource.getId(), "Scope A"));
        Assert.assertFalse((boolean)this.hasPermission("kolo", "password", resource.getId(), "Scope B"));
        resource.setScopes(new HashSet());
        authorization.resources().resource(resource.getId()).update(resource);
        Assert.assertTrue((boolean)this.hasPermission("kolo", "password", resource.getId()));
        Assert.assertFalse((boolean)this.hasPermission("kolo", "password", resource.getId(), "Scope A"));
        Assert.assertFalse((boolean)this.hasPermission("kolo", "password", resource.getId(), "Scope B"));
    }

    @Test
    public void testObtainAllEntitlementsWithLimit() throws Exception {
        org.keycloak.authorization.client.resource.AuthorizationResource authorizationResource = this.getAuthzClient(AUTHZ_CLIENT_CONFIG).authorization("marta", "password");
        AuthorizationResponse response = authorizationResource.authorize();
        AccessToken accessToken = this.toAccessToken(response.getToken());
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        Assert.assertTrue((authorization.getPermissions().size() >= 20 ? 1 : 0) != 0);
        AuthorizationRequest request = new AuthorizationRequest();
        AuthorizationRequest.Metadata metadata = new AuthorizationRequest.Metadata();
        metadata.setLimit(Integer.valueOf(10));
        request.setMetadata(metadata);
        response = authorizationResource.authorize(request);
        accessToken = this.toAccessToken(response.getToken());
        authorization = accessToken.getAuthorization();
        Assert.assertEquals((long)10L, (long)authorization.getPermissions().size());
        metadata.setLimit(Integer.valueOf(1));
        request.setMetadata(metadata);
        response = authorizationResource.authorize(request);
        accessToken = this.toAccessToken(response.getToken());
        authorization = accessToken.getAuthorization();
        Assert.assertEquals((long)1L, (long)authorization.getPermissions().size());
    }

    @Test
    public void testObtainAllEntitlementsInvalidResource() throws Exception {
        ClientResource client = this.getClient(this.getRealm(), RESOURCE_SERVER_TEST);
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName(KeycloakModelUtils.generateId());
        policy.setCode("$evaluation.grant();");
        authorization.policies().js().create(policy).close();
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName("Sensors");
        resource.addScope(new String[]{"sensors:view", "sensors:update", "sensors:delete"});
        authorization.resources().create(resource).close();
        ScopePermissionRepresentation permission = new ScopePermissionRepresentation();
        permission.setName("View Sensor");
        permission.addScope(new String[]{"sensors:view"});
        permission.addPolicy(new String[]{policy.getName()});
        authorization.permissions().scope().create(permission).close();
        String accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "kolo", "password").getAccessToken();
        AuthzClient authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission("Sensortest", new String[]{"sensors:view"});
        this.getTestContext().getTestingClient().testing().clearEventQueue();
        try {
            authzClient.authorization(accessToken).authorize(request);
            Assert.fail((String)"resource is invalid");
        }
        catch (RuntimeException expected) {
            Assert.assertEquals((long)400L, (long)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).getStatusCode());
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).toString().contains("invalid_resource"));
        }
        this.events.expect(EventType.PERMISSION_TOKEN_ERROR).realm(this.getRealm().toRepresentation().getId()).client(RESOURCE_SERVER_TEST).session((String)null).error("invalid_request").detail("reason", "Resource with id [Sensortest] does not exist.").user(AssertEvents.isUUID()).assertEvent();
    }

    @Test
    public void testObtainAllEntitlementsInvalidScope() throws Exception {
        ClientResource client = this.getClient(this.getRealm(), RESOURCE_SERVER_TEST);
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName(KeycloakModelUtils.generateId());
        policy.setCode("$evaluation.grant();");
        authorization.policies().js().create(policy).close();
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName(KeycloakModelUtils.generateId());
        resource.addScope(new String[]{"sensors:view", "sensors:update", "sensors:delete"});
        try (Response response = authorization.resources().create(resource);){
            resource = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        }
        ScopePermissionRepresentation permission = new ScopePermissionRepresentation();
        permission.setName(KeycloakModelUtils.generateId());
        permission.addScope(new String[]{"sensors:view"});
        permission.addPolicy(new String[]{policy.getName()});
        authorization.permissions().scope().create(permission).close();
        String accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "kolo", "password").getAccessToken();
        AuthzClient authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission(resource.getId(), new String[]{"sensors:view_invalid"});
        try {
            authzClient.authorization(accessToken).authorize(request);
            Assert.fail((String)"scope is invalid");
        }
        catch (RuntimeException expected) {
            Assert.assertEquals((long)400L, (long)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).getStatusCode());
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).toString().contains("invalid_scope"));
        }
        request = new AuthorizationRequest();
        request.addPermission(null, new String[]{"sensors:view_invalid"});
        try {
            authzClient.authorization(accessToken).authorize(request);
            Assert.fail((String)"scope is invalid");
        }
        catch (RuntimeException expected) {
            Assert.assertEquals((long)400L, (long)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).getStatusCode());
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).toString().contains("invalid_scope"));
        }
    }

    @Test
    public void testObtainAllEntitlementsForScope() throws Exception {
        ClientResource client = this.getClient(this.getRealm(), RESOURCE_SERVER_TEST);
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName(KeycloakModelUtils.generateId());
        policy.setCode("$evaluation.grant();");
        authorization.policies().js().create(policy).close();
        HashSet<String> resourceIds = new HashSet<String>();
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName(KeycloakModelUtils.generateId());
        resource.addScope(new String[]{"sensors:view", "sensors:update", "sensors:delete"});
        try (Response response = authorization.resources().create(resource);){
            resourceIds.add(((ResourceRepresentation)response.readEntity(ResourceRepresentation.class)).getId());
        }
        resource = new ResourceRepresentation();
        resource.setName(KeycloakModelUtils.generateId());
        resource.addScope(new String[]{"sensors:view", "sensors:update"});
        response = authorization.resources().create(resource);
        var7_7 = null;
        try {
            resourceIds.add(((ResourceRepresentation)response.readEntity(ResourceRepresentation.class)).getId());
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (response != null) {
                if (var7_7 != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    response.close();
                }
            }
        }
        ScopePermissionRepresentation permission = new ScopePermissionRepresentation();
        permission.setName(KeycloakModelUtils.generateId());
        permission.addScope(new String[]{"sensors:view", "sensors:update"});
        permission.addPolicy(new String[]{policy.getName()});
        authorization.permissions().scope().create(permission).close();
        String accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "kolo", "password").getAccessToken();
        AuthzClient authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission(null, new String[]{"sensors:view"});
        AuthorizationResponse response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        Collection permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)2L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertTrue((boolean)resourceIds.containsAll(Arrays.asList(grantedPermission.getResourceId())));
            Assert.assertEquals((long)1L, (long)grantedPermission.getScopes().size());
            Assert.assertTrue((boolean)grantedPermission.getScopes().containsAll(Arrays.asList("sensors:view")));
        }
        request.addPermission(null, new String[]{"sensors:view", "sensors:update"});
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)2L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertTrue((boolean)resourceIds.containsAll(Arrays.asList(grantedPermission.getResourceId())));
            Assert.assertEquals((long)2L, (long)grantedPermission.getScopes().size());
            Assert.assertTrue((boolean)grantedPermission.getScopes().containsAll(Arrays.asList("sensors:view", "sensors:update")));
        }
        request.addPermission(null, new String[]{"sensors:view", "sensors:update", "sensors:delete"});
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)2L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertTrue((boolean)resourceIds.containsAll(Arrays.asList(grantedPermission.getResourceId())));
            Assert.assertEquals((long)2L, (long)grantedPermission.getScopes().size());
            Assert.assertTrue((boolean)grantedPermission.getScopes().containsAll(Arrays.asList("sensors:view", "sensors:update")));
        }
        request = new AuthorizationRequest();
        request.addPermission(null, new String[]{"sensors:view"});
        request.addPermission(null, new String[]{"sensors:update"});
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)2L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertTrue((boolean)resourceIds.containsAll(Arrays.asList(grantedPermission.getResourceId())));
            Assert.assertEquals((long)2L, (long)grantedPermission.getScopes().size());
            Assert.assertTrue((boolean)grantedPermission.getScopes().containsAll(Arrays.asList("sensors:view", "sensors:update")));
        }
    }

    @Test
    public void testObtainAllEntitlementsForScopeWithDeny() throws Exception {
        ClientResource client = this.getClient(this.getRealm(), RESOURCE_SERVER_TEST);
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName(KeycloakModelUtils.generateId());
        policy.setCode("$evaluation.grant();");
        authorization.policies().js().create(policy).close();
        authorization.scopes().create(new ScopeRepresentation("sensors:view")).close();
        ScopePermissionRepresentation permission = new ScopePermissionRepresentation();
        permission.setName(KeycloakModelUtils.generateId());
        permission.addScope(new String[]{"sensors:view"});
        permission.addPolicy(new String[]{policy.getName()});
        authorization.permissions().scope().create(permission).close();
        String accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "kolo", "password").getAccessToken();
        AuthzClient authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission(null, new String[]{"sensors:view"});
        AuthorizationResponse response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        Collection permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertNull((Object)grantedPermission.getResourceId());
            Assert.assertEquals((long)1L, (long)grantedPermission.getScopes().size());
            Assert.assertTrue((boolean)grantedPermission.getScopes().containsAll(Arrays.asList("sensors:view")));
        }
    }

    @Test
    public void testObtainAllEntitlementsForResourceWithResourcePermission() throws Exception {
        ClientResource client = this.getClient(this.getRealm(), RESOURCE_SERVER_TEST);
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName(KeycloakModelUtils.generateId());
        policy.setCode("$evaluation.grant();");
        authorization.policies().js().create(policy).close();
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName(KeycloakModelUtils.generateId());
        resource.addScope(new String[]{"scope:view", "scope:update", "scope:delete"});
        try (Response response = authorization.resources().create(resource);){
            resource = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        }
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName(KeycloakModelUtils.generateId());
        permission.addResource(resource.getId());
        permission.addPolicy(new String[]{policy.getName()});
        authorization.permissions().resource().create(permission).close();
        String accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "kolo", "password").getAccessToken();
        AuthzClient authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission(null, new String[]{"scope:view", "scope:update", "scope:delete"});
        AuthorizationResponse response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        Collection permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((Object)resource.getId(), (Object)grantedPermission.getResourceId());
            Assert.assertEquals((long)3L, (long)grantedPermission.getScopes().size());
            Assert.assertTrue((boolean)grantedPermission.getScopes().containsAll(Arrays.asList("scope:view")));
        }
        resource.setScopes(new HashSet());
        resource.addScope(new String[]{"scope:view", "scope:update"});
        authorization.resources().resource(resource.getId()).update(resource);
        request = new AuthorizationRequest();
        request.addPermission(null, new String[]{"scope:view", "scope:update", "scope:delete"});
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((Object)resource.getId(), (Object)grantedPermission.getResourceId());
            Assert.assertEquals((long)2L, (long)grantedPermission.getScopes().size());
            Assert.assertTrue((boolean)grantedPermission.getScopes().containsAll(Arrays.asList("scope:view", "scope:update")));
        }
        request = new AuthorizationRequest();
        request.addPermission(resource.getId(), new String[]{"scope:view", "scope:update", "scope:delete"});
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((Object)resource.getId(), (Object)grantedPermission.getResourceId());
            Assert.assertEquals((long)2L, (long)grantedPermission.getScopes().size());
            Assert.assertTrue((boolean)grantedPermission.getScopes().containsAll(Arrays.asList("scope:view", "scope:update")));
        }
    }

    @Test
    public void testObtainAllEntitlementsForResourceWithScopePermission() throws Exception {
        ClientResource client = this.getClient(this.getRealm(), RESOURCE_SERVER_TEST);
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName(KeycloakModelUtils.generateId());
        policy.setCode("$evaluation.grant();");
        authorization.policies().js().create(policy).close();
        ResourceRepresentation resourceWithoutType = new ResourceRepresentation();
        resourceWithoutType.setName(KeycloakModelUtils.generateId());
        resourceWithoutType.addScope(new String[]{"scope:view", "scope:update", "scope:delete"});
        try (Response response = authorization.resources().create(resourceWithoutType);){
            resourceWithoutType = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        }
        ResourceRepresentation resourceWithType = new ResourceRepresentation();
        resourceWithType.setName(KeycloakModelUtils.generateId());
        resourceWithType.setType("type-one");
        resourceWithType.addScope(new String[]{"scope:view", "scope:update", "scope:delete"});
        try (Response response = authorization.resources().create(resourceWithType);){
            resourceWithType = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        }
        ScopePermissionRepresentation permission = new ScopePermissionRepresentation();
        permission.setName(KeycloakModelUtils.generateId());
        permission.addResource(resourceWithoutType.getId());
        permission.addScope(new String[]{"scope:view"});
        permission.addPolicy(new String[]{policy.getName()});
        authorization.permissions().scope().create(permission).close();
        permission = new ScopePermissionRepresentation();
        permission.setName(KeycloakModelUtils.generateId());
        permission.setResourceType("type-one");
        permission.addScope(new String[]{"scope:update"});
        permission.addPolicy(new String[]{policy.getName()});
        authorization.permissions().scope().create(permission).close();
        String accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "kolo", "password").getAccessToken();
        AuthzClient authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission(resourceWithoutType.getId(), new String[]{"scope:view", "scope:update", "scope:delete"});
        AuthorizationResponse response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        Collection permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((Object)resourceWithoutType.getId(), (Object)grantedPermission.getResourceId());
            Assert.assertEquals((long)1L, (long)grantedPermission.getScopes().size());
            Assert.assertTrue((boolean)grantedPermission.getScopes().containsAll(Arrays.asList("scope:view")));
        }
        request = new AuthorizationRequest();
        request.addPermission(resourceWithType.getId(), new String[]{"scope:view", "scope:update", "scope:delete"});
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((Object)resourceWithType.getId(), (Object)grantedPermission.getResourceId());
            Assert.assertEquals((long)1L, (long)grantedPermission.getScopes().size());
            Assert.assertTrue((boolean)grantedPermission.getScopes().containsAll(Arrays.asList("scope:update")));
        }
    }

    @Test
    public void testServerDecisionStrategy() throws Exception {
        ClientResource client = this.getClient(this.getRealm(), RESOURCE_SERVER_TEST);
        AuthorizationResource authorization = client.authorization();
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName(KeycloakModelUtils.generateId());
        resource.addScope(new String[]{"read", "write", "delete"});
        try (Response response = authorization.resources().create(resource);){
            resource = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        }
        JSPolicyRepresentation grantPolicy = new JSPolicyRepresentation();
        grantPolicy.setName(KeycloakModelUtils.generateId());
        grantPolicy.setCode("$evaluation.grant();");
        authorization.policies().js().create(grantPolicy).close();
        JSPolicyRepresentation denyPolicy = new JSPolicyRepresentation();
        denyPolicy.setName(KeycloakModelUtils.generateId());
        denyPolicy.setCode("$evaluation.deny();");
        authorization.policies().js().create(denyPolicy).close();
        ResourcePermissionRepresentation resourcePermission = new ResourcePermissionRepresentation();
        resourcePermission.setName(KeycloakModelUtils.generateId());
        resourcePermission.addResource(resource.getId());
        resourcePermission.addPolicy(new String[]{denyPolicy.getName()});
        authorization.permissions().resource().create(resourcePermission).close();
        ScopePermissionRepresentation scopePermission1 = new ScopePermissionRepresentation();
        scopePermission1.setName(KeycloakModelUtils.generateId());
        scopePermission1.addScope(new String[]{"read"});
        scopePermission1.addPolicy(new String[]{grantPolicy.getName()});
        ScopePermissionsResource scopePermissions = authorization.permissions().scope();
        scopePermissions.create(scopePermission1).close();
        String accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "kolo", "password").getAccessToken();
        AuthzClient authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission(resource.getName(), new String[0]);
        try {
            authzClient.authorization(accessToken).authorize(request);
            Assert.fail((String)"kolo can not access the resource");
        }
        catch (RuntimeException expected) {
            Assert.assertEquals((long)403L, (long)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).getStatusCode());
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).toString().contains("access_denied"));
        }
        ResourceServerRepresentation settings = authorization.getSettings();
        settings.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        authorization.update(settings);
        this.assertPermissions(authzClient, accessToken, request, resource, "read");
        scopePermission1 = scopePermissions.findByName(scopePermission1.getName());
        scopePermission1.addScope(new String[]{"read", "delete"});
        scopePermissions.findById(scopePermission1.getId()).update(scopePermission1);
        this.assertPermissions(authzClient, accessToken, request, resource, "read", "delete");
        ScopePermissionRepresentation scopePermission2 = new ScopePermissionRepresentation();
        scopePermission2.setName(KeycloakModelUtils.generateId());
        scopePermission2.addScope(new String[]{"write"});
        scopePermission2.addPolicy(new String[]{grantPolicy.getName()});
        scopePermissions.create(scopePermission2).close();
        this.assertPermissions(authzClient, accessToken, request, resource, "read", "delete", "write");
        ScopePermissionRepresentation scopePermission3 = new ScopePermissionRepresentation();
        scopePermission3.setName(KeycloakModelUtils.generateId());
        scopePermission3.addResource(resource.getId());
        scopePermission3.addScope(new String[]{"write", "read", "delete"});
        scopePermission3.addPolicy(new String[]{grantPolicy.getName()});
        scopePermissions.create(scopePermission3).close();
        this.assertPermissions(authzClient, accessToken, request, resource, "read", "delete", "write");
        scopePermission2 = scopePermissions.findByName(scopePermission2.getName());
        scopePermissions.findById(scopePermission2.getId()).remove();
        this.assertPermissions(authzClient, accessToken, request, resource, "read", "delete", "write");
        scopePermission1 = scopePermissions.findByName(scopePermission1.getName());
        scopePermissions.findById(scopePermission1.getId()).remove();
        this.assertPermissions(authzClient, accessToken, request, resource, "read", "delete", "write");
        scopePermission3 = scopePermissions.findByName(scopePermission3.getName());
        scopePermission3.addScope(new String[]{"write", "delete"});
        scopePermissions.findById(scopePermission3.getId()).update(scopePermission3);
        this.assertPermissions(authzClient, accessToken, request, resource, "delete", "write");
        scopePermissions.findById(scopePermission3.getId()).remove();
        try {
            authzClient.authorization(accessToken).authorize(request);
            Assert.fail((String)"kolo can not access the resource");
        }
        catch (RuntimeException expected) {
            Assert.assertEquals((long)403L, (long)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).getStatusCode());
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).toString().contains("access_denied"));
        }
        ResourcePermissionRepresentation grantResourcePermission = new ResourcePermissionRepresentation();
        grantResourcePermission.setName(KeycloakModelUtils.generateId());
        grantResourcePermission.addResource(resource.getId());
        grantResourcePermission.addPolicy(new String[]{grantPolicy.getName()});
        authorization.permissions().resource().create(grantResourcePermission).close();
        this.assertPermissions(authzClient, accessToken, request, resource, "read", "delete", "write");
        settings.setDecisionStrategy(DecisionStrategy.UNANIMOUS);
        authorization.update(settings);
        try {
            authzClient.authorization(accessToken).authorize(request);
            Assert.fail((String)"kolo can not access the resource");
        }
        catch (RuntimeException expected) {
            Assert.assertEquals((long)403L, (long)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).getStatusCode());
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).toString().contains("access_denied"));
        }
    }

    @Test
    public void testObtainAllEntitlementsForResourceType() throws Exception {
        ResourceRepresentation resource;
        int i;
        ClientResource client = this.getClient(this.getRealm(), RESOURCE_SERVER_TEST);
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName(KeycloakModelUtils.generateId());
        policy.setCode("$evaluation.grant();");
        authorization.policies().js().create(policy).close();
        for (i = 0; i < 10; ++i) {
            resource = new ResourceRepresentation();
            resource.setType("type-one");
            resource.setName(KeycloakModelUtils.generateId());
            authorization.resources().create(resource).close();
        }
        for (i = 0; i < 10; ++i) {
            resource = new ResourceRepresentation();
            resource.setType("type-two");
            resource.setName(KeycloakModelUtils.generateId());
            authorization.resources().create(resource).close();
        }
        for (i = 0; i < 10; ++i) {
            resource = new ResourceRepresentation();
            resource.setType("type-three");
            resource.setName(KeycloakModelUtils.generateId());
            authorization.resources().create(resource).close();
        }
        for (i = 0; i < 10; ++i) {
            resource = new ResourceRepresentation();
            resource.setType("type-four");
            resource.setName(KeycloakModelUtils.generateId());
            resource.addScope(new String[]{"scope:view", "scope:update"});
            authorization.resources().create(resource).close();
        }
        for (i = 0; i < 10; ++i) {
            resource = new ResourceRepresentation();
            resource.setType("type-five");
            resource.setName(KeycloakModelUtils.generateId());
            resource.addScope(new String[]{"scope:view"});
            authorization.resources().create(resource).close();
        }
        ResourcePermissionRepresentation resourcePermission = new ResourcePermissionRepresentation();
        resourcePermission.setName(KeycloakModelUtils.generateId());
        resourcePermission.setResourceType("type-one");
        resourcePermission.addPolicy(new String[]{policy.getName()});
        authorization.permissions().resource().create(resourcePermission).close();
        resourcePermission = new ResourcePermissionRepresentation();
        resourcePermission.setName(KeycloakModelUtils.generateId());
        resourcePermission.setResourceType("type-two");
        resourcePermission.addPolicy(new String[]{policy.getName()});
        authorization.permissions().resource().create(resourcePermission).close();
        resourcePermission = new ResourcePermissionRepresentation();
        resourcePermission.setName(KeycloakModelUtils.generateId());
        resourcePermission.setResourceType("type-three");
        resourcePermission.addPolicy(new String[]{policy.getName()});
        authorization.permissions().resource().create(resourcePermission).close();
        ScopePermissionRepresentation scopePersmission = new ScopePermissionRepresentation();
        scopePersmission.setName(KeycloakModelUtils.generateId());
        scopePersmission.setResourceType("type-four");
        scopePersmission.addScope(new String[]{"scope:view"});
        scopePersmission.addPolicy(new String[]{policy.getName()});
        authorization.permissions().scope().create(scopePersmission).close();
        String accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "kolo", "password").getAccessToken();
        AuthzClient authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission("resource-type:type-one", new String[0]);
        AuthorizationResponse response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        Collection permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)10L, (long)permissions.size());
        request = new AuthorizationRequest();
        request.addPermission("resource-type:type-three", new String[0]);
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)10L, (long)permissions.size());
        request = new AuthorizationRequest();
        request.addPermission("resource-type:type-four", new String[]{"scope:view"});
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)10L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((long)1L, (long)grantedPermission.getScopes().size());
            Assert.assertTrue((boolean)grantedPermission.getScopes().containsAll(Arrays.asList("scope:view")));
        }
        request = new AuthorizationRequest();
        request.addPermission("resource-type:type-five", new String[]{"scope:view"});
        try {
            authzClient.authorization(accessToken).authorize(request);
            Assert.fail((String)"no type-five resources can be granted since scope permission for scope:view only applies to type-four");
        }
        catch (RuntimeException expected) {
            Assert.assertEquals((long)403L, (long)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).getStatusCode());
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).toString().contains("access_denied"));
        }
        for (int i2 = 0; i2 < 5; ++i2) {
            ResourceRepresentation resource2 = new ResourceRepresentation();
            resource2.setOwner("kolo");
            resource2.setType("type-two");
            resource2.setName(KeycloakModelUtils.generateId());
            authorization.resources().create(resource2).close();
        }
        request = new AuthorizationRequest();
        request.addPermission("resource-type-any:type-two", new String[0]);
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)15L, (long)permissions.size());
        request = new AuthorizationRequest();
        request.addPermission("resource-type-owner:type-two", new String[0]);
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)5L, (long)permissions.size());
        request = new AuthorizationRequest();
        request.addPermission("resource-type-instance:type-two", new String[0]);
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)5L, (long)permissions.size());
        Permission next = (Permission)permissions.iterator().next();
        ResourceResource resourceMgmt = client.authorization().resources().resource(next.getResourceId());
        ResourceRepresentation representation = resourceMgmt.toRepresentation();
        representation.setType("type-three");
        resourceMgmt.update(representation);
        request = new AuthorizationRequest();
        request.addPermission("resource-type-instance:type-two", new String[0]);
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)4L, (long)permissions.size());
        request = new AuthorizationRequest();
        request.addPermission("resource-type-instance:type-three", new String[0]);
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        request = new AuthorizationRequest();
        request.addPermission("resource-type-any:type-three", new String[0]);
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)11L, (long)permissions.size());
        for (int i3 = 0; i3 < 2; ++i3) {
            ResourceRepresentation resource3 = new ResourceRepresentation();
            resource3.setOwner("marta");
            resource3.setType("type-one");
            resource3.setName(KeycloakModelUtils.generateId());
            authorization.resources().create(resource3).close();
        }
        request = new AuthorizationRequest();
        request.addPermission("resource-type:type-one", new String[0]);
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)10L, (long)permissions.size());
        accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "marta", "password").getAccessToken();
        request = new AuthorizationRequest();
        request.addPermission("resource-type-owner:type-one", new String[0]);
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)2L, (long)permissions.size());
        request = new AuthorizationRequest();
        request.addPermission("resource-type-instance:type-one", new String[0]);
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)2L, (long)permissions.size());
        request = new AuthorizationRequest();
        request.addPermission("resource-type-any:type-one", new String[0]);
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)12L, (long)permissions.size());
    }

    @Test
    public void testOverridePermission() throws Exception {
        Set scopes;
        Object scopes2;
        ClientResource client = this.getClient(this.getRealm(), RESOURCE_SERVER_TEST);
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation onlyOwnerPolicy = this.createOnlyOwnerPolicy();
        authorization.policies().js().create(onlyOwnerPolicy).close();
        ResourceRepresentation typedResource = new ResourceRepresentation();
        typedResource.setType("resource");
        typedResource.setName(KeycloakModelUtils.generateId());
        typedResource.addScope(new String[]{"read", "update"});
        try (Response response = authorization.resources().create(typedResource);){
            typedResource = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        }
        ResourcePermissionRepresentation typedResourcePermission = new ResourcePermissionRepresentation();
        typedResourcePermission.setName(KeycloakModelUtils.generateId());
        typedResourcePermission.setResourceType("resource");
        typedResourcePermission.addPolicy(new String[]{onlyOwnerPolicy.getName()});
        try (Response response = authorization.permissions().resource().create(typedResourcePermission);){
            typedResourcePermission = (ResourcePermissionRepresentation)response.readEntity(ResourcePermissionRepresentation.class);
        }
        ResourceRepresentation martaResource = new ResourceRepresentation();
        martaResource.setType("resource");
        martaResource.setName(KeycloakModelUtils.generateId());
        martaResource.addScope(new String[]{"read", "update"});
        martaResource.setOwner("marta");
        try (Response response = authorization.resources().create(martaResource);){
            martaResource = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        }
        String accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "marta", "password").getAccessToken();
        AuthzClient authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission(martaResource.getName(), new String[0]);
        AuthorizationResponse response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        Collection permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((Object)martaResource.getName(), (Object)grantedPermission.getResourceName());
            Set scopes3 = grantedPermission.getScopes();
            Assert.assertEquals((long)2L, (long)scopes3.size());
            Assert.assertThat((Object)scopes3, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"read", "update"}));
        }
        accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "kolo", "password").getAccessToken();
        authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        request = new AuthorizationRequest();
        request.addPermission(martaResource.getId(), new String[0]);
        try {
            authzClient.authorization(accessToken).authorize(request);
            Assert.fail((String)"kolo can not access marta resource");
        }
        catch (RuntimeException expected) {
            Assert.assertEquals((long)403L, (long)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).getStatusCode());
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).toString().contains("access_denied"));
        }
        UserPolicyRepresentation onlyKoloPolicy = new UserPolicyRepresentation();
        onlyKoloPolicy.setName(KeycloakModelUtils.generateId());
        onlyKoloPolicy.addUser("kolo");
        authorization.policies().user().create(onlyKoloPolicy).close();
        ResourcePermissionRepresentation martaResourcePermission = new ResourcePermissionRepresentation();
        martaResourcePermission.setName(KeycloakModelUtils.generateId());
        martaResourcePermission.addResource(martaResource.getId());
        martaResourcePermission.addPolicy(new String[]{onlyKoloPolicy.getName()});
        try (Response response1 = authorization.permissions().resource().create(martaResourcePermission);){
            martaResourcePermission = (ResourcePermissionRepresentation)response1.readEntity(ResourcePermissionRepresentation.class);
        }
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((Object)martaResource.getName(), (Object)grantedPermission.getResourceName());
            scopes2 = grantedPermission.getScopes();
            Assert.assertEquals((long)2L, (long)scopes2.size());
            Assert.assertThat((Object)scopes2, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"read", "update"}));
        }
        typedResourcePermission.setResourceType(null);
        typedResourcePermission.addResource(typedResource.getName());
        authorization.permissions().resource().findById(typedResourcePermission.getId()).update(typedResourcePermission);
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((Object)martaResource.getName(), (Object)grantedPermission.getResourceName());
            scopes2 = grantedPermission.getScopes();
            Assert.assertEquals((long)2L, (long)scopes2.size());
            Assert.assertThat((Object)scopes2, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"read", "update"}));
        }
        ScopePermissionRepresentation martaResourceUpdatePermission = new ScopePermissionRepresentation();
        martaResourceUpdatePermission.setName(KeycloakModelUtils.generateId());
        martaResourceUpdatePermission.addResource(martaResource.getId());
        martaResourceUpdatePermission.addScope(new String[]{"update"});
        martaResourceUpdatePermission.addPolicy(new String[]{onlyOwnerPolicy.getName()});
        Response response1 = authorization.permissions().scope().create(martaResourceUpdatePermission);
        scopes2 = null;
        try {
            martaResourceUpdatePermission = (ScopePermissionRepresentation)response1.readEntity(ScopePermissionRepresentation.class);
        }
        catch (Throwable throwable) {
            scopes2 = throwable;
            throw throwable;
        }
        finally {
            if (response1 != null) {
                if (scopes2 != null) {
                    try {
                        response1.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)scopes2).addSuppressed(throwable);
                    }
                } else {
                    response1.close();
                }
            }
        }
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((Object)martaResource.getName(), (Object)grantedPermission.getResourceName());
            scopes = grantedPermission.getScopes();
            Assert.assertEquals((long)1L, (long)scopes.size());
            Assert.assertThat((Object)scopes, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"read"}));
        }
        authorization.permissions().resource().findById(martaResourcePermission.getId()).remove();
        try {
            authzClient.authorization(accessToken).authorize(request);
            Assert.fail((String)"kolo can not access marta resource");
        }
        catch (RuntimeException expected) {
            Assert.assertEquals((long)403L, (long)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).getStatusCode());
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).toString().contains("access_denied"));
        }
        martaResourceUpdatePermission.addPolicy(new String[]{onlyKoloPolicy.getName()});
        martaResourceUpdatePermission.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        authorization.permissions().scope().findById(martaResourceUpdatePermission.getId()).update(martaResourceUpdatePermission);
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((Object)martaResource.getName(), (Object)grantedPermission.getResourceName());
            scopes = grantedPermission.getScopes();
            Assert.assertEquals((long)1L, (long)scopes.size());
            Assert.assertThat((Object)scopes, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"update"}));
        }
        accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "marta", "password").getAccessToken();
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((Object)martaResource.getName(), (Object)grantedPermission.getResourceName());
            scopes = grantedPermission.getScopes();
            Assert.assertEquals((long)2L, (long)scopes.size());
            Assert.assertThat((Object)scopes, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"update", "read"}));
        }
        authorization.permissions().scope().findById(martaResourceUpdatePermission.getId()).remove();
        accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "kolo", "password").getAccessToken();
        try {
            authzClient.authorization(accessToken).authorize(request);
            Assert.fail((String)"kolo can not access marta resource");
        }
        catch (RuntimeException expected) {
            Assert.assertEquals((long)403L, (long)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).getStatusCode());
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).toString().contains("access_denied"));
        }
    }

    @Test
    public void testOverrideParentScopePermission() throws Exception {
        Set scopes;
        Object scopes2;
        ClientResource client = this.getClient(this.getRealm(), RESOURCE_SERVER_TEST);
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation onlyOwnerPolicy = this.createOnlyOwnerPolicy();
        authorization.policies().js().create(onlyOwnerPolicy).close();
        ResourceRepresentation typedResource = new ResourceRepresentation();
        typedResource.setType("resource");
        typedResource.setName(KeycloakModelUtils.generateId());
        typedResource.addScope(new String[]{"read", "update"});
        try (Response response = authorization.resources().create(typedResource);){
            typedResource = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        }
        ScopePermissionRepresentation typedResourcePermission = new ScopePermissionRepresentation();
        typedResourcePermission.setName(KeycloakModelUtils.generateId());
        typedResourcePermission.addResource(typedResource.getName());
        typedResourcePermission.addPolicy(new String[]{onlyOwnerPolicy.getName()});
        typedResourcePermission.addScope(new String[]{"read", "update"});
        authorization.permissions().scope().create(typedResourcePermission).close();
        ResourceRepresentation martaResource = new ResourceRepresentation();
        martaResource.setType("resource");
        martaResource.setName(KeycloakModelUtils.generateId());
        martaResource.addScope(new String[]{"read"});
        martaResource.setOwner("marta");
        try (Response response = authorization.resources().create(martaResource);){
            martaResource = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        }
        String accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "marta", "password").getAccessToken();
        AuthzClient authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission(martaResource.getName(), new String[0]);
        AuthorizationResponse response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        Collection permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((Object)martaResource.getName(), (Object)grantedPermission.getResourceName());
            Set scopes3 = grantedPermission.getScopes();
            Assert.assertEquals((long)2L, (long)scopes3.size());
            Assert.assertThat((Object)scopes3, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"read", "update"}));
        }
        accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "kolo", "password").getAccessToken();
        authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        request = new AuthorizationRequest();
        request.addPermission(martaResource.getId(), new String[0]);
        try {
            authzClient.authorization(accessToken).authorize(request);
            Assert.fail((String)"kolo can not access marta resource");
        }
        catch (RuntimeException expected) {
            Assert.assertEquals((long)403L, (long)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).getStatusCode());
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).toString().contains("access_denied"));
        }
        UserPolicyRepresentation onlyKoloPolicy = new UserPolicyRepresentation();
        onlyKoloPolicy.setName(KeycloakModelUtils.generateId());
        onlyKoloPolicy.addUser("kolo");
        authorization.policies().user().create(onlyKoloPolicy).close();
        ResourcePermissionRepresentation martaResourcePermission = new ResourcePermissionRepresentation();
        martaResourcePermission.setName(KeycloakModelUtils.generateId());
        martaResourcePermission.addResource(martaResource.getId());
        martaResourcePermission.addPolicy(new String[]{onlyKoloPolicy.getName()});
        try (Response response1 = authorization.permissions().resource().create(martaResourcePermission);){
            martaResourcePermission = (ResourcePermissionRepresentation)response1.readEntity(ResourcePermissionRepresentation.class);
        }
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((Object)martaResource.getName(), (Object)grantedPermission.getResourceName());
            scopes2 = grantedPermission.getScopes();
            Assert.assertEquals((long)2L, (long)scopes2.size());
            Assert.assertThat((Object)scopes2, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"read", "update"}));
        }
        ScopePermissionRepresentation martaResourceUpdatePermission = new ScopePermissionRepresentation();
        martaResourceUpdatePermission.setName(KeycloakModelUtils.generateId());
        martaResourceUpdatePermission.addResource(martaResource.getId());
        martaResourceUpdatePermission.addScope(new String[]{"update"});
        martaResourceUpdatePermission.addPolicy(new String[]{onlyOwnerPolicy.getName()});
        Response response1 = authorization.permissions().scope().create(martaResourceUpdatePermission);
        scopes2 = null;
        try {
            martaResourceUpdatePermission = (ScopePermissionRepresentation)response1.readEntity(ScopePermissionRepresentation.class);
        }
        catch (Throwable throwable) {
            scopes2 = throwable;
            throw throwable;
        }
        finally {
            if (response1 != null) {
                if (scopes2 != null) {
                    try {
                        response1.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)scopes2).addSuppressed(throwable);
                    }
                } else {
                    response1.close();
                }
            }
        }
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((Object)martaResource.getName(), (Object)grantedPermission.getResourceName());
            scopes = grantedPermission.getScopes();
            Assert.assertEquals((long)1L, (long)scopes.size());
            Assert.assertThat((Object)scopes, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"read"}));
        }
        authorization.permissions().resource().findById(martaResourcePermission.getId()).remove();
        try {
            authzClient.authorization(accessToken).authorize(request);
            Assert.fail((String)"kolo can not access marta resource");
        }
        catch (RuntimeException expected) {
            Assert.assertEquals((long)403L, (long)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).getStatusCode());
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).toString().contains("access_denied"));
        }
        martaResourceUpdatePermission.addPolicy(new String[]{onlyKoloPolicy.getName()});
        martaResourceUpdatePermission.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        authorization.permissions().scope().findById(martaResourceUpdatePermission.getId()).update(martaResourceUpdatePermission);
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((Object)martaResource.getName(), (Object)grantedPermission.getResourceName());
            scopes = grantedPermission.getScopes();
            Assert.assertEquals((long)1L, (long)scopes.size());
            Assert.assertThat((Object)scopes, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"update"}));
        }
        accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "marta", "password").getAccessToken();
        response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((Object)martaResource.getName(), (Object)grantedPermission.getResourceName());
            scopes = grantedPermission.getScopes();
            Assert.assertEquals((long)2L, (long)scopes.size());
            Assert.assertThat((Object)scopes, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"update", "read"}));
        }
        authorization.permissions().scope().findById(martaResourceUpdatePermission.getId()).remove();
        accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "kolo", "password").getAccessToken();
        try {
            authzClient.authorization(accessToken).authorize(request);
            Assert.fail((String)"kolo can not access marta resource");
        }
        catch (RuntimeException expected) {
            Assert.assertEquals((long)403L, (long)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).getStatusCode());
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(expected.getCause())).toString().contains("access_denied"));
        }
    }

    @NotNull
    private JSPolicyRepresentation createOnlyOwnerPolicy() {
        JSPolicyRepresentation onlyOwnerPolicy = new JSPolicyRepresentation();
        onlyOwnerPolicy.setName(KeycloakModelUtils.generateId());
        onlyOwnerPolicy.setCode("var context = $evaluation.getContext();\nvar identity = context.getIdentity();\nvar permission = $evaluation.getPermission();\nvar resource = permission.getResource();\n\nif (resource) {\n    if (resource.owner == identity.id) {\n        $evaluation.grant();\n    }\n}");
        return onlyOwnerPolicy;
    }

    @Test
    public void testPermissionsWithResourceAttributes() throws Exception {
        ClientResource client = this.getClient(this.getRealm(), RESOURCE_SERVER_TEST);
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation onlyPublicResourcesPolicy = new JSPolicyRepresentation();
        onlyPublicResourcesPolicy.setName(KeycloakModelUtils.generateId());
        onlyPublicResourcesPolicy.setCode("var createPermission = $evaluation.getPermission();\nvar resource = createPermission.getResource();\n\nif (resource) {\n    var attributes = resource.getAttributes();\n    var visibility = attributes.get('visibility');\n    \n    if (visibility && \"private\".equals(visibility.get(0))) {\n        $evaluation.deny();\n      } else {\n        $evaluation.grant();\n    }\n}");
        authorization.policies().js().create(onlyPublicResourcesPolicy).close();
        JSPolicyRepresentation onlyOwnerPolicy = this.createOnlyOwnerPolicy();
        authorization.policies().js().create(onlyOwnerPolicy).close();
        ResourceRepresentation typedResource = new ResourceRepresentation();
        typedResource.setType("resource");
        typedResource.setName(KeycloakModelUtils.generateId());
        try (Response response = authorization.resources().create(typedResource);){
            typedResource = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        }
        ResourceRepresentation userResource = new ResourceRepresentation();
        userResource.setName(KeycloakModelUtils.generateId());
        userResource.setType("resource");
        userResource.setOwner("marta");
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        attributes.put("visibility", Arrays.asList("private"));
        userResource.setAttributes(attributes);
        try (Response response = authorization.resources().create(userResource);){
            userResource = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        }
        ResourcePermissionRepresentation typedResourcePermission = new ResourcePermissionRepresentation();
        typedResourcePermission.setName(KeycloakModelUtils.generateId());
        typedResourcePermission.setResourceType("resource");
        typedResourcePermission.addPolicy(new String[]{onlyPublicResourcesPolicy.getName()});
        try (Response response = authorization.permissions().resource().create(typedResourcePermission);){
            typedResourcePermission = (ResourcePermissionRepresentation)response.readEntity(ResourcePermissionRepresentation.class);
        }
        AuthzClient authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission(typedResource.getId(), new String[0]);
        request.addPermission(userResource.getId(), new String[0]);
        AuthorizationResponse response = authzClient.authorization("marta", "password").authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        Collection permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((Object)typedResource.getName(), (Object)grantedPermission.getResourceName());
        }
        typedResourcePermission.addPolicy(new String[]{onlyOwnerPolicy.getName()});
        typedResourcePermission.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        authorization.permissions().resource().findById(typedResourcePermission.getId()).update(typedResourcePermission);
        response = authzClient.authorization("marta", "password").authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)2L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertThat(Arrays.asList(typedResource.getName(), userResource.getName()), (Matcher)Matchers.hasItem((Object)grantedPermission.getResourceName()));
        }
        typedResource.setAttributes(attributes);
        authorization.resources().resource(typedResource.getId()).update(typedResource);
        response = authzClient.authorization("marta", "password").authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertThat((Object)userResource.getName(), (Matcher)Matchers.equalTo((Object)grantedPermission.getResourceName()));
        }
        userResource.addScope(new String[]{"create", "read"});
        authorization.resources().resource(userResource.getId()).update(userResource);
        typedResource.addScope(new String[]{"create", "read"});
        authorization.resources().resource(typedResource.getId()).update(typedResource);
        ScopePermissionRepresentation createPermission = new ScopePermissionRepresentation();
        createPermission.setName(KeycloakModelUtils.generateId());
        createPermission.addScope(new String[]{"create"});
        createPermission.addPolicy(new String[]{onlyPublicResourcesPolicy.getName()});
        authorization.permissions().scope().create(createPermission).close();
        response = authzClient.authorization("marta", "password").authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertThat((Object)userResource.getName(), (Matcher)Matchers.equalTo((Object)grantedPermission.getResourceName()));
            Assert.assertThat((Object)grantedPermission.getScopes(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"create")));
        }
        typedResource.setAttributes(new HashMap());
        authorization.resources().resource(typedResource.getId()).update(typedResource);
        response = authzClient.authorization("marta", "password").authorize();
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        for (Permission grantedPermission : permissions) {
            if (grantedPermission.getResourceName().equals(userResource.getName())) {
                Assert.assertThat((Object)grantedPermission.getScopes(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"create")));
                continue;
            }
            if (!grantedPermission.getResourceName().equals(typedResource.getName())) continue;
            Assert.assertThat((Object)grantedPermission.getScopes(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"create", "read"}));
        }
        request = new AuthorizationRequest();
        request.addPermission(typedResource.getId(), new String[0]);
        request.addPermission(userResource.getId(), new String[0]);
        response = authzClient.authorization("marta", "password").authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        for (Permission grantedPermission : permissions) {
            if (grantedPermission.getResourceName().equals(userResource.getName())) {
                Assert.assertThat((Object)grantedPermission.getScopes(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"create")));
                continue;
            }
            if (!grantedPermission.getResourceName().equals(typedResource.getName())) continue;
            Assert.assertThat((Object)grantedPermission.getScopes(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"create", "read"}));
        }
        request = new AuthorizationRequest();
        request.addPermission(userResource.getId(), new String[0]);
        request.addPermission(typedResource.getId(), new String[0]);
        response = authzClient.authorization("marta", "password").authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        for (Permission grantedPermission : permissions) {
            if (grantedPermission.getResourceName().equals(userResource.getName())) {
                Assert.assertThat((Object)grantedPermission.getScopes(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"create")));
                continue;
            }
            if (!grantedPermission.getResourceName().equals(typedResource.getName())) continue;
            Assert.assertThat((Object)grantedPermission.getScopes(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"create", "read"}));
        }
    }

    @Test
    public void testOfflineRequestingPartyToken() throws Exception {
        ClientResource client = this.getClient(this.getRealm(), RESOURCE_SERVER_TEST);
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName(KeycloakModelUtils.generateId());
        policy.setCode("$evaluation.grant();");
        authorization.policies().js().create(policy).close();
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName("Sensors");
        resource.addScope(new String[]{"sensors:view", "sensors:update", "sensors:delete"});
        try (Response response = authorization.resources().create(resource);){
            resource = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        }
        ScopePermissionRepresentation permission = new ScopePermissionRepresentation();
        permission.setName("View Sensor");
        permission.addScope(new String[]{"sensors:view"});
        permission.addPolicy(new String[]{policy.getName()});
        authorization.permissions().scope().create(permission).close();
        String accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).scope("offline_access").doGrantAccessTokenRequest("secret", "offlineuser", "password").getAccessToken();
        AuthzClient authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        AuthorizationResponse response = authzClient.authorization(accessToken).authorize();
        Assert.assertNotNull((Object)response.getToken());
        this.controller.stop(this.suiteContext.getAuthServerInfo().getQualifier());
        this.controller.start(this.suiteContext.getAuthServerInfo().getQualifier());
        this.reconnectAdminClient();
        this.configureSectorIdentifierRedirectUris();
        TokenIntrospectionResponse introspectionResponse = authzClient.protection().introspectRequestingPartyToken(response.getToken());
        Assert.assertTrue((boolean)introspectionResponse.getActive());
        Assert.assertFalse((boolean)introspectionResponse.getPermissions().isEmpty());
        response = authzClient.authorization(accessToken).authorize();
        Assert.assertNotNull((Object)response.getToken());
    }

    @Test
    public void testProcessMappersForTargetAudience() throws Exception {
        ClientResource publicClient = this.getClient(this.getRealm(), PUBLIC_TEST_CLIENT);
        ProtocolMapperRepresentation customClaimMapper = new ProtocolMapperRepresentation();
        customClaimMapper.setName("custom_claim");
        customClaimMapper.setProtocolMapper("oidc-hardcoded-claim-mapper");
        customClaimMapper.setProtocol("openid-connect");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("claim.name", "custom_claim");
        config.put("claim.value", PUBLIC_TEST_CLIENT);
        config.put("access.token.claim", "true");
        customClaimMapper.setConfig(config);
        publicClient.getProtocolMappers().createMapper(customClaimMapper);
        ClientResource client = this.getClient(this.getRealm(), RESOURCE_SERVER_TEST);
        config.put("claim.value", RESOURCE_SERVER_TEST);
        client.getProtocolMappers().createMapper(customClaimMapper);
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName(KeycloakModelUtils.generateId());
        policy.setCode("$evaluation.grant();");
        authorization.policies().js().create(policy).close();
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName("Sensors");
        try (Response response = authorization.resources().create(resource);){
            resource = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        }
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName("View Sensor");
        permission.addResource(resource.getName());
        permission.addPolicy(new String[]{policy.getName()});
        authorization.permissions().resource().create(permission).close();
        this.oauth.realm("authz-test");
        this.oauth.clientId(PUBLIC_TEST_CLIENT);
        this.oauth.doLogin("marta", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, null);
        AccessToken token = this.toAccessToken(response.getAccessToken());
        Assert.assertEquals((Object)PUBLIC_TEST_CLIENT, token.getOtherClaims().get("custom_claim"));
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission("Sensors", new String[0]);
        AuthorizationResponse authorizationResponse = this.getAuthzClient(AUTHZ_CLIENT_CONFIG).authorization(response.getAccessToken()).authorize(request);
        token = this.toAccessToken(authorizationResponse.getToken());
        Assert.assertEquals((Object)RESOURCE_SERVER_TEST, token.getOtherClaims().get("custom_claim"));
        Assert.assertEquals((Object)PUBLIC_TEST_CLIENT, (Object)token.getIssuedFor());
        authorizationResponse = this.getAuthzClient(AUTHZ_CLIENT_CONFIG).authorization(response.getAccessToken()).authorize(request);
        token = this.toAccessToken(authorizationResponse.getToken());
        Assert.assertEquals((Object)RESOURCE_SERVER_TEST, token.getOtherClaims().get("custom_claim"));
        Assert.assertEquals((Object)PUBLIC_TEST_CLIENT, (Object)token.getIssuedFor());
    }

    @Test
    public void testUsingExpiredToken() throws Exception {
        ClientResource client = this.getClient(this.getRealm(), RESOURCE_SERVER_TEST);
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName(KeycloakModelUtils.generateId());
        policy.setCode("$evaluation.grant();");
        authorization.policies().js().create(policy).close();
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName("Sensors");
        try (Response response = authorization.resources().create(resource);){
            resource = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        }
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName("View Sensor");
        permission.addPolicy(new String[]{policy.getName()});
        authorization.permissions().resource().create(permission).close();
        String accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "marta", "password").getAccessToken();
        AuthzClient authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        AuthorizationResponse response = authzClient.authorization(accessToken).authorize();
        Assert.assertNotNull((Object)response.getToken());
        this.getRealm().logoutAll();
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission("Sensors", new String[0]);
        request.setSubjectToken(accessToken);
        try {
            authzClient.authorization().authorize(request);
            Assert.fail((String)"should fail, session invalidated");
        }
        catch (Exception e) {
            Throwable expected = e.getCause();
            Assert.assertEquals((long)400L, (long)((HttpResponseException)HttpResponseException.class.cast(expected)).getStatusCode());
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(expected)).toString().contains("unauthorized_client"));
        }
    }

    @Test
    public void testInvalidTokenSignature() throws Exception {
        RealmEventsConfigRepresentation eventConfig = this.getRealm().getRealmEventsConfig();
        eventConfig.setEventsEnabled(true);
        eventConfig.setEnabledEventTypes(Arrays.asList(EventType.PERMISSION_TOKEN_ERROR.name()));
        this.getRealm().updateRealmEventsConfig(eventConfig);
        ClientResource client = this.getClient(this.getRealm(), RESOURCE_SERVER_TEST);
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName(KeycloakModelUtils.generateId());
        policy.setCode("$evaluation.grant();");
        authorization.policies().js().create(policy).close();
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName("Sensors");
        try (Response response = authorization.resources().create(resource);){
            response.readEntity(ResourceRepresentation.class);
        }
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName("View Sensor");
        permission.addPolicy(new String[]{policy.getName()});
        authorization.permissions().resource().create(permission).close();
        String accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "marta", "password").getAccessToken();
        AuthzClient authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission("Sensors", new String[0]);
        request.setSubjectToken(accessToken + "i");
        try {
            authzClient.authorization().authorize(request);
            Assert.fail((String)"should fail, session invalidated");
        }
        catch (Exception e) {
            Throwable expected = e.getCause();
            Assert.assertEquals((long)400L, (long)((HttpResponseException)HttpResponseException.class.cast(expected)).getStatusCode());
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(expected)).toString().contains("unauthorized_client"));
        }
        List events = this.getRealm().getEvents(Arrays.asList(EventType.PERMISSION_TOKEN_ERROR.name()), null, null, null, null, null, null, null);
        Assert.assertEquals((long)1L, (long)events.size());
    }

    @Test
    public void testDenyScopeNotManagedByScopePolicy() throws Exception {
        ClientResource client = this.getClient(this.getRealm(), RESOURCE_SERVER_TEST);
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName(KeycloakModelUtils.generateId());
        policy.setCode("$evaluation.grant();");
        authorization.policies().js().create(policy).close();
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName(KeycloakModelUtils.generateId());
        resource.addScope(new String[]{"sensors:view", "sensors:update", "sensors:delete"});
        try (Response response = authorization.resources().create(resource);){
            resource = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        }
        ScopePermissionRepresentation permission = new ScopePermissionRepresentation();
        permission.setName(KeycloakModelUtils.generateId());
        permission.addResource(resource.getId());
        permission.addScope(new String[]{"sensors:view"});
        permission.addPolicy(new String[]{policy.getName()});
        authorization.permissions().scope().create(permission).close();
        String accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", "kolo", "password").getAccessToken();
        AuthzClient authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission(resource.getId(), new String[]{"sensors:view"});
        AuthorizationResponse response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        Collection permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((Object)resource.getId(), (Object)grantedPermission.getResourceId());
            Assert.assertEquals((long)1L, (long)grantedPermission.getScopes().size());
            Assert.assertThat((Object)grantedPermission.getScopes(), (Matcher)CoreMatchers.hasItem((Object)"sensors:view"));
        }
        request = new AuthorizationRequest();
        request.addPermission(resource.getId(), new String[]{"sensors:update"});
        this.expectedException.expect(AuthorizationDeniedException.class);
        this.expectedException.expectCause(Matchers.allOf((Matcher)Matchers.instanceOf(HttpResponseException.class), (Matcher)Matchers.hasProperty((String)"statusCode", (Matcher)Matchers.is((Object)403))));
        this.expectedException.reportMissingExceptionWithMessage("should fail, session invalidated");
        authzClient.authorization().authorize(request);
    }

    @Test
    public void testPermissionsAcrossResourceServers() throws Exception {
        String rsBId;
        try (Response response = this.getRealm().clients().create(ClientBuilder.create().clientId("rs-a").secret("secret").serviceAccount().authorizationServicesEnabled(true).build());){
            String rsAId = ApiUtil.getCreatedId((Response)response);
        }
        try (Response response = this.getRealm().clients().create(ClientBuilder.create().clientId("rs-b").secret("secret").serviceAccount().authorizationServicesEnabled(true).build());){
            rsBId = ApiUtil.getCreatedId((Response)response);
        }
        ClientResource rsB = this.getRealm().clients().get(rsBId);
        rsB.authorization().resources().create(new ResourceRepresentation("Resource A", new String[0]));
        JSPolicyRepresentation grantPolicy = new JSPolicyRepresentation();
        grantPolicy.setName("Grant Policy");
        grantPolicy.setCode("$evaluation.grant();");
        rsB.authorization().policies().js().create(grantPolicy);
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName("Resource A Permission");
        permission.addResource("Resource A");
        permission.addPolicy(new String[]{grantPolicy.getName()});
        rsB.authorization().permissions().resource().create(permission);
        AuthzClient authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        Configuration config = authzClient.getConfiguration();
        config.setResource("rs-a");
        authzClient = AuthzClient.create((Configuration)config);
        AccessTokenResponse accessTokenResponse = authzClient.obtainAccessToken();
        AccessToken accessToken = this.toAccessToken(accessTokenResponse.getToken());
        config.setResource("rs-b");
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission("Resource A", new String[0]);
        AuthorizationResponse response = authzClient.authorization(accessTokenResponse.getToken()).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        Collection permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        Assert.assertEquals((Object)"Resource A", (Object)((Permission)permissions.iterator().next()).getResourceName());
    }

    @Test
    public void testClientToClientPermissionRequest() throws Exception {
        ClientResource client = this.getClient(this.getRealm(), RESOURCE_SERVER_TEST);
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName(KeycloakModelUtils.generateId());
        policy.setCode("$evaluation.grant();");
        authorization.policies().js().create(policy).close();
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName("Sensors");
        try (Response response = authorization.resources().create(resource);){
            response.readEntity(ResourceRepresentation.class);
        }
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName("View Sensor");
        permission.addPolicy(new String[]{policy.getName()});
        authorization.permissions().resource().create(permission).close();
        ClientRepresentation otherClient = new ClientRepresentation();
        otherClient.setClientId("serviceB");
        otherClient.setServiceAccountsEnabled(Boolean.valueOf(true));
        otherClient.setSecret("secret");
        otherClient.setPublicClient(Boolean.valueOf(false));
        this.getRealm().clients().create(otherClient);
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("secret", "secret");
        AuthzClient authzClient = AuthzClient.create((Configuration)new Configuration(this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth", this.getRealm().toRepresentation().getRealm(), otherClient.getClientId(), credentials, this.getAuthzClient(AUTHZ_CLIENT_CONFIG).getConfiguration().getHttpClient()));
        AuthorizationRequest request = new AuthorizationRequest();
        request.setAudience(RESOURCE_SERVER_TEST);
        AuthorizationResponse response = authzClient.authorization().authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        Assert.assertNull((Object)response.getRefreshToken());
    }

    @Test
    public void testPermissionOrder() throws Exception {
        ClientResource client = this.getClient(this.getRealm(), RESOURCE_SERVER_TEST);
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName(KeycloakModelUtils.generateId());
        policy.setCode("$evaluation.grant();");
        authorization.policies().js().create(policy).close();
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName("my_resource");
        resource.addScope(new String[]{"entity:read"});
        try (Response response = authorization.resources().create(resource);){
            resource = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        }
        ScopeRepresentation featureAccessScope = new ScopeRepresentation("feature:access");
        authorization.scopes().create(featureAccessScope);
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName(KeycloakModelUtils.generateId());
        permission.addPolicy(new String[]{policy.getName()});
        permission.addResource(resource.getId());
        authorization.permissions().resource().create(permission).close();
        ScopePermissionRepresentation scopePermission = new ScopePermissionRepresentation();
        scopePermission.setName(KeycloakModelUtils.generateId());
        scopePermission.addPolicy(new String[]{policy.getName()});
        scopePermission.addScope(new String[]{featureAccessScope.getName()});
        authorization.permissions().scope().create(scopePermission).close();
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission(null, new String[]{"entity:read"});
        request.addPermission(null, new String[]{"feature:access"});
        AuthzClient authzClient = this.getAuthzClient(AUTHZ_CLIENT_CONFIG);
        AuthorizationResponse response = authzClient.authorization().authorize(request);
        AccessToken token = this.toAccessToken(response.getToken());
        AccessToken.Authorization result = token.getAuthorization();
        Assert.assertEquals((long)2L, (long)result.getPermissions().size());
        Assert.assertTrue((boolean)result.getPermissions().stream().anyMatch(p -> p.getResourceId() == null && p.getScopes().contains(featureAccessScope.getName())));
        String resourceId = resource.getId();
        Assert.assertTrue((boolean)result.getPermissions().stream().anyMatch(p -> p.getResourceId() != null && p.getResourceId().equals(resourceId) && p.getScopes().contains("entity:read")));
        request = new AuthorizationRequest();
        request.addPermission(null, new String[]{"feature:access"});
        request.addPermission(null, new String[]{"entity:read"});
        response = authzClient.authorization().authorize(request);
        token = this.toAccessToken(response.getToken());
        result = token.getAuthorization();
        Assert.assertEquals((long)2L, (long)result.getPermissions().size());
        Assert.assertTrue((boolean)result.getPermissions().stream().anyMatch(p -> p.getResourceId() == null && p.getScopes().contains(featureAccessScope.getName())));
        Assert.assertTrue((boolean)result.getPermissions().stream().anyMatch(p -> p.getResourceId() != null && p.getResourceId().equals(resourceId) && p.getScopes().contains("entity:read")));
    }

    private void testRptRequestWithResourceName(String configFile) {
        AuthorizationRequest.Metadata metadata = new AuthorizationRequest.Metadata();
        metadata.setIncludeResourceName(Boolean.valueOf(true));
        this.assertResponse(metadata, () -> this.getAuthzClient(configFile).authorization("marta", "password").authorize());
        AuthorizationRequest request = new AuthorizationRequest();
        request.setMetadata(metadata);
        request.addPermission("Resource 13", new String[0]);
        this.assertResponse(metadata, () -> this.getAuthzClient(configFile).authorization("marta", "password").authorize(request));
        request.setMetadata(null);
        this.assertResponse(metadata, () -> this.getAuthzClient(configFile).authorization("marta", "password").authorize(request));
    }

    private void testResourceServerAsAudience(String testClientId, String resourceServerClientId, String configFile) throws Exception {
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission("Resource 1", new String[0]);
        String accessToken = new OAuthClient().realm("authz-test").clientId(testClientId).doGrantAccessTokenRequest("secret", "marta", "password").getAccessToken();
        AuthorizationResponse response = this.getAuthzClient(configFile).authorization(accessToken).authorize(request);
        AccessToken rpt = this.toAccessToken(response.getToken());
        Assert.assertEquals((Object)resourceServerClientId, (Object)rpt.getAudience()[0]);
    }

    private boolean hasPermission(String userName, String password, String resourceId, String ... scopeIds) throws Exception {
        String accessToken = new OAuthClient().realm("authz-test").clientId(RESOURCE_SERVER_TEST).doGrantAccessTokenRequest("secret", userName, password).getAccessToken();
        AuthorizationResponse response = this.getAuthzClient(AUTHZ_CLIENT_CONFIG).authorization(accessToken).authorize(new AuthorizationRequest());
        AccessToken rpt = this.toAccessToken(response.getToken());
        AccessToken.Authorization authz = rpt.getAuthorization();
        Collection permissions = authz.getPermissions();
        Assert.assertNotNull((Object)permissions);
        Assert.assertFalse((boolean)permissions.isEmpty());
        for (Permission grantedPermission : permissions) {
            if (!grantedPermission.getResourceId().equals(resourceId)) continue;
            return scopeIds == null || scopeIds.length == 0 || grantedPermission.getScopes().containsAll(Arrays.asList(scopeIds));
        }
        return false;
    }

    private boolean hasPermission(String userName, String password, String resourceId) throws Exception {
        return this.hasPermission(userName, password, resourceId, null);
    }

    private void assertResponse(AuthorizationRequest.Metadata metadata, Supplier<AuthorizationResponse> responseSupplier) {
        AccessToken.Authorization authorization = this.toAccessToken(responseSupplier.get().getToken()).getAuthorization();
        Collection permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        Assert.assertFalse((boolean)permissions.isEmpty());
        for (Permission permission : permissions) {
            if (metadata.getIncludeResourceName().booleanValue()) {
                Assert.assertNotNull((Object)permission.getResourceName());
                continue;
            }
            Assert.assertNull((Object)permission.getResourceName());
        }
    }

    private RealmResource getRealm() throws Exception {
        return this.adminClient.realm("authz-test");
    }

    private ClientResource getClient(RealmResource realm, String clientId) {
        ClientsResource clients = realm.clients();
        return clients.findByClientId(clientId).stream().map(representation -> clients.get(representation.getId())).findFirst().orElseThrow(() -> new RuntimeException("Expected client [resource-server-test]"));
    }

    private AuthzClient getAuthzClient(String configFile) {
        if (this.authzClient == null) {
            Configuration configuration;
            try {
                configuration = (Configuration)JsonSerialization.readValue((InputStream)EntitlementAPITest.httpsAwareConfigurationStream(this.getClass().getResourceAsStream("/authorization-test/" + configFile)), Configuration.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read configuration", e);
            }
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setValidateAfterInactivity(10);
            connectionManager.setMaxTotal(10);
            CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
            this.authzClient = AuthzClient.create((Configuration)new Configuration(configuration.getAuthServerUrl(), configuration.getRealm(), configuration.getResource(), configuration.getCredentials(), (HttpClient)client));
        }
        return this.authzClient;
    }

    private void configureAuthorization(String clientId) throws Exception {
        ClientResource client = this.getClient(this.getRealm(), clientId);
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName("Default Policy");
        policy.setCode("$evaluation.grant();");
        authorization.policies().js().create(policy).close();
        for (int i = 1; i <= 20; ++i) {
            ResourceRepresentation resource = new ResourceRepresentation("Resource " + i, new String[0]);
            authorization.resources().create(resource).close();
            ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
            permission.setName(resource.getName() + " Permission");
            permission.addResource(resource.getName());
            permission.addPolicy(new String[]{policy.getName()});
            authorization.permissions().resource().create(permission).close();
        }
    }

    private void removeAuthorization(String clientId) throws Exception {
        ClientResource client = this.getClient(this.getRealm(), clientId);
        ClientRepresentation representation = client.toRepresentation();
        representation.setAuthorizationServicesEnabled(Boolean.valueOf(false));
        client.update(representation);
        representation.setAuthorizationServicesEnabled(Boolean.valueOf(true));
        client.update(representation);
    }

    private void assertPermissions(AuthzClient authzClient, String accessToken, AuthorizationRequest request, ResourceRepresentation resource, String ... expectedScopes) {
        AuthorizationResponse response = authzClient.authorization(accessToken).authorize(request);
        Assert.assertNotNull((Object)response.getToken());
        Collection permissions = this.toAccessToken(response.getToken()).getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        for (Permission grantedPermission : permissions) {
            Assert.assertEquals((Object)resource.getId(), (Object)grantedPermission.getResourceId());
            Assert.assertEquals((long)expectedScopes.length, (long)grantedPermission.getScopes().size());
            Assert.assertTrue((boolean)grantedPermission.getScopes().containsAll(Arrays.asList(expectedScopes)));
        }
    }
}

