/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.PolicyEnforcementMode;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.authz.AbstractAuthzTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.util.JsonSerialization;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ConflictingScopePermissionTest
extends AbstractAuthzTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(RealmBuilder.create().name("authz-test").user(UserBuilder.create().username("marta").password("password")).user(UserBuilder.create().username("kolo").password("password")).client(ClientBuilder.create().clientId("resource-server-test").secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-test").defaultRoles("uma_protection").directAccessGrants()).build());
    }

    @Before
    public void configureAuthorization() throws Exception {
        RealmResource realm = this.getRealm();
        ClientResource client = this.getClient(realm);
        if (client.authorization().resources().findByName("Resource A").isEmpty()) {
            this.createResourcesAndScopes();
            this.createPolicies(realm, client);
            this.createPermissions(client);
        }
    }

    @Test
    public void testMartaCanAccessResourceAWithExecuteAndWrite() throws Exception {
        ClientResource client = this.getClient(this.getRealm());
        AuthorizationResource authorization = client.authorization();
        ResourceServerRepresentation settings = authorization.getSettings();
        settings.setPolicyEnforcementMode(PolicyEnforcementMode.ENFORCING);
        settings.setDecisionStrategy(DecisionStrategy.UNANIMOUS);
        authorization.update(settings);
        Collection<Permission> permissions = this.getEntitlements("marta", "password");
        Assert.assertEquals((long)1L, (long)permissions.size());
        block8: for (Permission permission : new ArrayList<Permission>(permissions)) {
            String resourceSetName;
            switch (resourceSetName = permission.getResourceName()) {
                case "Resource A": {
                    Assert.assertThat((Object)permission.getScopes(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"execute", "write"}));
                    permissions.remove(permission);
                    continue block8;
                }
                case "Resource C": {
                    Assert.assertThat((Object)permission.getScopes(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"execute", "write", "read"}));
                    permissions.remove(permission);
                    continue block8;
                }
            }
            Assert.fail((String)("Unexpected permission for resource [" + resourceSetName + "]"));
        }
        Assert.assertTrue((boolean)permissions.isEmpty());
    }

    @Test
    public void testMartaCanAccessResourceA() throws Exception {
        ClientResource client = this.getClient(this.getRealm());
        AuthorizationResource authorization = client.authorization();
        ResourceServerRepresentation settings = authorization.getSettings();
        settings.setPolicyEnforcementMode(PolicyEnforcementMode.ENFORCING);
        settings.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        authorization.update(settings);
        Collection<Permission> permissions = this.getEntitlements("marta", "password");
        Assert.assertEquals((long)1L, (long)permissions.size());
        block8: for (Permission permission : new ArrayList<Permission>(permissions)) {
            String resourceSetName;
            switch (resourceSetName = permission.getResourceName()) {
                case "Resource A": {
                    Assert.assertThat((Object)permission.getScopes(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"execute", "write", "read"}));
                    permissions.remove(permission);
                    continue block8;
                }
                case "Resource C": {
                    Assert.assertThat((Object)permission.getScopes(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"execute", "write", "read"}));
                    permissions.remove(permission);
                    continue block8;
                }
            }
            Assert.fail((String)("Unexpected permission for resource [" + resourceSetName + "]"));
        }
        Assert.assertTrue((boolean)permissions.isEmpty());
    }

    @Test
    public void testWithPermissiveMode() throws Exception {
        ClientResource client = this.getClient(this.getRealm());
        AuthorizationResource authorization = client.authorization();
        ResourceServerRepresentation settings = authorization.getSettings();
        settings.setPolicyEnforcementMode(PolicyEnforcementMode.PERMISSIVE);
        settings.setDecisionStrategy(DecisionStrategy.UNANIMOUS);
        authorization.update(settings);
        Collection<Permission> permissions = this.getEntitlements("marta", "password");
        Assert.assertEquals((long)3L, (long)permissions.size());
        block10: for (Permission permission : new ArrayList<Permission>(permissions)) {
            String resourceSetName;
            switch (resourceSetName = permission.getResourceName()) {
                case "Resource A": {
                    Assert.assertThat((Object)permission.getScopes(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"execute", "write"}));
                    permissions.remove(permission);
                    continue block10;
                }
                case "Resource C": {
                    Assert.assertThat((Object)permission.getScopes(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"execute", "write", "read"}));
                    permissions.remove(permission);
                    continue block10;
                }
                case "Resource B": {
                    Assert.assertThat((Object)permission.getScopes(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"execute", "write", "read"}));
                    permissions.remove(permission);
                    continue block10;
                }
            }
            Assert.fail((String)("Unexpected permission for resource [" + resourceSetName + "]"));
        }
        Assert.assertTrue((boolean)permissions.isEmpty());
    }

    @Test
    public void testWithDisabledMode() throws Exception {
        ClientResource client = this.getClient(this.getRealm());
        AuthorizationResource authorization = client.authorization();
        ResourceServerRepresentation settings = authorization.getSettings();
        settings.setPolicyEnforcementMode(PolicyEnforcementMode.DISABLED);
        settings.setDecisionStrategy(DecisionStrategy.UNANIMOUS);
        authorization.update(settings);
        Collection<Permission> permissions = this.getEntitlements("marta", "password");
        Assert.assertEquals((long)3L, (long)permissions.size());
        block10: for (Permission permission : new ArrayList<Permission>(permissions)) {
            String resourceSetName;
            switch (resourceSetName = permission.getResourceName()) {
                case "Resource A": {
                    Assert.assertThat((Object)permission.getScopes(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"execute", "write", "read"}));
                    permissions.remove(permission);
                    continue block10;
                }
                case "Resource C": {
                    Assert.assertThat((Object)permission.getScopes(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"execute", "write", "read"}));
                    permissions.remove(permission);
                    continue block10;
                }
                case "Resource B": {
                    Assert.assertThat((Object)permission.getScopes(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"execute", "write", "read"}));
                    permissions.remove(permission);
                    continue block10;
                }
            }
            Assert.fail((String)("Unexpected permission for resource [" + resourceSetName + "]"));
        }
        Assert.assertTrue((boolean)permissions.isEmpty());
    }

    private Collection<Permission> getEntitlements(String username, String password) {
        AccessToken accessToken;
        AuthzClient authzClient = this.getAuthzClient();
        AuthorizationResponse response = authzClient.authorization(username, password).authorize();
        try {
            accessToken = (AccessToken)new JWSInput(response.getToken()).readJsonContent(AccessToken.class);
        }
        catch (JWSInputException cause) {
            throw new RuntimeException("Failed to deserialize RPT", cause);
        }
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        Assert.assertNotNull((String)"RPT does not contain any authorization data", (Object)authorization);
        return authorization.getPermissions();
    }

    private RealmResource getRealm() throws Exception {
        return this.adminClient.realm("authz-test");
    }

    private ClientResource getClient(RealmResource realm) {
        ClientsResource clients = realm.clients();
        return clients.findByClientId("resource-server-test").stream().map(representation -> clients.get(representation.getId())).findFirst().orElseThrow(() -> new RuntimeException("Expected client [resource-server-test]"));
    }

    private void createPermissions(ClientResource client) throws IOException {
        this.createResourcePermission("Resource A Only For Marta Permission", "Resource A", Arrays.asList("Only Marta Policy"), client);
        this.createScopePermission("Resource A Scope Read Only For Marta Permission", "Resource A", Arrays.asList("read"), Arrays.asList("Only Marta Policy"), client);
        this.createScopePermission("Resource A Scope Read Only For Kolo Permission", "Resource A", Arrays.asList("read"), Arrays.asList("Only Kolo Policy"), client);
    }

    private void createPolicies(RealmResource realm, ClientResource client) throws IOException {
        this.createUserPolicy("Only Marta Policy", realm, client, "marta");
        this.createUserPolicy("Only Kolo Policy", realm, client, "kolo");
    }

    private void createResourcesAndScopes() throws IOException {
        AuthzClient authzClient = this.getAuthzClient();
        HashSet<ScopeRepresentation> scopes = new HashSet<ScopeRepresentation>();
        scopes.add(new ScopeRepresentation("read"));
        scopes.add(new ScopeRepresentation("write"));
        scopes.add(new ScopeRepresentation("execute"));
        ArrayList<ResourceRepresentation> resources = new ArrayList<ResourceRepresentation>();
        resources.add(new ResourceRepresentation("Resource A", scopes));
        resources.add(new ResourceRepresentation("Resource B", scopes));
        resources.add(new ResourceRepresentation("Resource C", scopes));
        resources.forEach(resource -> authzClient.protection().resource().create(resource));
    }

    private void createUserPolicy(String name, RealmResource realm, ClientResource client, String username) throws IOException {
        String userId = realm.users().search(username).stream().map(representation -> representation.getId()).findFirst().orElseThrow(() -> new RuntimeException("Expected user [userId]"));
        PolicyRepresentation representation2 = new PolicyRepresentation();
        representation2.setName(name);
        representation2.setType("user");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("users", JsonSerialization.writeValueAsString((Object)new String[]{userId}));
        representation2.setConfig(config);
        client.authorization().policies().create(representation2).close();
    }

    private void createResourcePermission(String name, String resourceName, List<String> policies, ClientResource client) throws IOException {
        ResourcePermissionRepresentation representation = new ResourcePermissionRepresentation();
        representation.setName(name);
        representation.addResource(resourceName);
        representation.addPolicy(policies.toArray(new String[policies.size()]));
        client.authorization().permissions().resource().create(representation).close();
    }

    private void createScopePermission(String name, String resourceName, List<String> scopes, List<String> policies, ClientResource client) throws IOException {
        AuthorizationResource authorization = client.authorization();
        ScopePermissionRepresentation representation = new ScopePermissionRepresentation();
        representation.setName(name);
        if (resourceName != null) {
            representation.addResource(resourceName);
        }
        representation.addScope(scopes.toArray(new String[scopes.size()]));
        representation.addPolicy(policies.toArray(new String[policies.size()]));
        authorization.permissions().scope().create(representation).close();
    }

    private AuthzClient getAuthzClient() {
        return AuthzClient.create((InputStream)this.getClass().getResourceAsStream("/authorization-test/default-keycloak.json"));
    }
}

