/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.ResourcesResource;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.JSPolicyRepresentation;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.ResourceOwnerRepresentation;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.authz.AbstractAuthzTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.RolesBuilder;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class AuthorizationTest
extends AbstractAuthzTest {
    private AuthzClient authzClient;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(RealmBuilder.create().name("authz-test").roles(RolesBuilder.create().realmRole(RoleBuilder.create().name("uma_authorization").build())).user(UserBuilder.create().username("marta").password("password").addRoles("uma_authorization")).user(UserBuilder.create().username("kolo").password("password")).client(ClientBuilder.create().clientId("resource-server-test").secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-test").defaultRoles("uma_protection").directAccessGrants()).client(ClientBuilder.create().clientId("test-client").secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/test-client").directAccessGrants()).build());
    }

    @Before
    public void configureAuthorization() throws Exception {
        ClientResource client = this.getClient();
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName("Grant Policy");
        policy.setCode("$evaluation.grant();");
        authorization.policies().js().create(policy).close();
        policy = new JSPolicyRepresentation();
        policy.setName("Deny Policy");
        policy.setCode("$evaluation.deny();");
    }

    @After
    public void onAfter() {
        ResourcesResource resources = this.getClient().authorization().resources();
        List existingResources = resources.resources();
        for (ResourceRepresentation resource : existingResources) {
            resources.resource(resource.getId()).remove();
        }
    }

    @Test
    public void testResourceWithSameNameDifferentOwner() throws JWSInputException {
        ResourceRepresentation koloResource = this.createResource("Resource A", "kolo", "Scope A", "Scope B");
        this.createResourcePermission(koloResource, "Grant Policy");
        ResourceRepresentation martaResource = this.createResource("Resource A", "marta", "Scope A", "Scope B");
        this.createResourcePermission(martaResource, "Grant Policy");
        Assert.assertNotEquals((Object)koloResource.getId(), (Object)martaResource.getId());
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission("Resource A", new String[0]);
        List<Permission> permissions = this.authorize("kolo", "password", request);
        Assert.assertEquals((long)1L, (long)permissions.size());
        Permission permission = permissions.get(0);
        Assert.assertTrue((boolean)permission.getScopes().containsAll(Arrays.asList("Scope A", "Scope B")));
        Assert.assertEquals((Object)koloResource.getId(), (Object)permission.getResourceId());
        permissions = this.authorize("marta", "password", request);
        Assert.assertEquals((long)1L, (long)permissions.size());
        permission = permissions.get(0);
        Assert.assertEquals((Object)martaResource.getId(), (Object)permission.getResourceId());
        Assert.assertTrue((boolean)permission.getScopes().containsAll(Arrays.asList("Scope A", "Scope B")));
    }

    @Test
    public void testResourceServerWithSameNameDifferentOwner() {
        ResourceRepresentation koloResource = this.createResource("Resource A", "kolo", "Scope A", "Scope B");
        this.createResourcePermission(koloResource, "Grant Policy");
        ResourceRepresentation serverResource = this.createResource("Resource A", null, "Scope A", "Scope B");
        this.createResourcePermission(serverResource, "Grant Policy");
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission("Resource A", new String[0]);
        List<Permission> permissions = this.authorize("kolo", "password", request);
        Assert.assertEquals((long)2L, (long)permissions.size());
        for (Permission permission : permissions) {
            Assert.assertTrue((permission.getResourceId().equals(koloResource.getId()) || permission.getResourceId().equals(serverResource.getId()) ? 1 : 0) != 0);
            Assert.assertEquals((Object)"Resource A", (Object)permission.getResourceName());
        }
    }

    private List<Permission> authorize(String userName, String password, AuthorizationRequest request) {
        AuthorizationResponse response = this.getAuthzClient().authorization(userName, password).authorize(request);
        AccessToken token = this.toAccessToken(response.getToken());
        AccessToken.Authorization authorization = token.getAuthorization();
        return new ArrayList<Permission>(authorization.getPermissions());
    }

    private void createResourcePermission(ResourceRepresentation resource, String ... policies) {
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName(resource.getName() + UUID.randomUUID().toString());
        permission.addResource(resource.getId());
        permission.addPolicy(policies);
        try (Response response = this.getClient().authorization().permissions().resource().create(permission);){
            Assert.assertEquals((long)201L, (long)response.getStatus());
        }
    }

    @NotNull
    private ResourceRepresentation createResource(String name, String owner, String ... scopes) {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName(name);
        resource.setOwner(owner != null ? new ResourceOwnerRepresentation(owner) : null);
        resource.addScope(scopes);
        Response response = this.getClient().authorization().resources().create(resource);
        ResourceRepresentation stored = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        response.close();
        resource.setId(stored.getId());
        return resource;
    }

    private RealmResource getRealm() {
        return this.adminClient.realm("authz-test");
    }

    private ClientResource getClient() {
        ClientsResource clients = this.getRealm().clients();
        return clients.findByClientId("resource-server-test").stream().map(representation -> clients.get(representation.getId())).findFirst().orElseThrow(() -> new RuntimeException("Expected client [resource-server-test]"));
    }

    private AuthzClient getAuthzClient() {
        if (this.authzClient == null) {
            this.authzClient = AuthzClient.create((InputStream)this.getClass().getResourceAsStream("/authorization-test/default-keycloak.json"));
        }
        return this.authzClient;
    }
}

