/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.net.InetAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.collections.map.HashedMap;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.authorization.attribute.Attributes;

public class AttributeTest {
    @Test
    public void testManageAttributes() throws ParseException {
        HashedMap map = new HashedMap();
        map.put("integer", Arrays.asList("1"));
        map.put("long", Arrays.asList("9223372036854775807"));
        map.put("string", Arrays.asList("some string"));
        map.put("date", Arrays.asList("12/12/2016"));
        map.put("ip_network_address", Arrays.asList("127.0.0.1"));
        map.put("host_network_address", Arrays.asList("localhost"));
        map.put("multi_valued", Arrays.asList("1", "2", "3", "4"));
        final Attributes attributes = Attributes.from((Map)map);
        map.keySet().forEach(new Consumer<String>(){

            @Override
            public void accept(String name) {
                Assert.assertTrue((boolean)attributes.exists(name));
            }
        });
        Assert.assertFalse((boolean)attributes.exists("not_found"));
        Assert.assertTrue((boolean)attributes.containsValue("integer", "1"));
        Assert.assertTrue((boolean)attributes.containsValue("multi_valued", "3"));
        Assert.assertEquals((long)1L, (long)attributes.getValue("multi_valued").asInt(0));
        Assert.assertEquals((long)4L, (long)attributes.getValue("multi_valued").asInt(3));
        Assert.assertEquals((Object)new SimpleDateFormat("dd/MM/yyyy").parse("12/12/2016"), (Object)attributes.getValue("date").asDate(0, "dd/MM/yyyy"));
        Assert.assertEquals((Object)InetAddress.getLoopbackAddress(), (Object)attributes.getValue("ip_network_address").asInetAddress(0));
        Assert.assertEquals((Object)InetAddress.getLoopbackAddress(), (Object)attributes.getValue("host_network_address").asInetAddress(0));
    }
}

