/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.partialimport;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.events.admin.OperationType;
import org.keycloak.partialimport.PartialImportResult;
import org.keycloak.partialimport.PartialImportResults;
import org.keycloak.partialimport.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.testsuite.AbstractAuthTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.util.AssertAdminEvents;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.util.JsonSerialization;

public class PartialImportTest
extends AbstractAuthTest {
    @Rule
    public AssertAdminEvents assertAdminEvents = new AssertAdminEvents(this);
    private static final int NUM_RESOURCE_TYPES = 6;
    private static final String CLIENT_ROLES_CLIENT = "clientRolesClient";
    private static final String CLIENT_SERVICE_ACCOUNT = "clientServiceAccount";
    private static final String USER_PREFIX = "user";
    private static final String GROUP_PREFIX = "group";
    private static final String CLIENT_PREFIX = "client";
    private static final String REALM_ROLE_PREFIX = "realmRole";
    private static final String CLIENT_ROLE_PREFIX = "clientRole";
    private static final String[] IDP_ALIASES = new String[]{"twitter", "github", "facebook", "google", "linkedin", "microsoft", "stackoverflow"};
    private static final int NUM_ENTITIES = IDP_ALIASES.length;
    private static final ResourceServerRepresentation resourceServerSampleSettings;
    private PartialImportRepresentation piRep;
    private String realmId;

    @Before
    public void initAdminEvents() {
        RealmRepresentation realmRep = RealmBuilder.edit(this.testRealmResource().toRepresentation()).testEventListener().build();
        this.realmId = realmRep.getId();
        realmRep.setDuplicateEmailsAllowed(Boolean.valueOf(false));
        this.adminClient.realm(realmRep.getRealm()).update(realmRep);
        this.piRep = new PartialImportRepresentation();
    }

    @After
    public void tearDownAdminEvents() {
        RealmRepresentation realmRep = RealmBuilder.edit(this.testRealmResource().toRepresentation()).removeTestEventListener().build();
        this.adminClient.realm(realmRep.getRealm()).update(realmRep);
    }

    @Before
    public void createClientForClientRoles() {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(CLIENT_ROLES_CLIENT);
        client.setName(CLIENT_ROLES_CLIENT);
        client.setProtocol("openid-connect");
        try (Response resp = this.testRealmResource().clients().create(client);){
            resp.readEntity(String.class);
        }
    }

    @Before
    public void createClientWithServiceAccount() {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(CLIENT_SERVICE_ACCOUNT);
        client.setName(CLIENT_SERVICE_ACCOUNT);
        client.setRootUrl("http://localhost/foo");
        client.setProtocol("openid-connect");
        client.setPublicClient(Boolean.valueOf(false));
        client.setSecret("secret");
        client.setServiceAccountsEnabled(Boolean.valueOf(true));
        try (Response resp = this.testRealmResource().clients().create(client);){
            String id = ApiUtil.getCreatedId((Response)resp);
            UserRepresentation serviceAccountUser = this.testRealmResource().clients().get(id).getServiceAccountUser();
            org.junit.Assert.assertNotNull((Object)serviceAccountUser);
        }
    }

    @Before
    public void removeUsers() {
        List toRemove = this.testRealmResource().users().search(USER_PREFIX, Integer.valueOf(0), Integer.valueOf(NUM_ENTITIES));
        for (UserRepresentation user : toRemove) {
            this.testRealmResource().users().get(user.getId()).remove();
        }
    }

    @Before
    public void removeGroups() {
        List toRemove = this.testRealmResource().groups().groups();
        for (GroupRepresentation group : toRemove) {
            this.testRealmResource().groups().group(group.getId()).remove();
        }
    }

    @Before
    public void removeClients() {
        List toRemove = this.testRealmResource().clients().findAll();
        for (ClientRepresentation client : toRemove) {
            if (client.getName() == null || !client.getName().startsWith(CLIENT_PREFIX)) continue;
            this.testRealmResource().clients().get(client.getId()).remove();
        }
    }

    @Before
    public void removeProviders() {
        List toRemove = this.testRealmResource().identityProviders().findAll();
        for (IdentityProviderRepresentation idp : toRemove) {
            this.testRealmResource().identityProviders().get(idp.getInternalId()).remove();
        }
    }

    @Before
    public void removeRealmRoles() {
        List toRemove = this.testRealmResource().roles().list();
        for (RoleRepresentation role : toRemove) {
            if (!role.getName().startsWith(REALM_ROLE_PREFIX)) continue;
            this.testRealmResource().roles().get(role.getName()).remove();
        }
    }

    @Before
    public void removeClientRoles() {
        List toRemove = this.clientRolesClient().roles().list();
        for (RoleRepresentation role : toRemove) {
            if (!role.getName().startsWith(CLIENT_ROLE_PREFIX)) continue;
            this.testRealmResource().clients().get(CLIENT_ROLES_CLIENT).roles().get(role.getName()).remove();
        }
    }

    private ClientResource clientRolesClient() {
        return ApiUtil.findClientResourceByName((RealmResource)this.testRealmResource(), (String)CLIENT_ROLES_CLIENT);
    }

    private void setFail() {
        this.piRep.setIfResourceExists(PartialImportRepresentation.Policy.FAIL.toString());
    }

    private void setSkip() {
        this.piRep.setIfResourceExists(PartialImportRepresentation.Policy.SKIP.toString());
    }

    private void setOverwrite() {
        this.piRep.setIfResourceExists(PartialImportRepresentation.Policy.OVERWRITE.toString());
    }

    private PartialImportResults doImport() {
        try (Response response = this.testRealmResource().partialImport(this.piRep);){
            PartialImportResults partialImportResults = (PartialImportResults)response.readEntity(PartialImportResults.class);
            return partialImportResults;
        }
    }

    private void addUsers() {
        ArrayList<UserRepresentation> users = new ArrayList<UserRepresentation>();
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            UserRepresentation user = PartialImportTest.createUserRepresentation(USER_PREFIX + i, USER_PREFIX + i + "@foo.com", "foo", "bar", true);
            users.add(user);
        }
        this.piRep.setUsers(users);
    }

    private void addUsersWithTermsAndConditions() {
        ArrayList<UserRepresentation> users = new ArrayList<UserRepresentation>();
        ArrayList<String> requiredActions = new ArrayList<String>();
        requiredActions.add("terms_and_conditions");
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            UserRepresentation user = PartialImportTest.createUserRepresentation(USER_PREFIX + i, USER_PREFIX + i + "@foo.com", "foo", "bar", true);
            user.setRequiredActions(requiredActions);
            users.add(user);
        }
        this.piRep.setUsers(users);
    }

    private void addGroups() {
        ArrayList<GroupRepresentation> groups = new ArrayList<GroupRepresentation>();
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            GroupRepresentation group = new GroupRepresentation();
            group.setName(GROUP_PREFIX + i);
            group.setPath("/group" + i);
            groups.add(group);
        }
        this.piRep.setGroups(groups);
    }

    private void addClients(boolean withServiceAccounts) throws IOException {
        ArrayList<ClientRepresentation> clients = new ArrayList<ClientRepresentation>();
        ArrayList<UserRepresentation> serviceAccounts = new ArrayList<UserRepresentation>();
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            ClientRepresentation client = new ClientRepresentation();
            client.setClientId(CLIENT_PREFIX + i);
            client.setName(CLIENT_PREFIX + i);
            clients.add(client);
            if (!withServiceAccounts) continue;
            client.setServiceAccountsEnabled(Boolean.valueOf(true));
            client.setBearerOnly(Boolean.valueOf(false));
            client.setPublicClient(Boolean.valueOf(false));
            client.setAuthorizationSettings(resourceServerSampleSettings);
            client.setAuthorizationServicesEnabled(Boolean.valueOf(true));
            UserRepresentation serviceAccount = new UserRepresentation();
            serviceAccount.setUsername("service-account-" + client.getClientId());
            serviceAccount.setEnabled(Boolean.valueOf(true));
            serviceAccount.setEmail(serviceAccount.getUsername() + "@placeholder.org");
            serviceAccount.setServiceAccountClientId(client.getClientId());
            serviceAccounts.add(serviceAccount);
        }
        if (withServiceAccounts) {
            if (this.piRep.getUsers() == null) {
                this.piRep.setUsers(new ArrayList());
            }
            this.piRep.getUsers().addAll(serviceAccounts);
        }
        this.piRep.setClients(clients);
    }

    private void addProviders() {
        ArrayList<IdentityProviderRepresentation> providers = new ArrayList<IdentityProviderRepresentation>();
        for (String alias : IDP_ALIASES) {
            IdentityProviderRepresentation idpRep = new IdentityProviderRepresentation();
            idpRep.setAlias(alias);
            idpRep.setProviderId(alias);
            idpRep.setEnabled(true);
            idpRep.setAuthenticateByDefault(false);
            idpRep.setFirstBrokerLoginFlowAlias("first broker login");
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("clientSecret", "secret");
            config.put("clientId", alias);
            idpRep.setConfig(config);
            providers.add(idpRep);
        }
        this.piRep.setIdentityProviders(providers);
    }

    private List<RoleRepresentation> makeRoles(String prefix) {
        ArrayList<RoleRepresentation> roles = new ArrayList<RoleRepresentation>();
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            RoleRepresentation role = new RoleRepresentation();
            role.setName(prefix + i);
            roles.add(role);
        }
        return roles;
    }

    private void addRealmRoles() {
        RolesRepresentation roles = this.piRep.getRoles();
        if (roles == null) {
            roles = new RolesRepresentation();
        }
        roles.setRealm(this.makeRoles(REALM_ROLE_PREFIX));
        this.piRep.setRoles(roles);
    }

    private void addClientRoles() {
        RolesRepresentation roles = this.piRep.getRoles();
        if (roles == null) {
            roles = new RolesRepresentation();
        }
        HashMap<String, List<RoleRepresentation>> clientRolesMap = new HashMap<String, List<RoleRepresentation>>();
        clientRolesMap.put(CLIENT_ROLES_CLIENT, this.makeRoles(CLIENT_ROLE_PREFIX));
        roles.setClient(clientRolesMap);
        this.piRep.setRoles(roles);
    }

    @Test
    public void testAddUsers() {
        this.assertAdminEvents.clear();
        this.setFail();
        this.addUsers();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)results.getAdded());
        HashSet<String> userIds = new HashSet<String>();
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            AdminEventRepresentation adminEvent = this.assertAdminEvents.poll();
            Assert.assertEquals((Object)this.realmId, (Object)adminEvent.getRealmId());
            Assert.assertEquals((Object)OperationType.CREATE.name(), (Object)adminEvent.getOperationType());
            Assert.assertTrue((boolean)adminEvent.getResourcePath().startsWith("users/"));
            String userId = adminEvent.getResourcePath().substring(6);
            userIds.add(userId);
        }
        this.assertAdminEvents.assertEmpty();
        for (PartialImportResult result : results.getResults()) {
            String id = result.getId();
            UserResource userRsc = this.testRealmResource().users().get(id);
            UserRepresentation user = userRsc.toRepresentation();
            Assert.assertThat((Object)user.getUsername(), (Matcher)CoreMatchers.startsWith((String)USER_PREFIX));
            Assert.assertThat(userIds, (Matcher)CoreMatchers.hasItem((Object)id));
        }
    }

    @Test
    public void testAddUsersWithDuplicateEmailsForbidden() {
        this.assertAdminEvents.clear();
        this.setFail();
        this.addUsers();
        UserRepresentation user = PartialImportTest.createUserRepresentation("user999", "user1@foo.com", "foo", "bar", true);
        this.piRep.getUsers().add(user);
        try (Response response = this.testRealmResource().partialImport(this.piRep);){
            org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
        }
    }

    @Test
    public void testAddUsersWithDuplicateEmailsAllowed() {
        RealmRepresentation realmRep = this.testRealmResource().toRepresentation();
        realmRep.setDuplicateEmailsAllowed(Boolean.valueOf(true));
        this.testRealmResource().update(realmRep);
        this.assertAdminEvents.clear();
        this.setFail();
        this.addUsers();
        this.doImport();
        UserRepresentation user = PartialImportTest.createUserRepresentation("user999", "user1@foo.com", "foo", "bar", true);
        this.piRep.setUsers(Arrays.asList(user));
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)1L, (long)results.getAdded());
    }

    @Test
    public void testAddUsersWithTermsAndConditions() {
        this.assertAdminEvents.clear();
        this.setFail();
        this.addUsersWithTermsAndConditions();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)results.getAdded());
        HashSet<String> userIds = new HashSet<String>();
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            AdminEventRepresentation adminEvent = this.assertAdminEvents.poll();
            Assert.assertEquals((Object)this.realmId, (Object)adminEvent.getRealmId());
            Assert.assertEquals((Object)OperationType.CREATE.name(), (Object)adminEvent.getOperationType());
            Assert.assertTrue((boolean)adminEvent.getResourcePath().startsWith("users/"));
            String userId = adminEvent.getResourcePath().substring(6);
            userIds.add(userId);
        }
        this.assertAdminEvents.assertEmpty();
        for (PartialImportResult result : results.getResults()) {
            String id = result.getId();
            UserResource userRsc = this.testRealmResource().users().get(id);
            UserRepresentation user = userRsc.toRepresentation();
            org.junit.Assert.assertTrue((boolean)user.getUsername().startsWith(USER_PREFIX));
            Assert.assertTrue((boolean)userIds.contains(id));
        }
    }

    @Test
    public void testAddClients() throws IOException {
        this.setFail();
        this.addClients(false);
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)results.getAdded());
        for (PartialImportResult result : results.getResults()) {
            String id = result.getId();
            ClientResource clientRsc = this.testRealmResource().clients().get(id);
            ClientRepresentation client = clientRsc.toRepresentation();
            org.junit.Assert.assertTrue((boolean)client.getName().startsWith(CLIENT_PREFIX));
        }
    }

    @EnableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
    @Test
    public void testAddClientsWithServiceAccountsAndAuthorization() throws IOException {
        this.setFail();
        this.addClients(true);
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)(NUM_ENTITIES * 2), (long)results.getAdded());
        for (PartialImportResult result : results.getResults()) {
            if (result.getResourceType().equals((Object)ResourceType.CLIENT)) {
                String id = result.getId();
                ClientResource clientRsc = this.testRealmResource().clients().get(id);
                ClientRepresentation client = clientRsc.toRepresentation();
                org.junit.Assert.assertTrue((boolean)client.getName().startsWith(CLIENT_PREFIX));
                Assert.assertTrue((boolean)client.isServiceAccountsEnabled());
                if (ProfileAssume.isFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION)) {
                    Assert.assertTrue((boolean)client.getAuthorizationServicesEnabled());
                    AuthorizationResource authRsc = clientRsc.authorization();
                    ResourceServerRepresentation authRep = authRsc.exportSettings();
                    Assert.assertNotNull((Object)authRep);
                    Assert.assertEquals((long)2L, (long)authRep.getResources().size());
                    Assert.assertEquals((long)3L, (long)authRep.getPolicies().size());
                    continue;
                }
                Assert.assertNull((Object)client.getAuthorizationServicesEnabled());
                continue;
            }
            UserResource userRsc = this.testRealmResource().users().get(result.getId());
            Assert.assertTrue((boolean)userRsc.toRepresentation().getUsername().startsWith("service-account-client"));
        }
    }

    @Test
    public void testAddProviders() {
        this.setFail();
        this.addProviders();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)IDP_ALIASES.length, (long)results.getAdded());
        for (PartialImportResult result : results.getResults()) {
            String id = result.getId();
            IdentityProviderResource idpRsc = this.testRealmResource().identityProviders().get(id);
            IdentityProviderRepresentation idp = idpRsc.toRepresentation();
            Map config = idp.getConfig();
            org.junit.Assert.assertTrue((boolean)Arrays.asList(IDP_ALIASES).contains(config.get("clientId")));
        }
    }

    @Test
    public void testAddRealmRoles() {
        this.setFail();
        this.addRealmRoles();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)results.getAdded());
        for (PartialImportResult result : results.getResults()) {
            String name = result.getResourceName();
            RoleResource roleRsc = this.testRealmResource().roles().get(name);
            RoleRepresentation role = roleRsc.toRepresentation();
            org.junit.Assert.assertTrue((boolean)role.getName().startsWith(REALM_ROLE_PREFIX));
        }
    }

    @Test
    public void testAddClientRoles() {
        this.setFail();
        this.addClientRoles();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)results.getAdded());
        List clientRoles = this.clientRolesClient().roles().list();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)clientRoles.size());
        for (RoleRepresentation roleRep : clientRoles) {
            org.junit.Assert.assertTrue((boolean)roleRep.getName().startsWith(CLIENT_ROLE_PREFIX));
        }
    }

    private void testFail() {
        this.setFail();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertNull((Object)results.getErrorMessage());
        results = this.doImport();
        org.junit.Assert.assertNotNull((Object)results.getErrorMessage());
    }

    @Test
    public void testAddUsersFail() {
        this.addUsers();
        this.testFail();
    }

    @Test
    public void testAddGroupsFail() {
        this.addGroups();
        this.testFail();
    }

    @Test
    public void testAddClientsFail() throws IOException {
        this.addClients(false);
        this.testFail();
    }

    @Test
    public void testAddProvidersFail() {
        this.addProviders();
        this.testFail();
    }

    @Test
    public void testAddRealmRolesFail() {
        this.addRealmRoles();
        this.testFail();
    }

    @Test
    public void testAddClientRolesFail() {
        this.addClientRoles();
        this.testFail();
    }

    private void testSkip() {
        this.setSkip();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)results.getAdded());
        results = this.doImport();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)results.getSkipped());
    }

    @Test
    public void testAddUsersSkip() {
        this.addUsers();
        this.testSkip();
    }

    @Test
    public void testAddGroupsSkip() {
        this.addGroups();
        this.testSkip();
    }

    @Test
    public void testAddClientsSkip() throws IOException {
        this.addClients(false);
        this.testSkip();
    }

    @EnableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
    @Test
    public void testAddClientsSkipWithServiceAccountsAndAuthorization() throws IOException {
        this.addClients(true);
        this.setSkip();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)(NUM_ENTITIES * 2), (long)results.getAdded());
        results = this.doImport();
        org.junit.Assert.assertEquals((long)(NUM_ENTITIES * 2), (long)results.getSkipped());
    }

    @Test
    public void testAddProvidersSkip() {
        this.addProviders();
        this.testSkip();
    }

    @Test
    public void testAddRealmRolesSkip() {
        this.addRealmRoles();
        this.testSkip();
    }

    @Test
    public void testAddClientRolesSkip() {
        this.addClientRoles();
        this.testSkip();
    }

    private void testOverwrite() {
        this.setOverwrite();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)results.getAdded());
        results = this.doImport();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)results.getOverwritten());
    }

    @Test
    public void testAddUsersOverwrite() {
        this.addUsers();
        this.testOverwrite();
    }

    @Test
    public void testAddGroupsOverwrite() {
        this.addGroups();
        this.testOverwrite();
    }

    @Test
    public void testAddClientsOverwrite() throws IOException {
        this.addClients(false);
        this.testOverwrite();
    }

    @EnableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
    @Test
    public void testAddClientsOverwriteWithServiceAccountsAndAuthorization() throws IOException {
        this.addClients(true);
        this.setOverwrite();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)(NUM_ENTITIES * 2), (long)results.getAdded());
        results = this.doImport();
        org.junit.Assert.assertEquals((long)(NUM_ENTITIES * 2), (long)results.getOverwritten());
    }

    @EnableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
    @Test
    public void testAddClientsOverwriteServiceAccountsWithNoServiceAccounts() throws IOException {
        List l;
        int i;
        this.addClients(true);
        this.setOverwrite();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)(NUM_ENTITIES * 2), (long)results.getAdded());
        for (i = 0; i < NUM_ENTITIES; ++i) {
            l = this.testRealmResource().users().search("service-account-client" + i);
            Assert.assertEquals((long)1L, (long)l.size());
        }
        this.piRep = new PartialImportRepresentation();
        this.addClients(false);
        this.setOverwrite();
        results = this.doImport();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)results.getOverwritten());
        for (i = 0; i < NUM_ENTITIES; ++i) {
            l = this.testRealmResource().users().search("service-account-client" + i);
            Assert.assertEquals((long)0L, (long)l.size());
        }
    }

    @Test
    public void testAddProvidersOverwrite() {
        this.addProviders();
        this.testOverwrite();
    }

    @Test
    public void testAddRealmRolesOverwrite() {
        this.addRealmRoles();
        this.testOverwrite();
    }

    @Test
    public void testAddClientRolesOverwrite() {
        this.addClientRoles();
        this.testOverwrite();
    }

    private void importEverything(boolean withServiceAccounts) throws IOException {
        this.addUsers();
        this.addGroups();
        this.addClients(withServiceAccounts);
        this.addProviders();
        this.addRealmRoles();
        this.addClientRoles();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertNull((Object)results.getErrorMessage());
        if (withServiceAccounts) {
            org.junit.Assert.assertEquals((long)(NUM_ENTITIES * 7), (long)results.getAdded());
        } else {
            org.junit.Assert.assertEquals((long)(NUM_ENTITIES * 6), (long)results.getAdded());
        }
    }

    @Test
    public void testEverythingFail() throws IOException {
        this.setFail();
        this.importEverything(false);
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertNotNull((Object)results.getErrorMessage());
    }

    @Test
    public void testEverythingSkip() throws IOException {
        this.setSkip();
        this.importEverything(false);
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)(NUM_ENTITIES * 6), (long)results.getSkipped());
    }

    @EnableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
    @Test
    public void testEverythingSkipWithServiceAccounts() throws IOException {
        this.setSkip();
        this.importEverything(true);
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)(NUM_ENTITIES * 7), (long)results.getSkipped());
    }

    @Test
    public void testEverythingOverwrite() throws IOException {
        this.setOverwrite();
        this.importEverything(false);
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)(NUM_ENTITIES * 6), (long)results.getOverwritten());
    }

    @EnableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
    @Test
    public void testEverythingOverwriteWithServiceAccounts() throws IOException {
        this.setOverwrite();
        this.importEverything(true);
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)(NUM_ENTITIES * 7), (long)results.getOverwritten());
    }

    @Test
    public void testOverwriteExistingClientWithRoles() {
        this.setOverwrite();
        ClientRepresentation client = (ClientRepresentation)this.adminClient.realm("master").clients().findByClientId("broker").get(0);
        List clientRoles = this.adminClient.realm("master").clients().get(client.getId()).roles().list();
        HashMap<String, List> clients = new HashMap<String, List>();
        clients.put(client.getClientId(), clientRoles);
        RolesRepresentation roles = new RolesRepresentation();
        roles.setClient(clients);
        this.piRep.setClients(Arrays.asList(client));
        this.piRep.setRoles(roles);
        this.doImport();
    }

    @Test
    public void testOverwriteExistingInternalClient() {
        this.setOverwrite();
        ClientRepresentation client = (ClientRepresentation)this.adminClient.realm("master").clients().findByClientId("security-admin-console").get(0);
        ClientRepresentation client2 = (ClientRepresentation)this.adminClient.realm("master").clients().findByClientId("master-realm").get(0);
        this.piRep.setClients(Arrays.asList(client, client2));
        PartialImportResults result = this.doImport();
        Assert.assertEquals((long)0L, (long)result.getOverwritten());
    }

    @Test
    public void testOverwriteExistingClientWithServiceAccount() {
        this.setOverwrite();
        this.piRep.setClients(Arrays.asList((ClientRepresentation)this.testRealmResource().clients().findByClientId(CLIENT_SERVICE_ACCOUNT).get(0)));
        Assert.assertEquals((long)1L, (long)this.doImport().getOverwritten());
        ClientRepresentation client = (ClientRepresentation)this.testRealmResource().clients().findByClientId(CLIENT_SERVICE_ACCOUNT).get(0);
        this.testRealmResource().clients().get(client.getId()).getServiceAccountUser();
    }

    static {
        try {
            resourceServerSampleSettings = (ResourceServerRepresentation)JsonSerialization.readValue((InputStream)PartialImportTest.class.getResourceAsStream("/import/sample-authz-partial-import.json"), ResourceServerRepresentation.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load sample resource server configuration", e);
        }
    }
}

