/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.group;

import com.google.common.collect.Comparators;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.GroupResource;
import org.keycloak.admin.client.resource.GroupsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.group.AbstractGroupTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.UncaughtServerErrorExpected;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.runonserver.RunOnServerException;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.GroupBuilder;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.testsuite.utils.tls.TLSUtils;
import org.keycloak.util.JsonSerialization;

public class GroupTest
extends AbstractGroupTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation testRealmRep = this.loadTestRealm(testRealms);
        testRealmRep.setEventsEnabled(true);
        List users = testRealmRep.getUsers();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("direct-login");
        user.setEmail("direct-login@localhost");
        user.setEnabled(Boolean.valueOf(true));
        LinkedList<CredentialRepresentation> credentials = new LinkedList<CredentialRepresentation>();
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue("password");
        credentials.add(credential);
        user.setCredentials(credentials);
        users.add(user);
        List clients = testRealmRep.getClients();
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId("resource-owner");
        client.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        client.setSecret("secret");
        clients.add(client);
    }

    @Test
    public void testClientRemoveWithClientRoleGroupMapping() throws Exception {
        RealmResource realm = this.adminClient.realms().realm("test");
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId("foo");
        client.setRootUrl("http://foo");
        client.setProtocol("openid-connect");
        Response response = realm.clients().create(client);
        response.close();
        String clientUuid = ApiUtil.getCreatedId((Response)response);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.clientResourcePath(clientUuid), (Object)client, ResourceType.CLIENT);
        client = (ClientRepresentation)realm.clients().findByClientId("foo").get(0);
        RoleRepresentation role = new RoleRepresentation();
        role.setName("foo-role");
        realm.clients().get(client.getId()).roles().create(role);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(clientUuid, "foo-role"), (Object)role, ResourceType.CLIENT_ROLE);
        role = realm.clients().get(client.getId()).roles().get("foo-role").toRepresentation();
        GroupRepresentation group = new GroupRepresentation();
        group.setName("2716");
        group = this.createGroup(realm, group);
        LinkedList<RoleRepresentation> list = new LinkedList<RoleRepresentation>();
        list.add(role);
        realm.groups().group(group.getId()).roles().clientLevel(client.getId()).add(list);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupRolesClientRolesPath(group.getId(), clientUuid), list, ResourceType.CLIENT_ROLE_MAPPING);
        realm.clients().get(client.getId()).remove();
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.clientResourcePath(clientUuid), ResourceType.CLIENT);
    }

    private GroupRepresentation createGroup(RealmResource realm, GroupRepresentation group) {
        try (Response response = realm.groups().add(group);){
            String groupId = ApiUtil.getCreatedId((Response)response);
            this.getCleanup().addGroupId(groupId);
            this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupPath(groupId), (Object)group, ResourceType.GROUP);
            group.setId(groupId);
            GroupRepresentation groupRepresentation = group;
            return groupRepresentation;
        }
    }

    private RoleRepresentation createRealmRole(RealmResource realm, RoleRepresentation role) {
        realm.roles().create(role);
        RoleRepresentation created = realm.roles().get(role.getName()).toRepresentation();
        this.getCleanup().addRoleId(created.getId());
        return created;
    }

    @Test
    public void doNotAllowSameGroupNameAtSameLevel() throws Exception {
        RealmResource realm = this.adminClient.realms().realm("test");
        GroupRepresentation topGroup = new GroupRepresentation();
        topGroup.setName("top");
        topGroup = this.createGroup(realm, topGroup);
        GroupRepresentation anotherTopGroup = new GroupRepresentation();
        anotherTopGroup.setName("top");
        Response response = realm.groups().add(anotherTopGroup);
        org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
        GroupRepresentation level2Group = new GroupRepresentation();
        level2Group.setName("level2");
        response = realm.groups().group(topGroup.getId()).subGroup(level2Group);
        response.close();
        org.junit.Assert.assertEquals((long)201L, (long)response.getStatus());
        GroupRepresentation anotherlevel2Group = new GroupRepresentation();
        anotherlevel2Group.setName("level2");
        response = realm.groups().group(topGroup.getId()).subGroup(anotherlevel2Group);
        response.close();
        org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
    }

    @Test
    public void doNotAllowSameGroupNameAtSameLevelWhenUpdatingName() throws Exception {
        RealmResource realm = this.adminClient.realms().realm("test");
        GroupRepresentation topGroup = new GroupRepresentation();
        topGroup.setName("top1");
        topGroup = this.createGroup(realm, topGroup);
        GroupRepresentation anotherTopGroup = new GroupRepresentation();
        anotherTopGroup.setName("top2");
        anotherTopGroup = this.createGroup(realm, anotherTopGroup);
        anotherTopGroup.setName("top1");
        try {
            realm.groups().group(anotherTopGroup.getId()).update(anotherTopGroup);
            org.junit.Assert.fail((String)"Expected ClientErrorException");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((Object)"HTTP 409 Conflict", (Object)e.getMessage());
        }
        GroupRepresentation level2Group = new GroupRepresentation();
        level2Group.setName("level2-1");
        this.addSubGroup(realm, topGroup, level2Group);
        GroupRepresentation anotherlevel2Group = new GroupRepresentation();
        anotherlevel2Group.setName("level2-2");
        this.addSubGroup(realm, topGroup, anotherlevel2Group);
        anotherlevel2Group.setName("level2-1");
        try {
            realm.groups().group(anotherlevel2Group.getId()).update(anotherlevel2Group);
            org.junit.Assert.fail((String)"Expected ClientErrorException");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((Object)"HTTP 409 Conflict", (Object)e.getMessage());
        }
    }

    private void addSubGroup(RealmResource realm, GroupRepresentation parent, GroupRepresentation child) {
        Response response = realm.groups().add(child);
        child.setId(ApiUtil.getCreatedId((Response)response));
        response = realm.groups().group(parent.getId()).subGroup(child);
        response.close();
    }

    @Test
    public void allowSameGroupNameAtDifferentLevel() throws Exception {
        RealmResource realm = this.adminClient.realms().realm("test");
        GroupRepresentation topGroup = new GroupRepresentation();
        topGroup.setName("test-group");
        topGroup = this.createGroup(realm, topGroup);
        this.getCleanup().addGroupId(topGroup.getId());
        GroupRepresentation childGroup = new GroupRepresentation();
        childGroup.setName("test-group");
        try (Response response = realm.groups().group(topGroup.getId()).subGroup(childGroup);){
            org.junit.Assert.assertEquals((long)201L, (long)response.getStatus());
            this.getCleanup().addGroupId(ApiUtil.getCreatedId((Response)response));
        }
        org.junit.Assert.assertNotNull((Object)realm.getGroupByPath("/test-group/test-group"));
    }

    @Test
    public void doNotAllowSameGroupNameAtTopLevel() throws Exception {
        RealmResource realm = this.adminClient.realms().realm("test");
        GroupRepresentation topGroup = new GroupRepresentation();
        topGroup.setName("test-group");
        topGroup = this.createGroup(realm, topGroup);
        this.getCleanup().addGroupId(topGroup.getId());
        GroupRepresentation group2 = new GroupRepresentation();
        group2.setName("test-group");
        try (Response response = realm.groups().add(group2);){
            org.junit.Assert.assertEquals((long)Response.Status.CONFLICT.getStatusCode(), (long)response.getStatus());
        }
    }

    @Test
    @UncaughtServerErrorExpected
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void doNotAllowSameGroupNameAtTopLevelInDatabase() throws Exception {
        String id = KeycloakModelUtils.generateId();
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealm("test");
            realm.createGroup(id, "test-group");
        });
        this.getCleanup().addGroupId(id);
        this.expectedException.expect(RunOnServerException.class);
        this.expectedException.expectMessage(ModelDuplicateException.class.getName());
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealm("test");
            realm.createGroup("test-group");
        });
    }

    @Test
    public void createGroupWithEmptyNameShouldFail() {
        Throwable throwable;
        Response response;
        RealmResource realm = this.adminClient.realms().realm("test");
        GroupRepresentation group = new GroupRepresentation();
        group.setName("");
        try {
            response = realm.groups().add(group);
            throwable = null;
            try {
                if (response.getStatus() != 400) {
                    org.junit.Assert.fail((String)"Creating a group with empty name should fail");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (response != null) {
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
        catch (Exception expected) {
            org.junit.Assert.assertNotNull((Object)expected);
        }
        group.setName(null);
        try {
            response = realm.groups().add(group);
            throwable = null;
            try {
                if (response.getStatus() != 400) {
                    org.junit.Assert.fail((String)"Creating a group with null name should fail");
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (response != null) {
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
        catch (Exception expected) {
            org.junit.Assert.assertNotNull((Object)expected);
        }
    }

    @Test
    public void updatingGroupWithEmptyNameShouldFail() {
        RealmResource realm = this.adminClient.realms().realm("test");
        GroupRepresentation group = new GroupRepresentation();
        group.setName("groupWithName");
        String groupId = null;
        try (Response response = realm.groups().add(group);){
            groupId = ApiUtil.getCreatedId((Response)response);
        }
        try {
            group.setName("");
            realm.groups().group(groupId).update(group);
            org.junit.Assert.fail((String)"Updating a group with empty name should fail");
        }
        catch (Exception expected) {
            org.junit.Assert.assertNotNull((Object)expected);
        }
        try {
            group.setName(null);
            realm.groups().group(groupId).update(group);
            org.junit.Assert.fail((String)"Updating a group with null name should fail");
        }
        catch (Exception expected) {
            org.junit.Assert.assertNotNull((Object)expected);
        }
    }

    @Test
    public void createAndTestGroups() throws Exception {
        RealmResource realm = this.adminClient.realms().realm("test");
        RoleRepresentation topRole = this.createRealmRole(realm, RoleBuilder.create().name("topRole").build());
        RoleRepresentation level2Role = this.createRealmRole(realm, RoleBuilder.create().name("level2Role").build());
        RoleRepresentation level3Role = this.createRealmRole(realm, RoleBuilder.create().name("level3Role").build());
        this.assertAdminEvents.clear();
        GroupRepresentation topGroup = new GroupRepresentation();
        topGroup.setName("top");
        topGroup = this.createGroup(realm, topGroup);
        LinkedList<RoleRepresentation> roles = new LinkedList<RoleRepresentation>();
        roles.add(topRole);
        realm.groups().group(topGroup.getId()).roles().realmLevel().add(roles);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupRolesRealmRolesPath(topGroup.getId()), roles, ResourceType.REALM_ROLE_MAPPING);
        GroupRepresentation level2Group = new GroupRepresentation();
        level2Group.setName("level2");
        Response response = realm.groups().group(topGroup.getId()).subGroup(level2Group);
        response.close();
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupSubgroupsPath(topGroup.getId()), (Object)level2Group, ResourceType.GROUP);
        URI location = response.getLocation();
        final String level2Id = ApiUtil.getCreatedId((Response)response);
        GroupRepresentation level2GroupById = realm.groups().group(level2Id).toRepresentation();
        org.junit.Assert.assertEquals((Object)level2Id, (Object)level2GroupById.getId());
        org.junit.Assert.assertEquals((Object)level2Group.getName(), (Object)level2GroupById.getName());
        URLAssert.assertGetURL(location, this.adminClient.tokenManager().getAccessTokenString(), new URLAssert.AssertJSONResponseHandler(){

            @Override
            protected void assertResponseBody(String body) throws IOException {
                GroupRepresentation level2 = (GroupRepresentation)JsonSerialization.readValue((String)body, GroupRepresentation.class);
                org.junit.Assert.assertEquals((Object)level2Id, (Object)level2.getId());
            }
        });
        level2Group = realm.getGroupByPath("/top/level2");
        org.junit.Assert.assertNotNull((Object)level2Group);
        roles.clear();
        roles.add(level2Role);
        realm.groups().group(level2Group.getId()).roles().realmLevel().add(roles);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupRolesRealmRolesPath(level2Group.getId()), roles, ResourceType.REALM_ROLE_MAPPING);
        GroupRepresentation level3Group = new GroupRepresentation();
        level3Group.setName("level3");
        response = realm.groups().group(level2Group.getId()).subGroup(level3Group);
        response.close();
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupSubgroupsPath(level2Group.getId()), (Object)level3Group, ResourceType.GROUP);
        level3Group = realm.getGroupByPath("/top/level2/level3");
        org.junit.Assert.assertNotNull((Object)level3Group);
        roles.clear();
        roles.add(level3Role);
        realm.groups().group(level3Group.getId()).roles().realmLevel().add(roles);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupRolesRealmRolesPath(level3Group.getId()), roles, ResourceType.REALM_ROLE_MAPPING);
        topGroup = realm.getGroupByPath("/top");
        org.junit.Assert.assertEquals((long)1L, (long)topGroup.getRealmRoles().size());
        org.junit.Assert.assertTrue((boolean)topGroup.getRealmRoles().contains("topRole"));
        org.junit.Assert.assertEquals((long)1L, (long)topGroup.getSubGroups().size());
        level2Group = (GroupRepresentation)topGroup.getSubGroups().get(0);
        org.junit.Assert.assertEquals((Object)"level2", (Object)level2Group.getName());
        org.junit.Assert.assertEquals((long)1L, (long)level2Group.getRealmRoles().size());
        org.junit.Assert.assertTrue((boolean)level2Group.getRealmRoles().contains("level2Role"));
        org.junit.Assert.assertEquals((long)1L, (long)level2Group.getSubGroups().size());
        level3Group = (GroupRepresentation)level2Group.getSubGroups().get(0);
        org.junit.Assert.assertEquals((Object)"level3", (Object)level3Group.getName());
        org.junit.Assert.assertEquals((long)1L, (long)level3Group.getRealmRoles().size());
        org.junit.Assert.assertTrue((boolean)level3Group.getRealmRoles().contains("level3Role"));
        UserRepresentation user = (UserRepresentation)realm.users().search("direct-login", Integer.valueOf(-1), Integer.valueOf(-1)).get(0);
        realm.users().get(user.getId()).joinGroup(level3Group.getId());
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.userGroupPath(user.getId(), level3Group.getId()), ResourceType.GROUP_MEMBERSHIP);
        List membership = realm.users().get(user.getId()).groups();
        org.junit.Assert.assertEquals((long)1L, (long)membership.size());
        org.junit.Assert.assertEquals((Object)"level3", (Object)((GroupRepresentation)membership.get(0)).getName());
        AccessToken token = this.login("direct-login", "resource-owner", "secret", user.getId());
        org.junit.Assert.assertTrue((boolean)token.getRealmAccess().getRoles().contains("topRole"));
        org.junit.Assert.assertTrue((boolean)token.getRealmAccess().getRoles().contains("level2Role"));
        org.junit.Assert.assertTrue((boolean)token.getRealmAccess().getRoles().contains("level3Role"));
        realm.addDefaultGroup(level3Group.getId());
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.defaultGroupPath(level3Group.getId()), ResourceType.GROUP);
        List defaultGroups = realm.getDefaultGroups();
        org.junit.Assert.assertEquals((long)1L, (long)defaultGroups.size());
        org.junit.Assert.assertEquals((Object)((GroupRepresentation)defaultGroups.get(0)).getId(), (Object)level3Group.getId());
        UserRepresentation newUser = new UserRepresentation();
        newUser.setUsername("groupUser");
        newUser.setEmail("group@group.com");
        response = realm.users().create(newUser);
        String userId = ApiUtil.getCreatedId((Response)response);
        response.close();
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.userResourcePath(userId), (Object)newUser, ResourceType.USER);
        membership = realm.users().get(userId).groups();
        org.junit.Assert.assertEquals((long)1L, (long)membership.size());
        org.junit.Assert.assertEquals((Object)"level3", (Object)((GroupRepresentation)membership.get(0)).getName());
        realm.removeDefaultGroup(level3Group.getId());
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.defaultGroupPath(level3Group.getId()), ResourceType.GROUP);
        defaultGroups = realm.getDefaultGroups();
        org.junit.Assert.assertEquals((long)0L, (long)defaultGroups.size());
        realm.groups().group(topGroup.getId()).remove();
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.groupPath(topGroup.getId()), ResourceType.GROUP);
        try {
            realm.getGroupByPath("/top/level2/level3");
            org.junit.Assert.fail((String)"Group should not have been found");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            realm.getGroupByPath("/top/level2");
            org.junit.Assert.fail((String)"Group should not have been found");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            realm.getGroupByPath("/top");
            org.junit.Assert.fail((String)"Group should not have been found");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        org.junit.Assert.assertNull((Object)this.login("direct-login", "resource-owner", "secret", user.getId()).getRealmAccess());
    }

    @Test
    public void updateGroup() {
        RealmResource realm = this.adminClient.realms().realm("test");
        String groupName = "group-" + UUID.randomUUID();
        GroupRepresentation group = GroupBuilder.create().name(groupName).singleAttribute("attr1", "attrval1").singleAttribute("attr2", "attrval2").build();
        this.createGroup(realm, group);
        group = realm.getGroupByPath("/" + groupName);
        org.junit.Assert.assertNotNull((Object)group);
        org.junit.Assert.assertThat((Object)group.getName(), (Matcher)Matchers.is((Object)groupName));
        org.junit.Assert.assertThat(group.getAttributes().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attr1", "attr2"}));
        org.junit.Assert.assertThat((Object)group.getAttributes(), (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"attr1"), (Matcher)Matchers.contains((Object[])new String[]{"attrval1"})));
        org.junit.Assert.assertThat((Object)group.getAttributes(), (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"attr2"), (Matcher)Matchers.contains((Object[])new String[]{"attrval2"})));
        String groupNewName = "group-" + UUID.randomUUID();
        group.setName(groupNewName);
        group.getAttributes().remove("attr1");
        ((List)group.getAttributes().get("attr2")).add("attrval2-2");
        group.getAttributes().put("attr3", Collections.singletonList("attrval2"));
        realm.groups().group(group.getId()).update(group);
        this.assertAdminEvents.assertEvent("test", OperationType.UPDATE, AdminEventPaths.groupPath(group.getId()), (Object)group, ResourceType.GROUP);
        group = realm.getGroupByPath("/" + groupNewName);
        org.junit.Assert.assertThat((Object)group.getName(), (Matcher)Matchers.is((Object)groupNewName));
        org.junit.Assert.assertThat(group.getAttributes().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attr2", "attr3"}));
        org.junit.Assert.assertThat((Object)group.getAttributes(), (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"attr2"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attrval2", "attrval2-2"})));
        org.junit.Assert.assertThat((Object)group.getAttributes(), (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"attr3"), (Matcher)Matchers.contains((Object[])new String[]{"attrval2"})));
    }

    @Test
    public void moveGroups() {
        RealmResource realm = this.adminClient.realms().realm("test");
        GroupRepresentation group = GroupBuilder.create().name("mygroup1").build();
        GroupRepresentation group1 = this.createGroup(realm, group);
        group = GroupBuilder.create().name("mygroup2").build();
        GroupRepresentation group2 = this.createGroup(realm, group);
        Response response = realm.groups().group(group1.getId()).subGroup(group2);
        org.junit.Assert.assertEquals((long)204L, (long)response.getStatus());
        response.close();
        group1 = realm.groups().group(group1.getId()).toRepresentation();
        group2 = realm.groups().group(group2.getId()).toRepresentation();
        Assert.assertNames(group1.getSubGroups(), "mygroup2");
        org.junit.Assert.assertEquals((Object)"/mygroup1/mygroup2", (Object)group2.getPath());
        this.assertAdminEvents.clear();
        group = GroupBuilder.create().name("mygroup2").build();
        GroupRepresentation group3 = this.createGroup(realm, group);
        response = realm.groups().group(group1.getId()).subGroup(group3);
        org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
        realm.groups().group(group3.getId()).remove();
        response = realm.groups().add(group2);
        org.junit.Assert.assertEquals((long)204L, (long)response.getStatus());
        response.close();
        group1 = realm.groups().group(group1.getId()).toRepresentation();
        group2 = realm.groups().group(group2.getId()).toRepresentation();
        org.junit.Assert.assertTrue((boolean)group1.getSubGroups().isEmpty());
        org.junit.Assert.assertEquals((Object)"/mygroup2", (Object)group2.getPath());
    }

    @Test
    public void groupMembership() {
        RealmResource realm = this.adminClient.realms().realm("test");
        GroupRepresentation group = new GroupRepresentation();
        group.setName("group");
        String groupId = this.createGroup(realm, group).getId();
        Response response = realm.users().create(UserBuilder.create().username("user-a").build());
        String userAId = ApiUtil.getCreatedId((Response)response);
        response.close();
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.userResourcePath(userAId), ResourceType.USER);
        response = realm.users().create(UserBuilder.create().username("user-b").build());
        String userBId = ApiUtil.getCreatedId((Response)response);
        response.close();
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.userResourcePath(userBId), ResourceType.USER);
        realm.users().get(userAId).joinGroup(groupId);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.userGroupPath(userAId, groupId), (Object)group, ResourceType.GROUP_MEMBERSHIP);
        List members = realm.groups().group(groupId).members(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertNames(members, "user-a");
        realm.users().get(userBId).joinGroup(groupId);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.userGroupPath(userBId, groupId), (Object)group, ResourceType.GROUP_MEMBERSHIP);
        members = realm.groups().group(groupId).members(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertNames(members, "user-a", "user-b");
        realm.users().get(userAId).leaveGroup(groupId);
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.userGroupPath(userAId, groupId), (Object)group, ResourceType.GROUP_MEMBERSHIP);
        members = realm.groups().group(groupId).members(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertNames(members, "user-b");
    }

    @Test
    public void groupMembershipUsersOrder() {
        RealmResource realm = this.adminClient.realms().realm("test");
        GroupRepresentation group = new GroupRepresentation();
        group.setName("group");
        String groupId = this.createGroup(realm, group).getId();
        ArrayList<String> usernames = new ArrayList<String>();
        for (int i = 0; i < 9; ++i) {
            UserRepresentation user = UserBuilder.create().username("user" + i).build();
            usernames.add(user.getUsername());
            try (Response create = realm.users().create(user);){
                org.junit.Assert.assertEquals((Object)Response.Status.CREATED, (Object)create.getStatusInfo());
                String userAId = ApiUtil.getCreatedId((Response)create);
                realm.users().get(userAId).joinGroup(groupId);
                continue;
            }
        }
        ArrayList<String> memberUsernames = new ArrayList<String>();
        for (UserRepresentation member : realm.groups().group(groupId).members(Integer.valueOf(0), Integer.valueOf(10))) {
            memberUsernames.add(member.getUsername());
        }
        org.junit.Assert.assertArrayEquals((String)("Expected: " + usernames + ", was: " + memberUsernames), (Object[])usernames.toArray(), (Object[])memberUsernames.toArray());
    }

    @Test
    public void deleteRealmWithDefaultGroups() throws IOException {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm("foo");
        GroupRepresentation group = new GroupRepresentation();
        group.setName("default1");
        group.setPath("/default1");
        rep.setGroups(Collections.singletonList(group));
        rep.setDefaultGroups(Collections.singletonList("/default1"));
        this.adminClient.realms().create(rep);
        this.adminClient.realm(rep.getRealm()).remove();
    }

    @Test
    public void roleMappings() {
        RealmResource realm = this.adminClient.realms().realm("test");
        this.createRealmRole(realm, RoleBuilder.create().name("realm-role").build());
        this.createRealmRole(realm, RoleBuilder.create().name("realm-composite").build());
        this.createRealmRole(realm, RoleBuilder.create().name("realm-child").build());
        realm.roles().get("realm-composite").addComposites(Collections.singletonList(realm.roles().get("realm-child").toRepresentation()));
        try (Response response = realm.clients().create(ClientBuilder.create().clientId("myclient").build());){
            String clientId = ApiUtil.getCreatedId((Response)response);
            this.getCleanup().addClientUuid(clientId);
            realm.clients().get(clientId).roles().create(RoleBuilder.create().name("client-role").build());
            realm.clients().get(clientId).roles().create(RoleBuilder.create().name("client-role2").build());
            realm.clients().get(clientId).roles().create(RoleBuilder.create().name("client-composite").build());
            realm.clients().get(clientId).roles().create(RoleBuilder.create().name("client-child").build());
            realm.clients().get(clientId).roles().get("client-composite").addComposites(Collections.singletonList(realm.clients().get(clientId).roles().get("client-child").toRepresentation()));
            this.assertAdminEvents.clear();
            GroupRepresentation group = new GroupRepresentation();
            group.setName("group");
            String groupId = this.createGroup(realm, group).getId();
            RoleMappingResource roles = realm.groups().group(groupId).roles();
            org.junit.Assert.assertEquals((long)0L, (long)roles.realmLevel().listAll().size());
            LinkedList<RoleRepresentation> l = new LinkedList<RoleRepresentation>();
            l.add(realm.roles().get("realm-role").toRepresentation());
            l.add(realm.roles().get("realm-composite").toRepresentation());
            roles.realmLevel().add(l);
            this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupRolesRealmRolesPath(group.getId()), l, ResourceType.REALM_ROLE_MAPPING);
            RoleRepresentation clientRole = realm.clients().get(clientId).roles().get("client-role").toRepresentation();
            RoleRepresentation clientComposite = realm.clients().get(clientId).roles().get("client-composite").toRepresentation();
            roles.clientLevel(clientId).add(Collections.singletonList(clientRole));
            roles.clientLevel(clientId).add(Collections.singletonList(clientComposite));
            this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupRolesClientRolesPath(group.getId(), clientId), Collections.singletonList(clientRole), ResourceType.CLIENT_ROLE_MAPPING);
            this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupRolesClientRolesPath(group.getId(), clientId), Collections.singletonList(clientComposite), ResourceType.CLIENT_ROLE_MAPPING);
            Assert.assertNames(roles.realmLevel().listAll(), "realm-role", "realm-composite");
            Assert.assertNames(roles.realmLevel().listAvailable(), "realm-child", "admin", "offline_access", "uma_authorization", "user", "customer-user-premium", "realm-composite-role", "sample-realm-role", "attribute-role", "default-roles-test");
            Assert.assertNames(roles.realmLevel().listEffective(), "realm-role", "realm-composite", "realm-child");
            Assert.assertNames(roles.clientLevel(clientId).listAll(), "client-role", "client-composite");
            Assert.assertNames(roles.clientLevel(clientId).listAvailable(), "client-role2", "client-child");
            Assert.assertNames(roles.clientLevel(clientId).listEffective(), "client-role", "client-composite", "client-child");
            MappingsRepresentation all = roles.getAll();
            Assert.assertNames(all.getRealmMappings(), "realm-role", "realm-composite");
            org.junit.Assert.assertEquals((long)1L, (long)all.getClientMappings().size());
            Assert.assertNames(((ClientMappingsRepresentation)all.getClientMappings().get("myclient")).getMappings(), "client-role", "client-composite");
            RoleRepresentation realmRoleRep = realm.roles().get("realm-role").toRepresentation();
            roles.realmLevel().remove(Collections.singletonList(realmRoleRep));
            this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.groupRolesRealmRolesPath(group.getId()), Collections.singletonList(realmRoleRep), ResourceType.REALM_ROLE_MAPPING);
            Assert.assertNames(roles.realmLevel().listAll(), "realm-composite");
            RoleRepresentation clientRoleRep = realm.clients().get(clientId).roles().get("client-role").toRepresentation();
            roles.clientLevel(clientId).remove(Collections.singletonList(clientRoleRep));
            this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.groupRolesClientRolesPath(group.getId(), clientId), Collections.singletonList(clientRoleRep), ResourceType.CLIENT_ROLE_MAPPING);
            Assert.assertNames(roles.clientLevel(clientId).listAll(), "client-composite");
        }
    }

    @Test
    public void rolesCanBeAssignedEvenWhenTheyAreAlreadyIndirectlyAssigned() {
        RealmResource realm = this.adminClient.realms().realm("test");
        this.createRealmRole(realm, RoleBuilder.create().name("realm-composite").build());
        this.createRealmRole(realm, RoleBuilder.create().name("realm-child").build());
        realm.roles().get("realm-composite").addComposites(Collections.singletonList(realm.roles().get("realm-child").toRepresentation()));
        try (Response response = realm.clients().create(ClientBuilder.create().clientId("myclient").build());){
            String clientId = ApiUtil.getCreatedId((Response)response);
            this.getCleanup().addClientUuid(clientId);
            realm.clients().get(clientId).roles().create(RoleBuilder.create().name("client-composite").build());
            realm.clients().get(clientId).roles().create(RoleBuilder.create().name("client-child").build());
            realm.clients().get(clientId).roles().get("client-composite").addComposites(Collections.singletonList(realm.clients().get(clientId).roles().get("client-child").toRepresentation()));
            GroupRepresentation group = new GroupRepresentation();
            group.setName("group");
            this.assertAdminEvents.clear();
            String groupId = this.createGroup(realm, group).getId();
            RoleMappingResource roles = realm.groups().group(groupId).roles();
            roles.realmLevel().add(Collections.singletonList(realm.roles().get("realm-composite").toRepresentation()));
            RoleRepresentation clientComposite = realm.clients().get(clientId).roles().get("client-composite").toRepresentation();
            roles.clientLevel(clientId).add(Collections.singletonList(clientComposite));
            Assert.assertNames(roles.realmLevel().listAll(), "realm-composite");
            Assert.assertNames(roles.realmLevel().listAvailable(), "realm-child", "admin", "offline_access", "uma_authorization", "user", "customer-user-premium", "realm-composite-role", "sample-realm-role", "attribute-role", "default-roles-test");
            Assert.assertNames(roles.realmLevel().listEffective(), "realm-composite", "realm-child");
            Assert.assertNames(roles.clientLevel(clientId).listAll(), "client-composite");
            Assert.assertNames(roles.clientLevel(clientId).listAvailable(), "client-child");
            Assert.assertNames(roles.clientLevel(clientId).listEffective(), "client-composite", "client-child");
            roles.realmLevel().add(Collections.singletonList(realm.roles().get("realm-child").toRepresentation()));
            RoleRepresentation clientChild = realm.clients().get(clientId).roles().get("client-child").toRepresentation();
            roles.clientLevel(clientId).add(Collections.singletonList(clientChild));
            Assert.assertNames(roles.realmLevel().listAll(), "realm-composite", "realm-child");
            Assert.assertNames(roles.realmLevel().listAvailable(), "admin", "offline_access", "uma_authorization", "user", "customer-user-premium", "realm-composite-role", "sample-realm-role", "attribute-role", "default-roles-test");
            Assert.assertNames(roles.realmLevel().listEffective(), "realm-composite", "realm-child");
            Assert.assertNames(roles.clientLevel(clientId).listAll(), "client-composite", "client-child");
            Assert.assertNames(roles.clientLevel(clientId).listAvailable(), new String[0]);
            Assert.assertNames(roles.clientLevel(clientId).listEffective(), "client-composite", "client-child");
            MappingsRepresentation all = roles.getAll();
            Assert.assertNames(all.getRealmMappings(), "realm-composite", "realm-child");
            org.junit.Assert.assertEquals((long)1L, (long)all.getClientMappings().size());
            Assert.assertNames(((ClientMappingsRepresentation)all.getClientMappings().get("myclient")).getMappings(), "client-composite", "client-child");
        }
    }

    @Test
    public void noAdminEndpointAccessWhenNoRoleAssigned() {
        String userName = "user-" + UUID.randomUUID();
        String realmName = "master";
        this.createUser("master", userName, "pwd", new String[0]);
        try (Keycloak userClient = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"master", (String)userName, (String)"pwd", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS());){
            this.expectedException.expect(ClientErrorException.class);
            this.expectedException.expectMessage(String.valueOf(Response.Status.FORBIDDEN.getStatusCode()));
            userClient.realms().findAll();
        }
    }

    @Test
    public void adminEndpointAccessibleWhenAdminRoleAssignedToUser() {
        String userName = "user-" + UUID.randomUUID();
        String realmName = "master";
        RealmResource realm = this.adminClient.realms().realm("master");
        RoleRepresentation adminRole = realm.roles().get(AdminRoles.ADMIN).toRepresentation();
        org.junit.Assert.assertThat((Object)adminRole, (Matcher)Matchers.notNullValue());
        org.junit.Assert.assertThat((Object)adminRole.getId(), (Matcher)Matchers.notNullValue());
        String userId = this.createUser("master", userName, "pwd", new String[0]);
        org.junit.Assert.assertThat((Object)userId, (Matcher)Matchers.notNullValue());
        RoleMappingResource mappings = realm.users().get(userId).roles();
        mappings.realmLevel().add(Collections.singletonList(adminRole));
        try (Keycloak userClient = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"master", (String)userName, (String)"pwd", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS());){
            org.junit.Assert.assertThat((Object)userClient.realms().findAll(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        }
    }

    @Test
    public void adminEndpointAccessibleWhenAdminRoleAssignedToGroup() {
        String userName = "user-" + UUID.randomUUID();
        String groupName = "group-" + UUID.randomUUID();
        String realmName = "master";
        RealmResource realm = this.adminClient.realms().realm("master");
        RoleRepresentation adminRole = realm.roles().get(AdminRoles.ADMIN).toRepresentation();
        org.junit.Assert.assertThat((Object)adminRole, (Matcher)Matchers.notNullValue());
        org.junit.Assert.assertThat((Object)adminRole.getId(), (Matcher)Matchers.notNullValue());
        String userId = this.createUser("master", userName, "pwd", new String[0]);
        GroupRepresentation group = GroupBuilder.create().name(groupName).build();
        try (Response response = realm.groups().add(group);){
            String groupId = ApiUtil.getCreatedId((Response)response);
            RoleMappingResource mappings = realm.groups().group(groupId).roles();
            mappings.realmLevel().add(Collections.singletonList(adminRole));
            realm.users().get(userId).joinGroup(groupId);
        }
        var9_9 = null;
        try (Keycloak userClient = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"master", (String)userName, (String)"pwd", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS());){
            org.junit.Assert.assertThat((Object)userClient.realms().findAll(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void searchForGroupsShouldOnlyReturnMatchingElementsOrIntermediatePaths() {
        String needle = "test1234";
        GroupRepresentation g1 = GroupBuilder.create().name("g1").build();
        GroupRepresentation g1_1 = GroupBuilder.create().name("g1.1-bubu").build();
        GroupRepresentation g1_2 = GroupBuilder.create().name("g1.2-" + needle).build();
        GroupRepresentation g2 = GroupBuilder.create().name("g2-" + needle).build();
        GroupRepresentation g3 = GroupBuilder.create().name("g3").build();
        GroupRepresentation g3_1 = GroupBuilder.create().name("g3.1-" + needle).build();
        GroupRepresentation g3_1_1 = GroupBuilder.create().name("g3.1.1").build();
        String realmName = "test";
        RealmResource realm = this.adminClient.realms().realm(realmName);
        this.createGroup(realm, g1);
        this.createGroup(realm, g2);
        this.createGroup(realm, g3);
        this.addSubGroup(realm, g1, g1_1);
        this.addSubGroup(realm, g1, g1_2);
        this.addSubGroup(realm, g3, g3_1);
        this.addSubGroup(realm, g3_1, g3_1_1);
        try {
            List result = realm.groups().groups(needle, Integer.valueOf(0), Integer.valueOf(100));
            org.junit.Assert.assertEquals((long)3L, (long)result.size());
            org.junit.Assert.assertEquals((Object)"g1", (Object)((GroupRepresentation)result.get(0)).getName());
            org.junit.Assert.assertEquals((long)1L, (long)((GroupRepresentation)result.get(0)).getSubGroups().size());
            org.junit.Assert.assertEquals((Object)("g1.2-" + needle), (Object)((GroupRepresentation)((GroupRepresentation)result.get(0)).getSubGroups().get(0)).getName());
            org.junit.Assert.assertEquals((Object)("g2-" + needle), (Object)((GroupRepresentation)result.get(1)).getName());
            org.junit.Assert.assertEquals((Object)"g3", (Object)((GroupRepresentation)result.get(2)).getName());
            org.junit.Assert.assertEquals((long)1L, (long)((GroupRepresentation)result.get(2)).getSubGroups().size());
            org.junit.Assert.assertEquals((Object)("g3.1-" + needle), (Object)((GroupRepresentation)((GroupRepresentation)result.get(2)).getSubGroups().get(0)).getName());
        }
        finally {
            if (g1.getId() != null) {
                realm.groups().group(g1.getId()).remove();
            }
            if (g2.getId() != null) {
                realm.groups().group(g2.getId()).remove();
            }
            if (g3.getId() != null) {
                realm.groups().group(g3.getId()).remove();
            }
        }
    }

    @Test
    public void adminEndpointAccessibleWhenAdminRoleAssignedToGroupAfterUserJoinedIt() {
        String userName = "user-" + UUID.randomUUID();
        String groupName = "group-" + UUID.randomUUID();
        String realmName = "master";
        RealmResource realm = this.adminClient.realms().realm("master");
        RoleRepresentation adminRole = realm.roles().get(AdminRoles.ADMIN).toRepresentation();
        org.junit.Assert.assertThat((Object)adminRole, (Matcher)Matchers.notNullValue());
        org.junit.Assert.assertThat((Object)adminRole.getId(), (Matcher)Matchers.notNullValue());
        String userId = this.createUser("master", userName, "pwd", new String[0]);
        GroupRepresentation group = GroupBuilder.create().name(groupName).build();
        try (Response response = realm.groups().add(group);){
            String groupId = ApiUtil.getCreatedId((Response)response);
            realm.users().get(userId).joinGroup(groupId);
            RoleMappingResource mappings = realm.groups().group(groupId).roles();
            mappings.realmLevel().add(Collections.singletonList(adminRole));
        }
        var9_9 = null;
        try (Keycloak userClient = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"master", (String)userName, (String)"pwd", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS());){
            org.junit.Assert.assertThat((Object)userClient.realms().findAll(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
    }

    @Test
    public void defaultMaxResults() {
        GroupsResource groups = this.adminClient.realms().realm("test").groups();
        try (Response response = groups.add(GroupBuilder.create().name("test").build());){
            String groupId = ApiUtil.getCreatedId((Response)response);
            GroupResource group = groups.group(groupId);
            UsersResource users = this.adminClient.realms().realm("test").users();
            for (int i = 0; i < 110; ++i) {
                try (Response r = users.create(UserBuilder.create().username("test-" + i).build());){
                    users.get(ApiUtil.getCreatedId((Response)r)).joinGroup(groupId);
                    continue;
                }
            }
            org.junit.Assert.assertEquals((long)100L, (long)group.members(null, null).size());
            org.junit.Assert.assertEquals((long)100L, (long)group.members().size());
            org.junit.Assert.assertEquals((long)105L, (long)group.members(Integer.valueOf(0), Integer.valueOf(105)).size());
            org.junit.Assert.assertEquals((long)110L, (long)group.members(Integer.valueOf(0), Integer.valueOf(1000)).size());
            org.junit.Assert.assertEquals((long)110L, (long)group.members(Integer.valueOf(-1), Integer.valueOf(-2)).size());
        }
    }

    @Test
    public void getGroupsWithFullRepresentation() {
        RealmResource realm = this.adminClient.realms().realm("test");
        GroupsResource groupsResource = this.adminClient.realms().realm("test").groups();
        GroupRepresentation group = new GroupRepresentation();
        group.setName("groupWithAttribute");
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        attributes.put("attribute1", Arrays.asList("attribute1", "attribute2"));
        group.setAttributes(attributes);
        group = this.createGroup(realm, group);
        List groups = groupsResource.groups("groupWithAttribute", Integer.valueOf(0), Integer.valueOf(20), false);
        org.junit.Assert.assertFalse((boolean)groups.isEmpty());
        org.junit.Assert.assertTrue((boolean)((GroupRepresentation)groups.get(0)).getAttributes().containsKey("attribute1"));
    }

    @Test
    public void getGroupsWithBriefRepresentation() {
        RealmResource realm = this.adminClient.realms().realm("test");
        GroupsResource groupsResource = this.adminClient.realms().realm("test").groups();
        GroupRepresentation group = new GroupRepresentation();
        group.setName("groupWithAttribute");
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        attributes.put("attribute1", Arrays.asList("attribute1", "attribute2"));
        group.setAttributes(attributes);
        group = this.createGroup(realm, group);
        List groups = groupsResource.groups("groupWithAttribute", Integer.valueOf(0), Integer.valueOf(20));
        org.junit.Assert.assertFalse((boolean)groups.isEmpty());
        org.junit.Assert.assertNull((Object)((GroupRepresentation)groups.get(0)).getAttributes());
    }

    @Test
    public void searchAndCountGroups() throws Exception {
        String firstGroupId = "";
        RealmResource realm = this.adminClient.realms().realm("test");
        for (GroupRepresentation group : realm.groups().groups()) {
            GroupResource resource = realm.groups().group(group.getId());
            resource.remove();
            this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.groupPath(group.getId()), ResourceType.GROUP);
        }
        for (int i = 0; i < 20; ++i) {
            GroupRepresentation group;
            group = new GroupRepresentation();
            group.setName("group" + i);
            group = this.createGroup(realm, group);
            if (i != 0) continue;
            firstGroupId = group.getId();
        }
        List allGroups = realm.groups().groups();
        org.junit.Assert.assertEquals((long)20L, (long)allGroups.size());
        List slice = realm.groups().groups(Integer.valueOf(5), Integer.valueOf(7));
        org.junit.Assert.assertEquals((long)7L, (long)slice.size());
        List search = realm.groups().groups("group1", Integer.valueOf(0), Integer.valueOf(20));
        org.junit.Assert.assertEquals((long)11L, (long)search.size());
        for (GroupRepresentation group : search) {
            org.junit.Assert.assertTrue((boolean)group.getName().contains("group1"));
        }
        List noResultSearch = realm.groups().groups("abcd", Integer.valueOf(0), Integer.valueOf(20));
        org.junit.Assert.assertEquals((long)0L, (long)noResultSearch.size());
        org.junit.Assert.assertEquals((Object)new Long(allGroups.size()), realm.groups().count().get("count"));
        org.junit.Assert.assertEquals((Object)new Long(search.size()), realm.groups().count("group1").get("count"));
        org.junit.Assert.assertEquals((Object)new Long(noResultSearch.size()), realm.groups().count("abcd").get("count"));
        GroupRepresentation level2Group = new GroupRepresentation();
        level2Group.setName("group1111");
        Response response = realm.groups().group(firstGroupId).subGroup(level2Group);
        response.close();
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupSubgroupsPath(firstGroupId), (Object)level2Group, ResourceType.GROUP);
        org.junit.Assert.assertEquals((Object)new Long(allGroups.size()), realm.groups().count(true).get("count"));
        org.junit.Assert.assertEquals((Object)new Long(allGroups.size() + 1), realm.groups().count(false).get("count"));
    }

    @Test
    public void orderGroupsByName() throws Exception {
        RealmResource realm = this.adminClient.realms().realm("test");
        for (GroupRepresentation group : realm.groups().groups()) {
            GroupResource resource = realm.groups().group(group.getId());
            resource.remove();
            this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.groupPath(group.getId()), ResourceType.GROUP);
        }
        ArrayList<GroupRepresentation> testGroups = new ArrayList<GroupRepresentation>();
        for (int i = 0; i < 40; ++i) {
            GroupRepresentation group = new GroupRepresentation();
            group.setName("group" + i);
            testGroups.add(group);
        }
        Collections.shuffle(testGroups);
        for (GroupRepresentation group : testGroups) {
            group = this.createGroup(realm, group);
        }
        Comparator<GroupRepresentation> compareByName = Comparator.comparing(GroupRepresentation::getName);
        List allGroups = realm.groups().groups();
        org.junit.Assert.assertEquals((long)40L, (long)allGroups.size());
        org.junit.Assert.assertTrue((boolean)Comparators.isInStrictOrder((Iterable)allGroups, compareByName));
        List firstPage = realm.groups().groups(Integer.valueOf(0), Integer.valueOf(20));
        org.junit.Assert.assertEquals((long)20L, (long)firstPage.size());
        org.junit.Assert.assertTrue((boolean)Comparators.isInStrictOrder((Iterable)firstPage, compareByName));
        List secondPage = realm.groups().groups(Integer.valueOf(20), Integer.valueOf(20));
        org.junit.Assert.assertEquals((long)20L, (long)secondPage.size());
        org.junit.Assert.assertTrue((boolean)Comparators.isInStrictOrder((Iterable)secondPage, compareByName));
        GroupRepresentation firstGroupOnSecondPage = (GroupRepresentation)secondPage.get(0);
        for (GroupRepresentation firstPageGroup : firstPage) {
            int comparisonResult = compareByName.compare(firstPageGroup, firstGroupOnSecondPage);
            org.junit.Assert.assertTrue((comparisonResult < 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBriefRepresentationOnGroupMembers() {
        RealmResource realm = this.adminClient.realms().realm("test");
        String groupName = "brief-grouptest-group";
        String userName = "brief-grouptest-user";
        GroupsResource groups = realm.groups();
        try (Response response = groups.add(GroupBuilder.create().name(groupName).build());){
            String groupId = ApiUtil.getCreatedId((Response)response);
            GroupResource group = groups.group(groupId);
            UsersResource users = realm.users();
            UserRepresentation userRepresentation = UserBuilder.create().username(userName).addAttribute("myattribute", "myvalue").build();
            Response r = users.create(userRepresentation);
            UserResource user = users.get(ApiUtil.getCreatedId((Response)r));
            user.joinGroup(groupId);
            UserRepresentation defaultRepresentation = (UserRepresentation)group.members(null, null).get(0);
            UserRepresentation fullRepresentation = (UserRepresentation)group.members(null, null, Boolean.valueOf(false)).get(0);
            UserRepresentation briefRepresentation = (UserRepresentation)group.members(null, null, Boolean.valueOf(true)).get(0);
            org.junit.Assert.assertEquals((String)"full group member representation includes attributes", (Object)fullRepresentation.getAttributes(), (Object)userRepresentation.getAttributes());
            org.junit.Assert.assertEquals((String)"default group member representation is full", (Object)defaultRepresentation.getAttributes(), (Object)userRepresentation.getAttributes());
            org.junit.Assert.assertNull((String)"brief group member representation omits attributes", (Object)briefRepresentation.getAttributes());
            group.remove();
            user.remove();
        }
    }

    @Test
    public void searchGroupsOnGroupHierarchies() throws Exception {
        RealmResource realm = this.adminClient.realms().realm("test");
        String searchFor = UUID.randomUUID().toString();
        GroupRepresentation g1 = new GroupRepresentation();
        g1.setName("g1");
        GroupRepresentation g1_1 = new GroupRepresentation();
        g1_1.setName("g1.1-" + searchFor);
        this.createGroup(realm, g1);
        this.addSubGroup(realm, g1, g1_1);
        GroupRepresentation expectedRootGroup = realm.groups().group(g1.getId()).toRepresentation();
        GroupRepresentation expectedChildGroup = realm.groups().group(g1_1.getId()).toRepresentation();
        List searchResultGroups = realm.groups().groups(searchFor, Integer.valueOf(0), Integer.valueOf(10));
        org.junit.Assert.assertFalse((boolean)searchResultGroups.isEmpty());
        org.junit.Assert.assertEquals((Object)expectedRootGroup.getId(), (Object)((GroupRepresentation)searchResultGroups.get(0)).getId());
        org.junit.Assert.assertEquals((Object)expectedRootGroup.getName(), (Object)((GroupRepresentation)searchResultGroups.get(0)).getName());
        List searchResultSubGroups = ((GroupRepresentation)searchResultGroups.get(0)).getSubGroups();
        org.junit.Assert.assertEquals((Object)expectedChildGroup.getId(), (Object)((GroupRepresentation)searchResultSubGroups.get(0)).getId());
        org.junit.Assert.assertEquals((Object)expectedChildGroup.getName(), (Object)((GroupRepresentation)searchResultSubGroups.get(0)).getName());
        searchResultSubGroups.remove(0);
        org.junit.Assert.assertTrue((boolean)searchResultSubGroups.isEmpty());
        searchResultGroups.remove(0);
        org.junit.Assert.assertTrue((boolean)searchResultGroups.isEmpty());
    }
}

