/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.event;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.AuthDetailsRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.event.AbstractEventTest;

public class AdminEventTest
extends AbstractEventTest {
    @Before
    public void initConfig() {
        this.enableEvents();
        this.testRealmResource().clearAdminEvents();
    }

    private List<AdminEventRepresentation> events() {
        return this.testRealmResource().getAdminEvents();
    }

    private String createUser(String username) {
        UserRepresentation user = AdminEventTest.createUserRepresentation(username, username + "@foo.com", "foo", "bar", true);
        String userId = ApiUtil.createUserWithAdminClient((RealmResource)this.testRealmResource(), (UserRepresentation)user);
        this.getCleanup().addUserId(userId);
        return userId;
    }

    private void updateRealm() {
        RealmRepresentation realm = this.testRealmResource().toRepresentation();
        realm.setDisplayName("Fury Road");
        this.testRealmResource().update(realm);
    }

    @Test
    public void clearAdminEventsTest() {
        this.createUser("user0");
        Assert.assertThat((Object)this.events().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        this.testRealmResource().clearAdminEvents();
        Assert.assertThat(this.events(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void adminEventAttributeTest() {
        this.createUser("user5");
        List<AdminEventRepresentation> events = this.events();
        Assert.assertThat((Object)this.events().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        AdminEventRepresentation event = events.get(0);
        Assert.assertThat((Object)event.getTime(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L))));
        Assert.assertThat((Object)event.getRealmId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.realmName())));
        Assert.assertThat((Object)event.getOperationType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"CREATE")));
        Assert.assertThat((Object)event.getResourcePath(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)event.getError(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        AuthDetailsRepresentation details = event.getAuthDetails();
        Assert.assertThat((Object)details.getRealmId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"master")));
        Assert.assertThat((Object)details.getClientId(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)details.getUserId(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)details.getIpAddress(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void retrieveAdminEventTest() {
        this.createUser("user1");
        List<AdminEventRepresentation> events = this.events();
        Assert.assertThat((Object)events.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        AdminEventRepresentation event = this.events().get(0);
        Assert.assertThat((Object)event.getOperationType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"CREATE")));
        Assert.assertThat((Object)event.getRealmId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.realmName())));
        Assert.assertThat((Object)event.getAuthDetails().getRealmId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"master")));
        Assert.assertThat((Object)event.getRepresentation(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testGetRepresentation() {
        this.configRep.setAdminEventsDetailsEnabled(Boolean.TRUE);
        this.saveConfig();
        this.createUser("user2");
        AdminEventRepresentation event = this.events().stream().filter(adminEventRep -> adminEventRep.getOperationType().equals("CREATE")).findFirst().orElseThrow(() -> new IllegalStateException("Wasn't able to obtain CREATE admin event."));
        Assert.assertThat((Object)event.getRepresentation(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)event.getRepresentation(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"foo"), (Matcher)Matchers.containsString((String)"bar")));
    }

    @Test
    public void testFilterAdminEvents() {
        this.createUser("user3");
        this.createUser("user4");
        this.updateRealm();
        Assert.assertThat((Object)this.events().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)3)));
        List events = this.testRealmResource().getAdminEvents(Arrays.asList("CREATE"), null, null, null, null, null, null, null, null, null);
        Assert.assertThat((Object)events.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)2)));
    }

    @Test
    public void defaultMaxResults() {
        RealmResource realm = this.adminClient.realms().realm("test");
        AdminEventRepresentation event = new AdminEventRepresentation();
        event.setOperationType(OperationType.CREATE.toString());
        event.setAuthDetails(new AuthDetailsRepresentation());
        event.setRealmId(realm.toRepresentation().getId());
        for (int i = 0; i < 110; ++i) {
            this.testingClient.testing("test").onAdminEvent(event, false);
        }
        Assert.assertThat((Object)realm.getAdminEvents(null, null, null, null, null, null, null, null, null, null).size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)100)));
        Assert.assertThat((Object)realm.getAdminEvents(null, null, null, null, null, null, null, null, Integer.valueOf(0), Integer.valueOf(105)).size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)105)));
        Assert.assertThat((Object)realm.getAdminEvents(null, null, null, null, null, null, null, null, Integer.valueOf(0), Integer.valueOf(1000)).size(), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(110))));
    }

    private void checkUpdateRealmEventsConfigEvent(int size) {
        List<AdminEventRepresentation> events = this.events();
        Assert.assertThat((Object)events.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)size)));
        AdminEventRepresentation event = this.events().get(0);
        Assert.assertThat((Object)event.getOperationType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"UPDATE")));
        Assert.assertThat((Object)event.getRealmId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.realmName())));
        Assert.assertThat((Object)event.getResourcePath(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"events/config")));
        Assert.assertThat((Object)event.getAuthDetails().getRealmId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"master")));
        Assert.assertThat((Object)event.getRepresentation(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void updateRealmEventsConfig() {
        this.configRep.setAdminEventsDetailsEnabled(Boolean.TRUE);
        this.configRep.setAdminEventsEnabled(Boolean.TRUE);
        this.saveConfig();
        this.checkUpdateRealmEventsConfigEvent(1);
        this.configRep.setEventsEnabled(Boolean.TRUE.booleanValue());
        this.saveConfig();
        this.checkUpdateRealmEventsConfigEvent(2);
        this.configRep.setAdminEventsEnabled(Boolean.FALSE);
        this.saveConfig();
        this.checkUpdateRealmEventsConfigEvent(3);
        this.configRep.setAdminEventsDetailsEnabled(Boolean.FALSE);
        this.saveConfig();
        Assert.assertThat((Object)this.events().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)3)));
    }
}

