/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.event;

import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.junit.After;
import org.junit.Before;
import org.junit.ComparisonFailure;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractAuthTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.AssertAdminEvents;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.testsuite.utils.tls.TLSUtils;

public class AdminEventAuthDetailsTest
extends AbstractAuthTest {
    @Rule
    public AssertAdminEvents assertAdminEvents = new AssertAdminEvents(this);
    private String masterAdminCliUuid;
    private String masterAdminUserId;
    private String masterAdminUser2Id;
    private String realmUuid;
    private String client1Uuid;
    private String adminCliUuid;
    private String admin1Id;
    private String admin2Id;
    private String appUserId;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmBuilder realm = RealmBuilder.create().name("test").testEventListener();
        this.client1Uuid = KeycloakModelUtils.generateId();
        realm.client(ClientBuilder.create().id(this.client1Uuid).clientId("client1").publicClient().directAccessGrants());
        this.admin1Id = KeycloakModelUtils.generateId();
        realm.user(UserBuilder.create().id(this.admin1Id).username("admin1").password("password").role("realm-management", AdminRoles.REALM_ADMIN));
        this.admin2Id = KeycloakModelUtils.generateId();
        realm.user(UserBuilder.create().id(this.admin2Id).username("admin2").password("password").role("realm-management", AdminRoles.REALM_ADMIN));
        this.appUserId = KeycloakModelUtils.generateId();
        realm.user(UserBuilder.create().id(this.appUserId).username("app-user").password("password"));
        testRealms.add(realm.build());
    }

    @Before
    public void initConfig() {
        RealmResource masterRealm = this.adminClient.realm("master");
        this.masterAdminCliUuid = ApiUtil.findClientByClientId((RealmResource)masterRealm, (String)"admin-cli").toRepresentation().getId();
        this.masterAdminUserId = ApiUtil.findUserByUsername((RealmResource)masterRealm, (String)"admin").getId();
        this.masterAdminUser2Id = ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)masterRealm, (UserRepresentation)UserBuilder.create().username("admin2").build(), (String)"password");
        masterRealm.users().get(this.masterAdminUser2Id).roles().realmLevel().add(Collections.singletonList(masterRealm.roles().get("admin").toRepresentation()));
        RealmResource testRealm = this.adminClient.realm("test");
        this.realmUuid = testRealm.toRepresentation().getId();
        this.adminCliUuid = ApiUtil.findClientByClientId((RealmResource)testRealm, (String)"admin-cli").toRepresentation().getId();
    }

    @After
    public void cleanUp() {
        this.adminClient.realm("master").users().get(this.masterAdminUser2Id).remove();
    }

    @Test
    public void testAuth() {
        this.testClient("master", "admin", "admin", "admin-cli", "master", this.masterAdminCliUuid, this.masterAdminUserId);
        this.testClient("master", "admin2", "password", "admin-cli", "master", this.masterAdminCliUuid, this.masterAdminUser2Id);
        this.testClient("test", "admin1", "password", "admin-cli", this.realmUuid, this.adminCliUuid, this.admin1Id);
        this.testClient("test", "admin2", "password", "admin-cli", this.realmUuid, this.adminCliUuid, this.admin2Id);
        this.testClient("test", "admin1", "password", "client1", this.realmUuid, this.client1Uuid, this.admin1Id);
        this.testClient("test", "admin2", "password", "client1", this.realmUuid, this.client1Uuid, this.admin2Id);
        try {
            this.testClient("test", "admin1", "password", "client1", this.realmUuid, this.adminCliUuid, this.admin1Id);
            Assert.fail((String)"Not expected to pass");
        }
        catch (ComparisonFailure comparisonFailure) {
            // empty catch block
        }
        try {
            this.testClient("test", "admin1", "password", "client1", this.realmUuid, this.client1Uuid, this.admin2Id);
            Assert.fail((String)"Not expected to pass");
        }
        catch (ComparisonFailure comparisonFailure) {
            // empty catch block
        }
    }

    private void testClient(String realmName, String username, String password, String clientId, String expectedRealmId, String expectedClientUuid, String expectedUserId) {
        try (Keycloak keycloak = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)realmName, (String)username, (String)password, (String)clientId, (SSLContext)TLSUtils.initializeTLS());){
            UserRepresentation rep = UserBuilder.create().id(this.appUserId).username("app-user").email("foo@email.org").build();
            keycloak.realm("test").users().get(this.appUserId).update(rep);
            this.assertAdminEvents.expect().realmId(this.realmUuid).operationType(OperationType.UPDATE).resourcePath(AdminEventPaths.userResourcePath(this.appUserId)).resourceType(ResourceType.USER).representation(rep).authDetails(expectedRealmId, expectedClientUuid, expectedUserId).assertEvent();
        }
    }
}

