/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.concurrency;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.Config;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.Retry;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.concurrency.AbstractConcurrencyTest;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.util.JsonSerialization;

public class ConcurrentLoginTest
extends AbstractConcurrencyTest {
    protected static final int DEFAULT_THREADS = 4;
    protected static final int CLIENTS_PER_THREAD = 30;
    protected static final int DEFAULT_CLIENTS_COUNT = 120;
    private String userSessionProvider;

    @Before
    public void beforeTest() {
        this.userSessionProvider = (String)this.testingClient.server().fetch((FetchOnServer & Serializable)session -> Config.getProvider((String)"userSessions"), String.class);
        this.createClients();
    }

    protected void createClients() {
        ClientsResource clients = this.adminClient.realm("test").clients();
        for (int i = 0; i < 120; ++i) {
            ClientRepresentation client = ClientBuilder.create().clientId("client" + i).directAccessGrants().redirectUris("*").addWebOrigin("*").secret("password").build();
            Response create = clients.create(client);
            String clientId = ApiUtil.getCreatedId((Response)create);
            create.close();
            this.getCleanup("test").addClientUuid(clientId);
            this.log.debugf("created %s [uuid=%s]", (Object)client.getClientId(), (Object)clientId);
        }
        this.log.debug((Object)"clients created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void concurrentLoginSingleUser() throws Throwable {
        Assume.assumeThat((String)"Test runs only with InfinispanUserSessionProvider", (Object)this.userSessionProvider, (Matcher)Matchers.is((Object)"infinispan"));
        this.log.info((Object)"*********************************************");
        long start = System.currentTimeMillis();
        AtomicReference<String> userSessionId = new AtomicReference<String>();
        LoginTask loginTask = null;
        try (CloseableHttpClient httpClient = this.getHttpsAwareClient();){
            loginTask = new LoginTask(httpClient, userSessionId, 100, 1, false, Arrays.asList(this.createHttpClientContextForUser(httpClient, "test-user@localhost", "password")));
            this.run(4, 120, loginTask);
            int clientSessionsCount = this.testingClient.testing().getClientSessionsCountInUserSession("test", userSessionId.get());
            Assert.assertEquals((long)121L, (long)clientSessionsCount);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis() - start;
            this.log.infof("Statistics: %s", loginTask == null ? "??" : loginTask.getHistogram());
            this.log.info((Object)("concurrentLoginSingleUser took " + end / 1000L + "s"));
            this.log.info((Object)"*********************************************");
            throw throwable;
        }
        long end = System.currentTimeMillis() - start;
        this.log.infof("Statistics: %s", loginTask == null ? "??" : loginTask.getHistogram());
        this.log.info((Object)("concurrentLoginSingleUser took " + end / 1000L + "s"));
        this.log.info((Object)"*********************************************");
    }

    protected CloseableHttpClient getHttpsAwareClient() {
        HttpClientBuilder builder = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        if (ServerURLs.AUTH_SERVER_SSL_REQUIRED) {
            builder.setSSLHostnameVerifier((s, sslSession) -> true);
        }
        return builder.build();
    }

    protected HttpClientContext createHttpClientContextForUser(CloseableHttpClient httpClient, String userName, String password) throws IOException {
        HttpClientContext context = HttpClientContext.create();
        BasicCookieStore cookieStore = new BasicCookieStore();
        context.setCookieStore((CookieStore)cookieStore);
        HttpUriRequest request = this.handleLogin(this.getPageContent(this.oauth.getLoginFormUrl(), httpClient, context), userName, password);
        Assert.assertThat((Object)this.parseAndCloseResponse(httpClient.execute(request, (HttpContext)context)), (Matcher)Matchers.containsString((String)"<title>AUTH_RESPONSE</title>"));
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void concurrentLoginSingleUserSingleClient() throws Throwable {
        this.log.info((Object)"*********************************************");
        long start = System.currentTimeMillis();
        AtomicReference<String> userSessionId = new AtomicReference<String>();
        LoginTask loginTask = null;
        try (CloseableHttpClient httpClient = this.getHttpsAwareClient();){
            loginTask = new LoginTask(httpClient, userSessionId, 100, 1, true, Arrays.asList(this.createHttpClientContextForUser(httpClient, "test-user@localhost", "password")));
            this.run(4, 120, loginTask);
            int clientSessionsCount = this.testingClient.testing().getClientSessionsCountInUserSession("test", userSessionId.get());
            Assert.assertEquals((long)2L, (long)clientSessionsCount);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis() - start;
            this.log.infof("Statistics: %s", loginTask == null ? "??" : loginTask.getHistogram());
            this.log.info((Object)("concurrentLoginSingleUserSingleClient took " + end / 1000L + "s"));
            this.log.info((Object)"*********************************************");
            throw throwable;
        }
        long end = System.currentTimeMillis() - start;
        this.log.infof("Statistics: %s", loginTask == null ? "??" : loginTask.getHistogram());
        this.log.info((Object)("concurrentLoginSingleUserSingleClient took " + end / 1000L + "s"));
        this.log.info((Object)"*********************************************");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void concurrentLoginMultipleUsers() throws Throwable {
        Assume.assumeThat((String)"Test runs only with InfinispanUserSessionProvider", (Object)this.userSessionProvider, (Matcher)Matchers.is((Object)"infinispan"));
        this.log.info((Object)"*********************************************");
        long start = System.currentTimeMillis();
        AtomicReference<String> userSessionId = new AtomicReference<String>();
        LoginTask loginTask = null;
        try (CloseableHttpClient httpClient = this.getHttpsAwareClient();){
            loginTask = new LoginTask(httpClient, userSessionId, 100, 1, false, Arrays.asList(this.createHttpClientContextForUser(httpClient, "test-user@localhost", "password"), this.createHttpClientContextForUser(httpClient, "john-doh@localhost", "password"), this.createHttpClientContextForUser(httpClient, "roleRichUser", "password")));
            this.run(4, 120, loginTask);
            int clientSessionsCount = this.testingClient.testing().getClientSessionsCountInUserSession("test", userSessionId.get());
            Assert.assertEquals((long)41L, (long)clientSessionsCount);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis() - start;
            this.log.infof("Statistics: %s", loginTask == null ? "??" : loginTask.getHistogram());
            this.log.info((Object)("concurrentLoginMultipleUsers took " + end / 1000L + "s"));
            this.log.info((Object)"*********************************************");
            throw throwable;
        }
        long end = System.currentTimeMillis() - start;
        this.log.infof("Statistics: %s", loginTask == null ? "??" : loginTask.getHistogram());
        this.log.info((Object)("concurrentLoginMultipleUsers took " + end / 1000L + "s"));
        this.log.info((Object)"*********************************************");
    }

    @Test
    public void concurrentCodeReuseShouldFail() throws Throwable {
        this.log.info((Object)"*********************************************");
        long start = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            final OAuthClient oauth1 = new OAuthClient();
            oauth1.init(this.driver);
            oauth1.clientId("client0");
            OAuthClient.AuthorizationEndpointResponse resp = oauth1.doLogin("test-user@localhost", "password");
            final String code = resp.getCode();
            Assert.assertNotNull((Object)code);
            final String codeURL = this.driver.getCurrentUrl();
            final AtomicInteger codeToTokenSuccessCount = new AtomicInteger(0);
            final AtomicInteger codeToTokenErrorsCount = new AtomicInteger(0);
            AbstractConcurrencyTest.KeycloakRunnable codeToTokenTask = new AbstractConcurrencyTest.KeycloakRunnable(){

                @Override
                public void run(int threadIndex, Keycloak keycloak, RealmResource realm) throws Throwable {
                    ConcurrentLoginTest.this.log.infof("Trying to execute codeURL: %s, threadIndex: %d", (Object)codeURL, (Object)threadIndex);
                    OAuthClient.AccessTokenResponse resp = oauth1.doAccessTokenRequest(code, "password");
                    if (resp.getAccessToken() != null && resp.getError() == null) {
                        codeToTokenSuccessCount.incrementAndGet();
                    } else if (resp.getAccessToken() == null && resp.getError() != null) {
                        codeToTokenErrorsCount.incrementAndGet();
                    }
                }
            };
            this.run(4, 4, codeToTokenTask);
            oauth1.openLogout();
            Assert.assertThat((Object)codeToTokenSuccessCount.get(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(1)));
            Assert.assertThat((Object)codeToTokenErrorsCount.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(3)));
            this.log.infof("Iteration %d passed successfully", (Object)i);
        }
        long end = System.currentTimeMillis() - start;
        this.log.info((Object)("concurrentCodeReuseShouldFail took " + end / 1000L + "s"));
        this.log.info((Object)"*********************************************");
    }

    protected String getPageContent(String url, CloseableHttpClient httpClient, HttpClientContext context) throws IOException {
        HttpGet request = new HttpGet(url);
        request.setHeader("User-Agent", "Mozilla/5.0");
        request.setHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        request.setHeader("Accept-Language", "en-US,en;q=0.5");
        return this.parseAndCloseResponse(httpClient.execute((HttpUriRequest)request, (HttpContext)context));
    }

    protected String parseAndCloseResponse(CloseableHttpResponse response) {
        try {
            int responseCode = response.getStatusLine().getStatusCode();
            String resp = EntityUtils.toString((HttpEntity)response.getEntity());
            if (responseCode != 200) {
                this.log.debugf("Response Code: %d, Body: %s", responseCode, (Object)resp);
            }
            String string = resp;
            return string;
        }
        catch (IOException | UnsupportedOperationException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected HttpUriRequest handleLogin(String html, String username, String password) throws UnsupportedEncodingException {
        boolean isPost;
        this.log.debug((Object)"Extracting form's data...");
        Element loginform = Jsoup.parse((String)html).getElementById("kc-form-login");
        String method = loginform.attr("method");
        String action = loginform.attr("action");
        ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
        for (Element inputElement : loginform.getElementsByTag("input")) {
            String key = inputElement.attr("name");
            if (key.equals("username")) {
                paramList.add(new BasicNameValuePair(key, username));
                continue;
            }
            if (!key.equals("password")) continue;
            paramList.add(new BasicNameValuePair(key, password));
        }
        boolean bl = isPost = method != null && "post".equalsIgnoreCase(method);
        if (isPost) {
            UrlEncodedFormEntity formEntity;
            HttpPost req = new HttpPost(action);
            try {
                formEntity = new UrlEncodedFormEntity(paramList, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            req.setEntity((HttpEntity)formEntity);
            return req;
        }
        throw new UnsupportedOperationException("not supported yet!");
    }

    private static Map<String, String> getQueryFromUrl(String url) throws URISyntaxException {
        return URLEncodedUtils.parse((URI)new URI(url), (String)"UTF-8").stream().collect(Collectors.toMap(p -> p.getName(), p -> p.getValue()));
    }

    public class LoginTask
    implements AbstractConcurrencyTest.KeycloakRunnable {
        private final AtomicInteger clientIndex = new AtomicInteger();
        private final ThreadLocal<OAuthClient> oauthClient = new ThreadLocal<OAuthClient>(){

            @Override
            protected OAuthClient initialValue() {
                OAuthClient oauth1 = new OAuthClient();
                oauth1.init(ConcurrentLoginTest.this.driver);
                oauth1.stateParamHardcoded(KeycloakModelUtils.generateId());
                oauth1.nonce(KeycloakModelUtils.generateId());
                oauth1.redirectUri(ConcurrentLoginTest.this.oauth.getRedirectUri() + "?some=" + new Random().nextInt(1024));
                return oauth1;
            }
        };
        private final CloseableHttpClient httpClient;
        private final AtomicReference<String> userSessionId;
        private final int retryDelayMs;
        private final int retryCount;
        private final AtomicInteger[] retryHistogram;
        private final AtomicInteger totalInvocations = new AtomicInteger();
        private final boolean sameClient;
        private final List<HttpClientContext> clientContexts;

        public LoginTask(CloseableHttpClient httpClient, AtomicReference<String> userSessionId, int retryDelayMs, int retryCount, boolean sameClient, List<HttpClientContext> clientContexts) {
            this.httpClient = httpClient;
            this.userSessionId = userSessionId;
            this.retryDelayMs = retryDelayMs;
            this.retryCount = retryCount;
            this.retryHistogram = new AtomicInteger[retryCount];
            for (int i = 0; i < this.retryHistogram.length; ++i) {
                this.retryHistogram[i] = new AtomicInteger();
            }
            this.sameClient = sameClient;
            this.clientContexts = clientContexts;
        }

        @Override
        public void run(int threadIndex, Keycloak keycloak, RealmResource realm) throws Throwable {
            int i = this.sameClient ? 0 : this.clientIndex.getAndIncrement();
            OAuthClient oauth1 = this.oauthClient.get();
            oauth1.clientId("client" + i);
            ConcurrentLoginTest.this.log.infof("%d [%s]: Accessing login page for %s", (Object)threadIndex, (Object)Thread.currentThread().getName(), (Object)oauth1.getClientId());
            HttpClientContext templateContext = this.clientContexts.get(i % this.clientContexts.size());
            HttpClientContext context = HttpClientContext.create();
            context.setCookieStore(templateContext.getCookieStore());
            String pageContent = ConcurrentLoginTest.this.getPageContent(oauth1.getLoginFormUrl(), this.httpClient, context);
            Assert.assertThat((Object)pageContent, (Matcher)Matchers.containsString((String)"<title>AUTH_RESPONSE</title>"));
            Assert.assertThat((Object)context.getRedirectLocations(), (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)context.getRedirectLocations(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
            String currentUrl = ((URI)context.getRedirectLocations().get(0)).toString();
            Map query = ConcurrentLoginTest.getQueryFromUrl(currentUrl);
            String code = (String)query.get("code");
            String state = (String)query.get("state");
            Assert.assertEquals((String)"Invalid state.", (Object)state, (Object)oauth1.getState());
            AtomicReference<OAuthClient.AccessTokenResponse> accessResRef = new AtomicReference<OAuthClient.AccessTokenResponse>();
            this.totalInvocations.incrementAndGet();
            OAuthClient.AccessTokenResponse accessRes = oauth1.doAccessTokenRequest(code, "password");
            Assert.assertEquals((String)("AccessTokenResponse: client: " + oauth1.getClientId() + ", error: '" + accessRes.getError() + "' desc: '" + accessRes.getErrorDescription() + "'"), (long)200L, (long)accessRes.getStatusCode());
            accessResRef.set(accessRes);
            AtomicReference refreshResRef = new AtomicReference();
            int invocationIndex = Retry.execute(() -> {
                OAuthClient.AccessTokenResponse refreshRes = oauth1.doRefreshTokenRequest(((OAuthClient.AccessTokenResponse)accessResRef.get()).getRefreshToken(), "password");
                Assert.assertEquals((String)("AccessTokenResponse: client: " + oauth1.getClientId() + ", error: '" + refreshRes.getError() + "' desc: '" + refreshRes.getErrorDescription() + "'"), (long)200L, (long)refreshRes.getStatusCode());
                refreshResRef.set(refreshRes);
            }, (int)this.retryCount, (long)this.retryDelayMs);
            this.retryHistogram[invocationIndex].incrementAndGet();
            AccessToken token = (AccessToken)JsonSerialization.readValue((byte[])new JWSInput(((OAuthClient.AccessTokenResponse)accessResRef.get()).getAccessToken()).getContent(), AccessToken.class);
            Assert.assertEquals((String)"Invalid nonce.", (Object)token.getNonce(), (Object)oauth1.getNonce());
            AccessToken refreshedToken = (AccessToken)JsonSerialization.readValue((byte[])new JWSInput(((OAuthClient.AccessTokenResponse)refreshResRef.get()).getAccessToken()).getContent(), AccessToken.class);
            Assert.assertEquals((String)"Invalid nonce.", (Object)refreshedToken.getNonce(), (Object)oauth1.getNonce());
            if (this.userSessionId.get() == null) {
                this.userSessionId.set(token.getSessionState());
            }
        }

        public int getRetryDelayMs() {
            return this.retryDelayMs;
        }

        public int getRetryCount() {
            return this.retryCount;
        }

        public Map<Integer, Integer> getHistogram() {
            LinkedHashMap<Integer, Integer> res = new LinkedHashMap<Integer, Integer>(this.retryCount);
            for (int i = 0; i < this.retryHistogram.length; ++i) {
                AtomicInteger item = this.retryHistogram[i];
                res.put(i * this.retryDelayMs, item.get());
            }
            return res;
        }
    }
}

