/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.PolicyResource;
import org.keycloak.admin.client.resource.UserPoliciesResource;
import org.keycloak.admin.client.resource.UserPolicyResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.testsuite.admin.client.authorization.AbstractPolicyManagementTest;
import org.keycloak.testsuite.arquillian.annotation.UncaughtServerErrorExpected;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public class UserPolicyManagementTest
extends AbstractPolicyManagementTest {
    @Override
    protected RealmBuilder createTestRealm() {
        return super.createTestRealm().user(UserBuilder.create().username("User A")).user(UserBuilder.create().username("User B")).user(UserBuilder.create().username("User C")).user(UserBuilder.create().username("User D")).user(UserBuilder.create().username("User E")).user(UserBuilder.create().username("User F"));
    }

    @Test
    public void testCreate() {
        AuthorizationResource authorization = this.getClient().authorization();
        UserPolicyRepresentation representation = new UserPolicyRepresentation();
        representation.setName("Realm User Policy");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.addUser("User A");
        representation.addUser("User B");
        this.assertCreated(authorization, representation);
    }

    @Test
    public void testUpdate() {
        AuthorizationResource authorization = this.getClient().authorization();
        UserPolicyRepresentation representation = new UserPolicyRepresentation();
        representation.setName("Update Test User Policy");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.addUser("User A");
        representation.addUser("User B");
        representation.addUser("User C");
        this.assertCreated(authorization, representation);
        representation.setName("changed");
        representation.setDescription("changed");
        representation.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        representation.setLogic(Logic.POSITIVE);
        representation.setUsers(representation.getUsers().stream().filter(userName -> !userName.equals("User A")).collect(Collectors.toSet()));
        UserPoliciesResource policies = authorization.policies().user();
        UserPolicyResource permission = policies.findById(representation.getId());
        permission.update(representation);
        this.assertRepresentation(representation, permission);
        representation.setUsers(representation.getUsers().stream().filter(userName -> !userName.equals("User C")).collect(Collectors.toSet()));
        permission.update(representation);
        this.assertRepresentation(representation, permission);
    }

    @Test
    public void testDelete() {
        AuthorizationResource authorization = this.getClient().authorization();
        UserPolicyRepresentation representation = new UserPolicyRepresentation();
        representation.setName("Test Delete Permission");
        representation.addUser("User A");
        UserPoliciesResource policies = authorization.policies().user();
        try (Response response = policies.create(representation);){
            UserPolicyRepresentation created = (UserPolicyRepresentation)response.readEntity(UserPolicyRepresentation.class);
            policies.findById(created.getId()).remove();
            UserPolicyResource removed = policies.findById(created.getId());
            try {
                removed.toRepresentation();
                Assert.fail((String)"Permission not removed");
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testDeleteUser() {
        AuthorizationResource authorization = this.getClient().authorization();
        UserPolicyRepresentation representation = new UserPolicyRepresentation();
        representation.setName("Realm User Policy");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.addUser("User D");
        representation.addUser("User E");
        representation.addUser("User F");
        this.assertCreated(authorization, representation);
        UsersResource users = this.getRealm().users();
        UserRepresentation user = (UserRepresentation)users.search("User D").get(0);
        users.get(user.getId()).remove();
        representation = authorization.policies().user().findById(representation.getId()).toRepresentation();
        Assert.assertEquals((long)2L, (long)representation.getUsers().size());
        Assert.assertFalse((boolean)representation.getUsers().contains(user.getId()));
        user = (UserRepresentation)users.search("User E").get(0);
        users.get(user.getId()).remove();
        representation = authorization.policies().user().findById(representation.getId()).toRepresentation();
        Assert.assertEquals((long)1L, (long)representation.getUsers().size());
        Assert.assertFalse((boolean)representation.getUsers().contains(user.getId()));
        user = (UserRepresentation)users.search("User F").get(0);
        users.get(user.getId()).remove();
        try {
            authorization.policies().user().findById(representation.getId()).toRepresentation();
            Assert.fail((String)"User policy should be removed");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGenericConfig() {
        AuthorizationResource authorization = this.getClient().authorization();
        UserPolicyRepresentation representation = new UserPolicyRepresentation();
        representation.setName("Test Generic Config Permission");
        representation.addUser("User A");
        UserPoliciesResource policies = authorization.policies().user();
        try (Response response = policies.create(representation);){
            UserPolicyRepresentation created = (UserPolicyRepresentation)response.readEntity(UserPolicyRepresentation.class);
            PolicyResource policy = authorization.policies().policy(created.getId());
            PolicyRepresentation genericConfig = policy.toRepresentation();
            Assert.assertNotNull((Object)genericConfig.getConfig());
            Assert.assertNotNull(genericConfig.getConfig().get("users"));
            UserRepresentation user = (UserRepresentation)this.getRealm().users().search("User A").get(0);
            Assert.assertTrue((boolean)((String)genericConfig.getConfig().get("users")).contains(user.getId()));
        }
    }

    @Test
    @UncaughtServerErrorExpected
    public void failInvalidUser() {
        AuthorizationResource authorization = this.getClient().authorization();
        PolicyRepresentation policy = new PolicyRepresentation();
        policy.setName("User Policy-Malformed");
        policy.setDescription("Description of a malformed user Policy");
        policy.setDecisionStrategy(DecisionStrategy.UNANIMOUS);
        policy.setType("user");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("users", "[\"doesnotexist\"]");
        policy.setConfig(config);
        try (Response response = authorization.policies().create(policy);){
            Assert.assertEquals((Object)Response.Status.INTERNAL_SERVER_ERROR, (Object)response.getStatusInfo());
        }
        config.put("users", "");
        policy.setConfig(config);
        response = authorization.policies().create(policy);
        var5_5 = null;
        try {
            Assert.assertEquals((Object)Response.Status.INTERNAL_SERVER_ERROR, (Object)response.getStatusInfo());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (response != null) {
                if (var5_5 != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    response.close();
                }
            }
        }
        config.clear();
        policy.setConfig(config);
        response = authorization.policies().create(policy);
        var5_5 = null;
        try {
            Assert.assertEquals((Object)Response.Status.INTERNAL_SERVER_ERROR, (Object)response.getStatusInfo());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (response != null) {
                if (var5_5 != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    response.close();
                }
            }
        }
    }

    private void assertCreated(AuthorizationResource authorization, UserPolicyRepresentation representation) {
        UserPoliciesResource permissions = authorization.policies().user();
        try (Response response = permissions.create(representation);){
            UserPolicyRepresentation created = (UserPolicyRepresentation)response.readEntity(UserPolicyRepresentation.class);
            UserPolicyResource permission = permissions.findById(created.getId());
            this.assertRepresentation(representation, permission);
        }
    }

    private void assertRepresentation(UserPolicyRepresentation representation, UserPolicyResource permission) {
        UserPolicyRepresentation actual = permission.toRepresentation();
        this.assertRepresentation((AbstractPolicyRepresentation)representation, (AbstractPolicyRepresentation)actual, () -> permission.resources(), () -> Collections.emptyList(), () -> permission.associatedPolicies());
        Assert.assertEquals((long)representation.getUsers().size(), (long)actual.getUsers().size());
        Assert.assertEquals((long)0L, (long)actual.getUsers().stream().filter(userId -> !representation.getUsers().stream().filter(userName -> this.getUserName((String)userId).equalsIgnoreCase((String)userName)).findFirst().isPresent()).count());
    }

    private String getUserName(String id) {
        return this.getRealm().users().get(id).toRepresentation().getUsername();
    }
}

