/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.util.Collections;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.TimePoliciesResource;
import org.keycloak.admin.client.resource.TimePolicyResource;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.TimePolicyRepresentation;
import org.keycloak.testsuite.admin.client.authorization.AbstractPolicyManagementTest;

public class TimePolicyManagementTest
extends AbstractPolicyManagementTest {
    @Test
    public void testCreate() {
        AuthorizationResource authorization = this.getClient().authorization();
        this.assertCreated(authorization, this.createRepresentation("Time Policy"));
    }

    @Test
    public void testUpdate() {
        AuthorizationResource authorization = this.getClient().authorization();
        TimePolicyRepresentation representation = this.createRepresentation("Update Time Policy");
        this.assertCreated(authorization, representation);
        representation.setName("changed");
        representation.setDescription("changed");
        representation.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        representation.setLogic(Logic.POSITIVE);
        representation.setDayMonth("11");
        representation.setDayMonthEnd("22");
        representation.setMonth("7");
        representation.setMonthEnd("9");
        representation.setYear("2019");
        representation.setYearEnd("2030");
        representation.setHour("15");
        representation.setHourEnd("23");
        representation.setMinute("55");
        representation.setMinuteEnd("58");
        representation.setNotBefore("2019-01-01 00:00:00");
        representation.setNotOnOrAfter("2019-02-03 00:00:00");
        TimePoliciesResource policies = authorization.policies().time();
        TimePolicyResource permission = policies.findById(representation.getId());
        permission.update(representation);
        this.assertRepresentation(representation, permission);
        representation.setDayMonth(null);
        representation.setDayMonthEnd(null);
        representation.setMonth(null);
        representation.setMonthEnd(null);
        representation.setYear(null);
        representation.setYearEnd(null);
        representation.setHour(null);
        representation.setHourEnd(null);
        representation.setMinute(null);
        representation.setMinuteEnd(null);
        representation.setNotBefore(null);
        representation.setNotOnOrAfter("2019-02-03 00:00:00");
        permission.update(representation);
        this.assertRepresentation(representation, permission);
        representation.setNotOnOrAfter(null);
        representation.setHour("2");
        permission.update(representation);
        this.assertRepresentation(representation, permission);
    }

    @Test
    public void testDelete() {
        AuthorizationResource authorization = this.getClient().authorization();
        TimePolicyRepresentation representation = this.createRepresentation("Test Delete Policy");
        TimePoliciesResource policies = authorization.policies().time();
        try (Response response = policies.create(representation);){
            TimePolicyRepresentation created = (TimePolicyRepresentation)response.readEntity(TimePolicyRepresentation.class);
            policies.findById(created.getId()).remove();
            TimePolicyResource removed = policies.findById(created.getId());
            try {
                removed.toRepresentation();
                Assert.fail((String)"Permission not removed");
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    private TimePolicyRepresentation createRepresentation(String name) {
        TimePolicyRepresentation representation = new TimePolicyRepresentation();
        representation.setName(name);
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.setDayMonth("1");
        representation.setDayMonthEnd("2");
        representation.setMonth("3");
        representation.setMonthEnd("4");
        representation.setYear("5");
        representation.setYearEnd("6");
        representation.setHour("7");
        representation.setHourEnd("8");
        representation.setMinute("9");
        representation.setMinuteEnd("10");
        representation.setNotBefore("2017-01-01 00:00:00");
        representation.setNotOnOrAfter("2017-02-01 00:00:00");
        return representation;
    }

    private void assertCreated(AuthorizationResource authorization, TimePolicyRepresentation representation) {
        TimePoliciesResource permissions = authorization.policies().time();
        try (Response response = permissions.create(representation);){
            TimePolicyRepresentation created = (TimePolicyRepresentation)response.readEntity(TimePolicyRepresentation.class);
            TimePolicyResource permission = permissions.findById(created.getId());
            this.assertRepresentation(representation, permission);
        }
    }

    private void assertRepresentation(TimePolicyRepresentation representation, TimePolicyResource permission) {
        TimePolicyRepresentation actual = permission.toRepresentation();
        this.assertRepresentation((AbstractPolicyRepresentation)representation, (AbstractPolicyRepresentation)actual, () -> permission.resources(), () -> Collections.emptyList(), () -> permission.associatedPolicies());
        Assert.assertEquals((Object)representation.getDayMonth(), (Object)actual.getDayMonth());
        Assert.assertEquals((Object)representation.getDayMonthEnd(), (Object)actual.getDayMonthEnd());
        Assert.assertEquals((Object)representation.getMonth(), (Object)actual.getMonth());
        Assert.assertEquals((Object)representation.getMonthEnd(), (Object)actual.getMonthEnd());
        Assert.assertEquals((Object)representation.getYear(), (Object)actual.getYear());
        Assert.assertEquals((Object)representation.getYearEnd(), (Object)actual.getYearEnd());
        Assert.assertEquals((Object)representation.getHour(), (Object)actual.getHour());
        Assert.assertEquals((Object)representation.getHourEnd(), (Object)actual.getHourEnd());
        Assert.assertEquals((Object)representation.getMinute(), (Object)actual.getMinute());
        Assert.assertEquals((Object)representation.getMinuteEnd(), (Object)actual.getMinuteEnd());
        Assert.assertEquals((Object)representation.getNotBefore(), (Object)actual.getNotBefore());
        Assert.assertEquals((Object)representation.getNotOnOrAfter(), (Object)actual.getNotOnOrAfter());
    }
}

