/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ScopePermissionResource;
import org.keycloak.admin.client.resource.ScopePermissionsResource;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.testsuite.admin.client.authorization.AbstractPolicyManagementTest;

public class ScopePermissionManagementTest
extends AbstractPolicyManagementTest {
    @Test
    public void testCreateResourceScopePermission() {
        AuthorizationResource authorization = this.getClient().authorization();
        ScopePermissionRepresentation representation = new ScopePermissionRepresentation();
        representation.setName("Resource  A Scope Permission");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.addResource("Resource A");
        representation.addScope(new String[]{"read", "execute"});
        representation.addPolicy(new String[]{"Only Marta Policy", "Only Kolo Policy"});
        this.assertCreated(authorization, representation);
    }

    @Test
    public void testCreateScopePermission() {
        AuthorizationResource authorization = this.getClient().authorization();
        ScopePermissionRepresentation representation = new ScopePermissionRepresentation();
        representation.setName("Read Permission");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.addScope(new String[]{"read", "write"});
        representation.addPolicy(new String[]{"Only Marta Policy"});
        this.assertCreated(authorization, representation);
    }

    @Test
    public void testUpdate() {
        AuthorizationResource authorization = this.getClient().authorization();
        ScopePermissionRepresentation representation = new ScopePermissionRepresentation();
        representation.setName("Update Test Scope Permission");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.addResource("Resource A");
        representation.addScope(new String[]{"read", "execute"});
        representation.addPolicy(new String[]{"Only Marta Policy", "Only Kolo Policy"});
        this.assertCreated(authorization, representation);
        representation.setName("changed");
        representation.setDescription("changed");
        representation.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        representation.setLogic(Logic.POSITIVE);
        representation.getResources().remove("Resource A");
        representation.addResource("Resource B");
        representation.getScopes().remove("execute");
        representation.getPolicies().remove("Only Marta Policy");
        ScopePermissionsResource permissions = authorization.permissions().scope();
        ScopePermissionResource permission = permissions.findById(representation.getId());
        permission.update(representation);
        this.assertRepresentation(representation, permission);
    }

    @Test
    public void testDelete() {
        AuthorizationResource authorization = this.getClient().authorization();
        ScopePermissionRepresentation representation = new ScopePermissionRepresentation();
        representation.setName("Test Delete Permission");
        representation.addScope(new String[]{"execute"});
        representation.addPolicy(new String[]{"Only Marta Policy"});
        this.assertCreated(authorization, representation);
        ScopePermissionsResource permissions = authorization.permissions().scope();
        permissions.findById(representation.getId()).remove();
        ScopePermissionResource removed = permissions.findById(representation.getId());
        try {
            removed.toRepresentation();
            Assert.fail((String)"Permission not removed");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void failCreateWithSameName() {
        AuthorizationResource authorization = this.getClient().authorization();
        ScopePermissionRepresentation permission1 = new ScopePermissionRepresentation();
        permission1.setName("Conflicting Name Permission");
        permission1.addScope(new String[]{"read"});
        permission1.addPolicy(new String[]{"Only Marta Policy"});
        ScopePermissionsResource permissions = authorization.permissions().scope();
        permissions.create(permission1).close();
        ScopePermissionRepresentation permission2 = new ScopePermissionRepresentation();
        permission2.setName(permission1.getName());
        try (Response response = permissions.create(permission2);){
            Assert.assertEquals((long)Response.Status.CONFLICT.getStatusCode(), (long)response.getStatus());
        }
    }

    private void assertCreated(AuthorizationResource authorization, ScopePermissionRepresentation representation) {
        ScopePermissionsResource permissions = authorization.permissions().scope();
        try (Response response = permissions.create(representation);){
            ScopePermissionRepresentation created = (ScopePermissionRepresentation)response.readEntity(ScopePermissionRepresentation.class);
            ScopePermissionResource permission = permissions.findById(created.getId());
            this.assertRepresentation(representation, permission);
        }
    }

    private void assertRepresentation(ScopePermissionRepresentation representation, ScopePermissionResource permission) {
        this.assertRepresentation((AbstractPolicyRepresentation)representation, (AbstractPolicyRepresentation)permission.toRepresentation(), () -> permission.resources(), () -> permission.scopes(), () -> permission.associatedPolicies());
    }
}

