/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.util.List;
import java.util.UUID;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.ResourceScopeResource;
import org.keycloak.admin.client.resource.ResourcesResource;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.testsuite.admin.client.authorization.AbstractAuthorizationTest;

public class ScopeManagementTest
extends AbstractAuthorizationTest {
    @Test
    public void testCreate() {
        ScopeRepresentation newScope = this.createDefaultScope().toRepresentation();
        Assert.assertEquals((Object)"Test Scope", (Object)newScope.getName());
        Assert.assertEquals((Object)"Scope Icon", (Object)newScope.getIconUri());
    }

    @Test
    public void testUpdate() {
        ResourceScopeResource scopeResource = this.createDefaultScope();
        ScopeRepresentation scope = scopeResource.toRepresentation();
        scope.setName("changed");
        scope.setIconUri("changed");
        scopeResource.update(scope);
        scope = scopeResource.toRepresentation();
        Assert.assertEquals((Object)"changed", (Object)scope.getName());
        Assert.assertEquals((Object)"changed", (Object)scope.getIconUri());
    }

    @Test
    public void testNotUpdateOnResourceUpdate() {
        ResourceRepresentation resource;
        ResourceScopeResource scopeResource = this.createDefaultScope();
        ScopeRepresentation scope = scopeResource.toRepresentation();
        scope.setName("changed");
        scope.setDisplayName("changed");
        scope.setIconUri("changed");
        scopeResource.update(scope);
        scope = scopeResource.toRepresentation();
        Assert.assertEquals((Object)"changed", (Object)scope.getName());
        Assert.assertEquals((Object)"changed", (Object)scope.getDisplayName());
        Assert.assertEquals((Object)"changed", (Object)scope.getIconUri());
        ResourcesResource resources = this.getClientResource().authorization().resources();
        try (Response response = resources.create(new ResourceRepresentation(UUID.randomUUID().toString(), new String[]{scope.getName()}));){
            resource = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        }
        ((ScopeRepresentation)resource.getScopes().iterator().next()).setDisplayName(null);
        resources.resource(resource.getId()).update(resource);
        scope = scopeResource.toRepresentation();
        Assert.assertEquals((Object)"changed", (Object)scope.getName());
        Assert.assertEquals((Object)"changed", (Object)scope.getDisplayName());
        Assert.assertEquals((Object)"changed", (Object)scope.getIconUri());
    }

    @Test(expected=NotFoundException.class)
    public void testDelete() {
        ResourceScopeResource scopeResource = this.createDefaultScope();
        scopeResource.remove();
        scopeResource.toRepresentation();
    }

    @Test(expected=NotFoundException.class)
    public void testDeleteAndPolicyUpdate() {
        ResourceScopeResource scopeResource = this.createDefaultScope();
        ScopeRepresentation scopeRepresentation = scopeResource.toRepresentation();
        ScopePermissionRepresentation representation = new ScopePermissionRepresentation();
        representation.setName(scopeRepresentation.getName());
        representation.addScope(new String[]{scopeRepresentation.getId()});
        this.getClientResource().authorization().permissions().scope().create(representation);
        ScopePermissionRepresentation permissionRepresentation = this.getClientResource().authorization().permissions().scope().findByName(scopeRepresentation.getName());
        List scopes = this.getClientResource().authorization().policies().policy(permissionRepresentation.getId()).scopes();
        Assert.assertEquals((long)1L, (long)scopes.size());
        scopeResource.remove();
        Assert.assertTrue((boolean)this.getClientResource().authorization().policies().policy(permissionRepresentation.getId()).scopes().isEmpty());
    }
}

