/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.io.InputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.PolicyEnforcementMode;
import org.keycloak.testsuite.admin.client.authorization.AbstractAuthorizationTest;
import org.keycloak.util.JsonSerialization;

public class ResourceServerManagementTest
extends AbstractAuthorizationTest {
    @Test
    public void testCreateAndDeleteResourceServer() throws Exception {
        ClientsResource clientsResource = this.testRealmResource().clients();
        clientsResource.create((ClientRepresentation)JsonSerialization.readValue((InputStream)this.getClass().getResourceAsStream("/authorization-test/client-with-authz-settings.json"), ClientRepresentation.class)).close();
        List clients = clientsResource.findByClientId("authz-client");
        Assert.assertFalse((boolean)clients.isEmpty());
        String clientId = ((ClientRepresentation)clients.get(0)).getId();
        AuthorizationResource settings = clientsResource.get(clientId).authorization();
        Assert.assertEquals((Object)PolicyEnforcementMode.PERMISSIVE, (Object)settings.exportSettings().getPolicyEnforcementMode());
        Assert.assertEquals((Object)DecisionStrategy.UNANIMOUS, (Object)settings.exportSettings().getDecisionStrategy());
        Assert.assertFalse((boolean)settings.resources().findByName("Resource 1").isEmpty());
        Assert.assertFalse((boolean)settings.resources().findByName("Resource 15").isEmpty());
        Assert.assertFalse((boolean)settings.resources().findByName("Resource 20").isEmpty());
        Assert.assertNotNull((Object)settings.permissions().resource().findByName("Resource 15 Permission"));
        Assert.assertNotNull((Object)settings.policies().role().findByName("Resource 1 Policy"));
        clientsResource.get(clientId).remove();
        clients = clientsResource.findByClientId("authz-client");
        Assert.assertTrue((boolean)clients.isEmpty());
    }
}

