/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.util.Collections;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ResourcePermissionResource;
import org.keycloak.admin.client.resource.ResourcePermissionsResource;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.testsuite.admin.client.authorization.AbstractPolicyManagementTest;

public class ResourcePermissionManagementTest
extends AbstractPolicyManagementTest {
    @Test
    public void testCreateResourcePermission() {
        AuthorizationResource authorization = this.getClient().authorization();
        ResourcePermissionRepresentation representation = new ResourcePermissionRepresentation();
        representation.setName("Resource A Permission");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.addResource("Resource A");
        representation.addPolicy(new String[]{"Only Marta Policy", "Only Kolo Policy"});
        this.assertCreated(authorization, representation);
    }

    @Test
    public void testCreateResourceType() {
        AuthorizationResource authorization = this.getClient().authorization();
        ResourcePermissionRepresentation representation = new ResourcePermissionRepresentation();
        representation.setName("Resource A Type Permission");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.setResourceType("test-resource");
        representation.addPolicy(new String[]{"Only Marta Policy"});
        this.assertCreated(authorization, representation);
    }

    @Test
    public void testUpdate() {
        AuthorizationResource authorization = this.getClient().authorization();
        ResourcePermissionRepresentation representation = new ResourcePermissionRepresentation();
        representation.setName("Update Test Resource Permission");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.addResource("Resource A");
        representation.addPolicy(new String[]{"Only Marta Policy", "Only Kolo Policy"});
        this.assertCreated(authorization, representation);
        representation.setName("changed");
        representation.setDescription("changed");
        representation.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        representation.setLogic(Logic.POSITIVE);
        representation.getResources().remove("Resource A");
        representation.addResource("Resource B");
        representation.getPolicies().remove("Only Marta Policy");
        ResourcePermissionsResource permissions = authorization.permissions().resource();
        ResourcePermissionResource permission = permissions.findById(representation.getId());
        permission.update(representation);
        this.assertRepresentation(representation, permission);
        representation.getResources().clear();
        representation.setResourceType("changed");
        permission.update(representation);
        this.assertRepresentation(representation, permission);
    }

    @Test
    public void testDelete() {
        AuthorizationResource authorization = this.getClient().authorization();
        ResourcePermissionRepresentation representation = new ResourcePermissionRepresentation();
        representation.setName("Test Delete Permission");
        representation.setResourceType("test-resource");
        representation.addPolicy(new String[]{"Only Marta Policy"});
        ResourcePermissionsResource permissions = authorization.permissions().resource();
        try (Response response = permissions.create(representation);){
            ResourcePermissionRepresentation created = (ResourcePermissionRepresentation)response.readEntity(ResourcePermissionRepresentation.class);
            permissions.findById(created.getId()).remove();
            ResourcePermissionResource removed = permissions.findById(created.getId());
            try {
                removed.toRepresentation();
                Assert.fail((String)"Permission not removed");
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    @Test
    public void failCreateWithSameName() {
        AuthorizationResource authorization = this.getClient().authorization();
        ResourcePermissionRepresentation permission1 = new ResourcePermissionRepresentation();
        permission1.setName("Conflicting Name Permission");
        permission1.setResourceType("test-resource");
        permission1.addPolicy(new String[]{"Only Marta Policy"});
        ResourcePermissionsResource permissions = authorization.permissions().resource();
        permissions.create(permission1).close();
        ResourcePermissionRepresentation permission2 = new ResourcePermissionRepresentation();
        permission2.setName(permission1.getName());
        try (Response response = permissions.create(permission2);){
            Assert.assertEquals((long)Response.Status.CONFLICT.getStatusCode(), (long)response.getStatus());
        }
    }

    private void assertCreated(AuthorizationResource authorization, ResourcePermissionRepresentation representation) {
        ResourcePermissionsResource permissions = authorization.permissions().resource();
        try (Response response = permissions.create(representation);){
            ResourcePermissionRepresentation created = (ResourcePermissionRepresentation)response.readEntity(ResourcePermissionRepresentation.class);
            ResourcePermissionResource permission = permissions.findById(created.getId());
            this.assertRepresentation(representation, permission);
        }
    }

    private void assertRepresentation(ResourcePermissionRepresentation representation, ResourcePermissionResource permission) {
        this.assertRepresentation((AbstractPolicyRepresentation)representation, (AbstractPolicyRepresentation)permission.toRepresentation(), () -> permission.resources(), () -> Collections.emptyList(), () -> permission.associatedPolicies());
    }
}

