/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.security.cert.X509Certificate;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.AuthorizationContext;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AuthenticatedActionsHandler;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.LogoutError;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.PermissionsResource;
import org.keycloak.admin.client.resource.ResourcesResource;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.common.Profile;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.JSPolicyRepresentation;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.RolePolicyRepresentation;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.RolesBuilder;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
@EnableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
public class PolicyEnforcerTest
extends AbstractKeycloakTest {
    private static final String RESOURCE_SERVER_CLIENT_ID = "resource-server-test";
    private static final String REALM_NAME = "authz-test";

    @BeforeClass
    public static void enabled() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(RealmBuilder.create().name(REALM_NAME).roles(RolesBuilder.create().realmRole(RoleBuilder.create().name("uma_authorization").build()).realmRole(RoleBuilder.create().name("uma_protection").build()).realmRole(RoleBuilder.create().name("user").build())).user(UserBuilder.create().username("marta").password("password").addRoles("uma_authorization", "uma_protection", "user").role(RESOURCE_SERVER_CLIENT_ID, "uma_protection")).user(UserBuilder.create().username("kolo").password("password")).client(ClientBuilder.create().clientId("resource-server-uma-test").secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-uma-test").defaultRoles("uma_protection").directAccessGrants()).client(ClientBuilder.create().clientId(RESOURCE_SERVER_CLIENT_ID).secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-test").defaultRoles("uma_protection").directAccessGrants()).client(ClientBuilder.create().clientId("public-client-test").publicClient().redirectUris("http://localhost:8180/auth/realms/master/app/auth/*", "https://localhost:8543/auth/realms/master/app/auth/*").directAccessGrants()).build());
    }

    @Before
    public void onBefore() {
        this.initAuthorizationSettings(this.getClientResource(RESOURCE_SERVER_CLIENT_ID));
    }

    @Test
    public void testBearerOnlyClientResponse() {
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-bearer-only.json"));
        PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
        OIDCHttpFacade httpFacade = this.createHttpFacade("/api/resourcea");
        AuthorizationContext context = policyEnforcer.enforce(httpFacade);
        Assert.assertFalse((boolean)context.isGranted());
        Assert.assertEquals((long)403L, (long)((TestResponse)TestResponse.class.cast(httpFacade.getResponse())).getStatus());
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId("public-client-test");
        this.oauth.doLogin("marta", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, null);
        String token = response.getAccessToken();
        httpFacade = this.createHttpFacade("/api/resourcea", token);
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertTrue((boolean)context.isGranted());
        httpFacade = this.createHttpFacade("/api/resourceb");
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertFalse((boolean)context.isGranted());
        Assert.assertEquals((long)403L, (long)((TestResponse)TestResponse.class.cast(httpFacade.getResponse())).getStatus());
    }

    @Test
    public void testPathConfigurationPrecendenceWhenLazyLoadingPaths() {
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-paths.json"));
        PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
        OIDCHttpFacade httpFacade = this.createHttpFacade("/api/resourcea");
        AuthorizationContext context = policyEnforcer.enforce(httpFacade);
        Assert.assertFalse((boolean)context.isGranted());
        Assert.assertEquals((long)403L, (long)((TestResponse)TestResponse.class.cast(httpFacade.getResponse())).getStatus());
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId("public-client-test");
        this.oauth.doLogin("marta", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, null);
        String token = response.getAccessToken();
        httpFacade = this.createHttpFacade("/api/resourcea", token);
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertTrue((boolean)context.isGranted());
        httpFacade = this.createHttpFacade("/");
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertTrue((boolean)context.isGranted());
    }

    @Test
    public void testResolvingClaimsOnce() {
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-bearer-only-with-cip.json"));
        PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId("public-client-test");
        this.oauth.doLogin("marta", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, null);
        String token = response.getAccessToken();
        OIDCHttpFacade httpFacade = this.createHttpFacade("/api/resourcea", token, new Function<String, String>(){
            AtomicBoolean resolved = new AtomicBoolean();

            @Override
            public String apply(String s) {
                Assert.assertTrue((boolean)this.resolved.compareAndSet(false, true));
                return "value-" + s;
            }
        });
        AuthorizationContext context = policyEnforcer.enforce(httpFacade);
        Permission permission = (Permission)context.getPermissions().get(0);
        Map claims = permission.getClaims();
        Assert.assertTrue((boolean)context.isGranted());
        Assert.assertEquals((Object)"value-claim-a", ((Set)claims.get("claim-a")).iterator().next());
        Assert.assertEquals((Object)"claim-b", ((Set)claims.get("claim-b")).iterator().next());
    }

    @Test
    public void testCustomClaimProvider() {
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-bearer-only-with-cip.json"));
        PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId("public-client-test");
        this.oauth.doLogin("marta", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, null);
        String token = response.getAccessToken();
        OIDCHttpFacade httpFacade = this.createHttpFacade("/api/resourcea", token);
        AuthorizationContext context = policyEnforcer.enforce(httpFacade);
        Permission permission = (Permission)context.getPermissions().get(0);
        Map claims = permission.getClaims();
        Assert.assertTrue((boolean)context.isGranted());
        Assert.assertEquals((Object)"test", ((Set)claims.get("resolved-claim")).iterator().next());
    }

    @Test
    public void testOnDenyRedirectTo() {
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-on-deny-redirect.json"));
        PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
        OIDCHttpFacade httpFacade = this.createHttpFacade("/api/resourcea");
        AuthorizationContext context = policyEnforcer.enforce(httpFacade);
        Assert.assertFalse((boolean)context.isGranted());
        TestResponse response = (TestResponse)TestResponse.class.cast(httpFacade.getResponse());
        Assert.assertEquals((long)302L, (long)response.getStatus());
        List location = response.getHeaders().getOrDefault("Location", Collections.emptyList());
        Assert.assertFalse((boolean)location.isEmpty());
        Assert.assertEquals((Object)"/accessDenied", location.get(0));
    }

    @Test
    public void testNotAuthenticatedDenyUnmapedPath() {
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-bearer-only.json"));
        PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
        OIDCHttpFacade httpFacade = this.createHttpFacade("/api/unmmaped");
        AuthorizationContext context = policyEnforcer.enforce(httpFacade);
        Assert.assertFalse((boolean)context.isGranted());
        TestResponse response = (TestResponse)TestResponse.class.cast(httpFacade.getResponse());
        Assert.assertEquals((long)403L, (long)response.getStatus());
    }

    @Test
    public void testPublicEndpointNoBearerAbortRequest() {
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-bearer-only.json"));
        OIDCHttpFacade httpFacade = this.createHttpFacade("/api/public");
        AuthenticatedActionsHandler handler = new AuthenticatedActionsHandler(deployment, httpFacade);
        Assert.assertTrue((boolean)handler.handledRequest());
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId("public-client-test");
        this.oauth.doLogin("marta", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, null);
        String token = response.getAccessToken();
        httpFacade = this.createHttpFacade("/api/resourcea", token);
        handler = new AuthenticatedActionsHandler(deployment, httpFacade);
        Assert.assertFalse((boolean)handler.handledRequest());
    }

    @Test
    public void testMappedPathEnforcementModeDisabled() {
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-disabled-enforce-mode-path.json"));
        PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
        OIDCHttpFacade httpFacade = this.createHttpFacade("/api/resource/public");
        AuthorizationContext context = policyEnforcer.enforce(httpFacade);
        Assert.assertTrue((boolean)context.isGranted());
        httpFacade = this.createHttpFacade("/api/resourceb");
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertFalse((boolean)context.isGranted());
        TestResponse response = (TestResponse)TestResponse.class.cast(httpFacade.getResponse());
        Assert.assertEquals((long)403L, (long)response.getStatus());
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId("public-client-test");
        this.oauth.doLogin("marta", "password");
        String token = this.oauth.doAccessTokenRequest((String)this.oauth.getCurrentQuery().get("code"), null).getAccessToken();
        httpFacade = this.createHttpFacade("/api/resourcea", token);
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertTrue((boolean)context.isGranted());
        httpFacade = this.createHttpFacade("/api/resourceb", token);
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertFalse((boolean)context.isGranted());
        response = (TestResponse)TestResponse.class.cast(httpFacade.getResponse());
        Assert.assertEquals((long)403L, (long)response.getStatus());
        httpFacade = this.createHttpFacade("/api/resource/public", token);
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertTrue((boolean)context.isGranted());
    }

    @Test
    public void testEnforcementModeDisabled() {
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-disabled-enforce-mode.json"));
        PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
        OIDCHttpFacade httpFacade = this.createHttpFacade("/api/resource/public");
        policyEnforcer.enforce(httpFacade);
        TestResponse response = (TestResponse)TestResponse.class.cast(httpFacade.getResponse());
        Assert.assertEquals((long)401L, (long)response.getStatus());
    }

    @Test
    public void testDefaultWWWAuthenticateCorsHeader() {
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-disabled-enforce-mode-path.json"));
        deployment.setCors(true);
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("Origin", Arrays.asList("http://localhost:8180"));
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId("public-client-test");
        this.oauth.doLogin("marta", "password");
        String token = this.oauth.doAccessTokenRequest((String)this.oauth.getCurrentQuery().get("code"), null).getAccessToken();
        OIDCHttpFacade httpFacade = this.createHttpFacade("http://server/api/resource/public", "OPTIONS", token, headers, Collections.emptyMap(), null, deployment);
        new AuthenticatedActionsHandler(deployment, httpFacade).handledRequest();
        Assert.assertEquals((Object)"WWW-Authenticate", ((List)headers.get("Access-Control-Expose-Headers")).get(0));
    }

    @Test
    public void testMatchHttpVerbsToScopes() {
        ClientResource clientResource = this.getClientResource(RESOURCE_SERVER_CLIENT_ID);
        ResourceRepresentation resource = this.createResource(clientResource, "Resource With HTTP Scopes", "/api/resource-with-scope", new String[0]);
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName(resource.getName() + " Permission");
        permission.addResource(resource.getName());
        permission.addPolicy(new String[]{"Always Grant Policy"});
        PermissionsResource permissions = clientResource.authorization().permissions();
        permissions.resource().create(permission).close();
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-match-http-verbs-scopes.json"));
        PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId("public-client-test");
        this.oauth.doLogin("marta", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, null);
        String token = response.getAccessToken();
        OIDCHttpFacade httpFacade = this.createHttpFacade("/api/resource-with-scope", token);
        AuthorizationContext context = policyEnforcer.enforce(httpFacade);
        Assert.assertFalse((String)"Should fail because resource does not have any scope named GET", (boolean)context.isGranted());
        Assert.assertEquals((long)403L, (long)((TestResponse)TestResponse.class.cast(httpFacade.getResponse())).getStatus());
        resource.addScope(new String[]{"GET", "POST"});
        clientResource.authorization().resources().resource(resource.getId()).update(resource);
        deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-match-http-verbs-scopes.json"));
        policyEnforcer = deployment.getPolicyEnforcer();
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertTrue((boolean)context.isGranted());
        httpFacade = this.createHttpFacade("/api/resource-with-scope", token, "POST");
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertTrue((boolean)context.isGranted());
        clientResource.authorization().scopes().create(new ScopeRepresentation("PATCH"));
        httpFacade = this.createHttpFacade("/api/resource-with-scope", token, "PATCH");
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertFalse((boolean)context.isGranted());
        ScopePermissionRepresentation postPermission = new ScopePermissionRepresentation();
        postPermission.setName("GET permission");
        postPermission.addScope(new String[]{"GET"});
        postPermission.addPolicy(new String[]{"Always Deny Policy"});
        permissions.scope().create(postPermission).close();
        httpFacade = this.createHttpFacade("/api/resource-with-scope", token);
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertFalse((boolean)context.isGranted());
        postPermission = permissions.scope().findByName(postPermission.getName());
        postPermission.addScope(new String[]{"GET"});
        postPermission.addPolicy(new String[]{"Always Grant Policy"});
        permissions.scope().findById(postPermission.getId()).update(postPermission);
        AuthzClient authzClient = this.getAuthzClient("default-keycloak.json");
        AuthorizationResponse authorize = authzClient.authorization(token).authorize();
        token = authorize.getToken();
        httpFacade = this.createHttpFacade("/api/resource-with-scope", token);
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertTrue((boolean)context.isGranted());
        httpFacade = this.createHttpFacade("/api/resource-with-scope", token, "POST");
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertTrue((boolean)context.isGranted());
        postPermission = permissions.scope().findByName(postPermission.getName());
        postPermission.addScope(new String[]{"GET"});
        postPermission.addPolicy(new String[]{"Always Deny Policy"});
        permissions.scope().findById(postPermission.getId()).update(postPermission);
        authorize = authzClient.authorization(token).authorize();
        token = authorize.getToken();
        httpFacade = this.createHttpFacade("/api/resource-with-scope", token);
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertFalse((boolean)context.isGranted());
        httpFacade = this.createHttpFacade("/api/resource-with-scope", token, "POST");
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertTrue((boolean)context.isGranted());
        postPermission = permissions.scope().findByName(postPermission.getName());
        postPermission.addScope(new String[]{"GET"});
        postPermission.addPolicy(new String[]{"Always Grant Policy"});
        permissions.scope().findById(postPermission.getId()).update(postPermission);
        authorize = authzClient.authorization(token).authorize();
        token = authorize.getToken();
        httpFacade = this.createHttpFacade("/api/resource-with-scope", token);
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertTrue((boolean)context.isGranted());
        httpFacade = this.createHttpFacade("/api/resource-with-scope", token, "POST");
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertTrue((boolean)context.isGranted());
        postPermission = permissions.scope().findByName(postPermission.getName());
        postPermission.addScope(new String[]{"POST"});
        postPermission.addPolicy(new String[]{"Always Deny Policy"});
        permissions.scope().findById(postPermission.getId()).update(postPermission);
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission(null, new String[]{"GET"});
        authorize = authzClient.authorization(token).authorize(request);
        token = authorize.getToken();
        httpFacade = this.createHttpFacade("/api/resource-with-scope", token);
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertTrue((boolean)context.isGranted());
        httpFacade = this.createHttpFacade("/api/resource-with-scope", token, "POST");
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertFalse((boolean)context.isGranted());
    }

    @Test
    public void testUsingSubjectToken() {
        ClientResource clientResource = this.getClientResource(RESOURCE_SERVER_CLIENT_ID);
        ResourceRepresentation resource = this.createResource(clientResource, "Resource Subject Token", "/api/check-subject-token", new String[0]);
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName(resource.getName() + " Permission");
        permission.addResource(resource.getName());
        permission.addPolicy(new String[]{"Only User Policy"});
        PermissionsResource permissions = clientResource.authorization().permissions();
        permissions.resource().create(permission).close();
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-bearer-only.json"));
        PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
        OIDCHttpFacade httpFacade = this.createHttpFacade("/api/check-subject-token");
        AuthorizationContext context = policyEnforcer.enforce(httpFacade);
        Assert.assertFalse((boolean)context.isGranted());
        Assert.assertEquals((long)403L, (long)((TestResponse)TestResponse.class.cast(httpFacade.getResponse())).getStatus());
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId("public-client-test");
        this.oauth.doLogin("marta", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, null);
        String token = response.getAccessToken();
        httpFacade = this.createHttpFacade("/api/check-subject-token", token);
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertTrue((boolean)context.isGranted());
    }

    @Test
    public void testUsingInvalidToken() {
        ClientResource clientResource = this.getClientResource(RESOURCE_SERVER_CLIENT_ID);
        ResourceRepresentation resource = this.createResource(clientResource, "Resource Subject Invalid Token", "/api/check-subject-token", new String[0]);
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName(resource.getName() + " Permission");
        permission.addResource(resource.getName());
        permission.addPolicy(new String[]{"Only User Policy"});
        PermissionsResource permissions = clientResource.authorization().permissions();
        permissions.resource().create(permission).close();
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-bearer-only.json"));
        PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
        OIDCHttpFacade httpFacade = this.createHttpFacade("/api/check-subject-token");
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId("public-client-test");
        this.oauth.doLogin("marta", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, null);
        String token = response.getAccessToken();
        httpFacade = this.createHttpFacade("/api/check-subject-token", token);
        AuthorizationContext context = policyEnforcer.enforce(httpFacade);
        Assert.assertTrue((boolean)context.isGranted());
        this.oauth.doLogout(response.getRefreshToken(), null);
        context = policyEnforcer.enforce(httpFacade);
        Assert.assertFalse((boolean)context.isGranted());
    }

    @Test
    public void testLazyLoadPaths() {
        int i;
        ClientResource clientResource = this.getClientResource(RESOURCE_SERVER_CLIENT_ID);
        for (int i2 = 0; i2 < 200; ++i2) {
            ResourceRepresentation representation = new ResourceRepresentation();
            representation.setType("test");
            representation.setName("Resource " + i2);
            representation.setUri("/api/" + i2);
            Response response = clientResource.authorization().resources().create(representation);
            representation.setId(((ResourceRepresentation)response.readEntity(ResourceRepresentation.class)).getId());
            response.close();
        }
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName("Test Permission");
        permission.setResourceType("test");
        permission.addPolicy(new String[]{"Only User Policy"});
        PermissionsResource permissions = clientResource.authorization().permissions();
        permissions.resource().create(permission).close();
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-no-lazyload.json"));
        PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
        Assert.assertEquals((long)205L, (long)policyEnforcer.getPaths().size());
        deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-lazyload.json"));
        policyEnforcer = deployment.getPolicyEnforcer();
        Assert.assertEquals((long)0L, (long)policyEnforcer.getPathMatcher().getPathCache().size());
        Assert.assertEquals((long)0L, (long)policyEnforcer.getPaths().size());
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId("public-client-test");
        this.oauth.doLogin("marta", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, null);
        String token = response.getAccessToken();
        for (i = 0; i < 101; ++i) {
            policyEnforcer.enforce(this.createHttpFacade("/api/" + i, token));
        }
        Assert.assertEquals((long)101L, (long)policyEnforcer.getPathMatcher().getPathCache().size());
        for (i = 101; i < 200; ++i) {
            policyEnforcer.enforce(this.createHttpFacade("/api/" + i, token));
        }
        Assert.assertEquals((long)200L, (long)policyEnforcer.getPathMatcher().getPathCache().size());
        Assert.assertEquals((long)0L, (long)policyEnforcer.getPaths().size());
        ResourceRepresentation resource = (ResourceRepresentation)clientResource.authorization().resources().findByName("Root").get(0);
        clientResource.authorization().resources().resource(resource.getId()).remove();
        deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-lazyload-with-paths.json"));
        policyEnforcer = deployment.getPolicyEnforcer();
        AuthorizationContext context = policyEnforcer.enforce(this.createHttpFacade("/api/0", token));
        Assert.assertTrue((boolean)context.isGranted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetMethodConfigs() {
        ClientResource clientResource = this.getClientResource(RESOURCE_SERVER_CLIENT_ID);
        ResourceRepresentation representation = new ResourceRepresentation();
        representation.setName(KeycloakModelUtils.generateId());
        representation.setUris(Collections.singleton("/api-method/*"));
        ResourcesResource resources = clientResource.authorization().resources();
        Response response = resources.create(representation);
        representation.setId(((ResourceRepresentation)response.readEntity(ResourceRepresentation.class)).getId());
        response.close();
        try {
            KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getAdapterConfiguration("enforcer-paths-use-method-config.json"));
            PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
            this.oauth.realm(REALM_NAME);
            this.oauth.clientId("public-client-test");
            this.oauth.doLogin("marta", "password");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse tokeResponse = this.oauth.doAccessTokenRequest(code, null);
            String token = tokeResponse.getAccessToken();
            AuthorizationContext context = policyEnforcer.enforce(this.createHttpFacade("/api-method/foo", token));
            Assert.assertTrue((boolean)context.isGranted());
            PolicyEnforcerConfig.PathConfig pathConfig = (PolicyEnforcerConfig.PathConfig)policyEnforcer.getPaths().get("/api-method/*");
            Assert.assertNotNull((Object)pathConfig);
            List methods = pathConfig.getMethods();
            Assert.assertEquals((long)1L, (long)methods.size());
            Assert.assertTrue((boolean)PolicyEnforcerConfig.ScopeEnforcementMode.DISABLED.equals((Object)((PolicyEnforcerConfig.MethodConfig)methods.get(0)).getScopesEnforcementMode()));
            context = policyEnforcer.enforce(this.createHttpFacade("/api-method/foo", token, "POST"));
            Assert.assertFalse((boolean)context.isGranted());
        }
        finally {
            resources.resource(representation.getId()).remove();
        }
    }

    private void initAuthorizationSettings(ClientResource clientResource) {
        StringBuilder code;
        if (clientResource.authorization().resources().findByName("Resource A").isEmpty()) {
            JSPolicyRepresentation jsPolicy = new JSPolicyRepresentation();
            jsPolicy.setName("Always Grant Policy");
            code = new StringBuilder();
            code.append("$evaluation.grant();");
            jsPolicy.setCode(code.toString());
            clientResource.authorization().policies().js().create(jsPolicy).close();
            RolePolicyRepresentation rolePolicy = new RolePolicyRepresentation();
            rolePolicy.setName("Only User Policy");
            rolePolicy.addRole("user");
            clientResource.authorization().policies().role().create(rolePolicy).close();
            this.createResource(clientResource, "Resource A", "/api/resourcea", new String[0]);
            ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
            permission.setName("Resource A Permission");
            permission.addResource("Resource A");
            permission.addPolicy(new String[]{jsPolicy.getName()});
            clientResource.authorization().permissions().resource().create(permission).close();
        }
        if (clientResource.authorization().resources().findByName("Resource B").isEmpty()) {
            JSPolicyRepresentation policy = new JSPolicyRepresentation();
            policy.setName("Always Deny Policy");
            code = new StringBuilder();
            code.append("$evaluation.deny();");
            policy.setCode(code.toString());
            clientResource.authorization().policies().js().create(policy).close();
            this.createResource(clientResource, "Resource B", "/api/resourceb", new String[0]);
            ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
            permission.setName("Resource B Permission");
            permission.addResource("Resource B");
            permission.addPolicy(new String[]{policy.getName()});
            clientResource.authorization().permissions().resource().create(permission).close();
        }
        if (clientResource.authorization().resources().findByName("Root").isEmpty()) {
            this.createResource(clientResource, "Root", "/*", new String[0]);
        }
    }

    private InputStream getAdapterConfiguration(String fileName) {
        try {
            return PolicyEnforcerTest.httpsAwareConfigurationStream(this.getClass().getResourceAsStream("/authorization-test/" + fileName));
        }
        catch (IOException e) {
            throw new AssertionError("Unexpected I/O error while dealing with configuration", e);
        }
    }

    private ResourceRepresentation createResource(ClientResource clientResource, String name, String uri, String ... scopes) {
        ResourceRepresentation representation = new ResourceRepresentation();
        representation.setName(name);
        representation.setUri(uri);
        representation.setScopes(Arrays.asList(scopes).stream().map(ScopeRepresentation::new).collect(Collectors.toSet()));
        Response response = clientResource.authorization().resources().create(representation);
        representation.setId(((ResourceRepresentation)response.readEntity(ResourceRepresentation.class)).getId());
        response.close();
        return representation;
    }

    private ClientResource getClientResource(String name) {
        ClientsResource clients = this.realmsResouce().realm(REALM_NAME).clients();
        ClientRepresentation representation = (ClientRepresentation)clients.findByClientId(name).get(0);
        return clients.get(representation.getId());
    }

    private OIDCHttpFacade createHttpFacade(String path, String method, String token, Map<String, List<String>> headers, Map<String, List<String>> parameters, InputStream requestBody, KeycloakDeployment deployment) {
        return this.createHttpFacade(path, method, token, headers, parameters, requestBody, deployment, null);
    }

    private OIDCHttpFacade createHttpFacade(final String path, final String method, final String token, final Map<String, List<String>> headers, final Map<String, List<String>> parameters, final InputStream requestBody, final KeycloakDeployment deployment, final Function<String, String> parameterFunction) {
        return new OIDCHttpFacade(){
            HttpFacade.Request request;
            HttpFacade.Response response;

            public KeycloakSecurityContext getSecurityContext() {
                if (token != null) {
                    AccessToken accessToken;
                    try {
                        accessToken = (AccessToken)new JWSInput(token).readJsonContent(AccessToken.class);
                    }
                    catch (JWSInputException cause) {
                        throw new RuntimeException(cause);
                    }
                    return new RefreshableKeycloakSecurityContext(deployment, null, token, accessToken, null, null, null);
                }
                return null;
            }

            public HttpFacade.Request getRequest() {
                if (this.request == null) {
                    this.request = PolicyEnforcerTest.this.createHttpRequest(path, method, headers, parameters, requestBody, parameterFunction);
                }
                return this.request;
            }

            public HttpFacade.Response getResponse() {
                if (this.response == null) {
                    this.response = PolicyEnforcerTest.this.createHttpResponse(headers);
                }
                return this.response;
            }

            public X509Certificate[] getCertificateChain() {
                return new X509Certificate[0];
            }
        };
    }

    private OIDCHttpFacade createHttpFacade(String path, String token) {
        return this.createHttpFacade(path, null, token, new HashMap<String, List<String>>(), new HashMap<String, List<String>>(), null, null);
    }

    private OIDCHttpFacade createHttpFacade(String path, String token, String method) {
        return this.createHttpFacade(path, method, token, new HashMap<String, List<String>>(), new HashMap<String, List<String>>(), null, null);
    }

    private OIDCHttpFacade createHttpFacade(String path) {
        return this.createHttpFacade(path, null, null, new HashMap<String, List<String>>(), new HashMap<String, List<String>>(), null, null);
    }

    private OIDCHttpFacade createHttpFacade(String path, String token, Function<String, String> parameterFunction) {
        return this.createHttpFacade(path, null, token, new HashMap<String, List<String>>(), new HashMap<String, List<String>>(), null, null, parameterFunction);
    }

    private HttpFacade.Response createHttpResponse(Map<String, List<String>> headers) {
        return new TestResponse(headers);
    }

    private HttpFacade.Request createHttpRequest(final String path, final String method, final Map<String, List<String>> headers, Map<String, List<String>> parameters, final InputStream requestBody, Function<String, String> parameterFunction) {
        if (parameterFunction == null) {
            parameterFunction = param -> {
                List values = parameters.getOrDefault(param, Collections.emptyList());
                if (!values.isEmpty()) {
                    return (String)values.get(0);
                }
                return null;
            };
        }
        final Function<String, String> finalParameterFunction = parameterFunction;
        return new HttpFacade.Request(){
            private InputStream inputStream;

            public String getMethod() {
                return method == null ? "GET" : method;
            }

            public String getURI() {
                return path;
            }

            public String getRelativePath() {
                return path;
            }

            public boolean isSecure() {
                return true;
            }

            public String getFirstParam(String param) {
                return (String)finalParameterFunction.apply(param);
            }

            public String getQueryParamValue(String param) {
                return this.getFirstParam(param);
            }

            public HttpFacade.Cookie getCookie(String cookieName) {
                return null;
            }

            public String getHeader(String name) {
                List<String> headers2 = this.getHeaders(name);
                if (!headers2.isEmpty()) {
                    return headers2.get(0);
                }
                return null;
            }

            public List<String> getHeaders(String name) {
                return headers.getOrDefault(name, Collections.emptyList());
            }

            public InputStream getInputStream() {
                return this.getInputStream(false);
            }

            public InputStream getInputStream(boolean buffer) {
                if (requestBody == null) {
                    return new ByteArrayInputStream(new byte[0]);
                }
                if (this.inputStream != null) {
                    return this.inputStream;
                }
                if (buffer) {
                    this.inputStream = new BufferedInputStream(requestBody);
                    return this.inputStream;
                }
                return requestBody;
            }

            public String getRemoteAddr() {
                return "user-remote-addr";
            }

            public void setError(AuthenticationError error) {
            }

            public void setError(LogoutError error) {
            }
        };
    }

    protected AuthzClient getAuthzClient(String fileName) {
        return AuthzClient.create((InputStream)this.getAdapterConfiguration(fileName));
    }

    private class TestResponse
    implements HttpFacade.Response {
        private final Map<String, List<String>> headers;
        private int status;

        public TestResponse(Map<String, List<String>> headers) {
            this.headers = headers;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        public void addHeader(String name, String value) {
            this.setHeader(name, value);
        }

        public void setHeader(String name, String value) {
            this.headers.put(name, Arrays.asList(value));
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public void resetCookie(String name, String path) {
        }

        public void setCookie(String name, String value, String path, String domain, int maxAge, boolean secure, boolean httpOnly) {
        }

        public OutputStream getOutputStream() {
            return null;
        }

        public void sendError(int code) {
            this.status = code;
        }

        public void sendError(int code, String message) {
            this.status = code;
        }

        public void end() {
        }
    }
}

