/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.GroupPoliciesResource;
import org.keycloak.admin.client.resource.GroupPolicyResource;
import org.keycloak.admin.client.resource.GroupsResource;
import org.keycloak.admin.client.resource.PolicyResource;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.GroupPolicyRepresentation;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.testsuite.admin.client.authorization.AbstractPolicyManagementTest;
import org.keycloak.testsuite.util.GroupBuilder;
import org.keycloak.testsuite.util.RealmBuilder;

public class GroupPolicyManagementTest
extends AbstractPolicyManagementTest {
    @Override
    protected RealmBuilder createTestRealm() {
        return super.createTestRealm().group(GroupBuilder.create().name("Group A").subGroups(Arrays.asList("Group B", "Group D").stream().map(name -> {
            if ("Group B".equals(name)) {
                return GroupBuilder.create().name((String)name).subGroups(Arrays.asList("Group C", "Group E").stream().map(name1 -> GroupBuilder.create().name((String)name1).build()).collect(Collectors.toList())).build();
            }
            return GroupBuilder.create().name((String)name).build();
        }).collect(Collectors.toList())).build()).group(GroupBuilder.create().name("Group F").build()).group(GroupBuilder.create().name("Group G").build()).group(GroupBuilder.create().name("Group H").subGroups(Arrays.asList("Group I", "Group J").stream().map(name -> {
            if ("Group I".equals(name)) {
                return GroupBuilder.create().name((String)name).subGroups(Arrays.asList("Group K", "Group L").stream().map(name1 -> GroupBuilder.create().name((String)name1).build()).collect(Collectors.toList())).build();
            }
            return GroupBuilder.create().name((String)name).build();
        }).collect(Collectors.toList())).build());
    }

    @Test
    public void testCreate() {
        AuthorizationResource authorization = this.getClient().authorization();
        GroupPolicyRepresentation representation = new GroupPolicyRepresentation();
        representation.setName("Group Policy");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.setGroupsClaim("groups");
        representation.addGroupPath("/Group A/Group B/Group C", true);
        representation.addGroupPath(new String[]{"Group F"});
        this.assertCreated(authorization, representation);
    }

    @Test
    public void testCreateWithoutGroupsClaim() {
        AuthorizationResource authorization = this.getClient().authorization();
        GroupPolicyRepresentation representation = new GroupPolicyRepresentation();
        representation.setName(KeycloakModelUtils.generateId());
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.addGroupPath("/Group A/Group B/Group C", true);
        representation.addGroupPath(new String[]{"Group F"});
        this.assertCreated(authorization, representation);
    }

    @Test
    public void testUpdate() {
        AuthorizationResource authorization = this.getClient().authorization();
        GroupPolicyRepresentation representation = new GroupPolicyRepresentation();
        representation.setName("Update Group Policy");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.setGroupsClaim("groups");
        representation.addGroupPath("/Group A/Group B/Group C", true);
        representation.addGroupPath(new String[]{"Group F"});
        this.assertCreated(authorization, representation);
        representation.setName("changed");
        representation.setDescription("changed");
        representation.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        representation.setLogic(Logic.POSITIVE);
        representation.setGroupsClaim(null);
        representation.removeGroup(new String[]{"/Group A/Group B"});
        GroupPoliciesResource policies = authorization.policies().group();
        GroupPolicyResource permission = policies.findById(representation.getId());
        permission.update(representation);
        this.assertRepresentation(representation, permission);
        for (GroupPolicyRepresentation.GroupDefinition roleDefinition : representation.getGroups()) {
            if (!roleDefinition.getPath().equals("Group F")) continue;
            roleDefinition.setExtendChildren(true);
        }
        permission.update(representation);
        this.assertRepresentation(representation, permission);
        representation.getGroups().clear();
        representation.addGroupPath(new String[]{"/Group A/Group B"});
        permission.update(representation);
        this.assertRepresentation(representation, permission);
    }

    @Test
    public void testDelete() {
        AuthorizationResource authorization = this.getClient().authorization();
        GroupPolicyRepresentation representation = new GroupPolicyRepresentation();
        representation.setName("Delete Group Policy");
        representation.setGroupsClaim("groups");
        representation.addGroupPath("/Group A/Group B/Group C", true);
        representation.addGroupPath(new String[]{"Group F"});
        GroupPoliciesResource policies = authorization.policies().group();
        try (Response response = policies.create(representation);){
            GroupPolicyRepresentation created = (GroupPolicyRepresentation)response.readEntity(GroupPolicyRepresentation.class);
            policies.findById(created.getId()).remove();
            GroupPolicyResource removed = policies.findById(created.getId());
            try {
                removed.toRepresentation();
                Assert.fail((String)"Permission not removed");
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testRemoveWithoutPath() {
        GroupPolicyRepresentation representation = new GroupPolicyRepresentation();
        representation.setName("Delete Group Path Policy");
        representation.setGroupsClaim("groups");
        representation.addGroup(new String[]{"Group A"});
        representation.removeGroup(new String[]{"Group A"});
        Assert.assertTrue((boolean)representation.getGroups().isEmpty());
    }

    @Test
    public void testGenericConfig() {
        AuthorizationResource authorization = this.getClient().authorization();
        GroupPolicyRepresentation representation = new GroupPolicyRepresentation();
        representation.setName("Test Generic Config Permission");
        representation.setGroupsClaim("groups");
        representation.addGroupPath(new String[]{"/Group A"});
        GroupPoliciesResource policies = authorization.policies().group();
        try (Response response = policies.create(representation);){
            GroupPolicyRepresentation created = (GroupPolicyRepresentation)response.readEntity(GroupPolicyRepresentation.class);
            PolicyResource policy = authorization.policies().policy(created.getId());
            PolicyRepresentation genericConfig = policy.toRepresentation();
            Assert.assertNotNull((Object)genericConfig.getConfig());
            Assert.assertNotNull(genericConfig.getConfig().get("groups"));
            GroupRepresentation group = this.getRealm().groups().groups().stream().filter(groupRepresentation -> groupRepresentation.getName().equals("Group A")).findFirst().get();
            Assert.assertTrue((boolean)((String)genericConfig.getConfig().get("groups")).contains(group.getId()));
        }
    }

    @Test
    public void testDeleteGroupAndPolicy() {
        AuthorizationResource authorization = this.getClient().authorization();
        GroupPolicyRepresentation representation = new GroupPolicyRepresentation();
        representation.setName(UUID.randomUUID().toString());
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.setGroupsClaim("groups");
        representation.addGroupPath("/Group G", true);
        this.assertCreated(authorization, representation);
        GroupsResource groups = this.getRealm().groups();
        GroupRepresentation group = (GroupRepresentation)groups.groups("Group G", null, null).get(0);
        groups.group(group.getId()).remove();
        try {
            this.getClient().authorization().policies().group().findByName(representation.getName());
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        representation.getGroups().clear();
        representation.addGroupPath(new String[]{"/Group H/Group I/Group K"});
        representation.addGroupPath(new String[]{"/Group F"});
        this.assertCreated(authorization, representation);
        group = (GroupRepresentation)groups.groups("Group K", null, null).get(0);
        groups.group(group.getId()).remove();
        GroupPolicyRepresentation policy = this.getClient().authorization().policies().group().findByName(representation.getName());
        Assert.assertNotNull((Object)policy);
        Assert.assertEquals((long)1L, (long)policy.getGroups().size());
    }

    private void assertCreated(AuthorizationResource authorization, GroupPolicyRepresentation representation) {
        GroupPoliciesResource policies = authorization.policies().group();
        Response response = policies.create(representation);
        GroupPolicyRepresentation created = (GroupPolicyRepresentation)response.readEntity(GroupPolicyRepresentation.class);
        GroupPolicyResource policy = policies.findById(created.getId());
        this.assertRepresentation(representation, policy);
    }

    private void assertRepresentation(GroupPolicyRepresentation representation, GroupPolicyResource permission) {
        GroupPolicyRepresentation actual = permission.toRepresentation();
        this.assertRepresentation((AbstractPolicyRepresentation)representation, (AbstractPolicyRepresentation)actual, () -> permission.resources(), () -> Collections.emptyList(), () -> permission.associatedPolicies());
        Assert.assertEquals((long)representation.getGroups().size(), (long)actual.getGroups().size());
        Assert.assertEquals((long)0L, (long)actual.getGroups().stream().filter(actualDefinition -> !representation.getGroups().stream().filter(groupDefinition -> this.getGroupPath(actualDefinition.getId()).equals(this.getCanonicalGroupPath(groupDefinition.getPath())) && actualDefinition.isExtendChildren() == groupDefinition.isExtendChildren()).findFirst().isPresent()).count());
    }

    private String getGroupPath(String id) {
        return this.getRealm().groups().group(id).toRepresentation().getPath();
    }

    private String getCanonicalGroupPath(String path) {
        if (path.charAt(0) == '/') {
            return path;
        }
        return "/" + path;
    }
}

