/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.client.authorization.AbstractAuthorizationTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.RoleBuilder;

public class ExportAuthorizationSettingsTest
extends AbstractAuthorizationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResourceBasedPermission() throws Exception {
        String permissionName = "resource-based-permission";
        ClientResource clientResource = this.getClientResource();
        AuthorizationResource authorizationResource = clientResource.authorization();
        List resources = authorizationResource.resources().findByName("Default Resource");
        Assert.assertTrue((resources.size() == 1 ? 1 : 0) != 0);
        ResourceRepresentation resource = (ResourceRepresentation)resources.get(0);
        PolicyRepresentation policy = authorizationResource.policies().findByName("Default Policy");
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName(permissionName);
        permission.addPolicy(new String[]{policy.getId()});
        permission.addResource(resource.getId());
        try (Response create = authorizationResource.permissions().resource().create(permission);){
            Assert.assertEquals((Object)Response.Status.CREATED, (Object)create.getStatusInfo());
        }
        ResourceServerRepresentation exportSettings = authorizationResource.exportSettings();
        boolean found = false;
        for (PolicyRepresentation p : exportSettings.getPolicies()) {
            if (!p.getName().equals(permissionName)) continue;
            found = true;
            Assert.assertEquals((Object)"[\"Default Resource\"]", p.getConfig().get("resources"));
            Assert.assertEquals((Object)"[\"Default Policy\"]", p.getConfig().get("applyPolicies"));
        }
        Assert.assertTrue((String)"Permission \"role-based-permission\" was not found.", (boolean)found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRoleBasedPolicy() {
        ClientResource clientResource = this.getClientResource();
        AuthorizationResource authorizationResource = clientResource.authorization();
        ClientRepresentation account = (ClientRepresentation)this.testRealmResource().clients().findByClientId("account").get(0);
        RoleRepresentation role = this.testRealmResource().clients().get(account.getId()).roles().get("view-profile").toRepresentation();
        PolicyRepresentation policy = new PolicyRepresentation();
        policy.setName("role-based-policy");
        policy.setType("role");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("roles", "[{\"id\":\"" + role.getId() + "\"}]");
        policy.setConfig(config);
        try (Response create = authorizationResource.policies().create(policy);){
            Assert.assertEquals((Object)Response.Status.CREATED, (Object)create.getStatusInfo());
        }
        authorizationResource.exportSettings();
        authorizationResource.exportSettings();
    }

    @Test
    public void testRoleBasedPolicyWithMultipleRoles() {
        ClientResource clientResource = this.getClientResource();
        AuthorizationResource authorizationResource = clientResource.authorization();
        this.testRealmResource().clients().create(ClientBuilder.create().clientId("test-client-1").build()).close();
        this.testRealmResource().clients().create(ClientBuilder.create().clientId("test-client-2").build()).close();
        ClientRepresentation client1 = this.getClientByClientId("test-client-1");
        ClientRepresentation client2 = this.getClientByClientId("test-client-2");
        this.testRealmResource().clients().get(client1.getId()).roles().create(RoleBuilder.create().name("client-role").build());
        this.testRealmResource().clients().get(client2.getId()).roles().create(RoleBuilder.create().name("client-role").build());
        RoleRepresentation role1 = this.testRealmResource().clients().get(client1.getId()).roles().get("client-role").toRepresentation();
        RoleRepresentation role2 = this.testRealmResource().clients().get(client2.getId()).roles().get("client-role").toRepresentation();
        PolicyRepresentation policy = new PolicyRepresentation();
        policy.setName("role-based-policy");
        policy.setType("role");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("roles", "[{\"id\":\"" + role1.getId() + "\"},{\"id\":\"" + role2.getId() + "\"}]");
        policy.setConfig(config);
        try (Response create = authorizationResource.policies().create(policy);){
            Assert.assertEquals((Object)Response.Status.CREATED, (Object)create.getStatusInfo());
        }
        ResourceServerRepresentation exportSettings = authorizationResource.exportSettings();
        boolean found = false;
        for (PolicyRepresentation p : exportSettings.getPolicies()) {
            if (!p.getName().equals("role-based-policy")) continue;
            found = true;
            Assert.assertTrue((((String)p.getConfig().get("roles")).contains("test-client-1/client-role") && ((String)p.getConfig().get("roles")).contains("test-client-2/client-role") ? 1 : 0) != 0);
        }
        if (!found) {
            Assert.fail((String)"Policy \"role-based-policy\" was not found in exported settings.");
        }
    }

    private ClientRepresentation getClientByClientId(String clientId) {
        List findByClientId = this.testRealmResource().clients().findByClientId(clientId);
        Assert.assertTrue((findByClientId.size() == 1 ? 1 : 0) != 0);
        return (ClientRepresentation)findByClientId.get(0);
    }
}

