/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.undertow.Undertow;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.cert.X509Certificate;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClients;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authorization.ClaimInformationPointProvider;
import org.keycloak.adapters.authorization.ClaimInformationPointProviderFactory;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.LogoutError;
import org.keycloak.common.Profile;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.keycloak.util.JsonSerialization;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ClaimInformationPointProviderTest
extends AbstractKeycloakTest {
    private static Undertow httpService;

    @BeforeClass
    public static void enabled() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
    }

    @BeforeClass
    public static void onBeforeClass() {
        httpService = Undertow.builder().addHttpListener(8989, "localhost").setHandler(exchange -> {
            if (exchange.isInIoThread()) {
                try {
                    if (exchange.getRelativePath().equals("/post-claim-information-provider")) {
                        FormParserFactory parserFactory = FormParserFactory.builder().build();
                        FormDataParser parser = parserFactory.createParser(exchange);
                        FormData formData = parser.parseBlocking();
                        if (!("Bearer tokenString".equals(exchange.getRequestHeaders().getFirst("Authorization")) && "post".equalsIgnoreCase(exchange.getRequestMethod().toString()) && "application/x-www-form-urlencoded".equals(exchange.getRequestHeaders().getFirst("Content-Type")) && exchange.getRequestHeaders().get("header-b").contains((Object)"header-b-value1") && exchange.getRequestHeaders().get("header-b").contains((Object)"header-b-value2") && ((FormData.FormValue)formData.get("param-a").getFirst()).getValue().equals("param-a-value1") && ((FormData.FormValue)formData.get("param-a").getLast()).getValue().equals("param-a-value2") && ((FormData.FormValue)formData.get("param-subject").getFirst()).getValue().equals("sub") && ((FormData.FormValue)formData.get("param-user-name").getFirst()).getValue().equals("username") && ((FormData.FormValue)formData.get("param-other-claims").getFirst()).getValue().equals("param-other-claims-value1") && ((FormData.FormValue)formData.get("param-other-claims").getLast()).getValue().equals("param-other-claims-value2"))) {
                            exchange.setStatusCode(400);
                            return;
                        }
                        exchange.setStatusCode(200);
                    } else if (exchange.getRelativePath().equals("/get-claim-information-provider")) {
                        if (!("Bearer idTokenString".equals(exchange.getRequestHeaders().getFirst("Authorization")) && "get".equalsIgnoreCase(exchange.getRequestMethod().toString()) && exchange.getRequestHeaders().get("header-b").contains((Object)"header-b-value1") && exchange.getRequestHeaders().get("header-b").contains((Object)"header-b-value2") && ((Deque)exchange.getQueryParameters().get("param-a")).contains("param-a-value1") && ((Deque)exchange.getQueryParameters().get("param-a")).contains("param-a-value2") && ((Deque)exchange.getQueryParameters().get("param-subject")).contains("sub") && ((Deque)exchange.getQueryParameters().get("param-user-name")).contains("username"))) {
                            exchange.setStatusCode(400);
                            return;
                        }
                        exchange.setStatusCode(200);
                    } else {
                        exchange.setStatusCode(404);
                    }
                }
                finally {
                    if (exchange.getStatusCode() == 200) {
                        try {
                            ObjectMapper mapper = JsonSerialization.mapper;
                            JsonParser jsonParser = mapper.getFactory().createParser("{\"a\": \"a-value1\", \"b\": \"b-value1\", \"d\": [\"d-value1\", \"d-value2\"]}");
                            TreeNode treeNode = mapper.readTree(jsonParser);
                            exchange.getResponseSender().send(treeNode.toString());
                        }
                        catch (Exception ignore) {
                            ignore.printStackTrace();
                        }
                    }
                    exchange.endExchange();
                }
            }
        }).build();
        httpService.start();
    }

    @AfterClass
    public static void onAfterClass() {
        if (httpService != null) {
            httpService.stop();
        }
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = IOUtil.loadRealm((InputStream)this.getClass().getResourceAsStream("/authorization-test/test-authz-realm.json"));
        testRealms.add(realm);
    }

    private ClaimInformationPointProvider getClaimInformationProviderForPath(String path, String providerName) {
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.getClass().getResourceAsStream("/authorization-test/enforcer-config-claims-provider.json"));
        deployment.setClient((HttpClient)HttpClients.createDefault());
        PolicyEnforcer policyEnforcer = deployment.getPolicyEnforcer();
        Map providers = policyEnforcer.getClaimInformationPointProviderFactories();
        PolicyEnforcerConfig.PathConfig pathConfig = (PolicyEnforcerConfig.PathConfig)policyEnforcer.getPaths().get(path);
        Assert.assertNotNull((Object)pathConfig);
        Map cipConfig = pathConfig.getClaimInformationPointConfig();
        Assert.assertNotNull((Object)cipConfig);
        ClaimInformationPointProviderFactory factory = (ClaimInformationPointProviderFactory)providers.get(providerName);
        Assert.assertNotNull((Object)factory);
        Map claimsConfig = (Map)cipConfig.get(providerName);
        return factory.create(claimsConfig);
    }

    @Test
    public void testBasicClaimsInformationPoint() {
        HttpFacade httpFacade = this.createHttpFacade();
        Map claims = this.getClaimInformationProviderForPath("/claims-provider", "claims").resolve(httpFacade);
        Assert.assertEquals((Object)"parameter-a", ((List)claims.get("claim-from-request-parameter")).get(0));
        Assert.assertEquals((Object)"header-b", ((List)claims.get("claim-from-header")).get(0));
        Assert.assertEquals((Object)"cookie-c", ((List)claims.get("claim-from-cookie")).get(0));
        Assert.assertEquals((Object)"user-remote-addr", ((List)claims.get("claim-from-remoteAddr")).get(0));
        Assert.assertEquals((Object)"GET", ((List)claims.get("claim-from-method")).get(0));
        Assert.assertEquals((Object)"/app/request-uri", ((List)claims.get("claim-from-uri")).get(0));
        Assert.assertEquals((Object)"/request-relative-path", ((List)claims.get("claim-from-relativePath")).get(0));
        Assert.assertEquals((Object)"true", ((List)claims.get("claim-from-secure")).get(0));
        Assert.assertEquals((Object)"static value", ((List)claims.get("claim-from-static-value")).get(0));
        Assert.assertEquals((Object)"static", ((List)claims.get("claim-from-multiple-static-value")).get(0));
        Assert.assertEquals((Object)"value", ((List)claims.get("claim-from-multiple-static-value")).get(1));
        Assert.assertEquals((Object)"Test param-other-claims-value1 and parameter-a", ((List)claims.get("param-replace-multiple-placeholder")).get(0));
    }

    @Test
    public void testBodyJsonClaimsInformationPoint() throws Exception {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("Content-Type", Arrays.asList("application/json"));
        ObjectMapper mapper = JsonSerialization.mapper;
        JsonParser parser = mapper.getFactory().createParser("{\"a\": {\"b\": {\"c\": \"c-value\"}}, \"d\": [\"d-value1\", \"d-value2\"], \"e\": {\"number\": 123}}");
        TreeNode treeNode = mapper.readTree(parser);
        HttpFacade httpFacade = this.createHttpFacade(headers, new ByteArrayInputStream(treeNode.toString().getBytes()));
        Map claims = this.getClaimInformationProviderForPath("/claims-provider", "claims").resolve(httpFacade);
        Assert.assertEquals((Object)"c-value", ((List)claims.get("claim-from-json-body-object")).get(0));
        Assert.assertEquals((Object)"d-value2", ((List)claims.get("claim-from-json-body-array")).get(0));
        Assert.assertEquals((Object)"123", ((List)claims.get("claim-from-json-body-number")).get(0));
    }

    @Test
    public void testBodyJsonObjectClaim() throws Exception {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("Content-Type", Arrays.asList("application/json"));
        ObjectMapper mapper = JsonSerialization.mapper;
        JsonParser parser = mapper.getFactory().createParser("{\"Individual\" : {\n\n                \"Name\":  \"John\",\n\n                \"Lastname\": \"Doe\",\n\n                \"individualRoles\" : [ {\n\n                                \"roleSpec\": 2342,\n\n                                \"roleId\": 4234},\n\n{\n\n                                \"roleSpec\": 4223,\n\n                                \"roleId\": 523\n\n                }\n\n                ]\n\n}}");
        TreeNode treeNode = mapper.readTree(parser);
        HttpFacade httpFacade = this.createHttpFacade(headers, new ByteArrayInputStream(treeNode.toString().getBytes()));
        Map claims = this.getClaimInformationProviderForPath("/claims-from-body-json-object", "claims").resolve(httpFacade);
        Assert.assertEquals((long)1L, (long)claims.size());
        Assert.assertEquals((long)2L, (long)((List)claims.get("individualRoles")).size());
        Assert.assertEquals((Object)"{\"roleSpec\":2342,\"roleId\":4234}", ((List)claims.get("individualRoles")).get(0));
        Assert.assertEquals((Object)"{\"roleSpec\":4223,\"roleId\":523}", ((List)claims.get("individualRoles")).get(1));
        headers.put("Content-Type", Arrays.asList("application/json; charset=utf-8"));
        httpFacade = this.createHttpFacade(headers, new ByteArrayInputStream(treeNode.toString().getBytes()));
        claims = this.getClaimInformationProviderForPath("/claims-from-body-json-object", "claims").resolve(httpFacade);
        Assert.assertEquals((long)1L, (long)claims.size());
        Assert.assertEquals((long)2L, (long)((List)claims.get("individualRoles")).size());
        Assert.assertEquals((Object)"{\"roleSpec\":2342,\"roleId\":4234}", ((List)claims.get("individualRoles")).get(0));
        Assert.assertEquals((Object)"{\"roleSpec\":4223,\"roleId\":523}", ((List)claims.get("individualRoles")).get(1));
    }

    @Test
    public void testBodyClaimsInformationPoint() {
        HttpFacade httpFacade = this.createHttpFacade(new HashMap<String, List<String>>(), new ByteArrayInputStream("raw-body-text".getBytes()));
        Map claims = this.getClaimInformationProviderForPath("/claims-provider", "claims").resolve(httpFacade);
        Assert.assertEquals((Object)"raw-body-text", ((List)claims.get("claim-from-body")).get(0));
    }

    @Test
    public void testHttpClaimInformationPointProviderWithoutClaims() {
        HttpFacade httpFacade = this.createHttpFacade();
        Map claims = this.getClaimInformationProviderForPath("/http-get-claim-provider", "http").resolve(httpFacade);
        Assert.assertEquals((Object)"a-value1", ((List)claims.get("a")).get(0));
        Assert.assertEquals((Object)"b-value1", ((List)claims.get("b")).get(0));
        Assert.assertEquals((Object)"d-value1", ((List)claims.get("d")).get(0));
        Assert.assertEquals((Object)"d-value2", ((List)claims.get("d")).get(1));
        Assert.assertNull(claims.get("claim-a"));
        Assert.assertNull(claims.get("claim-d"));
        Assert.assertNull(claims.get("claim-d0"));
        Assert.assertNull(claims.get("claim-d-all"));
    }

    @Test
    public void testHttpClaimInformationPointProviderWithClaims() {
        HttpFacade httpFacade = this.createHttpFacade();
        Map claims = this.getClaimInformationProviderForPath("/http-post-claim-provider", "http").resolve(httpFacade);
        Assert.assertEquals((Object)"a-value1", ((List)claims.get("claim-a")).get(0));
        Assert.assertEquals((Object)"d-value1", ((List)claims.get("claim-d")).get(0));
        Assert.assertEquals((Object)"d-value2", ((List)claims.get("claim-d")).get(1));
        Assert.assertEquals((Object)"d-value1", ((List)claims.get("claim-d0")).get(0));
        Assert.assertEquals((Object)"d-value1", ((List)claims.get("claim-d-all")).get(0));
        Assert.assertEquals((Object)"d-value2", ((List)claims.get("claim-d-all")).get(1));
        Assert.assertNull(claims.get("a"));
        Assert.assertNull(claims.get("b"));
        Assert.assertNull(claims.get("d"));
    }

    private HttpFacade createHttpFacade(final Map<String, List<String>> headers, final InputStream requestBody) {
        return new OIDCHttpFacade(){
            private HttpFacade.Request request;

            public KeycloakSecurityContext getSecurityContext() {
                AccessToken token = new AccessToken();
                token.subject("sub");
                token.setPreferredUsername("username");
                token.getOtherClaims().put("custom_claim", Arrays.asList("param-other-claims-value1", "param-other-claims-value2"));
                IDToken idToken = new IDToken();
                idToken.subject("sub");
                idToken.setPreferredUsername("username");
                idToken.getOtherClaims().put("custom_claim", Arrays.asList("param-other-claims-value1", "param-other-claims-value2"));
                return new KeycloakSecurityContext("tokenString", token, "idTokenString", idToken);
            }

            public HttpFacade.Request getRequest() {
                if (this.request == null) {
                    this.request = ClaimInformationPointProviderTest.this.createHttpRequest(headers, requestBody);
                }
                return this.request;
            }

            public HttpFacade.Response getResponse() {
                return ClaimInformationPointProviderTest.this.createHttpResponse();
            }

            public X509Certificate[] getCertificateChain() {
                return new X509Certificate[0];
            }
        };
    }

    private HttpFacade createHttpFacade() {
        return this.createHttpFacade(new HashMap<String, List<String>>(), null);
    }

    private HttpFacade.Response createHttpResponse() {
        return new HttpFacade.Response(){

            public void setStatus(int status) {
            }

            public void addHeader(String name, String value) {
            }

            public void setHeader(String name, String value) {
            }

            public void resetCookie(String name, String path) {
            }

            public void setCookie(String name, String value, String path, String domain, int maxAge, boolean secure, boolean httpOnly) {
            }

            public OutputStream getOutputStream() {
                return null;
            }

            public void sendError(int code) {
            }

            public void sendError(int code, String message) {
            }

            public void end() {
            }
        };
    }

    private HttpFacade.Request createHttpRequest(final Map<String, List<String>> headers, final InputStream requestBody) {
        final HashMap<String, List<String>> queryParameter = new HashMap<String, List<String>>();
        queryParameter.put("a", Arrays.asList("parameter-a"));
        headers.put("b", Arrays.asList("header-b"));
        final HashMap<String, HttpFacade.Cookie> cookies = new HashMap<String, HttpFacade.Cookie>();
        cookies.put("c", new HttpFacade.Cookie("c", "cookie-c", 1, "localhost", "/"));
        return new HttpFacade.Request(){
            private InputStream inputStream;

            public String getMethod() {
                return "GET";
            }

            public String getURI() {
                return "/app/request-uri";
            }

            public String getRelativePath() {
                return "/request-relative-path";
            }

            public boolean isSecure() {
                return true;
            }

            public String getFirstParam(String param) {
                List values = queryParameter.getOrDefault(param, Collections.emptyList());
                if (!values.isEmpty()) {
                    return (String)values.get(0);
                }
                return null;
            }

            public String getQueryParamValue(String param) {
                return this.getFirstParam(param);
            }

            public HttpFacade.Cookie getCookie(String cookieName) {
                return (HttpFacade.Cookie)cookies.get(cookieName);
            }

            public String getHeader(String name) {
                List<String> headers2 = this.getHeaders(name);
                if (!headers2.isEmpty()) {
                    return headers2.get(0);
                }
                return null;
            }

            public List<String> getHeaders(String name) {
                return headers.getOrDefault(name, Collections.emptyList());
            }

            public InputStream getInputStream() {
                return this.getInputStream(false);
            }

            public InputStream getInputStream(boolean buffer) {
                if (requestBody == null) {
                    return new ByteArrayInputStream(new byte[0]);
                }
                if (this.inputStream != null) {
                    return this.inputStream;
                }
                if (buffer) {
                    this.inputStream = new BufferedInputStream(requestBody);
                    return this.inputStream;
                }
                return requestBody;
            }

            public String getRemoteAddr() {
                return "user-remote-addr";
            }

            public void setError(AuthenticationError error) {
            }

            public void setError(LogoutError error) {
            }
        };
    }
}

