/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.JSPolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.testsuite.admin.client.authorization.AbstractAuthorizationTest;

public class AuthorizationTest
extends AbstractAuthorizationTest {
    @Test
    public void testEnableAuthorizationServices() {
        ClientResource clientResource = this.getClientResource();
        ClientRepresentation resourceServer = this.getResourceServer();
        RealmResource realm = this.realmsResouce().realm(this.getRealmId());
        UserRepresentation serviceAccount = (UserRepresentation)realm.users().search("service-account-" + resourceServer.getClientId()).get(0);
        Assert.assertNotNull((Object)serviceAccount);
        List serviceAccountRoles = realm.users().get(serviceAccount.getId()).roles().clientLevel(resourceServer.getId()).listEffective();
        Assert.assertTrue((boolean)serviceAccountRoles.stream().anyMatch(roleRepresentation -> "uma_protection".equals(roleRepresentation.getName())));
        this.enableAuthorizationServices(false);
        this.enableAuthorizationServices(true);
        serviceAccount = clientResource.getServiceAccountUser();
        Assert.assertNotNull((Object)serviceAccount);
        realm = this.realmsResouce().realm(this.getRealmId());
        serviceAccountRoles = realm.users().get(serviceAccount.getId()).roles().clientLevel(resourceServer.getId()).listEffective();
        Assert.assertTrue((boolean)serviceAccountRoles.stream().anyMatch(roleRepresentation -> "uma_protection".equals(roleRepresentation.getName())));
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName("should be removed");
        policy.setCode("");
        clientResource.authorization().policies().js().create(policy);
        List defaultResources = clientResource.authorization().resources().resources();
        Assert.assertEquals((long)1L, (long)defaultResources.size());
        List defaultPolicies = clientResource.authorization().policies().policies();
        Assert.assertEquals((long)3L, (long)defaultPolicies.size());
        this.enableAuthorizationServices(false);
        this.enableAuthorizationServices(true);
        ResourceServerRepresentation settings = clientResource.authorization().getSettings();
        Assert.assertEquals((Object)PolicyEnforcerConfig.EnforcementMode.ENFORCING.name(), (Object)settings.getPolicyEnforcementMode().name());
        Assert.assertTrue((boolean)settings.isAllowRemoteResourceManagement());
        Assert.assertEquals((Object)resourceServer.getId(), (Object)settings.getClientId());
        defaultResources = clientResource.authorization().resources().resources();
        Assert.assertEquals((long)1L, (long)defaultResources.size());
        defaultPolicies = clientResource.authorization().policies().policies();
        Assert.assertEquals((long)2L, (long)defaultPolicies.size());
        serviceAccount = clientResource.getServiceAccountUser();
        Assert.assertNotNull((Object)serviceAccount);
        serviceAccountRoles = realm.users().get(serviceAccount.getId()).roles().clientLevel(resourceServer.getId()).listEffective();
        Assert.assertTrue((boolean)serviceAccountRoles.stream().anyMatch(roleRepresentation -> "uma_protection".equals(roleRepresentation.getName())));
    }

    @Test
    public void testRemoveDefaultResourceWithAdminEventsEnabled() {
        RealmResource realmResource = this.testRealmResource();
        RealmRepresentation realmRepresentation = realmResource.toRepresentation();
        realmRepresentation.setAdminEventsEnabled(Boolean.valueOf(true));
        realmResource.update(realmRepresentation);
        ClientResource clientResource = this.getClientResource();
        ClientRepresentation resourceServer = this.getResourceServer();
        ResourceServerRepresentation settings = clientResource.authorization().getSettings();
        Assert.assertEquals((Object)PolicyEnforcerConfig.EnforcementMode.ENFORCING.name(), (Object)settings.getPolicyEnforcementMode().name());
        Assert.assertEquals((Object)resourceServer.getId(), (Object)settings.getClientId());
        List defaultResources = clientResource.authorization().resources().resources();
        Assert.assertEquals((long)1L, (long)defaultResources.size());
        clientResource.authorization().resources().resource(((ResourceRepresentation)defaultResources.get(0)).getId()).remove();
        Assert.assertTrue((boolean)clientResource.authorization().resources().resources().isEmpty());
    }
}

