/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.util.Collections;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.AggregatePoliciesResource;
import org.keycloak.admin.client.resource.AggregatePolicyResource;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.AggregatePolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.testsuite.admin.client.authorization.AbstractPolicyManagementTest;

public class AggregatePolicyManagementTest
extends AbstractPolicyManagementTest {
    @Test
    public void testCreate() {
        AuthorizationResource authorization = this.getClient().authorization();
        AggregatePolicyRepresentation representation = new AggregatePolicyRepresentation();
        representation.setName("Aggregate Policy");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.addPolicy(new String[]{"Only Marta Policy", "Only Kolo Policy"});
        this.assertCreated(authorization, representation);
    }

    @Test
    public void testUpdate() {
        AuthorizationResource authorization = this.getClient().authorization();
        AggregatePolicyRepresentation representation = new AggregatePolicyRepresentation();
        representation.setName("Update Aggregate Policy");
        representation.setDescription("description");
        representation.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        representation.setLogic(Logic.NEGATIVE);
        representation.addPolicy(new String[]{"Only Marta Policy", "Only Kolo Policy"});
        this.assertCreated(authorization, representation);
        representation.setName("changed");
        representation.setDescription("changed");
        representation.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        representation.setLogic(Logic.POSITIVE);
        representation.getPolicies().clear();
        representation.addPolicy(new String[]{"Only Kolo Policy"});
        AggregatePoliciesResource policies = authorization.policies().aggregate();
        AggregatePolicyResource policy = policies.findById(representation.getId());
        policy.update(representation);
        this.assertRepresentation(representation, policy);
    }

    @Test
    public void testDelete() {
        AuthorizationResource authorization = this.getClient().authorization();
        AggregatePolicyRepresentation representation = new AggregatePolicyRepresentation();
        representation.setName("Test Delete Policy");
        representation.addPolicy(new String[]{"Only Marta Policy"});
        AggregatePoliciesResource policies = authorization.policies().aggregate();
        try (Response response = policies.create(representation);){
            AggregatePolicyRepresentation created = (AggregatePolicyRepresentation)response.readEntity(AggregatePolicyRepresentation.class);
            policies.findById(created.getId()).remove();
            AggregatePolicyResource removed = policies.findById(created.getId());
            try {
                removed.toRepresentation();
                Assert.fail((String)"Policy not removed");
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    private void assertCreated(AuthorizationResource authorization, AggregatePolicyRepresentation representation) {
        AggregatePoliciesResource permissions = authorization.policies().aggregate();
        try (Response response = permissions.create(representation);){
            AggregatePolicyRepresentation created = (AggregatePolicyRepresentation)response.readEntity(AggregatePolicyRepresentation.class);
            AggregatePolicyResource permission = permissions.findById(created.getId());
            this.assertRepresentation(representation, permission);
        }
    }

    private void assertRepresentation(AggregatePolicyRepresentation representation, AggregatePolicyResource policy) {
        AggregatePolicyRepresentation actual = policy.toRepresentation();
        this.assertRepresentation((AbstractPolicyRepresentation)representation, (AbstractPolicyRepresentation)actual, () -> policy.resources(), () -> Collections.emptyList(), () -> policy.associatedPolicies());
    }
}

