/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public abstract class AbstractPolicyManagementTest
extends AbstractKeycloakTest {
    @BeforeClass
    public static void enabled() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(this.createTestRealm().build());
    }

    protected RealmBuilder createTestRealm() {
        return RealmBuilder.create().name("authz-test").user(UserBuilder.create().username("marta").password("password")).user(UserBuilder.create().username("kolo").password("password")).client(ClientBuilder.create().clientId("resource-server-test").secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-test").defaultRoles("uma_protection").directAccessGrants());
    }

    @Before
    public void configureAuthorization() throws Exception {
        this.createResourcesAndScopes();
        RealmResource realm = this.getRealm();
        this.createPolicies(realm, this.getClient(realm));
    }

    protected void assertRepresentation(AbstractPolicyRepresentation expected, AbstractPolicyRepresentation actual, Supplier<List<ResourceRepresentation>> resources, Supplier<List<ScopeRepresentation>> scopes, Supplier<List<PolicyRepresentation>> policies) {
        Assert.assertNotNull((Object)actual);
        Assert.assertNotNull((Object)actual.getId());
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((Object)expected.getDescription(), (Object)actual.getDescription());
        Assert.assertEquals((Object)expected.getDecisionStrategy(), (Object)actual.getDecisionStrategy());
        Assert.assertEquals((Object)expected.getLogic(), (Object)actual.getLogic());
        Assert.assertNull((Object)actual.getResources());
        Assert.assertNull((Object)actual.getPolicies());
        Assert.assertNull((Object)actual.getScopes());
        List<PolicyRepresentation> associatedPolicies = policies.get();
        if (expected.getPolicies() != null) {
            Assert.assertEquals((long)expected.getPolicies().size(), (long)associatedPolicies.size());
            Assert.assertEquals((long)0L, (long)associatedPolicies.stream().map(representation1 -> representation1.getName()).filter(policyName -> !expected.getPolicies().contains(policyName)).count());
        } else {
            Assert.assertTrue((boolean)associatedPolicies.isEmpty());
        }
        List<ResourceRepresentation> associatedResources = resources.get();
        if (expected.getResources() != null) {
            Assert.assertEquals((long)expected.getResources().size(), (long)associatedResources.size());
            Assert.assertEquals((long)0L, (long)associatedResources.stream().map(representation1 -> representation1.getName()).filter(resourceName -> !expected.getResources().contains(resourceName)).count());
        } else {
            Assert.assertTrue((boolean)associatedResources.isEmpty());
        }
        List<ScopeRepresentation> associatedScopes = scopes.get();
        if (expected.getScopes() != null) {
            Assert.assertEquals((long)expected.getScopes().size(), (long)associatedScopes.size());
            Assert.assertEquals((long)0L, (long)associatedScopes.stream().map(representation1 -> representation1.getName()).filter(scopeName -> !expected.getScopes().contains(scopeName)).count());
        } else {
            Assert.assertTrue((boolean)associatedScopes.isEmpty());
        }
        expected.setId(actual.getId());
    }

    private void createResourcesAndScopes() throws IOException {
        HashSet<ScopeRepresentation> scopes = new HashSet<ScopeRepresentation>();
        scopes.add(new ScopeRepresentation("read"));
        scopes.add(new ScopeRepresentation("write"));
        scopes.add(new ScopeRepresentation("execute"));
        ArrayList<ResourceRepresentation> resources = new ArrayList<ResourceRepresentation>();
        resources.add(new ResourceRepresentation("Resource A", scopes));
        resources.add(new ResourceRepresentation("Resource B", scopes));
        resources.add(new ResourceRepresentation("Resource C", scopes));
        resources.forEach(resource -> {
            Response response = this.getClient().authorization().resources().create(resource);
            response.close();
        });
    }

    private void createPolicies(RealmResource realm, ClientResource client) throws IOException {
        this.createUserPolicy("Only Marta Policy", realm, client, "marta");
        this.createUserPolicy("Only Kolo Policy", realm, client, "kolo");
    }

    private void createUserPolicy(String name, RealmResource realm, ClientResource client, String username) throws IOException {
        String userId = realm.users().search(username).stream().map(representation -> representation.getId()).findFirst().orElseThrow(() -> new RuntimeException("Expected user [userId]"));
        UserPolicyRepresentation representation2 = new UserPolicyRepresentation();
        representation2.setName(name);
        representation2.addUser(userId);
        Response response = client.authorization().policies().user().create(representation2);
        response.close();
    }

    protected ClientResource getClient() {
        return this.getClient(this.getRealm());
    }

    protected ClientResource getClient(RealmResource realm) {
        ClientsResource clients = realm.clients();
        return clients.findByClientId("resource-server-test").stream().map(representation -> clients.get(representation.getId())).findFirst().orElseThrow(() -> new RuntimeException("Expected client [resource-server-test]"));
    }

    protected RealmResource getRealm() {
        try {
            return this.adminClient.realm("authz-test");
        }
        catch (Exception cause) {
            throw new RuntimeException("Failed to create admin client", cause);
        }
    }
}

