/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client;

import java.util.List;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.common.Profile;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.testsuite.admin.client.AbstractClientTest;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.auth.page.account.AccountManagement;
import org.keycloak.testsuite.util.AdminEventPaths;

@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class SessionTest
extends AbstractClientTest {
    @Page
    protected AccountManagement testRealmAccountManagementPage;

    @Before
    public void init() {
        this.createTestUserWithAdminClient();
        this.getCleanup().addUserId(this.testUser.getId());
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.userResourcePath(this.testUser.getId()), ResourceType.USER);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.ACTION, AdminEventPaths.userResetPasswordPath(this.testUser.getId()), ResourceType.USER);
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmAccountManagementPage.setAuthRealm(this.getRealmId());
        this.loginPage.setAuthRealm(this.getRealmId());
    }

    @Test
    public void testGetAppSessionCount() {
        ClientResource accountClient = this.findClientResourceById("account");
        int sessionCount = (Integer)accountClient.getApplicationSessionCount().get("count");
        Assert.assertEquals((long)0L, (long)sessionCount);
        this.testRealmAccountManagementPage.navigateTo();
        this.loginPage.form().login(this.testUser);
        sessionCount = (Integer)accountClient.getApplicationSessionCount().get("count");
        Assert.assertEquals((long)1L, (long)sessionCount);
        this.testRealmAccountManagementPage.signOut();
        sessionCount = (Integer)accountClient.getApplicationSessionCount().get("count");
        Assert.assertEquals((long)0L, (long)sessionCount);
    }

    @Test
    public void testGetUserSessions() {
        ClientResource account = this.findClientResourceById("account");
        this.testRealmAccountManagementPage.navigateTo();
        this.loginPage.form().login(this.testUser);
        List sessions = account.getUserSessions(Integer.valueOf(0), Integer.valueOf(5));
        Assert.assertEquals((long)1L, (long)sessions.size());
        UserSessionRepresentation rep = (UserSessionRepresentation)sessions.get(0);
        UserRepresentation testUserRep = this.getFullUserRep(this.testUser.getUsername());
        Assert.assertEquals((Object)testUserRep.getId(), (Object)rep.getUserId());
        Assert.assertEquals((Object)testUserRep.getUsername(), (Object)rep.getUsername());
        String clientId = account.toRepresentation().getId();
        Assert.assertEquals((Object)"account", rep.getClients().get(clientId));
        Assert.assertNotNull((Object)rep.getIpAddress());
        Assert.assertNotNull((Object)rep.getLastAccess());
        Assert.assertNotNull((Object)rep.getStart());
        this.testRealmAccountManagementPage.signOut();
    }
}

