/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.ws.rs.ClientErrorException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RoleByIdResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.client.AbstractClientTest;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.RoleBuilder;

public class ClientRolesTest
extends AbstractClientTest {
    private ClientResource clientRsc;
    private String clientDbId;
    private RolesResource rolesRsc;

    @Before
    public void init() {
        this.clientDbId = this.createOidcClient("roleClient");
        this.clientRsc = this.findClientResource("roleClient");
        this.rolesRsc = this.clientRsc.roles();
    }

    @After
    public void tearDown() {
        this.clientRsc.remove();
    }

    private RoleRepresentation makeRole(String name) {
        RoleRepresentation role = new RoleRepresentation();
        role.setName(name);
        return role;
    }

    private boolean hasRole(RolesResource rolesRsc, String name) {
        for (RoleRepresentation role : rolesRsc.list()) {
            if (!role.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testAddRole() {
        RoleRepresentation role1 = this.makeRole("role1");
        role1.setDescription("role1-description");
        role1.setAttributes(Collections.singletonMap("role1-attr-key", Collections.singletonList("role1-attr-val")));
        this.rolesRsc.create(role1);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, "role1"), (Object)role1, ResourceType.CLIENT_ROLE);
        RoleRepresentation addedRole = this.rolesRsc.get(role1.getName()).toRepresentation();
        org.junit.Assert.assertEquals((Object)role1.getName(), (Object)addedRole.getName());
        org.junit.Assert.assertEquals((Object)role1.getDescription(), (Object)addedRole.getDescription());
        org.junit.Assert.assertEquals((Object)role1.getAttributes(), (Object)addedRole.getAttributes());
    }

    @Test(expected=ClientErrorException.class)
    public void createRoleWithSameName() {
        RoleRepresentation role = RoleBuilder.create().name("role-a").build();
        this.rolesRsc.create(role);
        this.rolesRsc.create(role);
    }

    @Test
    public void testRemoveRole() {
        RoleRepresentation role2 = this.makeRole("role2");
        this.rolesRsc.create(role2);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, "role2"), (Object)role2, ResourceType.CLIENT_ROLE);
        this.rolesRsc.deleteRole("role2");
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, "role2"), ResourceType.CLIENT_ROLE);
        org.junit.Assert.assertFalse((boolean)this.hasRole(this.rolesRsc, "role2"));
    }

    @Test
    public void testComposites() {
        RoleRepresentation roleA = this.makeRole("role-a");
        this.rolesRsc.create(roleA);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, "role-a"), (Object)roleA, ResourceType.CLIENT_ROLE);
        org.junit.Assert.assertFalse((boolean)this.rolesRsc.get("role-a").toRepresentation().isComposite());
        org.junit.Assert.assertEquals((long)0L, (long)this.rolesRsc.get("role-a").getRoleComposites().size());
        RoleRepresentation roleB = this.makeRole("role-b");
        this.rolesRsc.create(roleB);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, "role-b"), (Object)roleB, ResourceType.CLIENT_ROLE);
        RoleRepresentation roleC = this.makeRole("role-c");
        this.testRealmResource().roles().create(roleC);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.roleResourcePath("role-c"), (Object)roleC, ResourceType.REALM_ROLE);
        LinkedList<RoleRepresentation> l = new LinkedList<RoleRepresentation>();
        l.add(this.rolesRsc.get("role-b").toRepresentation());
        l.add(this.testRealmResource().roles().get("role-c").toRepresentation());
        this.rolesRsc.get("role-a").addComposites(l);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourceCompositesPath(this.clientDbId, "role-a"), l, ResourceType.CLIENT_ROLE);
        Set composites = this.rolesRsc.get("role-a").getRoleComposites();
        org.junit.Assert.assertTrue((boolean)this.rolesRsc.get("role-a").toRepresentation().isComposite());
        Assert.assertNames(composites, "role-b", "role-c");
        Set realmComposites = this.rolesRsc.get("role-a").getRealmRoleComposites();
        Assert.assertNames(realmComposites, "role-c");
        Set clientComposites = this.rolesRsc.get("role-a").getClientRoleComposites(this.clientRsc.toRepresentation().getId());
        Assert.assertNames(clientComposites, "role-b");
        this.rolesRsc.get("role-a").deleteComposites(l);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientRoleResourceCompositesPath(this.clientDbId, "role-a"), l, ResourceType.CLIENT_ROLE);
        org.junit.Assert.assertFalse((boolean)this.rolesRsc.get("role-a").toRepresentation().isComposite());
        org.junit.Assert.assertEquals((long)0L, (long)this.rolesRsc.get("role-a").getRoleComposites().size());
    }

    @Test
    public void testCompositeRolesSearch() {
        RoleRepresentation mainRole = this.makeRole("main-role");
        this.rolesRsc.create(mainRole);
        RoleResource mainRoleRsc = this.rolesRsc.get("main-role");
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, "main-role"), (Object)mainRole, ResourceType.CLIENT_ROLE);
        List createdRoles = IntStream.range(0, 20).boxed().map(i -> this.makeRole("role" + i)).peek(arg_0 -> ((RolesResource)this.rolesRsc).create(arg_0)).peek(role -> this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, role.getName()), role, ResourceType.CLIENT_ROLE)).map(role -> this.rolesRsc.get(role.getName()).toRepresentation()).collect(Collectors.toList());
        mainRoleRsc.addComposites(createdRoles);
        mainRole = mainRoleRsc.toRepresentation();
        RoleByIdResource roleByIdResource = this.adminClient.realm(this.getRealmId()).rolesById();
        Set foundRoles = roleByIdResource.getRoleComposites(mainRole.getId());
        MatcherAssert.assertThat((Object)foundRoles, (Matcher)Matchers.hasSize((int)createdRoles.size()));
        foundRoles = roleByIdResource.searchRoleComposites(mainRole.getId(), null, Integer.valueOf(0), Integer.valueOf(10));
        MatcherAssert.assertThat((Object)foundRoles, (Matcher)Matchers.hasSize((int)10));
        foundRoles = roleByIdResource.searchRoleComposites(mainRole.getId(), "role1", null, null);
        MatcherAssert.assertThat((Object)foundRoles, (Matcher)Matchers.hasSize((int)11));
        foundRoles.forEach(System.out::println);
        foundRoles = roleByIdResource.searchRoleComposites(mainRole.getId(), "role1", Integer.valueOf(5), Integer.valueOf(5));
        MatcherAssert.assertThat((Object)foundRoles, (Matcher)Matchers.hasSize((int)5));
    }

    @Test
    public void usersInRole() {
        String clientID = this.clientRsc.toRepresentation().getId();
        String roleName = "test-role";
        RoleRepresentation role = this.makeRole(roleName);
        this.rolesRsc.create(role);
        org.junit.Assert.assertTrue((boolean)this.hasRole(this.rolesRsc, roleName));
        List<RoleRepresentation> roleToAdd = Collections.singletonList(this.rolesRsc.get(roleName).toRepresentation());
        HashSet<Object> users = new HashSet<Object>();
        for (int i = 0; i < 10; ++i) {
            String userName = "user" + i;
            Object user = new UserRepresentation();
            user.setUsername(userName);
            this.testRealmResource().users().create((UserRepresentation)user);
            user = this.getFullUserRep(userName);
            this.testRealmResource().users().get(user.getId()).roles().clientLevel(clientID).add(roleToAdd);
            users.add(user);
        }
        RoleResource roleResource = this.rolesRsc.get(roleName);
        Set usersInRole = roleResource.getRoleUserMembers();
        org.junit.Assert.assertEquals((long)users.size(), (long)usersInRole.size());
        for (UserRepresentation userRepresentation : users) {
            Optional<UserRepresentation> result = usersInRole.stream().filter(u -> user.getUsername().equals(u.getUsername())).findAny();
            org.junit.Assert.assertTrue((boolean)result.isPresent());
        }
        Set usersInRole1 = roleResource.getRoleUserMembers(Integer.valueOf(0), Integer.valueOf(5));
        org.junit.Assert.assertEquals((long)5L, (long)usersInRole1.size());
        Set set = roleResource.getRoleUserMembers(Integer.valueOf(5), Integer.valueOf(10));
        org.junit.Assert.assertEquals((long)5L, (long)set.size());
        for (UserRepresentation userRepresentation : users) {
            Optional<UserRepresentation> result1 = usersInRole1.stream().filter(u -> user.getUsername().equals(u.getUsername())).findAny();
            Optional<UserRepresentation> result2 = set.stream().filter(u -> user.getUsername().equals(u.getUsername())).findAny();
            org.junit.Assert.assertTrue((!(!result1.isPresent() && !result2.isPresent() || result1.isPresent() && result2.isPresent()) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSearchForRoles() {
        for (int i = 0; i < 15; ++i) {
            String roleName = "role" + i;
            RoleRepresentation role = this.makeRole(roleName);
            this.rolesRsc.create(role);
            this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, roleName), (Object)role, ResourceType.CLIENT_ROLE);
        }
        String roleNameA = "abcdef";
        RoleRepresentation roleA = this.makeRole(roleNameA);
        this.rolesRsc.create(roleA);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, roleNameA), (Object)roleA, ResourceType.CLIENT_ROLE);
        String roleNameB = "defghi";
        RoleRepresentation roleB = this.makeRole(roleNameB);
        this.rolesRsc.create(roleB);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, roleNameB), (Object)roleB, ResourceType.CLIENT_ROLE);
        List resultSearch = this.rolesRsc.list("def", Integer.valueOf(-1), Integer.valueOf(-1));
        org.junit.Assert.assertEquals((long)2L, (long)resultSearch.size());
        List resultSearch2 = this.rolesRsc.list("role", Integer.valueOf(-1), Integer.valueOf(-1));
        org.junit.Assert.assertEquals((long)15L, (long)resultSearch2.size());
        List resultSearchPagination = this.rolesRsc.list("role", Integer.valueOf(1), Integer.valueOf(5));
        org.junit.Assert.assertEquals((long)5L, (long)resultSearchPagination.size());
    }

    @Test
    public void testPaginationRoles() {
        for (int i = 0; i < 15; ++i) {
            String roleName = "role" + i;
            RoleRepresentation role = this.makeRole(roleName);
            this.rolesRsc.create(role);
            this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, roleName), (Object)role, ResourceType.CLIENT_ROLE);
        }
        List resultSearchWithoutPagination = this.rolesRsc.list();
        org.junit.Assert.assertEquals((long)15L, (long)resultSearchWithoutPagination.size());
        List resultSearchPagination = this.rolesRsc.list(Integer.valueOf(1), Integer.valueOf(5));
        org.junit.Assert.assertEquals((long)5L, (long)resultSearchPagination.size());
        List resultSearchPaginationIncoherentParams = this.rolesRsc.list(Integer.valueOf(1), null);
        org.junit.Assert.assertTrue((resultSearchPaginationIncoherentParams.size() >= 15 ? 1 : 0) != 0);
    }

    @Test
    public void testPaginationRolesCache() {
        for (int i = 0; i < 5; ++i) {
            String roleName = "paginaterole" + i;
            RoleRepresentation role = this.makeRole(roleName);
            this.rolesRsc.create(role);
            this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, roleName), (Object)role, ResourceType.CLIENT_ROLE);
        }
        List resultBeforeAddingRoleToTestCache = this.rolesRsc.list(Integer.valueOf(1), Integer.valueOf(1000));
        RoleRepresentation role = this.makeRole("anewrole");
        this.rolesRsc.create(role);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, "anewrole"), (Object)role, ResourceType.CLIENT_ROLE);
        List resultafterAddingRoleToTestCache = this.rolesRsc.list(Integer.valueOf(1), Integer.valueOf(1000));
        org.junit.Assert.assertEquals((long)(resultBeforeAddingRoleToTestCache.size() + 1), (long)resultafterAddingRoleToTestCache.size());
    }

    @Test
    public void getRolesWithFullRepresentation() {
        for (int i = 0; i < 5; ++i) {
            String roleName = "attributesrole" + i;
            RoleRepresentation role = this.makeRole(roleName);
            HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
            attributes.put("attribute1", Arrays.asList("value1", "value2"));
            role.setAttributes(attributes);
            this.rolesRsc.create(role);
            this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, roleName), (Object)role, ResourceType.CLIENT_ROLE);
        }
        List roles = this.rolesRsc.list(false);
        org.junit.Assert.assertTrue((boolean)((RoleRepresentation)roles.get(0)).getAttributes().containsKey("attribute1"));
    }

    @Test
    public void getRolesWithBriefRepresentation() {
        for (int i = 0; i < 5; ++i) {
            String roleName = "attributesrole" + i;
            RoleRepresentation role = this.makeRole(roleName);
            HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
            attributes.put("attribute1", Arrays.asList("value1", "value2"));
            role.setAttributes(attributes);
            this.rolesRsc.create(role);
            this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, roleName), (Object)role, ResourceType.CLIENT_ROLE);
        }
        List roles = this.rolesRsc.list();
        org.junit.Assert.assertNull((Object)((RoleRepresentation)roles.get(0)).getAttributes());
    }
}

