/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client;

import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.client.AbstractProtocolMapperTest;
import org.keycloak.testsuite.util.AdminEventPaths;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ClientProtocolMapperTest
extends AbstractProtocolMapperTest {
    private ClientResource oidcClientRsc;
    private String oidcClientId;
    private ProtocolMappersResource oidcMappersRsc;
    private ClientResource samlClientRsc;
    private String samlClientId;
    private ProtocolMappersResource samlMappersRsc;

    @Before
    public void init() {
        this.oidcClientId = this.createOidcClient("oidcMapperClient");
        this.oidcClientRsc = this.findClientResource("oidcMapperClient");
        this.oidcMappersRsc = this.oidcClientRsc.getProtocolMappers();
        this.samlClientId = this.createSamlClient("samlMapperClient");
        this.samlClientRsc = this.findClientResource("samlMapperClient");
        this.samlMappersRsc = this.samlClientRsc.getProtocolMappers();
        super.initBuiltinMappers();
    }

    @After
    public void tearDown() {
        this.removeClient(this.oidcClientId);
        this.removeClient(this.samlClientId);
    }

    @Test
    public void test01GetMappersList() {
        org.junit.Assert.assertTrue((boolean)this.oidcMappersRsc.getMappers().isEmpty());
        org.junit.Assert.assertTrue((boolean)this.samlMappersRsc.getMappers().isEmpty());
    }

    @Test
    public void test02CreateOidcMappersFromList() {
        this.testAddAllBuiltinMappers(this.oidcMappersRsc, "openid-connect", AdminEventPaths.clientProtocolMappersPath(this.oidcClientId));
    }

    @Test
    public void test03CreateSamlMappersFromList() {
        this.testAddAllBuiltinMappers(this.samlMappersRsc, "saml", AdminEventPaths.clientProtocolMappersPath(this.samlClientId));
    }

    @Test
    public void test04CreateSamlProtocolMapper() {
        ProtocolMapperRepresentation rep = this.makeSamlMapper("saml-role-name-mapper");
        int totalMappers = this.samlMappersRsc.getMappers().size();
        int totalSamlMappers = this.samlMappersRsc.getMappersPerProtocol("saml").size();
        Response resp = this.samlMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientProtocolMapperPath(this.samlClientId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        org.junit.Assert.assertEquals((long)(totalMappers + 1), (long)this.samlMappersRsc.getMappers().size());
        org.junit.Assert.assertEquals((long)(totalSamlMappers + 1), (long)this.samlMappersRsc.getMappersPerProtocol("saml").size());
        ProtocolMapperRepresentation created = this.samlMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, created);
    }

    @Test
    public void test05CreateOidcProtocolMapper() {
        ProtocolMapperRepresentation rep = this.makeOidcMapper("oidc-hardcoded-role-mapper");
        int totalMappers = this.oidcMappersRsc.getMappers().size();
        int totalOidcMappers = this.oidcMappersRsc.getMappersPerProtocol("openid-connect").size();
        Response resp = this.oidcMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientProtocolMapperPath(this.oidcClientId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        org.junit.Assert.assertEquals((long)(totalMappers + 1), (long)this.oidcMappersRsc.getMappers().size());
        org.junit.Assert.assertEquals((long)(totalOidcMappers + 1), (long)this.oidcMappersRsc.getMappersPerProtocol("openid-connect").size());
        ProtocolMapperRepresentation created = this.oidcMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, created);
    }

    @Test
    public void test06UpdateSamlMapper() {
        ProtocolMapperRepresentation rep = this.makeSamlMapper("saml-role-name-mapper2");
        Response resp = this.samlMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientProtocolMapperPath(this.samlClientId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        rep.getConfig().put("role", "account.manage-account");
        rep.setId(createdId);
        this.samlMappersRsc.update(createdId, rep);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.UPDATE, AdminEventPaths.clientProtocolMapperPath(this.samlClientId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        ProtocolMapperRepresentation updated = this.samlMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, updated);
    }

    @Test
    public void test07UpdateOidcMapper() {
        ProtocolMapperRepresentation rep = this.makeOidcMapper("oidc-hardcoded-role-mapper2");
        Response resp = this.oidcMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientProtocolMapperPath(this.oidcClientId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        rep.getConfig().put("role", "myotherrole");
        rep.setId(createdId);
        this.oidcMappersRsc.update(createdId, rep);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.UPDATE, AdminEventPaths.clientProtocolMapperPath(this.oidcClientId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        ProtocolMapperRepresentation updated = this.oidcMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, updated);
    }

    @Test
    public void test08DeleteSamlMapper() {
        ProtocolMapperRepresentation rep = this.makeSamlMapper("saml-role-name-mapper3");
        Response resp = this.samlMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientProtocolMapperPath(this.samlClientId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        this.samlMappersRsc.delete(createdId);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientProtocolMapperPath(this.samlClientId, createdId), ResourceType.PROTOCOL_MAPPER);
        try {
            this.samlMappersRsc.getMapperById(createdId);
            Assert.fail((String)"Not expected to find mapper");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void test09DeleteOidcMapper() {
        ProtocolMapperRepresentation rep = this.makeOidcMapper("oidc-hardcoded-role-mapper3");
        Response resp = this.oidcMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientProtocolMapperPath(this.oidcClientId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        this.oidcMappersRsc.delete(createdId);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientProtocolMapperPath(this.oidcClientId, createdId), ResourceType.PROTOCOL_MAPPER);
        try {
            this.oidcMappersRsc.getMapperById(createdId);
            Assert.fail((String)"Not expected to find mapper");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }
}

