/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.authentication;

import java.util.List;
import javax.ws.rs.NotFoundException;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.testsuite.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.testsuite.util.AdminEventPaths;

public class ShiftRequiredActionTest
extends AbstractAuthenticationTest {
    @Test
    public void testShiftRequiredAction() {
        List actions = this.authMgmtResource.getRequiredActions();
        RequiredActionProviderRepresentation last = (RequiredActionProviderRepresentation)actions.get(actions.size() - 1);
        RequiredActionProviderRepresentation oneButLast = (RequiredActionProviderRepresentation)actions.get(actions.size() - 2);
        try {
            this.authMgmtResource.raisePriority("not-existent");
            Assert.fail((String)"Not expected to raise priority of not existent required action");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.authMgmtResource.raiseRequiredActionPriority(last.getAlias());
        this.assertAdminEvents.assertEvent("test", OperationType.UPDATE, AdminEventPaths.authRaiseRequiredActionPath(last.getAlias()), ResourceType.REQUIRED_ACTION);
        List actions2 = this.authMgmtResource.getRequiredActions();
        RequiredActionProviderRepresentation last2 = (RequiredActionProviderRepresentation)actions2.get(actions.size() - 1);
        RequiredActionProviderRepresentation oneButLast2 = (RequiredActionProviderRepresentation)actions2.get(actions.size() - 2);
        Assert.assertEquals((String)"Required action shifted up - N", (Object)last.getAlias(), (Object)oneButLast2.getAlias());
        Assert.assertEquals((String)"Required action up - N-1", (Object)oneButLast.getAlias(), (Object)last2.getAlias());
        try {
            this.authMgmtResource.lowerRequiredActionPriority("not-existent");
            Assert.fail((String)"Not expected to raise priority of not existent required action");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.authMgmtResource.lowerRequiredActionPriority(oneButLast2.getAlias());
        this.assertAdminEvents.assertEvent("test", OperationType.UPDATE, AdminEventPaths.authLowerRequiredActionPath(oneButLast2.getAlias()), ResourceType.REQUIRED_ACTION);
        actions2 = this.authMgmtResource.getRequiredActions();
        last2 = (RequiredActionProviderRepresentation)actions2.get(actions.size() - 1);
        oneButLast2 = (RequiredActionProviderRepresentation)actions2.get(actions.size() - 2);
        Assert.assertEquals((String)"Required action shifted down - N", (Object)last.getAlias(), (Object)last2.getAlias());
        Assert.assertEquals((String)"Required action shifted down - N-1", (Object)oneButLast.getAlias(), (Object)oneButLast2.getAlias());
    }
}

